/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Key;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class PropertiesEditor
extends JPanel
implements JCCellDisplayListener {
    private static final String PWD = ".Password";
    private static final String PWD_ENCRYPTED = ".Password.encrypted";
    public static final String[] COLUMNS = new String[]{"Property", "Value"};
    public static final int COL_NAME = 0;
    public static final int COL_VALUE = 1;
    public static final int[] COLUMN_WIDTHS = new int[]{12, 12};
    boolean encryptedPassword = false;
    BorderLayout borderLayout1 = new BorderLayout();
    private String[] titles = new String[0];
    private String[] keys = new String[0];
    private ExtendedListTable table = new ExtendedListTable(){

        @Override
        public String getToolTipText(MouseEvent event) {
            JCCellPosition cp = this.XYToCell(event.getX(), event.getY());
            if (cp.column < 0 || cp.row < 0) {
                return null;
            }
            try {
                if (cp.column == 1) {
                    return PropertiesEditor.this.toolTips[cp.row - 1];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    };
    private JCEditableVectorDataSource model = new JCEditableVectorDataSource();
    private String[] defaultValues;
    private String[] toolTips;
    private JCCellStyle readOnly;

    public PropertiesEditor() {
        this(false);
    }

    public PropertiesEditor(boolean nameEditable) {
        this.model.setNumColumns(COLUMNS.length);
        this.model.setColumnLabels(COLUMNS);
        this.model.setNumRows(1);
        this.table.setDataSource(this.model);
        this.table.setRowHidden(0, true);
        this.table.setRowLabelDisplay(false);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setStyle(nameEditable);
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.addCellDisplayListener(this);
    }

    private void setStyle(boolean nameEditable) {
        if (!nameEditable) {
            this.readOnly = new JCCellStyle(this.table.getDefaultCellStyle());
            this.readOnly.setEditable(nameEditable);
            this.table.setCellStyle(-997, 0, this.readOnly);
        } else {
            this.table.setCellEditor(String.class, new JCStringCellEditor());
        }
        for (int i2 = 0; i2 < COLUMNS.length; ++i2) {
            this.table.setCharWidth(i2, COLUMN_WIDTHS[i2]);
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.table, "Center");
    }

    public void setKeys(String[] keys) {
        if (keys == null) {
            throw new NullPointerException();
        }
        this.keys = keys;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setTitles(String[] titles) {
        if (titles == null) {
            throw new NullPointerException();
        }
        this.titles = titles;
    }

    public String[] getTitles() {
        return this.titles;
    }

    public void setProperties(Properties props) {
        this.setProperties(props, true);
    }

    public void setProperties(Properties props, boolean withTitles) {
        this.model.setNumRows(1);
        int passwordRow = -1;
        this.encryptedPassword = false;
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            Vector<String> row = new Vector<String>(COLUMNS.length);
            if (withTitles) {
                row.add(this.titles != null && i2 < this.titles.length ? this.titles[i2] : null);
            }
            row.add(props.getProperty(this.keys[i2], this.defaultValues[i2]));
            if (this.keys[i2].endsWith(PWD_ENCRYPTED)) {
                this.encryptedPassword = Boolean.valueOf(props.getProperty(this.keys[i2], this.defaultValues[i2]));
            }
            if (this.keys[i2].endsWith(PWD)) {
                passwordRow = i2 + 1;
            }
            this.model.addRow(Integer.MAX_VALUE, null, row);
            if (this.titles[i2] == null) {
                this.table.setRowHidden(i2 + 1, true);
                continue;
            }
            this.table.setRowHidden(i2 + 1, false);
        }
        if (this.encryptedPassword && passwordRow >= 0) {
            try {
                String encrpyted = this.model.getTableDataItem(passwordRow, 1).toString();
                this.model.setTableDataItem(PropertiesEditor.decryptPassword(encrpyted), passwordRow, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setProperties(Map<String, String> props) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            Vector<String> row = new Vector<String>(COLUMNS.length);
            row.add(entry.getKey());
            row.add(entry.getValue());
            this.model.addRow(Integer.MAX_VALUE, null, row);
        }
    }

    public String getSelectedPropertyKey() {
        int row = TableUtils.getFirstSelectedRow(this.table);
        if (row > 0 && row < this.table.getNumRows()) {
            return (String)this.table.getDataView().getTableDataItem(row, 0);
        }
        return null;
    }

    public String getSelectedPropertyValue() {
        int row = TableUtils.getFirstSelectedRow(this.table);
        if (row > 0 && row < this.table.getNumRows()) {
            return (String)this.table.getDataView().getTableDataItem(row, 1);
        }
        return null;
    }

    public void setSelectedPropertyKey(String key) {
        int row = TableUtils.getFirstSelectedRow(this.table);
        if (row > 0 && row < this.table.getNumRows()) {
            this.table.getDataView().setTableDataItem(key, row, 0);
        }
    }

    public void setSelectedPropertyValue(String value) {
        int row = TableUtils.getFirstSelectedRow(this.table);
        if (row > 0 && row < this.table.getNumRows()) {
            this.table.getDataView().setTableDataItem(value, row, 1);
        }
    }

    public void addProperty(String key, String value) {
        Vector<String> row = new Vector<String>(COLUMNS.length);
        row.add(key);
        row.add(value);
        this.model.addRow(Integer.MAX_VALUE, null, row);
    }

    public void removeSelectedRows() {
        int[] selectedRows = TableUtils.getSelectedRows(this.table);
        for (int i2 = selectedRows.length - 1; i2 >= 0; --i2) {
            this.model.deleteRows(selectedRows[i2], 1);
        }
    }

    private static String encryptPassword(String password) throws Exception {
        Key key;
        try {
            ObjectInputStream in = new ObjectInputStream(PropertiesEditor.class.getResourceAsStream("PropertyHelper.properties"));
            key = (Key)in.readObject();
            in.close();
        }
        catch (IOException fnfe) {
            return password;
        }
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, key);
        byte[] stringBytes = password.getBytes("UTF8");
        byte[] raw = cipher.doFinal(stringBytes);
        Base64.Encoder encoder = Base64.getEncoder();
        String base64 = encoder.encodeToString(raw);
        return base64;
    }

    private static String decryptPassword(String password) throws Exception {
        Key key;
        try {
            InputStream is = PropertiesEditor.class.getResourceAsStream("PropertyHelper.properties");
            ObjectInputStream in = new ObjectInputStream(is);
            key = (Key)in.readObject();
            in.close();
        }
        catch (IOException fnfe) {
            return password;
        }
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(2, key);
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] raw = decoder.decode(password);
        byte[] stringBytes = cipher.doFinal(raw);
        String result = new String(stringBytes, "UTF8");
        return result;
    }

    public static Hashtable filterProperties(Properties props) {
        Hashtable<String, String> originalValues = new Hashtable<String, String>(10, 10.0f);
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String pwdName;
            String pwd;
            String name = (String)en.nextElement();
            if (!name.endsWith(PWD_ENCRYPTED) || !Boolean.valueOf(props.getProperty(name, "false")).booleanValue() || (pwd = props.getProperty(pwdName = name.substring(0, name.length() - PWD_ENCRYPTED.length()) + PWD)) == null) continue;
            originalValues.put(pwdName, pwd);
            try {
                pwd = PropertiesEditor.decryptPassword(pwd);
                props.put(pwdName, pwd);
            }
            catch (Exception exception) {}
        }
        return originalValues;
    }

    public void getProperties(Properties props) {
        int i2;
        this.table.commitEdit(true);
        for (i2 = 0; i2 < this.keys.length; ++i2) {
            String val = (String)this.model.getTableDataItem(i2 + 1, 1);
            if (this.encryptedPassword && this.keys[i2].endsWith(PWD)) {
                try {
                    val = PropertiesEditor.encryptPassword(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            props.setProperty(this.keys[i2], val);
        }
        for (i2 = this.keys.length + 1; i2 < this.model.getNumRows(); ++i2) {
            props.setProperty((String)this.model.getTableDataItem(i2, 0), (String)this.model.getTableDataItem(i2, 1));
        }
    }

    public LinkedHashMap<String, String> getProperties() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        this.table.commitEdit(true);
        for (int i2 = 1; i2 < this.model.getNumRows(); ++i2) {
            String key = (String)this.model.getTableDataItem(i2, 0);
            if (key == null || key.length() == 0) continue;
            String val = (String)this.model.getTableDataItem(i2, 1);
            props.put(key, val);
        }
        return props;
    }

    public void setDefaultValues(String[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    public String[] getDefaultValues() {
        return this.defaultValues;
    }

    public void setToolTips(String[] toolTips) {
        if (toolTips == null) {
            throw new NullPointerException();
        }
        this.toolTips = toolTips;
    }

    public String[] getToolTips() {
        return this.toolTips;
    }

    public void addHiddenProperty(String key, String value) {
        Vector<String> r2 = new Vector<String>(2);
        r2.add(key);
        r2.add(value);
        this.model.addRow(Integer.MAX_VALUE, null, r2);
        this.table.setRowHidden(this.model.getNumRows() - 1, true);
    }

    @Override
    public void cellDisplay(JCCellDisplayEvent e2) {
        Object o2;
        if (e2.getColumn() == 1 && e2.getRow() > 0 && e2.getRow() < this.model.getNumRows() && (o2 = this.model.getTableDataItem(e2.getRow(), 0)) != null && o2.toString().equalsIgnoreCase("Password")) {
            StringBuffer s = new StringBuffer(o2.toString().length());
            for (int i2 = 0; i2 < o2.toString().length(); ++i2) {
                s.append("*");
            }
            e2.setDisplayData(s.toString());
        }
    }
}

