/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.repository.ProgressCallback;
import java.awt.Component;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class ProgressWatcher
implements ProgressCallback {
    private ProgressMonitor pm;
    private Component parent;
    private Object message;

    public ProgressWatcher(Component c2, Object message) {
        this.parent = c2;
        this.message = message;
    }

    public void close() {
        if (this.pm != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressWatcher.this.pm.close();
                }
            });
        }
    }

    @Override
    public boolean progressEvent(final int current, int total, final String descr) {
        if (this.pm == null) {
            this.pm = new ProgressMonitor(this.parent, this.message, descr, 0, total);
        }
        if (this.pm.isCanceled()) {
            return true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressWatcher.this.pm.setNote(descr);
                ProgressWatcher.this.pm.setProgress(current);
            }
        });
        return false;
    }
}

