/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.MIBCompiler;
import com.agentpp.common.ParserLogTree;
import com.agentpp.common.SortLabelRenderer;
import com.agentpp.mib.MIBModule;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.notepad.Notepad;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.CellStyleModel;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.FormatTree;
import com.klg.jclass.higrid.GridScrollbarCallback;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridErrorListener;
import com.klg.jclass.higrid.HiGridExpansionAdapter;
import com.klg.jclass.higrid.HiGridExpansionEvent;
import com.klg.jclass.higrid.HiGridFormatNodeAdapter;
import com.klg.jclass.higrid.HiGridFormatNodeEvent;
import com.klg.jclass.higrid.HiGridFormatNodeListener;
import com.klg.jclass.higrid.HiGridTraverseAdapter;
import com.klg.jclass.higrid.HiGridTraverseEvent;
import com.klg.jclass.higrid.HiGridTraverseListener;
import com.klg.jclass.higrid.HiGridUpdateAdapter;
import com.klg.jclass.higrid.HiGridUpdateEvent;
import com.klg.jclass.higrid.KeyActionInitiator;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.SortLabelCellRenderer;
import com.klg.jclass.higrid.TableNodeRenderer;
import com.klg.jclass.higrid.Walkable;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ParserLog
extends JPanel
implements HiGridErrorListener,
GridScrollbarCallback,
HiGridTraverseListener,
MIBImporter {
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    private static final Color HEADER_COLOR = new Color(200, 215, 250);
    private UserConfigFile config;
    JPanel toolBarPanel = new JPanel();
    JPanel errorPanel = new JPanel();
    JTextArea errorText = new JTextArea();
    HiGrid hiGrid = new HiGrid();
    JScrollPane scrollPane = new JScrollPane();
    JSplitPane splitPane = new JSplitPane(0);
    HiGridFormatNodeListener formatNodeListener = new BaseExampleHiGridFormatNodeListener();
    ParserLogTree data;
    private JFrame myFrame;
    private MIBImporter importer;
    private boolean lookupEnabled;

    public ParserLog() {
        this.init();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addMouseWheelListener();
    }

    public ParserLog(UserConfigFile config, JFrame myFrame, MIBImporter importer) {
        this();
        this.config = config;
        this.myFrame = myFrame;
        this.importer = importer;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.toolBarPanel, "North");
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setTopComponent(this.hiGrid);
        this.splitPane.setBottomComponent(this.errorPanel);
        this.errorPanel.setLayout(this.borderLayout2);
        this.errorPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add(this.errorText);
        this.errorText.setEditable(false);
        this.splitPane.setOneTouchExpandable(true);
        this.errorText.setToolTipText("Displays error description of the selected error");
    }

    public void setDividerLocation(double relativeLocation) {
        this.splitPane.setDividerLocation(relativeLocation);
    }

    private void init() {
        this.data = new ParserLogTree();
        TableNodeRenderer nodeRenderer = new TableNodeRenderer();
        this.hiGrid.getLookupTable().setNodeRenderer(nodeRenderer);
        this.hiGrid.getHorizontalScrollbar().setDisplay(0);
        this.hiGrid.addHiGridFormatNodeListener(this.formatNodeListener);
        this.hiGrid.addHiGridUpdateListener(new AutoColumnSizeHiGridUpdateListener());
        this.hiGrid.setBatched(true);
        this.hiGrid.setRowtipVisible(true);
        this.hiGrid.getEditPopupMenu().setDefaultMenuList(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().add((Component)new JMenuItem(new ExpandAllAction("Expand All")), 0);
        this.hiGrid.getEditPopupMenu().add((Component)new JMenuItem(new CollapseAllAction("Collapse All")), 1);
        this.hiGrid.getEditPopupMenu().add((Component)new JMenuItem(new EditAction("Edit...")), 2);
        this.hiGrid.setDataModel(this.data);
        this.hiGrid.setToolTipText("Double click on file or error to edit it");
        this.data.setDataModelListener(this.hiGrid.getDataModelListener());
        this.hiGrid.setBatched(false);
        KeyActionInitiator copy = new KeyActionInitiator(67, 2);
        this.hiGrid.getController().addAction(copy, 24);
        this.hiGrid.setEditorHidden(true);
        this.hiGrid.addHiGridExpansionListener(new ListModeHiGridExpansionListener());
        this.hiGrid.addHiGridTraverseListener(new ListModeHiGridTraverseListener());
        this.hiGrid.getErrorHandler().setShowErrorDialog(false);
        this.hiGrid.addHiGridErrorListener(this);
        this.hiGrid.setLevelIndented(true);
        this.hiGrid.setEditable(false);
        this.hiGrid.getVerticalScrollbar().setRowtipCallback(this);
        SortLabelCellRenderer.setAscendingImage(SortLabelRenderer.ascendingIcon.getImage());
        SortLabelCellRenderer.setDescendingImage(SortLabelRenderer.descendingIcon.getImage());
        this.createFormats();
        this.setFormatStyle(new Integer(0));
        this.addMouseWheelListener();
        this.hiGrid.setSortable(new CellValueComparator());
        this.hiGrid.addHiGridTraverseListener(this);
        this.hiGrid.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                CellPosition cp;
                if (e2.getClickCount() == 2 && (cp = ParserLog.this.hiGrid.getCellPositionFromPoint(e2.getPoint())) != null) {
                    RowNode node = cp.getRowNode();
                    ParserLog.this.edit(node);
                }
            }
        });
    }

    private void edit(RowNode node) {
        List errorList = null;
        DataTableModel model = node.getDataTableModel();
        List files = (List)model.getUserData("files");
        SMIParseException pex = null;
        File f2 = null;
        if (files != null) {
            Object[] fileRow;
            long bookmark = node.getBookmark();
            int index = model.getRowIndex(bookmark);
            if (index >= 0 && index < files.size() && (fileRow = (Object[])files.get(index)) != null) {
                DataTableModel errorModel = model.getTable(bookmark, this.data.getErrorsListMetaData());
                if (errorModel == null) {
                    errorModel = this.data.getErrorTable(bookmark);
                }
                if (errorModel != null && (errorList = (List)errorModel.getUserData("errors")) != null && errorList.size() > 0) {
                    pex = (SMIParseException)errorList.get(0);
                    Object path = fileRow[3];
                    if (path instanceof MIBCompiler.ZipReference) {
                        f2 = this.extractZipReference((MIBCompiler.ZipReference)path);
                        fileRow[3] = f2;
                    } else {
                        f2 = (File)path;
                    }
                }
            }
        } else {
            long bookmark;
            int index;
            errorList = (List)model.getUserData("errors");
            Object[] fileRow = (Object[])model.getUserData("file");
            if (fileRow != null && (index = model.getRowIndex(bookmark = node.getBookmark())) >= 0 && index < errorList.size()) {
                pex = (SMIParseException)errorList.get(index);
                Object path = fileRow[3];
                if (path instanceof MIBCompiler.ZipReference) {
                    f2 = this.extractZipReference((MIBCompiler.ZipReference)path);
                    fileRow[3] = f2;
                } else {
                    f2 = (File)path;
                }
            }
        }
        if (pex != null && f2 != null) {
            pex.setErrorList(errorList);
            this.showFile(pex, f2);
        }
    }

    private File extractZipReference(MIBCompiler.ZipReference ref) {
        try {
            byte[] b2;
            int l2;
            File n2 = new File(ref.entry.getName());
            File f2 = File.createTempFile("MIB_" + n2.getName(), ".txt");
            FileOutputStream fos = new FileOutputStream(f2);
            InputStream is = ref.file.getInputStream(ref.entry);
            while (is.available() > 0 && (l2 = is.read(b2 = new byte[is.available()])) > 0) {
                fos.write(b2, 0, l2);
            }
            fos.close();
            is.close();
            return f2;
        }
        catch (IOException iox) {
            JOptionPane.showMessageDialog(this, "Could not create temporary file: " + iox.getMessage(), "IO Error", 0);
            return null;
        }
    }

    protected void showFile(SMIParseException pex, File file) {
        StringTokenizer st;
        final Notepad np = pex.fileError != null ? (pex.fileError.getFoundTokenImage() != null ? new Notepad(this.myFrame, file, pex.fileError.getLine(), pex.fileError.getColumn(), pex.fileError.getFoundTokenImage().length()) : new Notepad(this.myFrame, file, pex.fileError.getLine(), pex.fileError.getColumn())) : (pex.objects != null ? new Notepad(this.myFrame, file, pex.objects.get(0).toString()) : (pex.getMessage() != null ? ((st = new StringTokenizer(pex.getMessage(), ", ")).hasMoreTokens() ? new Notepad(this.myFrame, file, st.nextToken()) : new Notepad(this.myFrame, file)) : new Notepad(this.myFrame, file)));
        np.setConfig(this.config);
        np.setImporter(this);
        np.setError(pex);
        np.setTitle(file.getName());
        np.setLocationRelativeTo(this.myFrame);
        np.setParserMode(1);
        np.setModal(true);
        np.setLookupEnabled(this.lookupEnabled);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                np.setVisible(true);
            }
        });
    }

    public void addResult(File f2, SMIParseException pex, Vector modules) {
        try {
            this.data.add(f2, pex, modules);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void addResult(MIBCompiler.ZipReference f2, SMIParseException pex, Vector modules) {
        try {
            this.data.add(f2, pex, modules);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void afterTraverse(HiGridTraverseEvent event) {
    }

    private void addMouseWheelListener() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> MouseWheelListener2 = cl.loadClass("java.awt.event.MouseWheelListener");
            cl = this.getClass().getClassLoader();
            Class<?> c2 = cl.loadClass("grid.GridMouseWheelListener");
            Constructor<?> constructor = c2.getDeclaredConstructors()[0];
            Object[] oargs = new Object[]{this.hiGrid};
            Object tableMouseWheelListener = null;
            tableMouseWheelListener = constructor.newInstance(oargs);
            Class[] params = new Class[]{MouseWheelListener2};
            Method addMouseWheelListener = null;
            addMouseWheelListener = this.hiGrid.getClass().getMethod("addMouseWheelListener", params);
            oargs[0] = tableMouseWheelListener;
            addMouseWheelListener.invoke((Object)this, oargs);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void setFormatStyle(Object style) {
        FormatTree formatTree = this.hiGrid.getFormatTree();
        if (formatTree == null || formatTree.getRoot() == null) {
            return;
        }
        this.setGlobalStyle((FormatNode)formatTree.getRoot(), style);
        this.hiGrid.refresh();
    }

    private void setGlobalStyle(FormatNode node, Object style) {
        if (node == null) {
            return;
        }
        this.setStyle(node, style);
        TreeIterator ti = node.getIterator();
        while (ti.hasMoreElements()) {
            node = (FormatNode)ti.get();
            this.setGlobalStyle(node, style);
            ti.nextElement();
        }
    }

    private void setStyle(FormatNode node, Object style) {
        this.setBorderStyle(node.getRecordFormat(), style);
        this.setBorderStyle(node.getHeaderFormat(), style);
        this.setBorderStyle(node.getFooterFormat(), style);
        this.setBorderStyle(node.getBeforeDetailsFormat(), style);
        this.setBorderStyle(node.getAfterDetailsFormat(), style);
    }

    private void setBorderStyle(RowFormat rowFormat, Object style) {
        CellFormat cellFormat;
        int borderStyle = (Integer)style;
        Enumeration e2 = rowFormat.getIndicatorFormats().elements();
        while (e2.hasMoreElements()) {
            cellFormat = (CellFormat)e2.nextElement();
            cellFormat.setBorderStyle(borderStyle);
        }
        e2 = rowFormat.getDataFormats().elements();
        while (e2.hasMoreElements()) {
            cellFormat = (CellFormat)e2.nextElement();
            cellFormat.setBorderStyle(borderStyle);
            cellFormat.setVerticalAlignment(1);
        }
    }

    protected void createFormats() {
        FormatTree formatTree = this.hiGrid.getFormatTree();
        FormatNode rootNode = (FormatNode)formatTree.getRoot();
        this.createNodeFormat(rootNode);
    }

    private void createNodeFormat(FormatNode node) {
        RecordFormat recordFormat = node.getRecordFormat();
        HeaderFormat headerFormat = node.getHeaderFormat();
        this.createRecordFormats(recordFormat);
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            FormatNode next = (FormatNode)node.getChildAt(i2);
            this.createNodeFormat(next);
        }
    }

    private void createRecordFormats(RecordFormat recordFormat) {
        Vector v = recordFormat.getDataFormats();
    }

    @Override
    public void processError(HiGridErrorEvent hiGridErrorEvent) {
        String msg = hiGridErrorEvent.getException().getMessage();
        if (hiGridErrorEvent.getException() instanceof DataModelException) {
            DataModelException ex = (DataModelException)hiGridErrorEvent.getException();
            Exception x = ex.getWrappedException();
            msg = ((DataModelException)x).getWrappedException().getMessage();
        }
        JOptionPane.showMessageDialog(this, msg, "Internal Error", 0);
    }

    @Override
    public String setRowtipText(RowNode rowNode, int currentValue, Adjustable adjustable) {
        return "Row index: " + Integer.toString(currentValue);
    }

    @Override
    public void positionRowtip(Container parent, Component rowtip) {
        if (parent != null) {
            rowtip.setSize(200, 24);
            Dimension containerDimension = parent.getSize();
            Dimension tipDimension = rowtip.getSize();
            int x = 0;
            int y = (containerDimension.height - tipDimension.height) / 2;
            rowtip.setLocation(x, y);
        }
    }

    public void refresh() {
        this.data.refreshFinished();
        this.hiGrid.refresh();
        this.setDividerLocation(0.75);
    }

    protected void selectCurrentRow() {
        if (this.hiGrid.getCurrentRowNode() != null) {
            RowNode node;
            SMIParseException pex;
            if (!this.hiGrid.getCurrentRowNode().isSelected()) {
                this.hiGrid.toggleRowSelection(this.hiGrid.getCurrentRowNode(), false);
            }
            if ((pex = this.getParseException(node = this.hiGrid.getCurrentRowNode())) != null) {
                String txt = DefaultRepositoryManager.getErrorText(pex);
                this.errorText.setText(txt);
                this.errorText.setCaretPosition(0);
            } else {
                this.errorText.setText("");
                this.errorText.setCaretPosition(0);
            }
        }
    }

    private SMIParseException getParseException(RowNode node) {
        long bookmark;
        int index;
        DataTableModel model = node.getDataTableModel();
        List errorList = (List)model.getUserData("errors");
        if (errorList != null && (index = model.getRowIndex(bookmark = node.getBookmark())) >= 0 && index < errorList.size()) {
            return (SMIParseException)errorList.get(index);
        }
        return null;
    }

    private void expandAll() {
        RowNode top = this.hiGrid.getRowNode(0);
        if (top == null) {
            return;
        }
        this.hiGrid.getRowTree().walk(top, new Walkable(){

            @Override
            public boolean getDownward() {
                return true;
            }

            @Override
            public boolean done() {
                return false;
            }

            @Override
            public void next(RowNode rowNode) {
                ParserLog.this.hiGrid.expandFolder(rowNode);
            }

            @Override
            public void previous(RowNode rowNode) {
                ParserLog.this.hiGrid.expandFolder(rowNode);
            }

            @Override
            public boolean find(RowNode rowNode) {
                return false;
            }
        });
    }

    @Override
    public ModuleInfo[] importMIB(Object caller, File file, int mode) throws SMIParseException, IOException {
        List files = this.data.getFiles();
        LinkedList<Integer> rows = new LinkedList<Integer>();
        int i2 = 0;
        Iterator it = files.iterator();
        while (it.hasNext()) {
            Object f2 = ((Object[])it.next())[3];
            if (file.equals(f2)) {
                rows.add(new Integer(i2));
            }
            ++i2;
        }
        try {
            int j2;
            ModuleInfo[] info = this.importer.importMIB(caller, file, mode);
            Vector<String> v = new Vector<String>();
            for (j2 = 0; j2 < info.length; ++j2) {
                v.add(info[j2].moduleName);
            }
            for (j2 = 0; j2 < rows.size(); ++j2) {
                RowNode row = this.hiGrid.getRowNode((Integer)rows.get(j2));
                this.data.replaceModules((Integer)rows.get(j2), v);
                if (j2 != 0) continue;
                this.hiGrid.toggleRowSelection(row, false, true);
            }
            this.data.refreshFinished();
            return info;
        }
        catch (SMIParseException pex) {
            int j3;
            for (j3 = 0; j3 < rows.size(); ++j3) {
                try {
                    this.data.replaceErrors((Integer)rows.get(j3), pex);
                    continue;
                }
                catch (DataModelException ex) {
                    ex.printStackTrace();
                }
            }
            this.data.refreshFinished();
            for (j3 = 0; j3 < rows.size(); ++j3) {
                int rowIndex = (Integer)rows.get(j3) + 1;
                RowNode row = this.hiGrid.getRowNode(rowIndex);
                this.hiGrid.expandFolder(row);
                if (j3 != 0) continue;
                this.hiGrid.toggleRowSelection(row, false, true);
            }
            throw pex;
        }
        catch (IOException iox) {
            throw iox;
        }
    }

    @Override
    public ModuleInfo[] checkMIB(Object caller, InputStream file, int mode) throws IOException, SMIParseException {
        return this.importer.checkMIB(caller, file, mode);
    }

    @Override
    public ModuleInfo[] importMIB(Object caller, InputStream is, String path, int mode) throws IOException, SMIParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MIBModule[] parseMIBs(Object caller, InputStream is, String path, int mode) throws IOException, SMIParseException {
        return this.importer.parseMIBs(caller, is, path, mode);
    }

    public boolean isLookupEnabled() {
        return this.lookupEnabled;
    }

    public void setLookupEnabled(boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
    }

    class ListModeHiGridTraverseListener
    extends HiGridTraverseAdapter {
        ListModeHiGridTraverseListener() {
        }

        @Override
        public void afterTraverse(HiGridTraverseEvent e2) {
            ParserLog.this.selectCurrentRow();
        }
    }

    class ListModeHiGridExpansionListener
    extends HiGridExpansionAdapter {
        ListModeHiGridExpansionListener() {
        }

        @Override
        public void afterExpandRow(HiGridExpansionEvent e2) {
            ParserLog.this.selectCurrentRow();
        }

        @Override
        public void afterCollapseRow(HiGridExpansionEvent e2) {
            ParserLog.this.selectCurrentRow();
        }
    }

    class ExpandAllAction
    extends AbstractAction {
        public ExpandAllAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ParserLog.this.expandAll();
        }
    }

    class EditAction
    extends AbstractAction {
        public EditAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ParserLog.this.edit(ParserLog.this.hiGrid.getCurrentRowNode());
        }
    }

    class CollapseAllAction
    extends AbstractAction {
        public CollapseAllAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                ParserLog.this.data.requeryAll(ParserLog.this.hiGrid.getDataModelListener());
            }
            catch (DataModelException ex) {
                ex.printStackTrace();
            }
        }
    }

    class BaseExampleHiGridFormatNodeListener
    extends HiGridFormatNodeAdapter {
        BaseExampleHiGridFormatNodeListener() {
        }

        @Override
        public void beforeCreateFormatNodeContents(HiGridFormatNodeEvent event) {
            CellStyleModel cellStyle = ParserLog.this.hiGrid.getRecordCellStyle();
            cellStyle.setBackground(Color.white);
        }
    }

    class AutoColumnSizeHiGridUpdateListener
    extends HiGridUpdateAdapter {
        AutoColumnSizeHiGridUpdateListener() {
        }

        @Override
        public void afterCreateRow(HiGridUpdateEvent ev) {
            RowNode rowNode = ev.getRowNode();
            DataTableModel dataTable = rowNode.getDataTableModel();
            RowFormat rowFormat = rowNode.getRowFormat();
            boolean repaintNeeded = false;
            if (rowFormat == null || dataTable == null) {
                return;
            }
            Enumeration e2 = rowFormat.getDataFormats().elements();
            while (e2.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)e2.nextElement();
                String name = cellFormat.getName();
                Object o2 = null;
                if (rowFormat instanceof RecordFormat) {
                    try {
                        o2 = dataTable.getResultData(rowNode.getBookmark(), name);
                    }
                    catch (Exception exception) {}
                } else if (rowFormat instanceof HeaderFormat) {
                    o2 = cellFormat.getText();
                }
                if (o2 == null) continue;
                int width = this.getStringWidth(ParserLog.this.hiGrid, cellFormat.getFont(), o2.toString());
                if (cellFormat.getWidth() >= width) continue;
                cellFormat.setWidth(width);
                repaintNeeded = true;
            }
            if (repaintNeeded) {
                ParserLog.this.hiGrid.refresh();
            }
        }

        private int getStringWidth(Component component, Font font, String s) {
            FontMetrics fm = component.getFontMetrics(font);
            return fm.stringWidth(s) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
        }
    }

    class CellValueComparator
    implements Comparator {
        CellValueComparator() {
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof File && o2 instanceof MIBCompiler.ZipReference) {
                return this.compare(o2, o1);
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

