/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.util.Vector;

public class MIBObjectInfoDataSource
extends JCVectorDataSource {
    private static final String[] COLUMNS = new String[]{"OID", "Name", "MIB", "Type", "Status", "Syntax", "Access"};
    private MIBRepository rep;

    public MIBObjectInfoDataSource(MIBRepository rep) {
        this.rep = rep;
        this.setNumColumns(COLUMNS.length);
        this.setNumRows(0);
        for (int i2 = 0; i2 < COLUMNS.length; ++i2) {
            this.setColumnLabel(i2, COLUMNS[i2]);
        }
    }

    public void addObject(MIBObject o2) {
        this.addRow(Integer.MAX_VALUE, null, this.getInfoOn(o2));
    }

    public Vector getInfoOn(MIBObject o2) {
        Vector<Object> v = new Vector<Object>(COLUMNS.length);
        v.addElement(o2.getOid());
        v.addElement(o2.getName());
        MIBModule m2 = this.rep.getModule(o2.getModuleID());
        if (m2 != null) {
            v.addElement(m2.getModuleName());
        } else {
            v.addElement("?");
        }
        v.addElement(o2.getTypeString());
        v.addElement(o2.getStatus());
        if (o2 instanceof MIBObjectType) {
            MIBObjectType ot = (MIBObjectType)o2;
            String s = ot.getSyntax().toSMI(1, this.rep, null, "\n");
            v.addElement(MIBObject.getFlatString(s));
            v.addElement(ot.getAccess());
        }
        return v;
    }
}

