/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.base.io.ExampleFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FilePanel
extends JPanel
implements ActionListener {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel label = new JLabel();
    private JTextField path = new JTextField();
    private JButton chooser = new JButton();
    private String defaultPath;
    private int selectionMode = 0;
    private int mode = 1;
    private transient Vector actionListeners;
    private ExampleFileFilter filter = null;

    public FilePanel() {
        this.path.addActionListener(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.label.setText("Path:");
        this.setLayout(this.gridBagLayout1);
        this.chooser.setText("Choose...");
        this.chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FilePanel.this.chooser_actionPerformed(e2);
            }
        });
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.path, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.chooser, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 11, 0, new Insets(8, 10, 10, 10), 0, 0));
    }

    public void setLabelText(String text) {
        if (text == null || text.length() == 0) {
            this.remove(this.label);
        }
        this.label.setText(text);
    }

    public String getLabelText() {
        return this.label.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.path.setEnabled(enabled);
        this.chooser.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    void chooser_actionPerformed(ActionEvent e2) {
        int r2;
        JFileChooser fc = new JFileChooser(this.defaultPath);
        File f2 = new File(this.path.getText());
        fc.setCurrentDirectory(f2.getParentFile());
        fc.setSelectedFile(f2);
        fc.setFileSelectionMode(this.selectionMode);
        fc.setDialogType(this.mode);
        if (this.filter != null) {
            fc.setFileFilter(this.filter);
        }
        if ((r2 = this.mode == 1 ? fc.showSaveDialog(this) : fc.showOpenDialog(this)) == 0) {
            this.path.setText(fc.getSelectedFile().getPath());
            this.fireActionPerformed(new ActionEvent(this, 1001, "FILE_SELECTED"));
        }
    }

    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setPathTextEnabled(boolean enable) {
        this.path.setEnabled(enable);
    }

    public boolean isPathTextEnabled() {
        return this.path.isEnabled();
    }

    public String getPath() {
        return this.path.getText();
    }

    public void setPath(String path) {
        this.path.setText(path);
    }

    public synchronized void removeActionListener(ActionListener l2) {
        if (this.actionListeners != null && this.actionListeners.contains(l2)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l2);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l2) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l2)) {
            v.addElement(l2);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e2) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ActionListener)listeners.elementAt(i2)).actionPerformed(e2);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.fireActionPerformed(new ActionEvent(this, 1001, "FILE_SELECTED"));
    }

    public void setFilter(ExampleFileFilter filter) {
        this.filter = filter;
    }

    public ExampleFileFilter getFilter() {
        return this.filter;
    }
}

