/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.table.PopupListTable;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FileList {
    private JPanel panel;
    private PopupListTable listTable;
    private List<File> fileList;
    private List<String> messages;
    private JCEditableVectorDataSource dataSource;

    public FileList(List<File> fileList, String columnLabel, List<Object> rowLabels, List<String> messages) {
        this.fileList = fileList;
        this.messages = messages;
        this.dataSource = new JCEditableVectorDataSource();
        this.dataSource.setNumColumns(messages == null ? 1 : 2);
        this.dataSource.setNumRows(0);
        this.$$$setupUI$$$();
        this.listTable.setPixelHeight(-997, 33002);
        this.listTable.setPixelWidth(-998, 33002);
        this.listTable.setVariableEstimateCount(5);
        if (columnLabel != null) {
            this.dataSource.setColumnLabels(new String[]{columnLabel});
        } else {
            this.listTable.setColumnLabelDisplay(false);
        }
        for (int i2 = 0; i2 < fileList.size(); ++i2) {
            File f2 = fileList.get(i2);
            Object rowLabel = null;
            if (rowLabels != null && i2 < rowLabels.size()) {
                rowLabel = rowLabels.get(i2);
            }
            if (messages == null) {
                this.dataSource.addRow(Integer.MAX_VALUE, rowLabel, new Vector<File>(Collections.singletonList(f2)));
                continue;
            }
            Vector<Object> row = new Vector<Object>(2);
            row.add(f2);
            row.add(messages.get(i2));
            this.dataSource.addRow(Integer.MAX_VALUE, rowLabel, row);
        }
        this.listTable.setDataSource(this.dataSource);
        this.listTable.setVisibleRows(10);
        this.listTable.getDefaultCellStyle().setEditable(false);
        this.listTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() > 1) {
                    JCCellPosition pos = FileList.this.listTable.XYToCell(e2.getPoint().x, e2.getPoint().y);
                    if (pos == null || pos.column != 0 || pos.row < 0) {
                        return;
                    }
                    Object fileObject = FileList.this.listTable.getDataView().getObject(pos.row, pos.column);
                    if (fileObject instanceof File) {
                        File file = (File)fileObject;
                        try {
                            Desktop.getDesktop().edit(file);
                        }
                        catch (IOException e1) {
                            JOptionPane.showMessageDialog(FileList.this.panel, "Failed to open '" + file + "': " + e1.getMessage(), "File IO Error", 0);
                        }
                    }
                }
            }
        });
    }

    public void setVisibleRows(int visibleRows) {
        this.listTable.setVisibleRows(visibleRows);
    }

    private void createUIComponents() {
        this.listTable = new PopupListTable();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.listTable, "Center");
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel.setLayout(new BorderLayout(0, 0));
        this.panel.add((Component)this.listTable, "Center");
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

