/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ExportPanel;
import com.agentpp.common.StatusBar;
import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.pdf.MIBModule2PDF;
import com.agentpp.mib.pdf.PDFPageSetupPanel;
import com.agentpp.mib.xml.MIBModule2XML;
import com.agentpp.mib.xsd.MIBModule2XSD;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowHtmlDialog;
import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class ExportThread
extends Thread {
    private JFrame frame;
    private MIBRepository rep;
    private ExportPanel exportPanel;
    private StatusBar statusBar;
    private String header;
    private String dtdURL;
    private RepositoryManager repMan;
    private boolean convertV2ToV1 = false;
    private UserConfigFile config;
    private String urlPrefixXSD = "http://www.mibexplorer.com/xsd/mibs/";

    public ExportThread(JFrame f2, StatusBar statusBar, UserConfigFile config, MIBRepository rep, ExportPanel exportPanel, String header, String dtdURL) {
        this.frame = f2;
        this.rep = rep;
        this.exportPanel = exportPanel;
        this.statusBar = statusBar;
        this.header = header;
        this.dtdURL = dtdURL;
        this.config = config;
        this.repMan = null;
    }

    public ExportThread(JFrame f2, StatusBar statusBar, UserConfigFile config, RepositoryManager repMan, ExportPanel exportPanel, String header, String dtdURL) {
        this.frame = f2;
        this.repMan = repMan;
        this.config = config;
        this.exportPanel = exportPanel;
        this.statusBar = statusBar;
        this.header = header;
        this.dtdURL = dtdURL;
    }

    @Override
    public void run() {
        try {
            if (this.exportPanel.isPDF()) {
                PDFPageSetupPanel p2 = new PDFPageSetupPanel();
                p2.load(this.config);
                Object[] options = new String[]{"OK", "Cancel"};
                if (JOptionPane.showOptionDialog(this.exportPanel.getDialog(), p2, "PDF Settings", 2, -1, null, options, options[0]) == 0) {
                    p2.save(this.config);
                } else {
                    this.statusBar.setMessage("Export canceled by user");
                    return;
                }
            }
            Vector modules = this.exportPanel.getModules();
            ProgressMonitor pm = new ProgressMonitor(this.frame, "Exporting...", "", 0, modules.size());
            boolean html = this.exportPanel.isHTML();
            boolean xml = this.exportPanel.isXML();
            boolean pdf = this.exportPanel.isPDF();
            boolean xsd = this.exportPanel.isXSD();
            boolean oidMapping = this.exportPanel.isOIDMapping();
            boolean appendOrigFileName = this.exportPanel.isAppendOrigFilename();
            String origFileNameSeparator = this.exportPanel.getOrigFileNameSeparator();
            int tabSize = this.exportPanel.getTabSize();
            this.exportMIBs(this.exportPanel.getExportPath(), modules, pm, html, xml, pdf, xsd, oidMapping, tabSize, this.exportPanel.isUseSpaces(), appendOrigFileName, origFileNameSeparator);
            if (pm.isCanceled()) {
                return;
            }
            SwingUtilities.invokeLater(new EventTrigger(pm));
            this.statusBar.setMessage("" + modules.size() + " MIB module" + (modules.size() == 1 ? "" : "s") + " exported to '" + this.exportPanel.getExportPath() + "'");
        }
        catch (Exception ix) {
            this.statusBar.setMessage("Export failed: " + ix.getMessage());
            ix.printStackTrace();
        }
    }

    public String exportMIBs(String path, Vector modules, ProgressMonitor pm, boolean html, boolean xml, boolean pdf, boolean xsd, boolean oidMapping, int tabSize, boolean useSpaces, boolean appendOrigFileName, String origFileNameSeparator) throws FileNotFoundException, IOException, DocumentException {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; !(i2 >= modules.size() || pm != null && pm.isCanceled()); ++i2) {
            FileOutputStream fos;
            File file;
            MIBModule module;
            if (pm != null) {
                if (pm.isCanceled()) {
                    SwingUtilities.invokeLater(new EventTrigger(pm));
                    return null;
                }
                pm.setProgress(i2);
            }
            if (this.repMan == null) {
                module = this.rep.getModule(modules.get(i2).toString());
            } else {
                String m2 = modules.get(i2).toString();
                try {
                    this.rep = null;
                    MIBObject[] objs = this.repMan.getObjects(m2);
                    MIBObject[] imp = this.repMan.getImportedObjects(m2);
                    this.rep = new MIBRepository(objs);
                    for (int j2 = 0; j2 < imp.length; ++j2) {
                        this.rep.addObject(imp[j2]);
                    }
                    this.rep.structureChanged();
                    module = this.rep.getModule(m2);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            if (module == null) continue;
            if (this.convertV2ToV1) {
                module.convertToSMIv1(this.rep);
            }
            if (pm != null) {
                pm.setNote(module.getModuleName());
            }
            if (xml) {
                file = this.getFile(path, module, ".xml", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                MIBModule2XML mxml = new MIBModule2XML(this.rep);
                mxml.output(fos, mxml.createXML(module, this.header, this.dtdURL), this.exportPanel.getTabSize());
                fos.close();
            } else if (pdf) {
                PDFPageSetupPanel p2 = new PDFPageSetupPanel();
                p2.load(this.config);
                file = this.getFile(path, module, ".pdf", appendOrigFileName, origFileNameSeparator);
                FileOutputStream fos2 = new FileOutputStream(file);
                MIBModule2PDF mpdf = new MIBModule2PDF(this.rep, SmiContext.getDefaultStyles(), tabSize);
                mpdf.setMode(this.getMode(mpdf.getMode()));
                mpdf.setFontSize(p2.getFontSize());
                mpdf.setKeepTogether(p2.isKeepTogether());
                mpdf.setOutlineAsTree(p2.isOutlineAsTree());
                mpdf.setDisplayPageNumbers(p2.isDisplayPageNumbers());
                mpdf.setDisplayCurrentDate(p2.isDisplayCurrentDate());
                mpdf.writePDF(module, fos2, this.header, p2.getPageSizeRectangle());
                fos2.close();
            } else if (html) {
                file = this.getFile(path, module, ".html", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                int mode = 6;
                mode = this.getMode(mode);
                String s = "<body  link=\"#808080\"><pre>" + ShowHtmlDialog.replaceTabs(module.toSMI(mode, this.rep, MIBObject.getLineSeparator()), tabSize) + "</pre></body>";
                fos.write(s.getBytes());
                fos.close();
            } else if (xsd) {
                file = this.getFile(path, module, ".xsd", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                MIBModule2XSD mxsd = new MIBModule2XSD(this.rep);
                mxsd.setURLPrefix(this.urlPrefixXSD);
                mxsd.output(fos, mxsd.createXML(module, this.header, this.dtdURL), this.exportPanel.getTabSize());
                fos.close();
            } else if (oidMapping) {
                file = this.getFile(path, module, ".txt", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                Enumeration it = module.objectsByOid().elements();
                while (it.hasMoreElements()) {
                    MIBObject mibObject = (MIBObject)it.nextElement();
                    String s = mibObject.getPrintableOid() + "=" + mibObject.getName();
                    fos.write(s.getBytes());
                    fos.write(MIBObject.getLineSeparator().getBytes());
                }
                fos.close();
            } else {
                file = this.getFile(path, module, ".txt", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                int mode = 1;
                mode = this.getMode(mode);
                if (useSpaces) {
                    String s = module.toSMI(mode, this.rep, MIBObject.getLineSeparator());
                    s = ShowHtmlDialog.replaceTabs(s, tabSize);
                    fos.write(s.getBytes());
                } else {
                    fos.write(module.toSMI(mode, this.rep, MIBObject.getLineSeparator()).getBytes());
                }
                fos.close();
            }
            buf.append(file.getPath());
            buf.append(" ");
        }
        return buf.toString();
    }

    private File getFile(String path, MIBModule module, String suffix, boolean appendOrigFilename, String separator) throws IOException {
        String name = module.getModuleName();
        if (appendOrigFilename && module.getFileName() != null && module.getFileName().trim().length() > 0) {
            int dotpos;
            String fileName = new File(module.getFileName()).getName();
            if (fileName.startsWith(name)) {
                fileName = fileName.substring(name.length());
                if (separator.length() > 0 && fileName.startsWith(separator)) {
                    fileName = fileName.substring(separator.length());
                }
            }
            if ((dotpos = fileName.lastIndexOf(46)) >= 0) {
                fileName = fileName.substring(0, dotpos);
            }
            if (fileName.trim().length() > 0) {
                name = name + separator + fileName;
            }
        }
        if (path == null) {
            return File.createTempFile(name, suffix);
        }
        return new File(path, name + suffix);
    }

    private int getMode(int mode) {
        mode |= this.config.getBoolean("OrderByType", true) ? 256 : 0;
        mode |= this.config.getBoolean("PreserveOrder", true) ? 128 : 0;
        mode |= this.config.getBoolean("GenerateComments", true) ? 32 : 0;
        return mode |= this.config.getBoolean("GenerateCommentsInline", false) ? 1024 : 0;
    }

    public void setConvertV2ToV1(boolean convertV2ToV1) {
        this.convertV2ToV1 = convertV2ToV1;
    }

    public boolean isConvertV2ToV1() {
        return this.convertV2ToV1;
    }

    public void setURLPrefixXSD(String urlPrefix) {
        this.urlPrefixXSD = urlPrefix;
    }

    class EventTrigger
    implements Runnable {
        private ProgressMonitor pm;

        public EventTrigger(ProgressMonitor pm) {
            this.pm = pm;
        }

        @Override
        public void run() {
            this.pm.close();
        }
    }
}

