/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.Suggestion;
import java.util.Enumeration;
import java.util.Vector;

public class SuggestionSet {
    private int maxWords;
    private Vector suggestions;

    public SuggestionSet(int n) {
        this.maxWords = n;
        if (this.maxWords <= 0) {
            this.maxWords = 1;
        }
        this.suggestions = new Vector();
    }

    public boolean add(String string, int n, boolean bl) {
        int n2;
        Suggestion suggestion;
        if (n <= 0) {
            return false;
        }
        if (this.suggestions.size() == this.maxWords) {
            suggestion = (Suggestion)this.suggestions.elementAt(this.suggestions.size() - 1);
            if (n <= suggestion.score) {
                return false;
            }
        }
        suggestion = new Suggestion();
        suggestion.word = new String(string);
        suggestion.score = n;
        suggestion.matchCase = bl;
        int n3 = this.suggestions.indexOf(suggestion);
        if (n3 >= 0) {
            return false;
        }
        for (n2 = 0; n2 < this.suggestions.size(); ++n2) {
            Suggestion suggestion2 = (Suggestion)this.suggestions.elementAt(n2);
            if (n > suggestion2.score) break;
        }
        if (this.suggestions.size() >= this.maxWords) {
            this.suggestions.setSize(this.suggestions.size() - 1);
        }
        this.suggestions.insertElementAt(suggestion, n2);
        return true;
    }

    public boolean add(String string, int n) {
        return this.add(string, n, true);
    }

    public void clear() {
        this.suggestions.removeAllElements();
    }

    public void deleteAt(int n) {
        this.suggestions.removeElementAt(n);
    }

    public boolean getMatchCaseAt(int n) {
        Suggestion suggestion = (Suggestion)this.suggestions.elementAt(n);
        return suggestion.matchCase;
    }

    public void replaceAt(int n, String string) {
        Suggestion suggestion = (Suggestion)this.suggestions.elementAt(n);
        suggestion.word = new String(string);
        this.suggestions.setElementAt(suggestion, n);
    }

    public int size() {
        return this.suggestions.size();
    }

    public int scoreAt(int n) throws ArrayIndexOutOfBoundsException {
        Suggestion suggestion = (Suggestion)this.suggestions.elementAt(n);
        return suggestion.score;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.suggestions.size(); ++i) {
            Suggestion suggestion = (Suggestion)this.suggestions.elementAt(i);
            stringBuffer.append(suggestion.word);
            if (i >= this.suggestions.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String wordAt(int n) throws ArrayIndexOutOfBoundsException {
        Suggestion suggestion = (Suggestion)this.suggestions.elementAt(n);
        return suggestion.word;
    }

    public Enumeration words() {
        Vector<String> vector = new Vector<String>(this.suggestions.size());
        for (int i = 0; i < this.suggestions.size(); ++i) {
            Suggestion suggestion = (Suggestion)this.suggestions.elementAt(i);
            vector.addElement(suggestion.word);
        }
        return vector.elements();
    }
}

