/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.Lexicon;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.ssce.UnsupportedException;
import com.wintertree.ssce.WordComparator;
import com.wintertree.ssce.WordParser;
import com.wintertree.util.UniCharacter;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SpellingSession
implements Serializable,
Cloneable {
    public static final int MAX_SUGGEST_DEPTH = 100;
    public static final int MAX_WORD_LEN = 63;
    public static final int CASE_SENSITIVE_OPT = 1;
    public static final int IGNORE_ALL_CAPS_WORD_OPT = 2;
    public static final int IGNORE_CAPPED_WORD_OPT = 4;
    public static final int IGNORE_MIXED_CASE_OPT = 8;
    public static final int IGNORE_MIXED_DIGITS_OPT = 16;
    public static final int IGNORE_NON_ALPHA_WORD_OPT = 32;
    public static final int REPORT_DOUBLED_WORD_OPT = 64;
    public static final int REPORT_MIXED_CASE_OPT = 128;
    public static final int REPORT_MIXED_DIGITS_OPT = 256;
    public static final int REPORT_SPELLING_OPT = 512;
    public static final int REPORT_UNCAPPED_OPT = 1024;
    public static final int SPLIT_CONTRACTED_WORDS_OPT = 2048;
    public static final int SPLIT_HYPHENATED_WORDS_OPT = 4096;
    public static final int SPLIT_WORDS_OPT = 8192;
    public static final int STRIP_POSSESSIVES_OPT = 16384;
    public static final int SUGGEST_SPLIT_WORDS_OPT = 32768;
    public static final int IGNORE_DOMAIN_NAMES_OPT = 65536;
    public static final int ALLOW_ACCENTED_CAPS_OPT = 131072;
    public static final int AUTO_CHANGE_WORD_RSLT = 1;
    public static final int CONDITIONALLY_CHANGE_WORD_RSLT = 2;
    public static final int DOUBLED_WORD_RSLT = 4;
    public static final int END_OF_TEXT_RSLT = 8;
    private static final int EXCLUDE_WORD_RSLT = 4096;
    public static final int MISSPELLED_WORD_RSLT = 16;
    public static final int MIXED_CASE_WORD_RSLT = 32;
    public static final int MIXED_DIGITS_WORD_RSLT = 64;
    public static final int OK_RSLT = 0;
    public static final int UNCAPPED_WORD_RSLT = 128;
    private static final int EXCLUDED_WORD_RSLT = 256;
    private Lexicon[] lexicons = null;
    private int options = 153121;
    private static Hashtable opts = null;
    private String misspelledWord = null;
    private int misspelledWordOffset = 0;

    public int check(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        return this.check(string, stringBuffer);
    }

    public int check(String string, StringBuffer stringBuffer) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        String string2 = string;
        if ((this.options & 0x4000) != 0) {
            string2 = SpellingSession.stripPossessives(string);
        }
        if ((n4 = string2.length()) == 0) {
            return n5;
        }
        stringBuffer.setLength(0);
        stringBuffer.append(string);
        this.misspelledWord = string;
        this.misspelledWordOffset = 0;
        if ((this.options & 0x200) == 0 && this.ignoreWord(string2)) {
            return n5;
        }
        if ((this.options & 0x200) != 0) {
            n3 = this.checkWord2(string2, stringBuffer);
            if ((n3 & 0x10) != 0) {
                CharSequence charSequence;
                if ((this.options & 0x2000) != 0) {
                    n2 = 0;
                    for (n = 2; n <= n4 - 2 && n2 == 0; ++n) {
                        charSequence = string2.substring(0, n);
                        String string3 = this.misspelledWord;
                        int n6 = this.misspelledWordOffset;
                        this.options &= 0xFFFFDFFF;
                        boolean bl = this.check((String)charSequence) == 0;
                        this.options |= 0x2000;
                        if (bl) {
                            if (this.check(string2.substring(n)) == 0) {
                                n2 = 1;
                            } else {
                                StringBuffer stringBuffer2 = new StringBuffer();
                                stringBuffer2.append(Character.toUpperCase(string2.charAt(n)));
                                if (string2.length() > n + 1) {
                                    stringBuffer2.append(string2.substring(n + 1));
                                }
                                if (this.check(stringBuffer2.toString()) == 0) {
                                    n2 = 1;
                                }
                            }
                        }
                        this.misspelledWord = string3;
                        this.misspelledWordOffset = n6;
                    }
                    if (n2 != 0) {
                        n3 &= 0xFFFFFFEF;
                    }
                }
                if ((n3 & 0x10) != 0 && (this.options & 0x1800) != 0 && this.containsSubWords(string2)) {
                    n2 = 1;
                    charSequence = new StringBuffer();
                    for (n = 0; n < n4 && n2 != 0; n += this.getSubWord(string2.substring(n), (StringBuffer)charSequence)) {
                        this.misspelledWordOffset = n;
                        int n7 = this.checkWord2(((StringBuffer)charSequence).toString(), stringBuffer);
                        if ((n7 & 0x1010) == 0) continue;
                        this.misspelledWord = ((StringBuffer)charSequence).toString();
                        n2 = 0;
                    }
                    if (n2 != 0) {
                        n3 &= 0xFFFFFFEF;
                    }
                }
            }
            if ((n3 & 0x1000) != 0) {
                n3 &= 0xFFFFEFFF;
                n3 |= 0x10;
            }
            n5 |= n3;
        }
        if ((this.options & 0x80) != 0 && this.isMixedCase(string2)) {
            n5 |= 0x20;
            for (n3 = 0; n3 < stringBuffer.length(); ++n3) {
                stringBuffer.setCharAt(n3, Character.toUpperCase(stringBuffer.charAt(n3)));
            }
            if (UniCharacter.isUpperCase(string.charAt(0)) && stringBuffer.length() > 0) {
                stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            }
        }
        if ((this.options & 0x100) != 0) {
            n3 = 0;
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                char c = string2.charAt(n);
                if (!(UniCharacter.isApostrophe(c) || UniCharacter.isLetter(c) || UniCharacter.isHyphen(c))) {
                    n3 = 1;
                    continue;
                }
                if (!UniCharacter.isLetter(c)) continue;
                n2 = 1;
            }
            if (n2 != 0 && n3 != 0) {
                n5 |= 0x40;
            }
        }
        if ((n5 & 0x40) != 0) {
            n3 = 0;
            if (stringBuffer.length() > 0) {
                n3 = UniCharacter.isLetter(stringBuffer.charAt(0)) ? 1 : 0;
            }
            for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
                n = stringBuffer.charAt(n2);
                if (n3 != 0 && UniCharacter.isDigit((char)n) || n3 == 0 && UniCharacter.isLetter((char)n)) {
                    stringBuffer.insert(n2, ' ');
                    ++n2;
                }
                n3 = UniCharacter.isLetter((char)n) ? 1 : 0;
            }
        }
        if ((this.options & 0x400) != 0 && (this.options & 1) != 0 && (n5 & 0x10) != 0 && UniCharacter.isLowerCase(string.charAt(0))) {
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(Character.toUpperCase(string2.charAt(0)));
            stringBuffer3.append(string.substring(1));
            n3 = this.checkWord3(stringBuffer3.toString(), string2, stringBuffer);
            if (n3 != 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(stringBuffer3.toString());
                n5 |= 0x80;
            } else {
                String string4 = string.toUpperCase();
                n3 = this.checkWord3(string4, string2, stringBuffer);
                if (n3 != 0) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(string4);
                    n5 |= 0x80;
                }
            }
        }
        if ((this.options & 0x20000) == 0 && (n5 & 0x10) == 0) {
            for (n3 = 0; n3 < n4; ++n3) {
                char c = string2.charAt(n3);
                if (!UniCharacter.isUpperCase(c) || c == UniCharacter.toBase(c)) continue;
                n5 |= 0x10;
                this.matchCase(stringBuffer, false, true, stringBuffer.toString());
                break;
            }
        }
        if (stringBuffer.length() > 0) {
            SpellingSession.restorePossessives(stringBuffer, string);
        }
        return n5;
    }

    public int check(WordParser wordParser, StringBuffer stringBuffer) {
        int n = 0;
        while (wordParser.hasMoreElements()) {
            String string = wordParser.getWord();
            n = this.check(string, stringBuffer);
            if ((this.options & 0x40) != 0 && !this.ignoreWord(string) && wordParser.isDoubledWord((this.options & 1) != 0)) {
                n |= 4;
                this.misspelledWordOffset = 0;
                this.misspelledWord = string;
            }
            if (n != 0) {
                if ((n & 0x10) != 0) {
                    wordParser.setCursor(wordParser.getCursor() + this.misspelledWordOffset);
                    wordParser.setWordLength(this.misspelledWord.length());
                }
                return n;
            }
            wordParser.nextWord();
        }
        return 8;
    }

    public Object clone() {
        SpellingSession spellingSession = null;
        try {
            spellingSession = (SpellingSession)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        spellingSession.setLexicons(this.getLexicons());
        spellingSession.options = this.options;
        spellingSession.misspelledWord = this.misspelledWord != null ? new String(this.misspelledWord) : null;
        spellingSession.misspelledWordOffset = this.misspelledWordOffset;
        return spellingSession;
    }

    public Lexicon[] getLexicons() {
        return this.lexicons;
    }

    public boolean getOption(int n) {
        return (this.options & n) != 0;
    }

    public static int getOption(Integer n) {
        if (opts != null) {
            Integer n2 = (Integer)opts.get(n);
            if (n2 == null) {
                return 0;
            }
            return n2;
        }
        return 0;
    }

    public String getMisspelledWord() {
        return this.misspelledWord;
    }

    public int getMisspelledWordOffset() {
        return this.misspelledWordOffset;
    }

    public void setLexicons(Lexicon[] lexiconArray) {
        try {
            int n;
            if (lexiconArray == null) {
                throw new UnsupportedException();
            }
            try {
                n = -1479411111;
                int n2 = 139;
                int n3 = 140;
                int n4 = 647;
                int n5 = 1999;
                int n6 = 151;
                int n7 = 499;
                int n8 = SpellingSession.getOption(new Integer(32));
                if ((n8 & 0xF3) == 162) {
                    int n9 = (n8 & 0x1F00) >> 8;
                    int n10 = (n8 & 0x1FFE000) >> 13;
                    int n11 = (n8 & 0xC) >> 2;
                    Date date = new Date();
                    Date date2 = new GregorianCalendar(2000 + n11 * 10, 0, 1).getTime();
                    Date date3 = new Date(date2.getTime() + (long)n10 * 86400000L);
                    long l = System.currentTimeMillis();
                    long l2 = (long)SpellingSession.getOption(new Integer(16)) * 1000L;
                    int n12 = n8 & 0x7FFFE000;
                    int n13 = 0;
                    for (int i = 0; i < 32; ++i) {
                        n13 += n12 & 1;
                        n12 >>= 1;
                    }
                    if (n13 != n9) {
                        throw new Exception();
                    }
                    if (date.after(date3)) {
                        if (l > l2 + 900000L) {
                            String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00d0\u00c5\u00d2\u00c9\u00cf\u00c4\u00a0\u00c5\u00d8\u00d0\u00c9\u00d2\u00c5\u00c4", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00ae", "\u00d9\u00ef\u00f5\u00f2\u00a0\u00b3\u00b0\u00ad\u00e4\u00e1\u00f9\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00ec\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5\u00a0\u00e8\u00e1\u00f3\u00a0\u00ee\u00ef\u00f7\u00a0\u00e5\u00f8\u00f0\u00e9\u00f2\u00e5\u00e4\u00ae", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                            for (int i = 0; i < stringArray.length; ++i) {
                                for (int j = 0; j < stringArray[i].length(); ++j) {
                                    System.out.print((char)(stringArray[i].charAt(j) & 0x7F));
                                }
                                System.out.println();
                            }
                            SpellingSession.setOption(new Integer(16), new Integer((int)(l / 1000L)));
                        }
                        throw new Exception();
                    }
                    if (l > l2 + 900000L) {
                        String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00c6\u00cf\u00d2\u00a0\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00cf\u00ce\u00cc\u00d9\u00a0\u00ad\u00a0\u00ce\u00cf\u00d4\u00a0\u00c6\u00cf\u00d2\u00a0\u00d0\u00d2\u00cf\u00c4\u00d5\u00c3\u00d4\u00c9\u00cf\u00ce\u00a0\u00d5\u00d3\u00c5", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00a1", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                        for (int i = 0; i < stringArray.length; ++i) {
                            for (int j = 0; j < stringArray[i].length(); ++j) {
                                System.out.print((char)(stringArray[i].charAt(j) & 0x7F));
                            }
                            System.out.println();
                        }
                        SpellingSession.setOption(new Integer(16), new Integer((int)(l / 1000L)));
                    }
                } else {
                    int n14;
                    long l = n8 ^ n;
                    long l3 = 0L;
                    for (n14 = 0; n14 < 32; ++n14) {
                        long l4 = l >> n14 & 1L;
                        l3 |= l4 << 31 - n14;
                    }
                    n14 = (int)(l3 / 10000L);
                    if (n14 != n2 && n14 != n3) {
                        throw new Exception();
                    }
                    int n15 = (int)(l3 % 10000L);
                    if (n14 == n2 && n15 < n4 || n15 > n5) {
                        throw new Exception();
                    }
                    if (n14 == n3 && (n15 < n6 || n15 > n7)) {
                        throw new Exception();
                    }
                }
            }
            catch (Exception exception) {
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() < l + 1000L) {
                }
                throw new UnsupportedException();
            }
            this.lexicons = new Lexicon[lexiconArray.length];
            for (n = 0; n < lexiconArray.length; ++n) {
                this.lexicons[n] = lexiconArray[n];
            }
        }
        catch (UnsupportedException unsupportedException) {
            this.lexicons = new Lexicon[0];
        }
    }

    public boolean setOption(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.options & n) != 0;
        this.options = bl ? (this.options |= n) : (this.options &= ~n);
        return bl2;
    }

    public static void setOption(Integer n, Integer n2) {
        if (opts == null) {
            opts = new Hashtable();
        }
        opts.put(n, n2);
    }

    public void suggest(String string, int n, WordComparator wordComparator, SuggestionSet suggestionSet) {
        int n2;
        int n3;
        int n4;
        int n5;
        CharSequence charSequence;
        int n6;
        String string2 = string;
        if ((this.options & 0x4000) != 0) {
            string2 = SpellingSession.stripPossessives(string);
        }
        if (string2.length() == 0) {
            return;
        }
        for (n6 = this.lexicons.length - 1; n6 >= 0; --n6) {
            if (this.lexicons[n6] == null) continue;
            this.lexicons[n6].suggest(string2, n, wordComparator, suggestionSet);
        }
        if ((this.options & 0x8000) != 0) {
            for (n6 = 1; n6 < string2.length(); ++n6) {
                charSequence = string2.substring(0, n6);
                String string3 = string2.substring(n6);
                n5 = this.options;
                this.options |= 0x200;
                if (this.check((String)charSequence) == 0 && this.check(string3) == 0) {
                    String string4 = (String)charSequence + " " + string3;
                    suggestionSet.add(string4, wordComparator.compare(string, string4));
                }
                this.options = n5;
            }
        }
        if ((this.options & 0x4000) != 0 && string2.length() >= 2 && ((n6 = (int)string2.charAt(string2.length() - 1)) == 115 || n6 == 83 && !UniCharacter.isApostrophe(string2.charAt(string2.length() - 2)))) {
            charSequence = new StringBuffer(string2);
            ((StringBuffer)charSequence).insert(((StringBuffer)charSequence).length() - 1, '\'');
            if (this.check(((StringBuffer)charSequence).toString()) != 16) {
                suggestionSet.add(((StringBuffer)charSequence).toString(), wordComparator.compare(string, ((StringBuffer)charSequence).toString()));
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (n4 = 0; n4 < stringBuffer.length() - 1; ++n4) {
            char c = stringBuffer.charAt(n4);
            n5 = stringBuffer.charAt(n4 + 1);
            char c2 = c;
            n3 = n5;
            if (UniCharacter.isUpperCase(c2) && UniCharacter.isLowerCase((char)n3)) {
                c2 = Character.toLowerCase(c2);
                n3 = Character.toUpperCase((char)n3);
            }
            stringBuffer.setCharAt(n4, (char)n3);
            stringBuffer.setCharAt(n4 + 1, c2);
            if (this.check(stringBuffer.toString()) == 0) {
                suggestionSet.add(stringBuffer.toString(), wordComparator.compare(string, stringBuffer.toString()));
            }
            stringBuffer.setCharAt(n4 + 1, (char)n5);
            stringBuffer.setCharAt(n4, c);
        }
        for (n4 = 0; n4 < string2.length(); ++n4) {
            String string5;
            String string6 = "";
            String string7 = "";
            if (n4 > 0) {
                string6 = string2.substring(0, n4);
            }
            if (n4 + 1 < string2.length()) {
                string7 = string2.substring(n4 + 1);
            }
            if (this.check(string5 = string6 + string7) != 0) continue;
            suggestionSet.add(string5, wordComparator.compare(string, string5));
        }
        n4 = 0;
        for (n2 = 0; n2 < string2.length(); ++n2) {
            if (!UniCharacter.isPunctuation(string2.charAt(n2))) continue;
            ++n4;
        }
        if (n4 == 1) {
            for (n2 = 0; n2 < string2.length() && !UniCharacter.isPunctuation(string2.charAt(n2)); ++n2) {
            }
            String string8 = null;
            if (n2 > 0) {
                string8 = string2.substring(0, n2);
            }
            String string9 = null;
            if (n2 < string2.length() - 1) {
                string9 = string2.substring(n2 + 1);
            }
            n3 = this.options;
            this.options |= 0x200;
            if (string8 != null && string9 != null && this.check(string8) == 0 && this.check(string9) == 0) {
                StringBuffer stringBuffer2 = new StringBuffer(string8);
                stringBuffer2.append(string2.charAt(n2));
                stringBuffer2.append(' ');
                stringBuffer2.append(string9);
                suggestionSet.add(stringBuffer2.toString(), wordComparator.compare(string, stringBuffer2.toString()));
            }
            this.options = n3;
        }
        for (n2 = 0; n2 < suggestionSet.size(); ++n2) {
            if (!suggestionSet.getMatchCaseAt(n2)) continue;
            String string10 = suggestionSet.wordAt(n2);
            StringBuffer stringBuffer3 = new StringBuffer(string10);
            this.matchCase(stringBuffer3, false, (this.options & 0x20000) != 0, string);
            SpellingSession.restorePossessives(stringBuffer3, string);
            if (string10.equals(stringBuffer3.toString())) continue;
            suggestionSet.replaceAt(n2, stringBuffer3.toString());
        }
        for (n2 = 0; n2 < suggestionSet.size(); ++n2) {
            for (int i = n2 + 1; i < suggestionSet.size(); ++i) {
                if (!suggestionSet.wordAt(n2).equals(suggestionSet.wordAt(i))) continue;
                suggestionSet.deleteAt(i);
            }
        }
    }

    public static String version() {
        String string = "$Revision: 5.10.16 $";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    private int actionToResultMask(int n) {
        switch (n) {
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 101: {
                return 4096;
            }
        }
        return 0;
    }

    private int checkWord2(String string, StringBuffer stringBuffer) {
        int n;
        StringBuffer stringBuffer2;
        if (this.lexicons == null) {
            return 16;
        }
        if (this.ignoreWord(string)) {
            return 0;
        }
        int n2 = this.checkWord3(string, string, stringBuffer);
        if (n2 != 0) {
            return this.actionToResultMask(n2);
        }
        if ((this.options & 1) != 0 && string.length() > 0 && UniCharacter.isUpperCase(string.charAt(0))) {
            stringBuffer2 = new StringBuffer(string.length());
            stringBuffer2.append(Character.toLowerCase(string.charAt(0)));
            stringBuffer2.append(string.substring(1));
            n2 = this.checkWord3(stringBuffer2.toString(), string, stringBuffer);
            if (n2 != 0) {
                return this.actionToResultMask(n2);
            }
        }
        if ((this.options & 1) != 0) {
            boolean bl = true;
            int c2 = string.length();
            for (n = 0; n < c2; ++n) {
                if (!UniCharacter.isLetter(string.charAt(n)) || UniCharacter.isUpperCase(string.charAt(n))) continue;
                bl = false;
                break;
            }
            if (bl) {
                n = this.options;
                this.options &= 0xFFFFFFFE;
                n2 = this.checkWord3(string, string, stringBuffer);
                this.options = n;
                if (n2 != 0) {
                    return this.actionToResultMask(n2);
                }
            }
        }
        if ((this.options & 0x20000) == 0 && UniCharacter.isUpperCase(string.charAt(0))) {
            char c;
            stringBuffer2 = new StringBuffer(string);
            do {
                n = this.options;
                this.options |= 0x20000;
                int n3 = this.checkWord2(stringBuffer2.toString(), stringBuffer);
                this.options = n;
                if ((n3 & 0x10) != 0) {
                    return n3;
                }
                c = UniCharacter.nextAccentFromBase(UniCharacter.toBase(string.charAt(0)), stringBuffer2.charAt(0));
                if (c == '\u0000') continue;
                stringBuffer2.setCharAt(0, c);
            } while (c != '\u0000');
        }
        return 16;
    }

    private int checkWord3(String string, String string2, StringBuffer stringBuffer) {
        for (int i = 0; i < this.lexicons.length; ++i) {
            if (this.lexicons[i] == null) continue;
            int n = this.lexicons[i].findWord(string, (this.options & 1) != 0, stringBuffer);
            if (n == 0) continue;
            if (n == 65 || n == 67) {
                this.matchCase(stringBuffer, false, (this.options & 0x20000) != 0, string2);
            }
            return n;
        }
        return 0;
    }

    protected boolean containsSubWords(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ((this.options & 0x1000) != 0 && UniCharacter.isHyphen(c)) {
                return true;
            }
            if ((this.options & 0x800) == 0 || !UniCharacter.isApostrophe(c)) continue;
            return true;
        }
        return false;
    }

    protected int getSubWord(String string, StringBuffer stringBuffer) {
        int n = 0;
        stringBuffer.setLength(0);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if ((this.options & 0x1000) != 0 && UniCharacter.isHyphen(c)) {
                ++n;
                break;
            }
            if ((this.options & 0x800) != 0 && UniCharacter.isApostrophe(c)) {
                ++n;
                break;
            }
            stringBuffer.append(c);
            ++n;
        }
        return n;
    }

    protected boolean ignoreWord(String string) {
        int n;
        int n2;
        int n3 = string.length();
        if ((this.options & 0x20) != 0) {
            n2 = 0;
            for (n = 0; n < n3 && n2 == 0; ++n) {
                if (!UniCharacter.isLetter(string.charAt(n))) continue;
                n2 = 1;
            }
            if (n2 == 0) {
                return true;
            }
        }
        if ((this.options & 4) != 0 && UniCharacter.isUpperCase(string.charAt(0))) {
            return true;
        }
        if ((this.options & 8) != 0 && this.isMixedCase(string)) {
            return true;
        }
        if ((this.options & 0x10) != 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (!UniCharacter.isDigit(string.charAt(n2))) continue;
                return true;
            }
        }
        if ((this.options & 2) != 0) {
            n2 = 1;
            for (n = 0; n < n3; ++n) {
                if (UniCharacter.isUpperCase(string.charAt(n))) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0 && n3 > 1) {
                return true;
            }
        }
        if ((this.options & 0x10000) != 0) {
            int n4;
            int n5;
            n2 = string.lastIndexOf(46);
            if (n2 >= 0) {
                n = 1;
                n5 = 0;
                for (n4 = n2 + 1; n4 < n3 && n != 0 && n5 <= 4; ++n5, ++n4) {
                    if (UniCharacter.isLetterOrDigit(string.charAt(n4))) continue;
                    n = 0;
                }
                if (n != 0 && n5 >= 2 && n5 <= 4) {
                    return true;
                }
            }
            if (string.indexOf("://") >= 0) {
                return true;
            }
            n = string.indexOf(47);
            if (n >= 0) {
                n5 = 1;
                n4 = 0;
                for (int i = n - 1; i >= 0 && string.charAt(i) != '.' && n5 != 0 && n4 <= 4; ++n4, --i) {
                    if (UniCharacter.isLetterOrDigit(string.charAt(i))) continue;
                    n5 = 0;
                }
                if (n5 != 0 && n4 >= 2 && n4 <= 4) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isMixedCase(String string) {
        int n;
        boolean bl = false;
        int n2 = string.length();
        for (n = 1; n < n2; ++n) {
            if (!UniCharacter.isLetter(string.charAt(n))) continue;
            bl = UniCharacter.isLowerCase(string.charAt(n));
            break;
        }
        if (n >= n2) {
            return false;
        }
        while (n < n2) {
            char c = string.charAt(n);
            if (UniCharacter.isLetter(c) && (bl && UniCharacter.isUpperCase(c) || !bl && UniCharacter.isLowerCase(c))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void matchCase(StringBuffer stringBuffer, boolean bl, boolean bl2, String string) {
        block10: {
            char c;
            char c2;
            boolean bl3;
            int n;
            block11: {
                char c3;
                block9: {
                    n = stringBuffer.length();
                    c3 = string.length();
                    if (n == 0 || c3 == '\u0000') {
                        return;
                    }
                    if (!bl) break block9;
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        char c4 = stringBuffer.charAt(i);
                        if (UniCharacter.isUpperCase(string.charAt(n2))) {
                            char c5;
                            c4 = Character.toUpperCase(c4);
                            if (!bl2 && (c5 = UniCharacter.toBase(c4)) != c4) {
                                c4 = c5;
                            }
                            stringBuffer.setCharAt(i, c4);
                        } else {
                            stringBuffer.setCharAt(i, Character.toLowerCase(stringBuffer.charAt(i)));
                        }
                        if (n2 + 1 >= c3) continue;
                        ++n2;
                    }
                    break block10;
                }
                bl3 = true;
                for (c2 = '\u0000'; c2 < c3; ++c2) {
                    c = string.charAt(c2);
                    if (!UniCharacter.isLetter(c) || UniCharacter.isUpperCase(c)) continue;
                    bl3 = false;
                    break;
                }
                if (bl3 || !UniCharacter.isUpperCase(string.charAt(0))) break block11;
                c2 = stringBuffer.charAt(0);
                stringBuffer.setCharAt(0, Character.toUpperCase(c2));
                if (bl2 || UniCharacter.toBase(c2) == c2) break block10;
                stringBuffer.setCharAt(0, UniCharacter.toBase(c2));
                break block10;
            }
            if (bl3 && string.length() > 1) {
                for (c2 = '\u0000'; c2 < n; ++c2) {
                    char c6;
                    c = Character.toUpperCase(stringBuffer.charAt(c2));
                    if (!bl2 && (c6 = UniCharacter.toBase(c)) != c) {
                        c = c6;
                    }
                    stringBuffer.setCharAt(c2, c);
                }
            }
        }
    }

    public static String stripPossessives(String string) {
        int n = string.length();
        if (n >= 2) {
            char c = string.charAt(n - 2);
            char c2 = string.charAt(n - 1);
            if (UniCharacter.isApostrophe(c) && Character.toLowerCase(c2) == 's') {
                return string.substring(0, n - 2);
            }
            if (Character.toLowerCase(c) == 's' && UniCharacter.isApostrophe(c2)) {
                return string.substring(0, n - 1);
            }
        }
        return string;
    }

    public static void restorePossessives(StringBuffer stringBuffer, String string) {
        char c = '\u0000';
        char c2 = '\u0000';
        boolean bl = false;
        char c3 = '\u0000';
        char c4 = '\u0000';
        if (string.length() >= 2) {
            c3 = string.charAt(string.length() - 2);
            c4 = string.charAt(string.length() - 1);
        }
        if (UniCharacter.isApostrophe(c3) && Character.toLowerCase(c4) == 's') {
            bl = true;
            c = c4;
            c2 = c3;
        } else if (Character.toLowerCase(c3) == 's' && UniCharacter.isApostrophe(c4)) {
            bl = true;
            c = c3;
            c2 = c4;
        }
        if (bl) {
            if (stringBuffer.length() > 0 && Character.toLowerCase(stringBuffer.charAt(stringBuffer.length() - 1)) == 's') {
                stringBuffer.append(c2);
            } else {
                stringBuffer.append(c2);
                stringBuffer.append(c);
            }
        }
    }
}

