/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.SegIndexNode;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.ssce.UnsupportedException;
import com.wintertree.ssce.WordException;
import com.wintertree.util.CharArray;
import com.wintertree.util.Search;
import com.wintertree.util.Sort;
import com.wintertree.util.UniCharacter;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class LexCompressor {
    public boolean debug;
    private Vector extSuffixes;
    private RandomAccessFile lexFile;
    private long segDataOffset;
    private Vector segIndex;
    private Vector simpleSuffixes;
    public static final int SEG_ID_LEN = 3;
    public static final int FILE_MAGIC = 1459619073;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int LANGUAGE_ID_SECTION = 1;
    public static final int CHARSET_SECTION = 2;
    public static final int SUFFIX_TBL_1_SECTION = 3;
    public static final int SEGMENT_INDEX_1_SECTION = 4;
    public static final int SEGMENT_DATA_1_SECTION = 5;
    public static final int LATIN1_CHARSET = 1;
    public static final int UNICODE_CHARSET = 2;
    public static final int END_OF_WORD = 0;
    public static final int EXT_SUFFIX = 1;
    public static final int FIRST_SIMPLE_SUFFIX = 2;
    public static final int LAST_SIMPLE_SUFFIX = 31;
    public static final int MAX_SIMPLE_SUFFIX = 30;
    public static final int MAX_EXT_SUFFIX = 65535;
    private static final String COMMENT_CHAR = "#";

    public LexCompressor(String string, String string2, int n) throws IOException {
        this.lexFile = new RandomAccessFile(string, "rw");
        this.lexFile.writeInt(1459619073);
        this.lexFile.writeInt(1);
        this.lexFile.writeInt(4);
        this.lexFile.writeInt(n);
        this.lexFile.writeInt(2);
        this.lexFile.writeInt(4);
        this.lexFile.writeInt(2);
        if (string2 != null) {
            this.loadSuffixes(string2);
        }
        this.saveSuffixes();
        this.lexFile.writeInt(5);
        this.lexFile.writeInt(0);
        this.segDataOffset = this.lexFile.getFilePointer();
        this.segIndex = new Vector();
    }

    public void compressFile(String string) throws IOException, WordException {
        Object[] objectArray;
        SegIndexNode segIndexNode = new SegIndexNode();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        char c = dataInputStream.readChar();
        dataInputStream.close();
        BufferedReader bufferedReader = c == '\ufeff' || c == '\ufffe' ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "Unicode")) : new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        Vector<Object[]> vector = new Vector<Object[]>();
        boolean bl = false;
        while (!bl) {
            objectArray = bufferedReader.readLine();
            if (objectArray == null) {
                bl = true;
                bufferedReader.close();
                continue;
            }
            if (objectArray.length() == 0 || objectArray.startsWith(COMMENT_CHAR)) continue;
            if (objectArray.length() > 63) {
                throw new WordException((String)objectArray + ": too long");
            }
            for (int i = 0; i < objectArray.length(); ++i) {
                if (UniCharacter.isPrintable(objectArray.charAt(i))) continue;
                throw new WordException((String)objectArray + ": contains invalid character(s)");
            }
            vector.addElement(objectArray);
        }
        bufferedReader.close();
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        Sort.ascending((String[])objectArray);
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
        StringBuffer stringBuffer = stringBufferArray[0];
        StringBuffer stringBuffer2 = stringBufferArray[1];
        char[] cArray = new char[4];
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            Object object = objectArray[i];
            if (this.debug) {
                System.out.println((String)object);
            }
            stringBuffer.setLength(0);
            stringBuffer.append((String)object);
            LexCompressor.toSegId(stringBuffer.toString(), cArray);
            if (this.cmpSegIds(cArray, segIndexNode.id) != 0) {
                if (segIndexNode.id[0] != '\u0000') {
                    segIndexNode.size = (int)this.lexFile.getFilePointer() - segIndexNode.offset;
                    try {
                        this.addSegIndexNode(segIndexNode);
                    }
                    catch (WordException wordException) {
                        throw new WordException(stringBuffer.toString() + ": " + wordException);
                    }
                }
                segIndexNode = new SegIndexNode();
                LexCompressor.toSegId(stringBuffer.toString(), segIndexNode.id);
                segIndexNode.offset = (int)this.lexFile.getFilePointer();
                segIndexNode.size = 0;
                stringBuffer2.setLength(0);
            }
            int n2 = 0;
            for (n = 3; n < stringBuffer2.length() && stringBuffer.charAt(n) == stringBuffer2.charAt(n); ++n) {
                n2 = (byte)(n2 + 1);
            }
            this.lexFile.writeByte(n2);
            n = 0;
            for (int j = 3 + n2; j < stringBuffer.length(); ++j) {
                int n3 = Search.binary(this.simpleSuffixes, stringBuffer.toString().substring(j));
                if (n3 >= 0) {
                    this.lexFile.writeChar(2 + n3);
                    j = stringBuffer.length();
                    n = 1;
                }
                if (n == 0 && (n3 = Search.binary(this.extSuffixes, stringBuffer.toString().substring(j))) >= 0) {
                    this.lexFile.writeChar(1);
                    this.lexFile.writeChar((char)n3);
                    j = stringBuffer.length();
                    n = 1;
                }
                if (n != 0) continue;
                this.lexFile.writeChar(stringBuffer.charAt(j));
            }
            if (n == 0) {
                this.lexFile.writeChar(0);
            }
            StringBuffer stringBuffer3 = stringBuffer;
            stringBuffer = stringBuffer2;
            stringBuffer2 = stringBuffer3;
        }
        if (segIndexNode.id[0] != '\u0000') {
            segIndexNode.size = (int)this.lexFile.getFilePointer() - segIndexNode.offset;
            try {
                this.addSegIndexNode(segIndexNode);
            }
            catch (WordException wordException) {
                throw new WordException(stringBuffer.toString() + ": " + wordException);
            }
        }
    }

    public void end() throws IOException {
        try {
            int n;
            int n2;
            if (this.lexFile == null) {
                throw new UnsupportedException();
            }
            try {
                int n3 = -1479411111;
                int n4 = 139;
                n2 = 140;
                int n5 = 647;
                int n6 = 1999;
                n = 151;
                int n7 = 499;
                int n8 = SpellingSession.getOption(new Integer(32));
                if ((n8 & 0xF3) == 162) {
                    int n9 = (n8 & 0x1F00) >> 8;
                    int n10 = (n8 & 0x1FFE000) >> 13;
                    int n11 = (n8 & 0xC) >> 2;
                    Date date = new Date();
                    Date date2 = new GregorianCalendar(2000 + n11 * 10, 0, 1).getTime();
                    Date date3 = new Date(date2.getTime() + (long)n10 * 86400000L);
                    long l = System.currentTimeMillis();
                    long l2 = (long)SpellingSession.getOption(new Integer(16)) * 1000L;
                    int n12 = n8 & 0x7FFFE000;
                    int n13 = 0;
                    for (int i = 0; i < 32; ++i) {
                        n13 += n12 & 1;
                        n12 >>= 1;
                    }
                    if (n13 != n9) {
                        throw new Exception();
                    }
                    if (date.after(date3)) {
                        if (l > l2 + 900000L) {
                            String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00d0\u00c5\u00d2\u00c9\u00cf\u00c4\u00a0\u00c5\u00d8\u00d0\u00c9\u00d2\u00c5\u00c4", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00ae", "\u00d9\u00ef\u00f5\u00f2\u00a0\u00b3\u00b0\u00ad\u00e4\u00e1\u00f9\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00ec\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5\u00a0\u00e8\u00e1\u00f3\u00a0\u00ee\u00ef\u00f7\u00a0\u00e5\u00f8\u00f0\u00e9\u00f2\u00e5\u00e4\u00ae", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                            for (int i = 0; i < stringArray.length; ++i) {
                                for (int j = 0; j < stringArray[i].length(); ++j) {
                                    System.out.print((char)(stringArray[i].charAt(j) & 0x7F));
                                }
                                System.out.println();
                            }
                            SpellingSession.setOption(new Integer(16), new Integer((int)(l / 1000L)));
                        }
                        throw new Exception();
                    }
                    if (l > l2 + 900000L) {
                        String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00c6\u00cf\u00d2\u00a0\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00cf\u00ce\u00cc\u00d9\u00a0\u00ad\u00a0\u00ce\u00cf\u00d4\u00a0\u00c6\u00cf\u00d2\u00a0\u00d0\u00d2\u00cf\u00c4\u00d5\u00c3\u00d4\u00c9\u00cf\u00ce\u00a0\u00d5\u00d3\u00c5", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00a1", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                        for (int i = 0; i < stringArray.length; ++i) {
                            for (int j = 0; j < stringArray[i].length(); ++j) {
                                System.out.print((char)(stringArray[i].charAt(j) & 0x7F));
                            }
                            System.out.println();
                        }
                        SpellingSession.setOption(new Integer(16), new Integer((int)(l / 1000L)));
                    }
                } else {
                    int n14;
                    long l = n8 ^ n3;
                    long l3 = 0L;
                    for (n14 = 0; n14 < 32; ++n14) {
                        long l4 = l >> n14 & 1L;
                        l3 |= l4 << 31 - n14;
                    }
                    n14 = (int)(l3 / 10000L);
                    if (n14 != n4 && n14 != n2) {
                        throw new Exception();
                    }
                    int n15 = (int)(l3 % 10000L);
                    if (n14 == n4 && n15 < n5 || n15 > n6) {
                        throw new Exception();
                    }
                    if (n14 == n2 && (n15 < n || n15 > n7)) {
                        throw new Exception();
                    }
                }
            }
            catch (Exception exception) {
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() < l + 1000L) {
                }
                throw new UnsupportedException();
            }
            long l = this.lexFile.getFilePointer();
            this.lexFile.seek(this.segDataOffset - 4L);
            this.lexFile.writeInt((int)(l - this.segDataOffset));
            this.lexFile.seek(l);
            this.lexFile.writeInt(4);
            n2 = 4 + this.segIndex.size() * 14;
            this.lexFile.writeInt(n2);
            this.lexFile.writeInt(this.segIndex.size());
            Enumeration enumeration = this.segIndex.elements();
            while (enumeration.hasMoreElements()) {
                SegIndexNode segIndexNode = (SegIndexNode)enumeration.nextElement();
                for (n = 0; n < 3; ++n) {
                    if (n < CharArray.length(segIndexNode.id)) {
                        this.lexFile.writeChar(segIndexNode.id[n]);
                        continue;
                    }
                    this.lexFile.writeChar(0);
                }
                n = (int)((long)segIndexNode.offset - this.segDataOffset);
                this.lexFile.writeInt(n);
                this.lexFile.writeInt(segIndexNode.size);
            }
            this.lexFile.close();
        }
        catch (UnsupportedException unsupportedException) {
            // empty catch block
        }
    }

    public static void toSegId(String string, char[] cArray) {
        int n = Math.min(string.length(), 3);
        string.getChars(0, n, cArray, 0);
        if (n < 3) {
            cArray[n] = '\u0000';
        }
    }

    private void addSegIndexNode(SegIndexNode segIndexNode) throws WordException {
        int n;
        int n2 = 0;
        for (n = 0; n < this.segIndex.size(); ++n) {
            SegIndexNode segIndexNode2 = (SegIndexNode)this.segIndex.elementAt(n);
            n2 = this.cmpSegIds(segIndexNode.id, segIndexNode2.id);
            if (n2 <= 0) break;
        }
        if (n2 == 0 && this.segIndex.size() > 0) {
            throw new WordException(segIndexNode.id + " out of sequence");
        }
        this.segIndex.insertElementAt(segIndexNode, n);
    }

    private int cmpSegIds(char[] cArray, char[] cArray2) {
        return CharArray.compare(cArray, cArray2);
    }

    private void loadSuffixes(String string) throws IOException {
        String string2;
        int n;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        char c = '\u0000';
        try {
            c = dataInputStream.readChar();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dataInputStream.close();
        BufferedReader bufferedReader = c == '\ufeff' || c == '\ufffe' ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "Unicode")) : new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        this.simpleSuffixes = new Vector();
        for (n = 0; n < 30 && (string2 = bufferedReader.readLine()) != null; ++n) {
            if (string2.startsWith(COMMENT_CHAR)) continue;
            this.simpleSuffixes.addElement(string2);
        }
        this.extSuffixes = new Vector();
        for (n = 0; n < 65535 && (string2 = bufferedReader.readLine()) != null; ++n) {
            if (string2.startsWith(COMMENT_CHAR)) continue;
            this.extSuffixes.addElement(string2);
        }
        bufferedReader.close();
    }

    private void saveSuffixes() throws IOException {
        Enumeration enumeration;
        this.lexFile.writeInt(3);
        int n = 0;
        Enumeration enumeration2 = this.simpleSuffixes.elements();
        while (enumeration2.hasMoreElements()) {
            enumeration = (String)enumeration2.nextElement();
            n += ((String)((Object)enumeration)).length() * 2 + 2;
        }
        int n2 = 0;
        enumeration = this.extSuffixes.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n2 += string.length() * 2 + 2;
        }
        this.lexFile.writeInt(4 + n + 4 + n2);
        this.lexFile.writeInt(n);
        enumeration = this.simpleSuffixes.elements();
        while (enumeration.hasMoreElements()) {
            this.lexFile.writeChars((String)enumeration.nextElement());
            this.lexFile.writeChar(0);
        }
        this.lexFile.writeInt(n2);
        enumeration = this.extSuffixes.elements();
        while (enumeration.hasMoreElements()) {
            this.lexFile.writeChars((String)enumeration.nextElement());
            this.lexFile.writeChar(0);
        }
    }
}

