/*
 * Decompiled with CFR 0.152.
 */
package com.wintertree.ssce;

import com.wintertree.ssce.FileExistsException;
import com.wintertree.ssce.FileFormatException;
import com.wintertree.ssce.LexiconUpdateException;
import com.wintertree.ssce.ParameterException;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.ssce.StreamTextLexicon;
import com.wintertree.ssce.UnsupportedException;
import com.wintertree.ssce.WordException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;

public class FileTextLexicon
extends StreamTextLexicon {
    protected String fileName;
    protected long lastModified;

    public FileTextLexicon(String string) throws IOException, FileFormatException, LexiconUpdateException {
        this.lastModified = 0L;
        this.open(string);
    }

    public FileTextLexicon(String string, int n) throws IOException, FileExistsException {
        super(n);
        File file = new File(string);
        if (file.canRead()) {
            throw new FileExistsException(string);
        }
        this.fileName = string;
        this.save();
    }

    public void addWord(String string) throws LexiconUpdateException {
        try {
            this.addWord(string, 105, "");
        }
        catch (ParameterException parameterException) {
            throw new LexiconUpdateException(parameterException.toString());
        }
    }

    public void addWord(String string, int n) throws LexiconUpdateException, ParameterException {
        if (n != 101 && n != 105) {
            throw new ParameterException(n + " action requires other word");
        }
        if (this.external && n != 105) {
            throw new LexiconUpdateException("Action " + n + " can't be used with external-format text lexicons");
        }
        this.addWord(string, n, "");
    }

    public void addWord(String string, int n, String string2) throws LexiconUpdateException, ParameterException {
        try {
            this.syncFile();
        }
        catch (Exception exception) {
            throw new LexiconUpdateException(exception.toString());
        }
        super.addWord(string, n, string2);
        try {
            this.save();
        }
        catch (IOException iOException) {
            try {
                super.deleteWord(string);
            }
            catch (WordException wordException) {
                // empty catch block
            }
            throw new LexiconUpdateException(iOException.toString());
        }
    }

    public void deleteWord(String string) throws LexiconUpdateException, WordException {
        try {
            this.syncFile();
        }
        catch (Exception exception) {
            throw new LexiconUpdateException(exception.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.findWord(string, true, stringBuffer);
        super.deleteWord(string);
        try {
            this.save();
        }
        catch (IOException iOException) {
            try {
                super.addWord(string, n, stringBuffer.toString());
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
            throw new LexiconUpdateException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        FileTextLexicon fileTextLexicon = (FileTextLexicon)object;
        return this.fileName.equals(fileTextLexicon.fileName) && super.equals(object);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public static boolean isFileTextLexicon(String string) {
        try {
            FileTextLexicon fileTextLexicon = new FileTextLexicon(string);
            fileTextLexicon = null;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void save() throws IOException {
        try {
            if (this.fileName == null) {
                throw new UnsupportedException();
            }
            try {
                int n = -1479411111;
                int n2 = 139;
                int n3 = 140;
                int n4 = 647;
                int n5 = 1999;
                int n6 = 151;
                int n7 = 499;
                int n8 = SpellingSession.getOption(new Integer(32));
                if ((n8 & 0xF3) == 162) {
                    int n9 = (n8 & 0x1F00) >> 8;
                    int n10 = (n8 & 0x1FFE000) >> 13;
                    int n11 = (n8 & 0xC) >> 2;
                    Date date = new Date();
                    Date date2 = new GregorianCalendar(2000 + n11 * 10, 0, 1).getTime();
                    Date date3 = new Date(date2.getTime() + (long)n10 * 86400000L);
                    long l = System.currentTimeMillis();
                    long l2 = (long)SpellingSession.getOption(new Integer(16)) * 1000L;
                    int n12 = n8 & 0x7FFFE000;
                    int n13 = 0;
                    for (int i = 0; i < 32; ++i) {
                        n13 += n12 & 1;
                        n12 >>= 1;
                    }
                    if (n13 != n9) {
                        throw new Exception();
                    }
                    if (date.after(date3)) {
                        if (l > l2 + 900000L) {
                            String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00d0\u00c5\u00d2\u00c9\u00cf\u00c4\u00a0\u00c5\u00d8\u00d0\u00c9\u00d2\u00c5\u00c4", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00ae", "\u00d9\u00ef\u00f5\u00f2\u00a0\u00b3\u00b0\u00ad\u00e4\u00e1\u00f9\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00ec\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5\u00a0\u00e8\u00e1\u00f3\u00a0\u00ee\u00ef\u00f7\u00a0\u00e5\u00f8\u00f0\u00e9\u00f2\u00e5\u00e4\u00ae", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                            for (int i = 0; i < stringArray.length; ++i) {
                                for (int j = 0; j < stringArray[i].length(); ++j) {
                                    System.out.print((char)(stringArray[i].charAt(j) & 0x7F));
                                }
                                System.out.println();
                            }
                            SpellingSession.setOption(new Integer(16), new Integer((int)(l / 1000L)));
                        }
                        throw new Exception();
                    }
                    if (l > l2 + 900000L) {
                        String[] stringArray = new String[]{"\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa", "\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00d3\u00f0\u00e5\u00ec\u00ec\u00e9\u00ee\u00e7\u00ad\u00c3\u00e8\u00e5\u00e3\u00eb\u00e5\u00f2\u00a0\u00c5\u00ee\u00e7\u00e9\u00ee\u00e5\u00a0\u00c5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ef\u00ee\u00a0\u00cc\u00e9\u00e3\u00e5\u00ee\u00f3\u00e5", "\u00c3\u00ef\u00f0\u00f9\u00f2\u00e9\u00e7\u00e8\u00f4\u00a0\u00a8\u00e3\u00a9\u00a0\u00b2\u00b0\u00b0\u00b3\u00a0\u00d7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00a0\u00d3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00a0\u00c9\u00ee\u00e3\u00ae", "\u00c6\u00cf\u00d2\u00a0\u00c5\u00d6\u00c1\u00cc\u00d5\u00c1\u00d4\u00c9\u00cf\u00ce\u00a0\u00cf\u00ce\u00cc\u00d9\u00a0\u00ad\u00a0\u00ce\u00cf\u00d4\u00a0\u00c6\u00cf\u00d2\u00a0\u00d0\u00d2\u00cf\u00c4\u00d5\u00c3\u00d4\u00c9\u00cf\u00ce\u00a0\u00d5\u00d3\u00c5", "\u00d4\u00e8\u00e1\u00ee\u00eb\u00a0\u00f9\u00ef\u00f5\u00a0\u00e6\u00ef\u00f2\u00a0\u00e5\u00f6\u00e1\u00ec\u00f5\u00e1\u00f4\u00e9\u00ee\u00e7\u00a0\u00d3\u00e5\u00ee\u00f4\u00f2\u00f9\u00a0\u00ca\u00e1\u00f6\u00e1\u00a0\u00d3\u00c4\u00cb\u00a1", "\u00d4\u00ef\u00a0\u00ef\u00f2\u00e4\u00e5\u00f2\u00ac\u00a0\u00e3\u00e1\u00ec\u00ec\u00a0\u00b1\u00ad\u00b8\u00b0\u00b0\u00ad\u00b3\u00b4\u00b0\u00ad\u00b8\u00b8\u00b0\u00b3\u00a0\u00a8\u00b1\u00ad\u00b6\u00b1\u00b3\u00ad\u00b6\u00b9\u00b2\u00ad\u00b0\u00b2\u00b0\u00b8\u00a9\u00ac\u00a0\u00ef\u00f2\u00a0\u00f3\u00e5\u00e5", "\u00f7\u00f7\u00f7\u00ae\u00f7\u00e9\u00ee\u00f4\u00e5\u00f2\u00f4\u00f2\u00e5\u00e5\u00ad\u00f3\u00ef\u00e6\u00f4\u00f7\u00e1\u00f2\u00e5\u00ae\u00e3\u00ef\u00ed\u00af\u00e4\u00e5\u00f6\u00af\u00f3\u00f3\u00e3\u00e5\u00af\u00ea\u00e1\u00f6\u00e1\u00f3\u00e4\u00eb\u00ae\u00e8\u00f4\u00ed\u00ec", "\u00e6\u00ef\u00f2\u00a0\u00ed\u00ef\u00f2\u00e5\u00a0\u00e9\u00ee\u00e6\u00ef\u00f2\u00ed\u00e1\u00f4\u00e9\u00ef\u00ee\u00ae", "\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa\u00aa"};
                        for (int i = 0; i < stringArray.length; ++i) {
                            for (int j = 0; j < stringArray[i].length(); ++j) {
                                System.out.print((char)(stringArray[i].charAt(j) & 0x7F));
                            }
                            System.out.println();
                        }
                        SpellingSession.setOption(new Integer(16), new Integer((int)(l / 1000L)));
                    }
                } else {
                    int n14;
                    long l = n8 ^ n;
                    long l3 = 0L;
                    for (n14 = 0; n14 < 32; ++n14) {
                        long l4 = l >> n14 & 1L;
                        l3 |= l4 << 31 - n14;
                    }
                    n14 = (int)(l3 / 10000L);
                    if (n14 != n2 && n14 != n3) {
                        throw new Exception();
                    }
                    int n15 = (int)(l3 % 10000L);
                    if (n14 == n2 && n15 < n4 || n15 > n5) {
                        throw new Exception();
                    }
                    if (n14 == n3 && (n15 < n6 || n15 > n7)) {
                        throw new Exception();
                    }
                }
            }
            catch (Exception exception) {
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() < l + 1000L) {
                }
                throw new UnsupportedException();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
            super.save(fileOutputStream);
            fileOutputStream.close();
            File file = new File(this.fileName);
            this.lastModified = file.lastModified();
        }
        catch (UnsupportedException unsupportedException) {
            // empty catch block
        }
    }

    protected void open(String string) throws IOException, FileFormatException, LexiconUpdateException {
        this.fileName = string;
        FileInputStream fileInputStream = new FileInputStream(string);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fileName + ')';
    }

    protected void syncFile() throws IOException, FileFormatException, LexiconUpdateException {
        File file = new File(this.fileName);
        long l = file.lastModified();
        if (l > this.lastModified) {
            FileInputStream fileInputStream = new FileInputStream(this.fileName);
            this.load(fileInputStream);
            this.lastModified = l;
            fileInputStream.close();
        }
    }
}

