/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.JCAction;
import com.klg.jclass.util.swing.JCHTMLPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JCHelpPane
extends JSplitPane {
    protected JCHTMLPane contentsPane;
    protected JCHTMLPane viewPane;
    protected JCHTMLPane titlePane;
    protected JSplitPane horizontalPane;
    protected JSplitPane verticalPane = null;
    protected boolean useToolBar = true;
    protected JToolBar toolBarCreated;
    protected JToolBar toolBarButtonsAddedTo;
    protected JToolBar toolBarListenersAddedTo;
    protected JButton forwardButton;
    protected JButton backButton;
    protected JCAction forwardAction = new ActionForward();
    protected JCAction backAction = new ActionBack();
    protected PageListener pageListener;
    protected Stack urlStack = new Stack();
    protected int currentStackPosition = -1;
    protected int movingThroughStack = 0;
    static /* synthetic */ Class class$javax$swing$RootPaneContainer;

    public JCHelpPane() {
        this.contentsPane = new ContentsPane();
        this.viewPane = new JCHTMLPane();
        this.setupPanes();
    }

    public JCHelpPane(URL uRL, URL uRL2) {
        this.contentsPane = new ContentsPane(uRL);
        this.viewPane = new JCHTMLPane(uRL2);
        this.setupPanes();
    }

    public JCHelpPane(URL uRL, URL uRL2, URL uRL3) {
        this.contentsPane = new ContentsPane(uRL);
        this.viewPane = new JCHTMLPane(uRL2);
        if (uRL3 != null) {
            this.titlePane = new JCHTMLPane(uRL3);
        }
        this.setupPanes();
    }

    public JCHelpPane(String string, String string2) {
        this.contentsPane = new ContentsPane(string);
        this.viewPane = new JCHTMLPane(string2);
        this.setupPanes();
    }

    public JCHelpPane(String string, String string2, String string3) {
        this.contentsPane = new ContentsPane(string);
        this.viewPane = new JCHTMLPane(string2);
        if (string3 != null) {
            this.titlePane = new JCHTMLPane(string3);
        }
        this.setupPanes();
    }

    public JSplitPane getHorizontalPane() {
        return this.horizontalPane;
    }

    public JSplitPane getVerticalPane() {
        return this.verticalPane;
    }

    public void resetHelpStack() {
        this.urlStack = new Stack();
        this.currentStackPosition = -1;
        this.movingThroughStack = 0;
        this.backAction.setEnabled(false);
        this.forwardAction.setEnabled(false);
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public JCHTMLPane getContentsPane() {
        return this.contentsPane;
    }

    public JCHTMLPane getViewPane() {
        return this.viewPane;
    }

    public void setContentsPage(URL uRL) {
        try {
            this.contentsPane.setPage(uRL);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    public URL getContentsPage() {
        return this.contentsPane.getPage();
    }

    public void setViewPage(URL uRL) {
        try {
            this.viewPane.setPage(uRL);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    public URL getViewPage() {
        return this.viewPane.getPage();
    }

    public void setTitlePage(URL uRL) {
        if (uRL != null && this.titlePane != null) {
            try {
                this.titlePane.setPage(uRL);
            }
            catch (IOException iOException) {
                System.out.println("IOException: " + iOException);
            }
            return;
        }
        if (uRL == null) {
            this.titlePane = null;
        } else if (this.titlePane == null) {
            this.titlePane = new JCHTMLPane(uRL);
        }
        this.setupPanes();
    }

    public URL getTitlePage() {
        if (this.titlePane != null) {
            return this.titlePane.getPage();
        }
        return null;
    }

    public void setUseToolBar(boolean bl) {
        if (bl == this.useToolBar) {
            return;
        }
        if (!bl) {
            if (this.toolBarButtonsAddedTo != null) {
                this.toolBarButtonsAddedTo.remove(this.backButton);
                this.toolBarButtonsAddedTo.remove(this.forwardButton);
                this.backButton = null;
                this.forwardButton = null;
                this.toolBarButtonsAddedTo = null;
            } else if (this.toolBarListenersAddedTo != null) {
                this.backButton.removeActionListener(this.backAction);
                this.forwardButton.removeActionListener(this.forwardAction);
                this.forwardButton = null;
                this.backButton = null;
                this.toolBarListenersAddedTo = null;
            } else if (this.toolBarCreated != null) {
                Container container = this.toolBarCreated.getParent();
                container.remove(this.toolBarCreated);
                this.forwardButton = null;
                this.backButton = null;
                this.toolBarCreated = null;
            }
        } else if (this.isDisplayable()) {
            this.connectToToolBar();
        }
        this.useToolBar = bl;
    }

    public boolean isUseToolBar() {
        return this.useToolBar;
    }

    public void addNotify() {
        super.addNotify();
        if (this.useToolBar) {
            this.connectToToolBar();
        }
    }

    protected void connectToToolBar() {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(class$javax$swing$RootPaneContainer == null ? (class$javax$swing$RootPaneContainer = JCHelpPane.class$("javax.swing.RootPaneContainer")) : class$javax$swing$RootPaneContainer, this));
        if (rootPaneContainer == null) {
            return;
        }
        JComponent jComponent = (JComponent)rootPaneContainer.getContentPane();
        JToolBar jToolBar = null;
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JToolBar) {
                jToolBar = (JToolBar)componentArray[n];
                break;
            }
            ++n;
        }
        if (jToolBar == null) {
            jToolBar = this.toolBarCreated = new JToolBar();
            jComponent.add((Component)jToolBar, "North");
            jComponent.invalidate();
            jComponent.validate();
        }
        if (this.backButton == null) {
            this.backButton = jToolBar.add(this.backAction);
        }
        if (this.forwardButton == null) {
            this.forwardButton = jToolBar.add(this.forwardAction);
        }
    }

    protected void setupPanes() {
        JScrollPane jScrollPane;
        if (this.getComponentCount() != 0) {
            this.setTopComponent(null);
            this.setBottomComponent(null);
        }
        if (this.pageListener == null) {
            this.pageListener = new PageListener();
            this.viewPane.addPropertyChangeListener(this.pageListener);
        }
        if (this.titlePane != null) {
            this.verticalPane = this;
            this.verticalPane.setOrientation(0);
            jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.titlePane);
            int n = 21;
            jScrollPane.setVerticalScrollBarPolicy(n);
            this.verticalPane.setTopComponent(jScrollPane);
            if (this.horizontalPane == this || this.horizontalPane == null) {
                this.horizontalPane = new JSplitPane();
            } else if (this.horizontalPane.getComponentCount() != 0) {
                this.horizontalPane.setLeftComponent(null);
                this.horizontalPane.setRightComponent(null);
            }
            this.verticalPane.setBottomComponent(this.horizontalPane);
            this.verticalPane.setDividerLocation(60);
        } else {
            this.verticalPane = null;
            this.horizontalPane = this;
            this.horizontalPane.setOrientation(1);
        }
        jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.contentsPane);
        this.horizontalPane.setLeftComponent(jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(this.viewPane);
        this.horizontalPane.setRightComponent(jScrollPane2);
        this.horizontalPane.setDividerLocation(200);
    }

    protected void back() {
        if (!this.backAction.isEnabled()) {
            return;
        }
        ++this.movingThroughStack;
        --this.currentStackPosition;
        this.enableButtons();
        URL uRL = (URL)this.urlStack.elementAt(this.currentStackPosition);
        this.setViewPage(uRL);
    }

    protected void forward() {
        if (!this.forwardAction.isEnabled()) {
            return;
        }
        ++this.movingThroughStack;
        ++this.currentStackPosition;
        this.enableButtons();
        URL uRL = (URL)this.urlStack.elementAt(this.currentStackPosition);
        this.setViewPage(uRL);
    }

    protected void enableButtons() {
        if (this.currentStackPosition < 1) {
            this.backAction.setEnabled(false);
        } else {
            this.backAction.setEnabled(true);
        }
        if (this.currentStackPosition == this.urlStack.size() - 1) {
            this.forwardAction.setEnabled(false);
        } else {
            this.forwardAction.setEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ActionBack
    extends JCAction {
        ActionBack() {
            super("back");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCHelpPane.this.back();
        }
    }

    class ActionForward
    extends JCAction {
        ActionForward() {
            super("forward");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCHelpPane.this.forward();
        }
    }

    class ContentsPane
    extends JCHTMLPane {
        public ContentsPane() {
        }

        public ContentsPane(URL uRL) {
            super(uRL);
        }

        public ContentsPane(String string) {
            super(string);
        }

        protected void followLink(URL uRL) {
            new JCHTMLPane.PageLoader(JCHelpPane.this.viewPane, uRL);
        }
    }

    class PageListener
    implements PropertyChangeListener {
        PageListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("page")) {
                if (JCHelpPane.this.movingThroughStack == 0) {
                    int n = JCHelpPane.this.urlStack.size() - 1;
                    while (n > JCHelpPane.this.currentStackPosition) {
                        JCHelpPane.this.urlStack.pop();
                        --n;
                    }
                    JCHelpPane.this.urlStack.push(propertyChangeEvent.getNewValue());
                    JCHelpPane.this.currentStackPosition = JCHelpPane.this.urlStack.size() - 1;
                }
                JCHelpPane.this.enableButtons();
                if (JCHelpPane.this.movingThroughStack != 0) {
                    --JCHelpPane.this.movingThroughStack;
                }
            }
        }
    }
}

