/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.JCTableDataModel;
import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.Result;
import java.awt.Point;

public class TableReference
implements ExpressionReference,
Cloneable {
    protected JCTableDataModel tableData;
    protected Expression row;
    protected Expression column;
    protected Point location;

    public TableReference(JCTableDataModel jCTableDataModel, int n, int n2) {
        this.tableData = jCTableDataModel;
        this.location = new Point(n2, n);
        this.checkLocation(this.location);
        this.row = new MathScalar(n);
        this.column = new MathScalar(n2);
    }

    public TableReference(JCTableDataModel jCTableDataModel, Point point) {
        this.tableData = jCTableDataModel;
        this.checkLocation(point);
        this.location = point;
        this.row = new MathScalar(point.y);
        this.column = new MathScalar(point.x);
    }

    public TableReference(JCTableDataModel jCTableDataModel, Expression expression, Expression expression2) {
        this.tableData = jCTableDataModel;
        this.location = this.computeLocation(expression, expression2);
        this.row = expression;
        this.column = expression2;
    }

    public Result evaluate() {
        this.location = this.computeLocation(this.row, this.column);
        Object object = this.tableData.getTableDataItem(this.location.y, this.location.x);
        if (object instanceof Result) {
            return (Result)object;
        }
        if (object instanceof Expression) {
            return ((Expression)object).evaluate();
        }
        return (Result)this.encapsulateValue(object);
    }

    public Object clone() {
        TableReference tableReference;
        try {
            tableReference = (TableReference)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (this.row != null) {
            try {
                tableReference.row = (Expression)this.row.evaluate().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                tableReference.row = new MathScalar(0);
            }
        }
        if (this.column != null) {
            try {
                tableReference.column = (Expression)this.column.evaluate().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                tableReference.column = new MathScalar(0);
            }
        }
        if (this.location != null) {
            tableReference.location = new Point(this.location);
        }
        return tableReference;
    }

    public Point getLocation() {
        if (this.location == null) {
            return this.computeLocation(this.row, this.column);
        }
        return new Point(this.location);
    }

    public void setLocation(Point point) {
        this.checkLocation(point);
        this.location = new Point(point);
        this.row = new MathScalar(this.location.y);
        this.column = new MathScalar(this.location.x);
    }

    public Expression getColumn() {
        return this.column;
    }

    public void setColumn(Expression expression) {
        this.location = this.computeLocation(this.row, expression);
        this.column = expression;
    }

    public Expression getRow() {
        return this.row;
    }

    public void setRow(Expression expression) {
        this.location = this.computeLocation(expression, this.column);
        this.row = expression;
    }

    private void checkLocation(Point point) {
        if (point.x < 0 || point.x > this.tableData.getNumColumns()) {
            throw new IllegalArgumentException("Column selection is out of range");
        }
        if (point.y < 0 || point.y > this.tableData.getNumRows()) {
            throw new IllegalArgumentException("Row selection is out of range");
        }
    }

    private Point computeLocation(Expression expression, Expression expression2) {
        try {
            int n = ((MathValue)expression.evaluate()).numberValue().intValue();
            int n2 = ((MathValue)expression2.evaluate()).numberValue().intValue();
            Point point = new Point(n2, n);
            this.checkLocation(point);
            return point;
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
    }

    private void updateLocation() {
        if (this.location != null) {
            return;
        }
        this.location = this.computeLocation(this.row, this.column);
        if (this.location == null) {
            Result result = this.row.evaluate();
            Result result2 = this.column.evaluate();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TableReference)) {
            return false;
        }
        TableReference tableReference = (TableReference)object;
        if (tableReference.tableData != this.tableData) {
            return false;
        }
        if (this.location != null) {
            return this.location.equals(tableReference.location);
        }
        return this.column == tableReference.column && this.row == tableReference.row;
    }

    protected Expression copy(boolean bl) {
        if (bl) {
            this.location = this.computeLocation(this.row, this.column);
        }
        if (!bl || this.location == null) {
            return new TableReference(this.tableData, this.row, this.column);
        }
        return new TableReference(this.tableData, this.location.y, this.location.x);
    }

    private Object encapsulateValue(Object object) {
        if (object instanceof Expression) {
            return ((Expression)object).evaluate();
        }
        if (object instanceof Number) {
            return new MathScalar((Number)object);
        }
        if (object instanceof Number[]) {
            return new MathVector((Number[])object);
        }
        if (object instanceof Number[][]) {
            return new MathMatrix((Number[][])object);
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.indexOf(46) >= -1) {
                return new MathScalar(Double.valueOf(string));
            }
            return new MathScalar(Integer.valueOf(string));
        }
        throw new ClassCastException("Can't convert " + object + " to type MathValue");
    }
}

