/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.calendar.JCDateChooser;
import com.klg.jclass.util.swing.JCSpinNumberBox;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Locale;

public class YearSpin
extends JCSpinNumberBox
implements CalendarComponent {
    protected JCValueModel calendarModel;
    protected JCCalendar specialDates;
    protected Locale locale = null;
    protected boolean ignoreChange = false;
    protected JCValueListener l = new ModelConduit();
    protected JCListenerList actionListeners = null;

    public YearSpin(JCValueModel jCValueModel, Locale locale) {
        this.setLocale(locale);
        this.setValueRange(new JCSpinNumberBox.Range(new Integer(0), new Integer(9999)));
        this.setCalendarModel(jCValueModel);
        this.setNumberFormat(new DecimalFormat("#"));
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        Calendar calendar = (Calendar)jCValueModel.getValue();
        if (calendar != null) {
            int n = calendar.get(1);
            this.ignoreChange = true;
            this.setValue(new Integer(n));
            this.ignoreChange = false;
        } else {
            this.ignoreChange = true;
            this.setValue(null);
            this.ignoreChange = false;
        }
        if (this.calendarModel != null) {
            this.calendarModel.removeValueListener(this.l);
        }
        if (this.valueModel != null) {
            this.valueModel.removeValueListener(this.l);
        }
        this.calendarModel = jCValueModel;
        this.calendarModel.addValueListener(this.l);
        this.valueModel.addValueListener(this.l);
    }

    public JCValueModel getCalendarModel() {
        return this.calendarModel;
    }

    public void setSpecialDates(JCCalendar jCCalendar) {
        this.specialDates = jCCalendar;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.locale == locale) {
            return;
        }
        super.setLocale(locale);
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    class ModelConduit
    implements JCValueListener,
    Serializable {
        private Calendar getUpdatedCalendar(int n) {
            Calendar calendar = (Calendar)YearSpin.this.calendarModel.getValue();
            Calendar calendar2 = JCCalendar.copyCalendar(calendar);
            calendar2.set(1, n);
            return calendar2;
        }

        public void valueChanging(JCValueEvent jCValueEvent) {
            if (YearSpin.this.ignoreChange || jCValueEvent.getSource() == YearSpin.this.calendarModel) {
                return;
            }
            Container container = YearSpin.this.getParent();
            if (container instanceof JCDateChooser) {
                JCDateChooser jCDateChooser = (JCDateChooser)container;
                int n = ((Number)jCValueEvent.getNewValue()).intValue();
                Calendar calendar = this.getUpdatedCalendar(n);
                if (!jCDateChooser.boundsValidator.isValid(calendar)) {
                    jCValueEvent.setAllowChange(false);
                    Toolkit toolkit = YearSpin.this.getToolkit();
                    if (toolkit != null) {
                        toolkit.beep();
                    }
                }
            }
        }

        public void valueChanged(JCValueEvent jCValueEvent) {
            if (!YearSpin.this.ignoreChange && jCValueEvent.getSource() == YearSpin.this.calendarModel) {
                Calendar calendar = (Calendar)jCValueEvent.getNewValue();
                int n = calendar.get(1);
                if (YearSpin.this.getValue().intValue() != n) {
                    YearSpin.this.ignoreChange = true;
                    YearSpin.this.setValue(new Integer(n));
                    YearSpin.this.ignoreChange = false;
                }
            } else if (!YearSpin.this.ignoreChange && jCValueEvent.getSource() == YearSpin.this.getValueModel()) {
                Calendar calendar = this.getUpdatedCalendar(YearSpin.this.getValue().intValue());
                YearSpin.this.ignoreChange = true;
                YearSpin.this.calendarModel.setValue(calendar);
                YearSpin.this.ignoreChange = false;
            }
        }
    }
}

