/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCTable;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.JScrollBar;

public class TableMouseWheelListener
implements MouseWheelListener,
Serializable {
    protected JCTable table;

    public TableMouseWheelListener(JCTable jCTable) {
        this.setTable(jCTable);
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public JCTable getTable() {
        return this.table;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.table == null || mouseWheelEvent == null) {
            return;
        }
        if (mouseWheelEvent.getScrollAmount() != 0) {
            JScrollBar jScrollBar = this.table.getVertSB();
            int n = 0;
            if (!(jScrollBar != null && jScrollBar.isVisible() || (jScrollBar = this.table.getHorizSB()) != null && jScrollBar.isVisible())) {
                return;
            }
            int n2 = n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
            if (mouseWheelEvent.getScrollType() == 0) {
                this.scrollByUnits(jScrollBar, n, mouseWheelEvent.getScrollAmount());
            } else if (mouseWheelEvent.getScrollType() == 1) {
                this.scrollByBlock(jScrollBar, n);
            }
        }
    }

    protected void scrollByBlock(JScrollBar jScrollBar, int n) {
        int n2 = jScrollBar.getValue();
        int n3 = jScrollBar.getBlockIncrement(n);
        int n4 = n3 * (n > 0 ? 1 : -1);
        jScrollBar.setValue(n2 + n4);
    }

    protected void scrollByUnits(JScrollBar jScrollBar, int n, int n2) {
        int n3 = n2;
        n3 = n > 0 ? (n3 *= jScrollBar.getUnitIncrement(n)) : (n3 *= -jScrollBar.getUnitIncrement(n));
        int n4 = jScrollBar.getValue();
        int n5 = n4 + n3;
        if (n3 > 0 && n5 < n4) {
            n5 = jScrollBar.getMaximum();
        } else if (n3 < 0 && n5 > n4) {
            n5 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n5);
    }
}

