/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.ImmutableEventException;
import java.util.EventObject;

public class JCResizeCellEvent
extends EventObject {
    public static final int BEFORE_RESIZE = 1;
    public static final int RESIZE = 2;
    public static final int RESIZE_DRAG = 3;
    public static final int AFTER_RESIZE = 4;
    protected int type;
    protected int row;
    protected int column;
    protected int current_row_height;
    protected int current_column_width;
    protected int new_row_height;
    protected int new_column_width;
    protected boolean cancelled = false;

    public JCResizeCellEvent(Object object, int n, int n2, int n3, int n4, int n5) {
        super(object);
        this.type = n;
        this.row = n2;
        this.column = n3;
        this.current_row_height = n5;
        this.current_column_width = n4;
        this.new_row_height = -999;
        this.new_column_width = -999;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getCurrentRowHeight() {
        return this.current_row_height;
    }

    public int getNewRowHeight() {
        return this.new_row_height;
    }

    public void setNewRowHeight(int n) {
        if (this.type == 1 || this.type == 4) {
            throw new ImmutableEventException("setNewRowHeight is only available in resizeCell/resizeCellDragged");
        }
        this.new_row_height = n;
    }

    public int getCurrentColumnWidth() {
        return this.current_column_width;
    }

    public int getNewColumnWidth() {
        return this.new_column_width;
    }

    public void setNewColumnWidth(int n) {
        if (this.type == 1 || this.type == 4) {
            throw new ImmutableEventException("setNewColumnWidth is only available in resizeCell/resizeCellDragged");
        }
        this.new_column_width = n;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        if (this.type == 4) {
            throw new ImmutableEventException("setCancelled is not available in afterResize");
        }
        this.cancelled = bl;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String string = "RESIZE [";
        if (this.type == 1) {
            string = string + "beforeResize ";
        } else if (this.type == 2) {
            string = string + "resize ";
        } else if (this.type == 3) {
            string = string + "resizeDrag ";
        } else if (this.type == 4) {
            string = string + "afterResize ";
        }
        return string + "R" + this.row + "C" + this.column + ", cancelled=" + this.isCancelled() + " " + this.current_column_width + "x" + this.current_row_height + " to " + this.new_column_width + "x" + this.new_row_height + "]";
    }
}

