/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.JCTable;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class JCCellLayout
implements CellLayoutModel,
Serializable {
    protected JCTable table;
    protected int column_label_height;
    protected int row_label_width;
    protected Chain widths;
    protected Chain heights;

    public JCCellLayout() {
        this.resetRows();
        this.resetColumns();
    }

    public JCTable getTable() {
        return this.table;
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public int getHeight(int n) {
        if (n == -1) {
            return this.column_label_height;
        }
        return this.heights.getValue(n);
    }

    public void setHeight(int n, int n2) {
        if (n == -1) {
            this.column_label_height = n2;
        } else {
            this.heights.setValue(n, n, n2);
        }
    }

    public void setHeight(int n, int n2, int n3) {
        this.heights.setValue(n, n2, n3);
    }

    public int getWidth(int n) {
        if (n == -1) {
            return this.row_label_width;
        }
        return this.widths.getValue(n);
    }

    public void setWidth(int n, int n2) {
        if (n == -1) {
            this.row_label_width = n2;
        } else {
            this.widths.setValue(n, n, n2);
        }
    }

    public void setWidth(int n, int n2, int n3) {
        this.widths.setValue(n, n2, n3);
    }

    public int getColumn(int n, int n2) {
        if (n < this.row_label_width) {
            return -1;
        }
        return this.widths.getIndex(n - this.row_label_width);
    }

    public int getRow(int n, int n2) {
        if (n2 < this.column_label_height) {
            return -1;
        }
        return this.heights.getIndex(n2 - this.column_label_height);
    }

    public int getColumnPosition(int n) {
        if (n == -1) {
            return 0;
        }
        return this.row_label_width + this.widths.getSum(n);
    }

    public int getRowPosition(int n) {
        if (n == -1) {
            return 0;
        }
        return this.column_label_height + this.heights.getSum(n);
    }

    public Rectangle getBounds(int n, int n2) {
        return this.getBounds(n, n2, new Rectangle());
    }

    public Rectangle getBounds(int n, int n2, Rectangle rectangle) {
        rectangle.setBounds(this.getColumnPosition(n2), this.getRowPosition(n), this.getWidth(n2), this.getHeight(n));
        return rectangle;
    }

    public Rectangle getBounds(int n, int n2, int n3, int n4) {
        return this.getBounds(n, n2, n3, n4, new Rectangle());
    }

    public Rectangle getBounds(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5 = this.getColumnPosition(n2);
        int n6 = this.getRowPosition(n);
        rectangle.setBounds(n5, n6, this.getColumnPosition(n4) + this.getWidth(n4) - n5, this.getRowPosition(n3) + this.getHeight(n3) - n6);
        return rectangle;
    }

    public void moveRows(int n, int n2, int n3) {
        this.table.requestChange(16);
    }

    public void moveColumns(int n, int n2, int n3) {
        this.table.requestChange(32);
    }

    public void addRows(int n, int n2) {
        this.table.requestChange(16);
    }

    public void addColumns(int n, int n2) {
        this.table.requestChange(32);
    }

    public void deleteRows(int n, int n2) {
        this.table.requestChange(16);
    }

    public void deleteColumns(int n, int n2) {
        this.table.requestChange(32);
    }

    public void remapRows(int[] nArray, int[] nArray2) {
        this.resetRows();
        this.table.requestChange(16);
    }

    public void remapColumns(int[] nArray, int[] nArray2) {
        this.resetColumns();
        this.table.requestChange(32);
    }

    public void resetRows() {
        this.heights = new Chain();
    }

    public void resetColumns() {
        this.widths = new Chain();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"cellLayout"};
        JCCellLayout jCCellLayout = new JCCellLayout();
        Chain chain = jCCellLayout.widths;
        chain.setValue(0, 9, 97);
        chain.setValue(10, 21, 98);
        System.out.println("layout:" + chain.toString());
        chain.setValue(22, 35, 99);
        System.out.println("layout:" + chain.toString());
        chain.setValue(2, 5, 100);
        System.out.println("layout:" + chain.toString());
        chain.setValue(2, 2, 101);
        System.out.println("layout:" + chain.toString());
        chain.setValue(3, 3, 101);
        System.out.println("layout:" + chain.toString());
        chain.setValue(9, 9, 98);
        System.out.println("layout:" + chain.toString());
        chain.setValue(14, 14, 103);
        System.out.println("layout:" + chain.toString());
        chain.setValue(1, 8, 104);
        System.out.println("layout:" + chain.toString());
        chain.setValue(9, 12, 104);
        System.out.println("layout:" + chain.toString());
        chain.setValue(1, 14, 97);
        System.out.println("layout:" + chain.toString());
        chain.setValue(3, 29, 98);
        System.out.println("layout:" + chain.toString());
        jCCellLayout.resetColumns();
        chain = jCCellLayout.widths;
        chain.setValue(0, 9, 97);
        chain.setValue(2, 5, 100);
        System.out.println("layout:" + chain.toString());
        chain.setValue(10, 21, 98);
        chain.setValue(2, 2, 101);
        chain.setValue(3, 3, 101);
        chain.setValue(9, 9, 98);
        chain.setValue(14, 14, 103);
        System.out.println("layout:" + chain.toString());
        chain.setValue(1, 8, 104);
        System.out.println("layout:" + chain.toString());
        chain.setValue(9, 17, 104);
        System.out.println("layout:" + chain.toString());
        chain.setValue(1, 14, 97);
        System.out.println("layout:" + chain.toString());
        chain.setValue(22, 28, 99);
        System.out.println("layout:" + chain.toString());
        chain.setValue(20, 35, 100);
        System.out.println("layout:" + chain.toString());
        chain.setValue(27, 40, 101);
        System.out.println("layout:" + chain.toString());
        chain.setValue(15, 26, 98);
        System.out.println("layout:" + chain.toString());
        chain.setValue(0, 40, 100);
        System.out.println("layout:" + chain.toString());
    }

    public class Run
    implements Serializable {
        protected int value;
        protected int start;
        protected int end;

        public Run(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.value = n3;
        }

        public String toString() {
            return "Run(start=" + this.start + ", end=" + this.end + ", value=" + this.value + ")";
        }

        public boolean equals(Object object) {
            if (!(object instanceof Run)) {
                return false;
            }
            Run run = (Run)object;
            return this.start == run.start && this.end == run.end && this.value == run.value;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.start;
            n = 37 * n + this.end;
            n = 37 * n + this.value;
            return n;
        }
    }

    public class Chain
    implements Serializable {
        protected List list = new Vector();
        protected int defaultValue = 0;

        public int getValue(int n) {
            ListIterator listIterator = this.list.listIterator();
            int n2 = this.defaultValue;
            try {
                while (listIterator.hasNext()) {
                    Run run = (Run)listIterator.next();
                    if (n > run.end) continue;
                    n2 = run.value;
                    break;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return this.defaultValue;
            }
            return n2;
        }

        public int getSum(int n) {
            int n2 = 0;
            ListIterator listIterator = this.list.listIterator();
            try {
                while (listIterator.hasNext()) {
                    Run run = (Run)listIterator.next();
                    if (n > run.end) {
                        n2 += run.value * (run.end - run.start + 1);
                        continue;
                    }
                    n2 += run.value * (n - run.start);
                    break;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return 0;
            }
            return n2;
        }

        public int getIndex(int n) {
            ListIterator listIterator = this.list.listIterator();
            Run run = null;
            try {
                while (listIterator.hasNext()) {
                    run = (Run)listIterator.next();
                    if (run.value <= 0) continue;
                    int n2 = run.value * (run.end - run.start + 1);
                    if (n2 <= n) {
                        n -= n2;
                        continue;
                    }
                    int n3 = n / run.value;
                    int n4 = run.start + n3;
                    return n4;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return 0;
            }
            if (run != null) {
                return run.end;
            }
            return -1;
        }

        public void setValue(int n, int n2) {
            this.setValue(n, n, n2);
        }

        public void setValue(int n, int n2, int n3) {
            ListIterator listIterator = this.list.listIterator();
            Run run = null;
            boolean bl = false;
            while (listIterator.hasNext()) {
                boolean bl2;
                run = (Run)listIterator.next();
                if (n > run.end) continue;
                if (n2 <= run.end) {
                    boolean bl3;
                    if (n3 == run.value) {
                        bl = true;
                        break;
                    }
                    boolean bl4 = n > run.start;
                    boolean bl5 = bl3 = n2 < run.end;
                    if (bl4 && bl3) {
                        this.splitLeftAndRight(listIterator, run, run, n, n2, n3);
                    } else if (bl4) {
                        this.splitLeft(listIterator, run, run, n, n2, n3);
                    } else if (bl3) {
                        this.splitRight(listIterator, run, run, n, n2, n3);
                    } else {
                        run.value = n3;
                    }
                    bl = true;
                    break;
                }
                Run run2 = run;
                boolean bl6 = n > run2.start;
                while (listIterator.hasNext()) {
                    run = (Run)listIterator.next();
                    if (run.end >= n2) break;
                    listIterator.remove();
                    run = run2;
                }
                boolean bl7 = bl2 = n2 < run.end;
                if (bl6 && bl2) {
                    this.splitLeftAndRight(listIterator, run2, run, n, n2, n3);
                } else if (bl6) {
                    this.splitLeft(listIterator, run2, run, n, n2, n3);
                } else if (bl2) {
                    this.splitRight(listIterator, run2, run, n, n2, n3);
                } else {
                    if (run2 != run) {
                        run2.end = run.start - 1;
                    }
                    run2.value = n3;
                    run.value = n3;
                }
                bl = true;
                break;
            }
            if (!bl) {
                this.list.add(new Run(n, n2, n3));
            }
            this.mergeRuns();
        }

        protected void splitLeftAndRight(ListIterator listIterator, Run run, Run run2, int n, int n2, int n3) {
            Run run3 = new Run(n, n2, n3);
            Run run4 = null;
            if (run == run2) {
                run4 = new Run(n2 + 1, run2.end, run2.value);
            } else {
                run2.start = n2 + 1;
            }
            run.end = n - 1;
            if (run4 == null) {
                listIterator.previous();
            }
            listIterator.add(run3);
            if (run4 != null) {
                listIterator.add(run4);
            }
        }

        protected void splitLeft(ListIterator listIterator, Run run, Run run2, int n, int n2, int n3) {
            Run run3 = null;
            if (run == run2) {
                run3 = new Run(n, n2, n3);
            } else {
                run2.start = n;
                run2.value = n3;
            }
            run.end = n - 1;
            if (run3 != null) {
                listIterator.add(run3);
            }
        }

        protected void splitRight(ListIterator listIterator, Run run, Run run2, int n, int n2, int n3) {
            Run run3 = null;
            if (run == run2) {
                run3 = new Run(n2 + 1, run2.end, run2.value);
            } else {
                run2.start = n2 + 1;
            }
            run.end = n2;
            run.value = n3;
            if (run3 != null) {
                listIterator.add(run3);
            }
        }

        protected void mergeRuns() {
            List list = this.list;
            ListIterator listIterator = list.listIterator();
            Run run = null;
            Run run2 = null;
            if (listIterator.hasNext()) {
                run2 = (Run)listIterator.next();
            }
            while (listIterator.hasNext()) {
                run = (Run)listIterator.next();
                if (run2.value == run.value) {
                    run2.end = run.end;
                    listIterator.remove();
                    continue;
                }
                run2 = run;
            }
        }

        public String toString() {
            return this.list.toString();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Chain)) {
                return false;
            }
            Chain chain = (Chain)object;
            return chain.list.equals(this.list);
        }

        public int hashcode() {
            return this.list.hashCode();
        }
    }
}

