/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.DataViewModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.StringCellRangeFlavor;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;

public class InputHandler
implements Serializable {
    protected JCTable table;
    protected boolean SELECTING = false;

    public InputHandler(JCTable jCTable) {
        this.table = jCTable;
    }

    public void getCellPosition(int n, int n2, JCCellPosition jCCellPosition) {
        if (jCCellPosition == null) {
            return;
        }
        CellAreaHandler cellAreaHandler = this.table.getCellAreaHandler();
        jCCellPosition.row = cellAreaHandler.getRow(n, n2);
        jCCellPosition.column = cellAreaHandler.getColumn(n, n2);
    }

    public boolean isShift(int n) {
        return (n & 1) != 0;
    }

    public boolean isControl(int n) {
        return (n & 2) != 0;
    }

    public boolean isAlt(int n) {
        return (n & 8) != 0;
    }

    public boolean isMeta(int n) {
        return (n & 4) != 0;
    }

    public boolean isCell(int n, int n2) {
        return n > -1 && n2 > -1;
    }

    public boolean isLabel(int n, int n2) {
        return n == -1 || n2 == -1;
    }

    public boolean isCopyAction(AWTEvent aWTEvent, int n, int n2) {
        return this.table.getAction(aWTEvent, n, n2) == 6;
    }

    public boolean isPasteAction(AWTEvent aWTEvent, int n, int n2) {
        return this.table.getAction(aWTEvent, n, n2) == 7;
    }

    public void performCopyAction() {
        JCCellRange jCCellRange;
        Object object;
        if (this.table.getSelectedCells() != null && this.table.getSelectedCells().size() > 0) {
            object = (JCCellRange)this.table.getSelectedCells().iterator().next();
            jCCellRange = new JCCellRange(Math.min(((JCCellRange)object).start_row, ((JCCellRange)object).end_row), Math.min(((JCCellRange)object).start_column, ((JCCellRange)object).end_column), Math.max(((JCCellRange)object).start_row, ((JCCellRange)object).end_row), Math.max(((JCCellRange)object).start_column, ((JCCellRange)object).end_column));
        } else {
            jCCellRange = new JCCellRange(this.table.current_row, this.table.current_column, this.table.current_row, this.table.current_column);
        }
        object = new StringCellRangeFlavor(this.table, jCCellRange);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, (ClipboardOwner)object);
    }

    public void performPasteAction() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        if (transferable != null) {
            try {
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                int n = 0;
                while (n < dataFlavorArray.length) {
                    String string = dataFlavorArray[n].getHumanPresentableName();
                    if (string.equals("CellRange")) {
                        Vector vector = (Vector)transferable.getTransferData(dataFlavorArray[n]);
                        this.loadPasteData(vector);
                        return;
                    }
                    if (string.equals("Unicode String")) {
                        String string2 = (String)transferable.getTransferData(dataFlavorArray[n]);
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", false);
                        Vector vector = new Vector();
                        while (stringTokenizer.hasMoreElements()) {
                            String string3 = (String)stringTokenizer.nextElement();
                            if (string3 == null) continue;
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "\t", false);
                            Vector<String> vector2 = new Vector<String>();
                            while (stringTokenizer2.hasMoreElements()) {
                                vector2.addElement(stringTokenizer2.nextToken());
                            }
                            vector.addElement(vector2);
                        }
                        this.loadPasteData(vector);
                        return;
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                System.out.println("Error pasting data: " + iOException.getMessage());
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("Error pasting data: " + unsupportedFlavorException.getMessage());
            }
        }
    }

    protected void loadPasteData(Vector vector) {
        JCCellRange jCCellRange;
        Collection collection = this.table.getSelectedCells();
        if (collection != null && collection.size() > 0) {
            JCCellRange jCCellRange2 = (JCCellRange)collection.iterator().next();
            jCCellRange = new JCCellRange(Math.min(jCCellRange2.start_row, jCCellRange2.end_row), Math.min(jCCellRange2.start_column, jCCellRange2.end_column), Math.max(jCCellRange2.start_row, jCCellRange2.end_row), Math.max(jCCellRange2.start_column, jCCellRange2.end_column));
        } else {
            jCCellRange = new JCCellRange(this.table.current_row, this.table.current_column, this.table.getNumRows() - 1, this.table.getNumColumns() - 1);
        }
        if (jCCellRange.end_row == Integer.MAX_VALUE) {
            jCCellRange.end_row = this.table.getNumRows() - 1;
        }
        if (jCCellRange.end_column == Integer.MAX_VALUE) {
            jCCellRange.end_column = this.table.getNumColumns() - 1;
        }
        if (jCCellRange != null) {
            int n = vector.size();
            if (n == 0) {
                return;
            }
            int n2 = ((Vector)vector.elementAt(0)).size();
            int n3 = jCCellRange.start_row;
            int n4 = 0;
            while (n3 <= jCCellRange.end_row && n4 < n) {
                Vector vector2 = (Vector)vector.elementAt(n4);
                int n5 = jCCellRange.start_column;
                int n6 = 0;
                while (n5 <= jCCellRange.end_column && n6 < n2) {
                    DataViewModel dataViewModel = this.table.getDataView();
                    if (n5 == -1 || n3 == -1) {
                        TableDataModel tableDataModel = dataViewModel.getDataSource();
                        if (tableDataModel instanceof JCVectorDataSource) {
                            JCVectorDataSource jCVectorDataSource = (JCVectorDataSource)tableDataModel;
                            if (n5 == -1) {
                                jCVectorDataSource.setRowLabel(n3, vector2.elementAt(n6));
                            } else if (n3 == -1) {
                                jCVectorDataSource.setColumnLabel(n5, vector2.elementAt(n6));
                            }
                        }
                    } else {
                        dataViewModel.setTableDataItem(vector2.elementAt(n6), n3, n5);
                    }
                    ++n5;
                    ++n6;
                }
                ++n3;
                ++n4;
            }
        }
    }
}

