/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.ComponentModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCScrollEvent;
import com.klg.jclass.table.JCScrollListener;
import com.klg.jclass.table.JCSeries;
import com.klg.jclass.table.JCTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;

public abstract class ComponentHandler
extends JCSeries
implements ComponentModel,
Serializable,
JCScrollListener,
FocusListener,
KeyListener {
    protected JCTable table = null;
    protected boolean adjustBoundsRequired = true;
    protected boolean needsSetParent = true;
    protected boolean shiftDown = false;
    protected boolean controlDown = false;

    public ComponentHandler() {
    }

    public ComponentHandler(JCTable jCTable) {
        this.setTable(jCTable);
    }

    public JCTable getTable() {
        return this.table;
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
        this.table.addScrollListener(this);
    }

    public boolean isParentSetRequired() {
        return this.needsSetParent;
    }

    public void setParentSetRequired(boolean bl) {
        this.needsSetParent = bl;
    }

    protected void addKeyAndFocusListeners(Component component, KeyListener keyListener, FocusListener focusListener) {
        component = this.table.getEditTraverseHandler().getFocusableChild(component);
        if (component == null) {
            return;
        }
        component.removeKeyListener(keyListener);
        component.addKeyListener(keyListener);
        component.removeFocusListener(focusListener);
        component.addFocusListener(focusListener);
    }

    protected abstract void addListeners(Component var1, KeyListener var2, FocusListener var3);

    public void setDefault(Object object) {
        Component component = (Component)object;
        this.addListeners(component, this, this);
        super.setDefault(object);
    }

    public boolean setValue(int n, int n2, Object object) {
        Serializable serializable;
        Component component = (Component)object;
        Component component2 = this.table.getComponent(n, n2);
        CellArea cellArea = this.table.cellAreaHandler.find(n, n2);
        boolean bl = true;
        if (component2 != null) {
            serializable = this.table.getEditTraverseHandler().getFocusableChild(component2);
            ((Component)serializable).removeKeyListener(this);
            ((Component)serializable).removeFocusListener(this);
            super.remove(n, n2);
            if (cellArea != null) {
                cellArea.remove(component2);
            }
        }
        if (component != null) {
            serializable = null;
            serializable = this.findPosition(component);
            if (serializable != null) {
                super.remove(((JCCellPosition)serializable).row, ((JCCellPosition)serializable).column);
            }
            this.addListeners(component, this, this);
            if (cellArea != null) {
                cellArea.add(component);
            } else {
                this.needsSetParent = true;
            }
            bl = super.setValue(n, n2, object);
        }
        this.table.cellAreaHandler.getCellAreaRenderer().repaintRange(n, n2, n, n2);
        return bl;
    }

    public void addComponentsToParent() {
        int n = 0;
        while (n < this.size()) {
            JCSeries.SeriesValue seriesValue = (JCSeries.SeriesValue)this.elementAt(n);
            CellArea cellArea = this.table.cellAreaHandler.find(seriesValue.row, seriesValue.column);
            cellArea.add((Component)seriesValue.value);
            ++n;
        }
    }

    public void removeCellComponents() {
        int n = 0;
        while (n < this.size()) {
            JCSeries.SeriesValue seriesValue = (JCSeries.SeriesValue)this.elementAt(n);
            CellArea cellArea = this.table.cellAreaHandler.find(seriesValue.row, seriesValue.column);
            if (cellArea != null && cellArea.getType() == 0) {
                Component[] componentArray = cellArea.getComponents();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    cellArea.remove(componentArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        this.needsSetParent = false;
    }

    public JCCellPosition findPosition(Component component) {
        int n = 0;
        while (n < this.size()) {
            JCSeries.SeriesValue seriesValue = (JCSeries.SeriesValue)this.elementAt(n);
            if (component == (Component)seriesValue.value) {
                return new JCCellPosition(seriesValue.row, seriesValue.column);
            }
            ++n;
        }
        return null;
    }

    public void scroll(JCScrollEvent jCScrollEvent) {
    }

    public void afterScroll(JCScrollEvent jCScrollEvent) {
        this.reconfigureComponents();
    }

    public void reconfigureComponents() {
        if (this.table.isTracking()) {
            return;
        }
        JCCellRange jCCellRange = this.table.getVisibleCells();
        int n = 0;
        while (n < this.size()) {
            JCSeries.SeriesValue seriesValue = (JCSeries.SeriesValue)this.elementAt(n);
            Component component = (Component)seriesValue.value;
            if (seriesValue.row >= jCCellRange.start_row && seriesValue.row <= jCCellRange.end_row && seriesValue.column >= jCCellRange.start_column && seriesValue.column <= jCCellRange.end_column) {
                component.setVisible(true);
            } else {
                component.setVisible(false);
            }
            ++n;
        }
    }

    protected JCCellPosition getTablePosition(Component component) {
        Container container;
        JCCellPosition jCCellPosition = this.table.getPosition(component);
        if (jCCellPosition == null && (container = component.getParent()) instanceof Component) {
            jCCellPosition = this.table.getPosition(container);
        }
        int n = jCCellPosition == null ? -1 : jCCellPosition.row;
        int n2 = jCCellPosition == null ? -1 : jCCellPosition.column;
        return jCCellPosition;
    }

    public abstract void focusGained(FocusEvent var1);

    public abstract void focusLost(FocusEvent var1);

    protected boolean updateTable(Component component) {
        JCCellPosition jCCellPosition = this.getTablePosition(component);
        if (jCCellPosition == null || jCCellPosition.row == -1 || jCCellPosition.column == -1 || !this.table.isTraversable(jCCellPosition.row, jCCellPosition.column)) {
            this.table.getFocusManager().requestFocus();
            return false;
        }
        int n = this.table.current_row;
        int n2 = this.table.current_column;
        this.table.current_row = jCCellPosition.row;
        this.table.current_column = jCCellPosition.column;
        CellAreaRenderer cellAreaRenderer = this.table.cellAreaHandler.cellAreaRenderer;
        cellAreaRenderer.repaintRange(n, n2, n, n2);
        cellAreaRenderer.repaintRange(this.table.current_row, this.table.current_column, this.table.current_row, this.table.current_column);
        return true;
    }

    protected int getDirectionFromKeyEvent(KeyEvent keyEvent) {
        int n = -999;
        if (keyEvent == null) {
            return n;
        }
        String string = "None";
        this.shiftDown = false;
        this.controlDown = false;
        switch (keyEvent.getKeyCode()) {
            case 9: {
                if (keyEvent.isControlDown()) {
                    this.controlDown = true;
                }
                if (keyEvent.isShiftDown()) {
                    this.shiftDown = true;
                    n = 3;
                    string = "Left";
                    break;
                }
                n = 4;
                string = "Right";
                break;
            }
            case 40: {
                n = 1;
                string = "Down";
                break;
            }
            case 38: {
                n = 2;
                string = "Up";
                break;
            }
            case 37: {
                n = 3;
                string = "Left";
                break;
            }
            case 39: {
                n = 4;
                string = "Right";
            }
        }
        return n;
    }

    public abstract void keyPressed(KeyEvent var1);

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void traverseNext(JCCellPosition jCCellPosition, int n) {
        JCCellPosition jCCellPosition2 = null;
        jCCellPosition2 = this.table.keyHandler.findTraversableCell(n, jCCellPosition.row, jCCellPosition.column);
        if (jCCellPosition2 != null) {
            this.table.getEditTraverseHandler().traverse(jCCellPosition2.row, jCCellPosition2.column, false, null, n, false);
        }
    }
}

