/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class LayoutButton
extends JButton {
    public static final int MAXIMIZE = 0;
    public static final int MINIMIZE = 1;
    public static final int ICONIFY = 2;
    public static final int CLOSE = 3;
    public static final int MOTIF_BUTTON_SIZE = 19;
    public static final Dimension motifButtonDimension = new Dimension(19, 19);
    protected static final String[] basic_icon_names = new String[]{"InternalFrame.maximizeIcon", "InternalFrame.minimizeIcon", "InternalFrame.iconifyIcon", "InternalFrame.closeIcon"};
    protected static final String[] metal_icon_names = new String[]{"InternalFrame.maximizeIcon", "InternalFrame.minimizeIcon", "InternalFrame.iconizeIcon", "InternalFrame.closeIcon"};
    protected static final String[] action_commands = new String[]{"Maximize", "Minimize", "Iconify", "Close"};
    protected Color motifColor;
    protected Color motifHighlight;
    protected Color motifShadow;
    protected int controlType = -1;
    public boolean isMotif = false;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);

    public LayoutButton(int n) {
        this.controlType = n;
        this.inferLookAndFeel();
    }

    public int getControlType() {
        return this.controlType;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void requestFocus() {
    }

    public boolean isOpaque() {
        return true;
    }

    public Dimension getMinimumSize() {
        if (this.isMotif) {
            return motifButtonDimension;
        }
        return super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.isMotif) {
            return motifButtonDimension;
        }
        return super.getPreferredSize();
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this.inferLookAndFeel();
    }

    public void updateUI() {
        super.updateUI();
        this.inferLookAndFeel();
    }

    public void paint(Graphics graphics) {
        if (!this.isMotif) {
            super.paint(graphics);
            return;
        }
        Dimension dimension = this.getSize();
        int n = dimension.width - 1;
        int n2 = dimension.height - 1;
        graphics.setColor(this.motifColor);
        graphics.fillRect(1, 1, dimension.width, dimension.height);
        boolean bl = this.getModel().isPressed();
        graphics.setColor(bl ? this.motifShadow : this.motifHighlight);
        graphics.drawLine(0, 0, n, 0);
        graphics.drawLine(0, 0, 0, n2);
        graphics.setColor(bl ? this.motifHighlight : this.motifShadow);
        graphics.drawLine(1, n2, n, n2);
        graphics.drawLine(n, 1, n, n2);
        if (this.controlType == 2) {
            graphics.setColor(this.motifHighlight);
            graphics.drawLine(7, 8, 7, 11);
            graphics.drawLine(7, 8, 10, 8);
            graphics.setColor(this.motifShadow);
            graphics.drawLine(8, 11, 10, 11);
            graphics.drawLine(11, 9, 11, 11);
        } else if (this.controlType == 0 || this.controlType == 1) {
            int n3 = 14;
            boolean bl2 = this.controlType == 1;
            graphics.setColor(bl2 ? this.motifShadow : this.motifHighlight);
            graphics.drawLine(4, 4, 4, n3);
            graphics.drawLine(4, 4, n3, 4);
            graphics.setColor(bl2 ? this.motifHighlight : this.motifShadow);
            graphics.drawLine(5, n3, n3, n3);
            graphics.drawLine(n3, 5, n3, n3);
        }
    }

    protected void inferLookAndFeel() {
        if (this.controlType == -1) {
            return;
        }
        String string = UIManager.getLookAndFeel().getClass().getName();
        this.setFocusPainted(false);
        if (string.indexOf("MetalLookAndFeel") != -1) {
            Icon icon = UIManager.getIcon(metal_icon_names[this.controlType]);
            if (icon == null) {
                icon = UIManager.getIcon(basic_icon_names[this.controlType]);
            }
            this.setIcon(icon);
            this.setBorder(handyEmptyBorder);
            this.isMotif = false;
            this.setOpaque(false);
        } else if (string.indexOf("MotifLookAndFeel") != -1) {
            this.motifColor = this.getBackground();
            this.motifShadow = this.motifColor.darker().darker();
            this.motifHighlight = this.motifColor.brighter();
            this.isMotif = true;
            this.setBorderPainted(false);
        } else {
            Icon icon = UIManager.getIcon(basic_icon_names[this.controlType]);
            this.setIcon(icon);
            this.isMotif = false;
        }
        this.setActionCommand(action_commands[this.controlType]);
    }
}

