/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCGaugeArea;
import com.klg.jclass.swing.gauge.JCLinearGauge;
import com.klg.jclass.swing.gauge.JCLinearTick;
import com.klg.jclass.swing.gauge.LinearConstraint;
import com.klg.jclass.swing.gauge.LinearLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JLabel;

public class JCLinearScale
extends JCAbstractScale {
    protected Orientation orientation = Orientation.HORIZONTAL;
    protected boolean useZoomFactorForMin = true;
    protected boolean useZoomFactorForMax = true;

    public JCLinearScale(JCLinearGauge jCLinearGauge) {
        super(jCLinearGauge);
        this.setLayout(new LinearLayout());
        this.setForeground(Color.white);
        GaugeUtil.createLegendPopulatorRenderer(jCLinearGauge, this);
    }

    public JCLinearScale(JCLinearGauge jCLinearGauge, JCAbstractScale.Direction direction, double d, double d2, Orientation orientation, Color color) {
        super(jCLinearGauge, direction, d, d2, color);
        this.setLayout(new LinearLayout());
        this.orientation = orientation;
        GaugeUtil.createLegendPopulatorRenderer(jCLinearGauge, this);
    }

    public JCLinearGauge getLinearGauge() {
        return (JCLinearGauge)this.getGauge();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getBounds().width, this.getParent().getBounds().height);
    }

    public Component add(Component component) {
        this.add(component, new LinearConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE));
        return component;
    }

    public Component add(Component component, int n) {
        this.add(component, new LinearConstraint(this.getGauge(), Double.MAX_VALUE, Double.MAX_VALUE), n);
        return component;
    }

    public Rectangle getScaleSize() {
        JCGaugeArea jCGaugeArea = this.getGauge().getGaugeArea();
        Insets insets = jCGaugeArea.getInsets();
        Insets insets2 = this.getInsets();
        int n = jCGaugeArea.getBounds().width;
        int n2 = jCGaugeArea.getBounds().height;
        int n3 = Math.max(insets2.left, insets.left);
        int n4 = Math.max(insets2.right, insets.right);
        int n5 = Math.max(insets2.top, insets.top);
        int n6 = Math.max(insets2.bottom, insets.bottom);
        int n7 = n3;
        int n8 = n5;
        n -= n3 + n4;
        n2 -= n5 + n6;
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        if (this.useZoomFactorForMin || this.useZoomFactorForMax) {
            if (this.orientation == Orientation.VERTICAL) {
                double d = (double)n - (double)n * this.zoomFactor;
                if (this.useZoomFactorForMin && this.useZoomFactorForMax) {
                    n7 += (int)(d / 2.0);
                } else if (this.useZoomFactorForMin) {
                    n7 += (int)d;
                }
                n = (int)((double)n * this.zoomFactor);
            } else {
                double d = (double)n2 - (double)n2 * this.zoomFactor;
                if (this.useZoomFactorForMin && this.useZoomFactorForMax) {
                    n8 += (int)(d / 2.0);
                } else if (this.useZoomFactorForMin) {
                    n8 += (int)d;
                }
                n2 = (int)((double)n2 * this.zoomFactor);
            }
        }
        return new Rectangle(n7, n8, n, n2);
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getScaleSize();
        super.paintComponent(graphics);
        Graphics graphics2 = graphics.create();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.image != null) {
            this.drawImage(graphics2, this.image, rectangle);
        } else {
            graphics2.fillRect(n, n2, n3, n4);
        }
        graphics2.dispose();
    }

    public double pick(Point point) {
        double d = this.min;
        Rectangle rectangle = this.getScaleSize();
        d = this.orientation == Orientation.VERTICAL ? GaugeUtil.positionToValue(point.y, this.min, this.max, rectangle.y, rectangle.y + rectangle.height) : GaugeUtil.positionToValue(point.x, this.min, this.max, rectangle.x, rectangle.x + rectangle.width);
        if (this.direction.equals(JCAbstractScale.Direction.BACKWARD) ^ this.orientation == Orientation.VERTICAL) {
            d = this.max - d + this.min;
        }
        d = GaugeUtil.clamp(d, this.min, this.max);
        return d;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.redraw();
    }

    public boolean getUseZoomFactorForMin() {
        return this.useZoomFactorForMin;
    }

    public void setUseZoomFactorForMin(boolean bl) {
        this.useZoomFactorForMin = bl;
    }

    public boolean getUseZoomFactorForMax() {
        return this.useZoomFactorForMax;
    }

    public void setUseZoomFactorForMax(boolean bl) {
        this.useZoomFactorForMax = bl;
    }

    protected void drawImage(Graphics graphics, Image image, Rectangle rectangle) {
        JLabel jLabel = new JLabel();
        if (super.getScaleImage()) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getForeground(), jLabel);
        } else {
            graphics.drawImage(image, rectangle.x, rectangle.y, this.getForeground(), jLabel);
        }
    }

    public void redraw() {
        if (this.gauge.getRepaintEnabled()) {
            Enumeration enumeration = this.gauge.getTicks().elements();
            while (enumeration.hasMoreElements()) {
                JCLinearTick jCLinearTick = (JCLinearTick)enumeration.nextElement();
                jCLinearTick.redraw(true);
            }
            this.repaint();
        }
    }

    public static class Orientation {
        public static final Orientation HORIZONTAL = new Orientation();
        public static final Orientation VERTICAL = new Orientation();

        private Orientation() {
        }
    }
}

