/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCAbstractNeedle;
import com.klg.jclass.swing.gauge.JCGauge;
import com.klg.jclass.swing.gauge.JCGaugePickEvent;
import com.klg.jclass.swing.gauge.JCLinearNeedle;
import com.klg.jclass.swing.gauge.JCLinearScale;
import com.klg.jclass.swing.gauge.JCLinearTick;
import com.klg.jclass.swing.gauge.LinearConstraint;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCLinearGauge
extends JCGauge
implements ServerRenderable {
    protected Vector labels = new Vector();
    private Graphics prevSetGraphics = null;

    public JCLinearGauge() {
        JCLinearScale jCLinearScale = new JCLinearScale(this);
        this.setScale(jCLinearScale, false);
        JCLinearNeedle jCLinearNeedle = new JCLinearNeedle(jCLinearScale);
        this.addNeedle(jCLinearNeedle);
        JCLinearTick jCLinearTick = new JCLinearTick(jCLinearScale);
        this.addTick(jCLinearTick);
        this.gaugeArea.add(jCLinearScale);
        this.setPreferredSize(new Dimension(200, 100));
    }

    public JCLinearGauge(boolean bl) {
        if (bl) {
            JCLinearScale jCLinearScale = new JCLinearScale(this);
            this.setScale(jCLinearScale);
        }
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.image != null) {
            this.drawImage(graphics, this.image, this.getBounds(), this.getBackground());
        }
        this.gaugeArea.doLayout();
        super.paintComponent(graphics);
    }

    public JCLinearScale getLinearScale() {
        return (JCLinearScale)this.getScale();
    }

    public void setScale(JCLinearScale jCLinearScale, boolean bl) {
        if (this.scale != null) {
            this.gaugeArea.remove((Component)((Object)this.scale));
        }
        this.scale = jCLinearScale;
        if (bl) {
            this.gaugeArea.add(jCLinearScale);
        }
        this.setIndicatorScales(jCLinearScale);
        this.setNeedleScales(jCLinearScale);
    }

    public void setScale(JCLinearScale jCLinearScale) {
        this.setScale(jCLinearScale, true);
    }

    public void addLabel(JComponent jComponent, LinearConstraint linearConstraint) {
        this.labels.addElement(jComponent);
        this.getGaugeArea().add(jComponent, linearConstraint, 0);
    }

    public void addLabel(JComponent jComponent, LinearConstraint linearConstraint, int n) {
        this.labels.addElement(jComponent);
        this.getGaugeArea().add(jComponent, linearConstraint, n);
    }

    public void removeLabel(JComponent jComponent) {
        if (this.labels.contains(jComponent)) {
            this.labels.removeElement(jComponent);
            this.getGaugeArea().remove(jComponent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JCLinearNeedle jCLinearNeedle;
        super.mouseClicked(mouseEvent);
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null && (jCLinearNeedle = this.getClosestNeedle(jCGaugePickEvent, JCAbstractNeedle.InteractionType.CLICK)) != null) {
            jCLinearNeedle.setValue(jCGaugePickEvent.getValue());
            this.redraw();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        JCGaugePickEvent jCGaugePickEvent = this.pick(mouseEvent.getPoint());
        if (jCGaugePickEvent != null) {
            if (this.draggedNeedle == null) {
                this.draggedNeedle = this.getClosestNeedle(jCGaugePickEvent, JCAbstractNeedle.InteractionType.DRAG);
            }
            if (this.draggedNeedle != null) {
                this.draggedNeedle.setValue(jCGaugePickEvent.getValue());
                this.redraw();
            }
        }
    }

    public JCLinearNeedle getClosestNeedle(JCGaugePickEvent jCGaugePickEvent, JCAbstractNeedle.InteractionType interactionType) {
        JCLinearNeedle jCLinearNeedle = null;
        int n = this.valueToPosition(jCGaugePickEvent.getValue());
        Enumeration enumeration = this.needles.elements();
        while (enumeration.hasMoreElements()) {
            JCLinearNeedle jCLinearNeedle2 = (JCLinearNeedle)enumeration.nextElement();
            JCAbstractNeedle.InteractionType interactionType2 = jCLinearNeedle2.getInteractionType();
            if (interactionType2 != JCAbstractNeedle.InteractionType.CLICK_DRAG && interactionType2 != interactionType) continue;
            if (jCLinearNeedle == null) {
                jCLinearNeedle = jCLinearNeedle2;
                continue;
            }
            int n2 = this.valueToPosition(jCLinearNeedle2.getValue());
            int n3 = this.valueToPosition(jCLinearNeedle.getValue());
            int n4 = Math.abs(n - n2);
            int n5 = Math.abs(n - n3);
            if (n5 <= n4) continue;
            jCLinearNeedle = jCLinearNeedle2;
        }
        return jCLinearNeedle;
    }

    protected int valueToPosition(double d) {
        JCLinearScale jCLinearScale = this.getLinearScale();
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        Rectangle rectangle = jCLinearScale.getScaleSize();
        int n = orientation == JCLinearScale.Orientation.VERTICAL ? GaugeUtil.valueToPosition(d, jCLinearScale.getMin(), jCLinearScale.getMax(), rectangle.y, rectangle.y + rectangle.height) : GaugeUtil.valueToPosition(d, jCLinearScale.getMin(), jCLinearScale.getMax(), rectangle.x, rectangle.x + rectangle.width);
        return n;
    }

    protected void drawImage(Graphics graphics, Image image, Rectangle rectangle, Color color) {
        JLabel jLabel = new JLabel();
        if (super.getScaleImage()) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, jLabel);
        } else {
            graphics.drawImage(image, rectangle.x, rectangle.y, color, jLabel);
        }
    }

    public void redraw() {
        if (this.getRepaintEnabled()) {
            this.repaint();
        }
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics;
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
        this.getLegend().setGraphics(graphics);
    }

    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    public void serverPaint(Graphics graphics) {
        ServerRenderer.paintContainer(graphics, this);
    }
}

