/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.swing.JCCellEditorToJTree;
import com.klg.jclass.cell.swing.JCCellRendererToJTree;
import com.klg.jclass.swing.JCVersion;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.swing.JCSortableTable;
import com.klg.jclass.util.treetable.BranchTree;
import com.klg.jclass.util.treetable.DefaultTreeIconRenderer;
import com.klg.jclass.util.treetable.EmptyTreeTableModel;
import com.klg.jclass.util.treetable.JCTreeIconRenderer;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import com.klg.jclass.util.treetable.NodeChildrenTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JCTreeExplorer
extends JSplitPane {
    protected JCTreeTableModel treetableModel;
    protected TreeModel treeModel;
    protected NodeChildrenTable tableModel;
    protected JTree tree;
    protected JCSortableTable table;
    protected TableCellRenderer firstColumnRenderer;
    protected TableCellEditor firstColumnEditor;
    protected JCTreeIconRenderer iconRenderer = new DefaultTreeIconRenderer();
    protected Icon openIcon;
    protected Icon closedIcon;
    protected Icon leafIcon;
    protected int iconGap;
    protected int iconWidth;
    protected int cellHeight;
    protected Color tableBackground;

    public JCTreeExplorer() {
        this(new EmptyTreeTableModel(EmptyTreeTableModel.makeDefaultTree()));
    }

    public JCTreeExplorer(JCTreeTableModel jCTreeTableModel, Dimension dimension) {
        this.setModel(jCTreeTableModel);
        this.table.setIntercellSpacing(dimension);
    }

    public JCTreeExplorer(JCTreeTableModel jCTreeTableModel) {
        this(jCTreeTableModel, new Dimension(0, 0));
    }

    public JCTreeTableModel getModel() {
        return this.treetableModel;
    }

    public void setModel(JCTreeTableModel jCTreeTableModel) {
        if (!(jCTreeTableModel instanceof TreeModel) && !(jCTreeTableModel instanceof TableModel)) {
            throw new IllegalArgumentException("TreeTableModel MUST implement both javax.swing.tree.TreeModel and\n\tjavax.swing.table.TableModel");
        }
        this.inferLookAndFeelSetVars();
        this.treetableModel = jCTreeTableModel;
        SelectionListener selectionListener = new SelectionListener();
        this.treeModel = new BranchTree(this.treetableModel);
        this.tableModel = new NodeChildrenTable(this.treetableModel);
        this.tableModel.addTableModelListener(selectionListener);
        JScrollPane jScrollPane = new JScrollPane();
        this.tree = new TreeIconRenderTree(this.treeModel);
        this.tree.addTreeSelectionListener(selectionListener);
        jScrollPane.setViewportView(this.tree);
        this.setLeftComponent(jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane();
        this.table = new TreeIconRenderTable(this.tableModel);
        this.firstColumnRenderer = new FirstColumnRenderer();
        this.firstColumnEditor = new FirstColumnEditor();
        this.table.addMouseListener(new ClickListener());
        jScrollPane2.setViewportView(this.table);
        this.setRightComponent(jScrollPane2);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (treeSelectionModel != null) {
            treeSelectionModel.setSelectionMode(1);
        }
        if (JCEnvironment.isDesignTime()) {
            this.setDividerLocation(50);
            this.tree.expandRow(0);
            this.tree.addSelectionRow(0);
        }
        this.inferLookAndFeelSetupControls();
    }

    public Dimension getPreferredSize() {
        if (JCEnvironment.isDesignTime()) {
            return new Dimension(300, 200);
        }
        return super.getPreferredSize();
    }

    public TreePath getSelectionPath() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return this.tree.getSelectionPath();
        }
        return treePathArray[0];
    }

    public TreePath[] getSelectionPaths() {
        TreePath treePath = this.tree.getSelectionPath();
        int[] nArray = this.table.getSelectedRows();
        if (treePath == null || nArray == null || nArray.length == 0) {
            return null;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            Object object = this.treetableModel.getChild(treePath.getLastPathComponent(), nArray[n]);
            treePathArray[n] = treePath.pathByAddingChild(object);
            ++n;
        }
        return treePathArray;
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public JTree getTree() {
        return this.tree;
    }

    public JTable getTable() {
        return this.table;
    }

    public void inferLookAndFeel() {
        this.inferLookAndFeelSetVars();
        this.inferLookAndFeelSetupControls();
    }

    protected void inferLookAndFeelSetVars() {
        this.openIcon = (Icon)UIManager.get("Tree.openIcon");
        this.closedIcon = (Icon)UIManager.get("Tree.closedIcon");
        this.leafIcon = (Icon)UIManager.get("Tree.leafIcon");
        this.iconGap = 2;
        this.iconWidth = Math.max(this.openIcon.getIconWidth(), this.closedIcon.getIconWidth());
        this.iconWidth = Math.max(this.iconWidth, this.leafIcon.getIconWidth());
        this.tableBackground = (Color)UIManager.get("Table.background");
        this.cellHeight = Math.max(this.openIcon.getIconHeight(), this.closedIcon.getIconHeight());
        this.cellHeight = Math.max(this.cellHeight, this.leafIcon.getIconHeight());
    }

    protected void inferLookAndFeelSetupControls() {
        if (this.table.getRowHeight() < this.cellHeight) {
            this.table.setRowHeight(this.cellHeight);
        }
    }

    public void setUI(TableUI tableUI) {
        this.inferLookAndFeel();
        super.setUI(tableUI);
    }

    public void setTreeIconRenderer(JCTreeIconRenderer jCTreeIconRenderer) {
        this.iconRenderer = jCTreeIconRenderer;
    }

    public JCTreeIconRenderer getTreeIconRenderer() {
        return this.iconRenderer;
    }

    protected class TreeIconRenderTree
    extends JTree {
        public TreeIconRenderTree(TreeModel treeModel) {
            super(treeModel);
        }
    }

    protected class TreeIconRenderTable
    extends JCSortableTable {
        public TreeIconRenderTable(TableModel tableModel) {
            super(tableModel);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return JCTreeExplorer.this.firstColumnRenderer;
            }
            return super.getCellRenderer(n, n2);
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return JCTreeExplorer.this.firstColumnEditor;
            }
            return super.getCellEditor(n, n2);
        }

        public TableCellRenderer getRealCellRenderer(int n, int n2) {
            return super.getCellRenderer(n, n2);
        }

        public TableCellEditor getRealCellEditor(int n, int n2) {
            return super.getCellEditor(n, n2);
        }
    }

    protected class ClickListener
    extends MouseAdapter {
        protected ClickListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            int n = JCTreeExplorer.this.table.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            TreePath treePath = JCTreeExplorer.this.tableModel.getParentPath();
            n = JCTreeExplorer.this.table.getUnsortedRow(n);
            Object object = JCTreeExplorer.this.treetableModel.getChild(treePath.getLastPathComponent(), n);
            if (JCTreeExplorer.this.treetableModel.isLeaf(object)) {
                return;
            }
            TreePath treePath2 = treePath.pathByAddingChild(object);
            JCTreeExplorer.this.tree.setSelectionPath(treePath2);
        }
    }

    protected class SelectionListener
    implements TreeSelectionListener,
    TableModelListener {
        protected SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            if (treePath != null && treePath.equals(JCTreeExplorer.this.tableModel.getParentPath())) {
                return;
            }
            JCTreeExplorer.this.table.clearSelection();
            JCTreeExplorer.this.tableModel.setParentPath(treePath);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            JCTreeExplorer.this.table.editingCanceled(null);
        }
    }

    protected class FirstColumnEditor
    extends WhiteOutContainer
    implements TableCellEditor {
        protected TableCellEditor editor = null;

        protected FirstColumnEditor() {
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            n = JCTreeExplorer.this.table.getUnsortedRow(n);
            TableCellEditor tableCellEditor = ((TreeIconRenderTable)jTable).getRealCellEditor(n, n2);
            TreePath treePath = JCTreeExplorer.this.tableModel.getParentPath();
            Object object2 = JCTreeExplorer.this.treetableModel.getChild(treePath.getLastPathComponent(), n);
            treePath = treePath.pathByAddingChild(object2);
            this.value = object;
            this.valueClass = object != null ? object.getClass() : jTable.getColumnModel().getColumn(n2).getClass();
            this.isLeaf = JCTreeExplorer.this.tableModel.isLeaf(n);
            this.removeAll();
            this.add(tableCellEditor.getTableCellEditorComponent(jTable, object, bl, n, n2));
            return this;
        }

        public TableCellEditor getEditor() {
            if (this.editor == null) {
                TreeIconRenderTable treeIconRenderTable = (TreeIconRenderTable)JCTreeExplorer.this.table;
                this.editor = treeIconRenderTable.getRealCellEditor(0, 0);
            }
            return this.editor;
        }

        public Object getCellEditorValue() {
            return this.getEditor().getCellEditorValue();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return this.getEditor().isCellEditable(eventObject);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return this.getEditor().shouldSelectCell(eventObject);
        }

        public boolean stopCellEditing() {
            boolean bl = this.getEditor().stopCellEditing();
            return bl;
        }

        public void cancelCellEditing() {
            this.getEditor().cancelCellEditing();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.getEditor().addCellEditorListener(cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.getEditor().removeCellEditorListener(cellEditorListener);
        }
    }

    protected class FirstColumnRenderer
    extends WhiteOutContainer
    implements TableCellRenderer {
        protected FirstColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableCellRenderer tableCellRenderer = ((TreeIconRenderTable)jTable).getRealCellRenderer(n, n2);
            n = JCTreeExplorer.this.table.getUnsortedRow(n);
            TreePath treePath = JCTreeExplorer.this.tableModel.getParentPath();
            Object object2 = JCTreeExplorer.this.treetableModel.getChild(treePath.getLastPathComponent(), n);
            this.path = treePath.pathByAddingChild(object2);
            this.value = object;
            this.valueClass = object != null ? object.getClass() : jTable.getColumnModel().getColumn(n2).getClass();
            this.isLeaf = JCTreeExplorer.this.tableModel.isLeaf(n);
            this.removeAll();
            this.add(tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2));
            return this;
        }
    }

    protected class TreeEditor
    extends WhiteOutContainer
    implements TreeCellEditor {
        TreeCellEditor editor = null;

        protected TreeEditor() {
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Object object2;
            Serializable serializable;
            this.value = object;
            this.valueClass = object != null ? object.getClass() : JCTreeExplorer.this.table.getColumnModel().getColumn(0).getClass();
            if (this.editor == null && (serializable = ((EditorRendererRegistry)(object2 = EditorRendererRegistry.getCentralRegistry())).getCellEditorInstance(this.valueClass, null)) != null) {
                this.editor = new JCCellEditorToJTree((JCCellEditor)serializable);
            }
            object2 = null;
            if (this.getComponentCount() != 0) {
                object2 = this.getComponent(0);
            }
            this.isLeaf = JCTreeExplorer.this.treeModel.isLeaf(object);
            serializable = this.editor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
            if (object2 != serializable) {
                this.add((Component)serializable);
            }
            return this;
        }

        public TreeCellEditor getEditor() {
            TableColumn tableColumn;
            EditorRendererRegistry editorRendererRegistry;
            JCCellEditor jCCellEditor;
            if (this.editor == null && (jCCellEditor = (editorRendererRegistry = EditorRendererRegistry.getCentralRegistry()).getCellEditorInstance((tableColumn = JCTreeExplorer.this.table.getColumnModel().getColumn(0)).getClass(), null)) != null) {
                return new JCCellEditorToJTree(jCCellEditor);
            }
            return this.editor;
        }

        public Object getCellEditorValue() {
            return this.getEditor().getCellEditorValue();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return this.getEditor().isCellEditable(eventObject);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return this.getEditor().shouldSelectCell(eventObject);
        }

        public boolean stopCellEditing() {
            return this.getEditor().stopCellEditing();
        }

        public void cancelCellEditing() {
            this.getEditor().cancelCellEditing();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.getEditor().addCellEditorListener(cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.getEditor().removeCellEditorListener(cellEditorListener);
        }
    }

    protected class TreeRenderer
    extends WhiteOutContainer
    implements TreeCellRenderer {
        TreeCellRenderer renderer = null;

        protected TreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            Serializable serializable;
            this.value = object;
            this.valueClass = object != null ? object.getClass() : JCTreeExplorer.this.table.getColumnModel().getColumn(0).getClass();
            if (this.renderer == null && (serializable = ((EditorRendererRegistry)(object2 = EditorRendererRegistry.getCentralRegistry())).getCellRendererInstance(this.valueClass, null)) != null) {
                this.renderer = new JCCellRendererToJTree((JCCellRenderer)serializable);
            }
            object2 = null;
            if (this.getComponentCount() != 0) {
                object2 = this.getComponent(0);
            }
            this.isLeaf = JCTreeExplorer.this.treeModel.isLeaf(object);
            serializable = this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object2 != serializable) {
                this.add((Component)serializable);
            }
            return this;
        }
    }

    protected class WhiteOutContainer
    extends JComponent {
        boolean isLeaf = true;
        TreePath path;
        Object value;
        Class valueClass;

        protected WhiteOutContainer() {
        }

        public void doLayout() {
            if (this.getComponentCount() > 0) {
                Component component = this.getComponent(0);
                if (component == null) {
                    return;
                }
                Dimension dimension = this.getSize();
                component.setBounds(JCTreeExplorer.this.iconWidth + JCTreeExplorer.this.iconGap, 0, dimension.width - JCTreeExplorer.this.iconWidth - JCTreeExplorer.this.iconGap, dimension.height);
            } else {
                super.doLayout();
            }
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(JCTreeExplorer.this.tableBackground);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            super.paint(graphics);
            int n = this.getSize().height;
            if (JCTreeExplorer.this.iconRenderer == null) {
                return;
            }
            Icon icon = null;
            icon = this.isLeaf ? JCTreeExplorer.this.leafIcon : JCTreeExplorer.this.closedIcon;
            Icon icon2 = JCTreeExplorer.this.iconRenderer.getNodeIcon(JCTreeExplorer.this.treeModel, this.path, this.value, this.valueClass, this.isLeaf, false, icon);
            if (icon2 != null) {
                icon2.paintIcon(this, graphics, 0, (n - JCTreeExplorer.this.leafIcon.getIconHeight()) / 2);
            }
        }

        public Dimension getPreferredSize() {
            Component component = this.getComponent(0);
            if (component == null) {
                return new Dimension(10, 10);
            }
            Dimension dimension = component.getPreferredSize();
            dimension.setSize(dimension.width + JCTreeExplorer.this.iconGap + JCTreeExplorer.this.iconWidth, dimension.height);
            return dimension;
        }

        public Dimension getMaximumSize() {
            Component component = this.getComponent(0);
            if (component == null) {
                return new Dimension(10, 10);
            }
            return component.getMaximumSize();
        }

        public Dimension getMinimumSize() {
            Component component = this.getComponent(0);
            if (component == null) {
                return new Dimension(10, 10);
            }
            return component.getMinimumSize();
        }
    }
}

