/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.swing.JCMDIFrame;
import com.klg.jclass.swing.JCMDIWindowMenu;
import com.klg.jclass.swing.JCVersion;
import com.klg.jclass.swing.util.LayoutButton;
import com.klg.jclass.swing.util.LayoutButtonBox;
import com.klg.jclass.swing.util.ShrinkWrapLayout;
import com.klg.jclass.swing.util.UserMenuItem;
import com.klg.jclass.swing.util.WindowMenuItem;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.swing.JCAction;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class JCMDIPane
extends JDesktopPane {
    public static final int WIREFRAME = 1;
    public static final int DEFAULT = 2;
    public static final int TILE_HORIZONTAL = 1;
    public static final int TILE_VERTICAL = 2;
    public static final int CASCADE = 3;
    protected static JCLocaleManager li = JCLocaleManager.getDefault();
    protected int initialLayout = 0;
    protected JMenuBar menubar = null;
    protected JToolBar toolbar = null;
    protected Listener listener = new Listener();
    protected FrameListener frameListener = new FrameListener();
    protected ActionListener menuListener = new WindowsMenuListener();
    protected boolean maximized = false;
    protected LayoutButtonBox layoutButtonBox = null;
    protected String savedTitle = null;
    protected boolean titleIsSaved = false;
    protected JCAction maxMinAction = null;
    protected JMenuItem maxMinItem = null;
    protected JCAction cascadeAction = null;
    protected JCAction tileHorizAction = null;
    protected JCAction tileVertAction = null;
    protected JCAction arrangeIconsAction = null;
    protected int frameManipulationStyle = 1;
    protected JToolBar lastToolBarSetToRoot = null;
    protected Icon selectedIcon;
    protected Icon nonSelectedIcon;
    protected JInternalFrame activeFrame = null;
    protected JPanel maximizedPanel = new JPanel(new ShrinkWrapLayout());
    protected JInternalFrame maximizedFrame = null;
    protected JInternalFrame maximizingFrame = null;
    protected boolean considerIconsWhenTiling = false;
    protected JMenuBar currentMenuBar = null;
    protected JInternalFrame activatingFrame = null;
    private static final String[] selectedIconPixels = new String[]{"             ", "             ", "         bbb ", "        bbb  ", "       bbb   ", "bbbb  bbb    ", " bbb bbb     ", "  bbbbb      ", "   bbb       ", "    b        ", "             ", "             ", "             "};
    private static final String[] nonSelectedIconPixels = new String[]{"             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "};
    protected int cascadeX = -1;
    protected int cascadeY = -1;
    protected int cascadeXStart = 0;
    protected int cascadeYStart = 0;
    protected int cascadeXIncrement = 20;
    protected int cascadeYIncrement = 25;
    protected int cascadeStartIncrement = 100;
    protected int cascadeTolerance = 50;
    private Dimension cascadeSize = new Dimension(0, 0);
    private int fudge2 = 0;
    private int fudge1 = 0;
    static /* synthetic */ Class class$javax$swing$JScrollPane;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public JCMDIPane() {
        this.setMinimumSize(new Dimension(300, 200));
        this.addContainerListener(this.listener);
        this.setSelectedIcon(JCMDIPane.makeImage(selectedIconPixels));
        this.setNonSelectedIcon(JCMDIPane.makeImage(nonSelectedIconPixels));
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public int getFrameManipulationStyle() {
        return this.frameManipulationStyle;
    }

    public void setFrameManipulationStyle(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("invalid parameter: " + n);
        }
        if (n == this.frameManipulationStyle) {
            return;
        }
        this.frameManipulationStyle = n;
    }

    public void setDragMode(int n) {
        if (JCEnvironment.getJavaVersion() >= 130) {
            super.setDragMode(n);
        }
        if (n == JDesktopPane.LIVE_DRAG_MODE) {
            this.setFrameManipulationStyle(2);
        } else {
            this.setFrameManipulationStyle(1);
        }
    }

    public int getDragMode() {
        if (JCEnvironment.getJavaVersion() >= 130) {
            return super.getDragMode();
        }
        if (this.frameManipulationStyle == 2) {
            return JDesktopPane.LIVE_DRAG_MODE;
        }
        return JDesktopPane.OUTLINE_DRAG_MODE;
    }

    public boolean isConsiderIconsWhenTiling() {
        return this.considerIconsWhenTiling;
    }

    public void setConsiderIconsWhenTiling(boolean bl) {
        this.considerIconsWhenTiling = bl;
    }

    public JToolBar getMDIToolBar() {
        return this.toolbar;
    }

    protected void checkIfMenuOrToolBarsNeeded() {
        JToolBar jToolBar = null;
        JMenuBar jMenuBar = null;
        if (this.isDisplayable()) {
            Component[] componentArray = this.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                JInternalFrame.JDesktopIcon jDesktopIcon;
                JInternalFrame jInternalFrame;
                JCMDIFrame jCMDIFrame = null;
                if (componentArray[n] instanceof JCMDIFrame) {
                    jCMDIFrame = (JCMDIFrame)componentArray[n];
                } else if (componentArray[n] instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = (jDesktopIcon = (JInternalFrame.JDesktopIcon)componentArray[n]).getInternalFrame()) instanceof JCMDIFrame) {
                    jCMDIFrame = (JCMDIFrame)jInternalFrame;
                }
                if (jCMDIFrame != null && jCMDIFrame.isSelected()) {
                    jMenuBar = jCMDIFrame.getMDIMenuBar();
                    jToolBar = jCMDIFrame.getMDIToolBar();
                    break;
                }
                ++n;
            }
            if (jMenuBar == null) {
                jMenuBar = this.menubar;
            }
            if (jToolBar == null) {
                jToolBar = this.toolbar;
            }
            this.setMenuAndToolBarsToRootPane(null, jMenuBar, jToolBar);
        }
    }

    public JToolBar getMDIToolBar(JInternalFrame jInternalFrame) {
        JToolBar jToolBar;
        if (jInternalFrame != null && jInternalFrame instanceof JCMDIFrame && (jToolBar = ((JCMDIFrame)jInternalFrame).getMDIToolBar()) != null) {
            return jToolBar;
        }
        return this.toolbar;
    }

    public void setMDIToolBar(JToolBar jToolBar) {
        this.toolbar = jToolBar;
        this.checkIfMenuOrToolBarsNeeded();
    }

    public JMenuBar getMDIMenuBar() {
        return this.menubar;
    }

    public JMenuBar getMDIMenuBar(JInternalFrame jInternalFrame) {
        JMenuBar jMenuBar;
        if (jInternalFrame != null && jInternalFrame instanceof JCMDIFrame && (jMenuBar = ((JCMDIFrame)jInternalFrame).getMDIMenuBar()) != null) {
            return jMenuBar;
        }
        return this.menubar;
    }

    public void setMDIMenuBar(JMenuBar jMenuBar) {
        this.menubar = jMenuBar;
        this.checkIfMenuOrToolBarsNeeded();
    }

    public void setLayout() {
    }

    public void addNotify() {
        this.selectNextFrame();
        super.addNotify();
        this.checkIfMenuOrToolBarsNeeded();
        this.updateWindowsMenu();
    }

    public JInternalFrame getTopFrame() {
        JInternalFrame[] jInternalFrameArray = this.getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);
        return jInternalFrameArray.length > 0 ? jInternalFrameArray[0] : null;
    }

    public Dimension getPreferredSize() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = JCMDIPane.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, this);
        int n = this.getComponentCount();
        if (jScrollPane == null || n == 0) {
            return this.getMinimumSize();
        }
        Rectangle rectangle = new Rectangle();
        int n2 = 0;
        while (n2 < n) {
            rectangle = rectangle.union(this.getComponent(n2).getBounds());
            ++n2;
        }
        return rectangle.getSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(100, 100);
    }

    protected void updateWindowsMenu() {
        JMenu jMenu = this.getWindowsMenuFromMenuBar();
        if (jMenu != null) {
            this.buildWindowsMenu(jMenu);
        }
    }

    protected JMenuBar getJMenuBar() {
        if (this.currentMenuBar != null) {
            return this.currentMenuBar;
        }
        JMenuBar jMenuBar = null;
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return null;
        }
        this.currentMenuBar = jMenuBar = jRootPane.getJMenuBar();
        return jMenuBar;
    }

    public JMenu getWindowsMenuFromMenuBar() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        MenuElement[] menuElementArray = jMenuBar.getSubElements();
        int n = 0;
        while (n < menuElementArray.length) {
            if (menuElementArray[n] instanceof JCMDIWindowMenu) {
                return (JMenu)menuElementArray[n];
            }
            ++n;
        }
        JCMDIWindowMenu jCMDIWindowMenu = new JCMDIWindowMenu();
        jMenuBar.add(jCMDIWindowMenu);
        return jCMDIWindowMenu;
    }

    protected void buildWindowsMenu(JMenu jMenu) {
        JInternalFrame jInternalFrame;
        if (jMenu.getMenuComponentCount() != 0) {
            jMenu.removeAll();
        }
        int n = this.getOpenInternalFrameCount();
        this.cascadeAction = new CascadeAction();
        JMenuItem jMenuItem = this.cascadeAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        }
        this.maxMinAction = new MaxMinAction();
        jMenuItem = this.maxMinAction.createMenuItem();
        if (this.maximized) {
            jMenuItem.setText(li.getString("ActionUndomax"));
        } else {
            jMenuItem.setText(li.getString("ActionMaximize"));
        }
        this.maxMinItem = jMenuItem;
        jMenu.add(jMenuItem);
        JInternalFrame jInternalFrame2 = jInternalFrame = this.activatingFrame == null ? this.activeFrame : this.activatingFrame;
        if (n == 0 || jInternalFrame != null && !jInternalFrame.isMaximizable()) {
            jMenuItem.setEnabled(false);
        }
        this.tileHorizAction = new TileHAction();
        jMenuItem = this.tileHorizAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        }
        this.tileVertAction = new TileVAction();
        jMenuItem = this.tileVertAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        }
        this.arrangeIconsAction = new ArrangeAction();
        jMenuItem = this.arrangeIconsAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (this.getIconifiedFrameCount() == 0) {
            jMenuItem.setEnabled(false);
        }
        jMenu.add(new JSeparator());
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        int n3 = 0;
        while (n3 < componentArray.length) {
            JInternalFrame jInternalFrame3 = null;
            if (componentArray[n3] instanceof JInternalFrame) {
                jInternalFrame3 = (JInternalFrame)componentArray[n3];
            } else if (componentArray[n3] instanceof JInternalFrame.JDesktopIcon && (jInternalFrame3 = ((JInternalFrame.JDesktopIcon)componentArray[n3]).getInternalFrame()).getParent() != null) {
                jInternalFrame3 = null;
            }
            if (jInternalFrame3 != null && jInternalFrame3.isVisible()) {
                char c = Integer.toString(n3).charAt(0);
                WindowMenuItem windowMenuItem = new WindowMenuItem("" + n2++ + " ", c, (Object)jInternalFrame3);
                if (n2 == 1) {
                    windowMenuItem.setIcon(this.getSelectedIcon());
                } else {
                    windowMenuItem.setIcon(this.getNonSelectedIcon());
                }
                windowMenuItem.addActionListener(this.menuListener);
                jMenu.add(windowMenuItem);
            }
            ++n3;
        }
    }

    protected void moveChildren(Container container, Container container2) {
        Component component;
        if (container instanceof JCMDIFrame) {
            component = ((JCMDIFrame)container).getContentPane();
        } else {
            if (container instanceof RootPaneContainer) {
                container = ((RootPaneContainer)((Object)container)).getContentPane();
            }
            if (container.getComponentCount() < 1) {
                return;
            }
            component = container.getComponent(0);
        }
        if (container2 instanceof JCMDIFrame) {
            ((JCMDIFrame)container2).restoreContainer((Container)component);
        } else {
            if (container2 instanceof RootPaneContainer) {
                container2 = ((RootPaneContainer)((Object)container2)).getContentPane();
            }
            container2.add(component);
        }
        container2.invalidate();
        container2.validate();
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        Object object;
        Frame frame;
        if (this.maximizingFrame != null) {
            return;
        }
        this.activeFrame = jInternalFrame;
        if (this.maximizedFrame == jInternalFrame) {
            return;
        }
        this.maximizingFrame = jInternalFrame;
        if (this.maximizedFrame != null) {
            try {
                this.maximizedFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if ((frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JCMDIPane.class$("java.awt.Frame")) : class$java$awt$Frame, this)) != null && !this.titleIsSaved) {
            this.savedTitle = frame.getTitle();
            this.titleIsSaved = true;
        }
        if (this.maximizedFrame != null && this.maximizedPanel.getComponentCount() != 0) {
            this.moveChildren(this.maximizedPanel, this.maximizedFrame);
        }
        if (jInternalFrame != null) {
            this.moveChildren(jInternalFrame, this.maximizedPanel);
            if (this.maximizedPanel.getParent() == null) {
                object = this.getParent();
                if (object != null && ((Component)object).getParent() != null && ((Component)object).getParent() instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)((Component)object).getParent();
                    jScrollPane.setHorizontalScrollBarPolicy(31);
                    jScrollPane.setVerticalScrollBarPolicy(21);
                    jScrollPane.revalidate();
                }
                this.add(this.maximizedPanel);
            }
            this.maximizedPanel.setBounds(0, 0, this.getVisibleSize().width, this.getVisibleSize().height);
            this.moveToFront(this.maximizedPanel);
        } else if (this.maximizedPanel.getParent() != null) {
            this.remove(this.maximizedPanel);
        }
        if (jInternalFrame == null) {
            // empty if block
        }
        this.maximizedFrame = jInternalFrame;
        if (this.titleIsSaved) {
            object = this.savedTitle == null ? "" : this.savedTitle;
            if (this.maximizedFrame != null) {
                object = (String)object + " - " + this.maximizedFrame.getTitle();
            }
            frame.setTitle((String)object);
        }
        this.checkIfMenuOrToolBarsNeeded();
        this.updateIconsInMenuBar(jInternalFrame);
        if (this.maximizedFrame != null) {
            this.maximizedFrame.grabFocus();
        }
        this.maximizingFrame = null;
    }

    protected void unmaximizeFrame() {
        Container container;
        if (this.maximizedFrame == null) {
            return;
        }
        if (this.maximizedPanel.getParent() != null) {
            container = this.getParent();
            if (container != null && container.getParent() != null && container.getParent() instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container.getParent();
                jScrollPane.setHorizontalScrollBarPolicy(30);
                jScrollPane.setVerticalScrollBarPolicy(20);
                jScrollPane.revalidate();
            }
            this.remove(this.maximizedPanel);
        }
        this.moveChildren(this.maximizedPanel, this.maximizedFrame);
        if (this.maximizedFrame != null) {
            this.maximizedFrame.grabFocus();
        }
        this.maximizedFrame = null;
        container = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JCMDIPane.class$("java.awt.Frame")) : class$java$awt$Frame, this);
        if (container != null && this.titleIsSaved) {
            ((Frame)container).setTitle(this.savedTitle);
        }
    }

    public void unmaximize() {
        this.maximized = false;
        if (this.maximizedFrame != null) {
            try {
                this.maximizedFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.unmaximizeFrame();
        if (this.maxMinItem != null) {
            this.maxMinItem.setText(li.getString("ActionMaximize"));
        }
        this.updateIconsInMenuBar(null);
        this.repaint();
    }

    protected void updateIconsInMenuBar(JInternalFrame jInternalFrame) {
        LayoutButtonBox layoutButtonBox = this.getLayoutButtonBox();
        if (jInternalFrame == null || !this.maximized) {
            Container container = layoutButtonBox.getParent();
            if (container != null) {
                container.remove(layoutButtonBox);
                container.repaint();
            }
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        layoutButtonBox.setMaximizedFrame(jInternalFrame);
        if (layoutButtonBox.getParent() != jMenuBar) {
            jMenuBar.add(layoutButtonBox);
            jMenuBar.validate();
            jMenuBar.repaint();
        }
    }

    public void doLayout() {
        if (this.maximized) {
            this.maximizedPanel.setBounds(0, 0, this.getVisibleSize().width, this.getVisibleSize().height);
        }
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JInternalFrame) {
                // empty if block
            }
            ++n;
        }
        super.doLayout();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        switch (this.initialLayout) {
            case 1: {
                this.tileWindowsHorizontally();
                break;
            }
            case 2: {
                this.tileWindowsVertically();
                break;
            }
            case 3: {
                this.cascadeWindows();
                break;
            }
        }
        this.initialLayout = 0;
    }

    public void setMaximized(boolean bl) {
        if (this.maximized == bl) {
            return;
        }
        if (bl) {
            if (this.activeFrame != null) {
                this.maximize(this.activeFrame);
            } else {
                this.maximized = true;
            }
        } else {
            this.unmaximize();
        }
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void maximize(JInternalFrame jInternalFrame) {
        if (jInternalFrame != null && jInternalFrame.isMaximizable() && jInternalFrame.isVisible()) {
            this.maximized = true;
            this.maximizeFrame(jInternalFrame);
        }
    }

    public void setInitialLayout(int n) {
        this.initialLayout = n;
    }

    protected void setTitleBar() {
        String string;
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JCMDIPane.class$("java.awt.Frame")) : class$java$awt$Frame, this);
        if (frame == null) {
            return;
        }
        if (this.maximized) {
            this.savedTitle = frame.getTitle();
            string = this.savedTitle == null ? "" : this.savedTitle;
            string = string + " - " + this.maximizedFrame.getTitle();
        } else {
            string = this.savedTitle;
        }
        frame.setTitle(string);
    }

    protected LayoutButtonBox getLayoutButtonBox() {
        if (this.layoutButtonBox == null) {
            this.layoutButtonBox = new LayoutButtonBox(new LayoutListener());
        }
        return this.layoutButtonBox;
    }

    public JInternalFrame[] getAllNonIconifiedAndNonPaletteFrames() {
        Object object;
        Vector<Object> vector = new Vector<Object>(this.getComponentCount());
        int n = 0;
        while (n < this.getComponentCount()) {
            if (this.getComponent(n) instanceof JInternalFrame && ((Component)(object = (JInternalFrame)this.getComponent(n))).isVisible() && ((JInternalFrame)object).getLayer() != JLayeredPane.PALETTE_LAYER.intValue()) {
                vector.addElement(object);
            }
            ++n;
        }
        object = new JInternalFrame[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public JInternalFrame.JDesktopIcon[] getAllIconifiedFrames() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>(this.getComponentCount());
        int n = 0;
        while (n < this.getComponentCount()) {
            JInternalFrame.JDesktopIcon jDesktopIcon;
            JInternalFrame jInternalFrame;
            object = this.getComponent(n);
            if (object instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = (jDesktopIcon = (JInternalFrame.JDesktopIcon)object).getInternalFrame()) != null && jInternalFrame.isVisible()) {
                vector.addElement((Object[])object);
            }
            ++n;
        }
        object = new JInternalFrame.JDesktopIcon[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    protected Dimension calcCascadeSize() {
        this.cascadeSize.width = (int)(0.8 * (double)this.getSize().width);
        this.cascadeSize.height = (int)(0.8 * (double)this.getSize().height);
        return this.cascadeSize;
    }

    protected void cascadeReset() {
        this.cascadeX = -1;
        this.cascadeY = -1;
        this.cascadeXStart = 0;
        this.cascadeYStart = 0;
    }

    protected void calcNewCascadePosition(Dimension dimension) {
        if (this.cascadeX < 0 || this.cascadeY < 0) {
            this.cascadeX = this.cascadeXStart;
            this.cascadeY = this.cascadeYStart;
            return;
        }
        int n = this.getVisibleSize().width;
        int n2 = this.getVisibleSize().height;
        this.cascadeX += this.cascadeXIncrement;
        this.cascadeY += this.cascadeYIncrement;
        if (this.cascadeY > n2 - this.cascadeTolerance || this.cascadeX > n - this.cascadeTolerance) {
            this.cascadeXStart += this.cascadeStartIncrement;
            if (this.cascadeXStart > n - this.cascadeTolerance) {
                this.cascadeXStart = 0;
                this.cascadeYStart += this.cascadeStartIncrement;
                if (this.cascadeYStart > n2 - this.cascadeTolerance) {
                    this.cascadeYStart = 0;
                }
            }
            this.cascadeX = this.cascadeXStart;
            this.cascadeY = this.cascadeYStart;
        }
    }

    protected void cascadeFrame(JInternalFrame jInternalFrame) {
        if (!this.isDisplayable()) {
            return;
        }
        Dimension dimension = this.calcCascadeSize();
        this.calcNewCascadePosition(dimension);
        if (jInternalFrame.isResizable()) {
            jInternalFrame.setBounds(this.cascadeX, this.cascadeY, dimension.width, dimension.height);
        } else {
            jInternalFrame.setLocation(this.cascadeX, this.cascadeY);
        }
    }

    protected void cascadeFrameByPreferredSize(JInternalFrame jInternalFrame) {
        Dimension dimension = jInternalFrame.getPreferredSize();
        this.calcNewCascadePosition(dimension);
        if (jInternalFrame.isResizable()) {
            jInternalFrame.setBounds(this.cascadeX, this.cascadeY, dimension.width, dimension.height);
        } else {
            jInternalFrame.setLocation(this.cascadeX, this.cascadeY);
        }
    }

    protected void resizingScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = JCMDIPane.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, this);
        if (jScrollPane != null) {
            this.revalidate();
        }
    }

    protected void sizingToScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = JCMDIPane.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, this);
        if (jScrollPane != null) {
            this.revalidate();
        }
    }

    public void cascadeWindows() {
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.moveIconsToBack(this.getAllIconifiedFrames());
        this.cascadeReset();
        int n = jInternalFrameArray.length - 1;
        while (n >= 0) {
            this.cascadeFrame(jInternalFrameArray[n]);
            --n;
        }
        this.sizingToScrollPane();
    }

    protected Dimension getVisibleSize() {
        Container container = this.getParent();
        if (container != null && container.getParent() instanceof JScrollPane) {
            this.fudge1 = 3;
            this.fudge2 = 1;
            return container.getParent().getSize();
        }
        this.fudge1 = 0;
        this.fudge2 = 0;
        return this.getSize();
    }

    protected void moveIconsToBack(JInternalFrame.JDesktopIcon[] jDesktopIconArray) {
        if (jDesktopIconArray != null) {
            int n = 0;
            while (n < jDesktopIconArray.length) {
                this.moveToBack(jDesktopIconArray[n]);
                ++n;
            }
        }
    }

    protected int getIconsHeight(JInternalFrame.JDesktopIcon[] jDesktopIconArray) {
        int n;
        int n2 = n = this.getVisibleSize().height;
        int n3 = 0;
        while (n3 < jDesktopIconArray.length) {
            Point point = jDesktopIconArray[n3].getLocation();
            n2 = Math.min(n2, (int)point.getY());
            ++n3;
        }
        return n - n2;
    }

    public void tileWindowsHorizontally() {
        int n;
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        int n2 = jInternalFrameArray.length;
        if (n2 == 0) {
            return;
        }
        int n3 = this.getVisibleSize().width - this.fudge1;
        int n4 = this.getVisibleSize().height - this.fudge2;
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        if (this.considerIconsWhenTiling) {
            this.arrangeIcons();
            n = this.getIconsHeight(jDesktopIconArray);
            if (n4 > n) {
                n4 -= n;
            }
        }
        this.moveIconsToBack(jDesktopIconArray);
        n = n4 / n2;
        int n5 = n4 % n2;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            int n8;
            int n9 = n8 = n7 < n5 ? n + 1 : n;
            if (jInternalFrameArray[n7].isResizable()) {
                jInternalFrameArray[n7].setBounds(0, n6, n3, n8);
            } else {
                jInternalFrameArray[n7].setLocation(0, n6);
            }
            n6 += n8;
            ++n7;
        }
        this.repaint();
        this.sizingToScrollPane();
    }

    public void tileWindowsVertically() {
        int n;
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        int n2 = jInternalFrameArray.length;
        if (n2 == 0) {
            return;
        }
        int n3 = this.getVisibleSize().width - this.fudge2;
        int n4 = this.getVisibleSize().height - this.fudge1;
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        if (this.considerIconsWhenTiling) {
            this.arrangeIcons();
            n = this.getIconsHeight(jDesktopIconArray);
            if (n4 > n) {
                n4 -= n;
            }
        }
        this.moveIconsToBack(jDesktopIconArray);
        n = n3 / n2;
        int n5 = n3 % n2;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            int n8;
            int n9 = n8 = n7 < n5 ? n + 1 : n;
            if (jInternalFrameArray[n7].isResizable()) {
                jInternalFrameArray[n7].setBounds(n6, 0, n8, n4);
            } else {
                jInternalFrameArray[n7].setLocation(n6, 0);
            }
            n6 += n8;
            ++n7;
        }
        this.sizingToScrollPane();
        this.repaint();
    }

    public void arrangeIcons() {
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        if (jDesktopIconArray.length == 0) {
            return;
        }
        int n = this.getVisibleSize().width;
        int n2 = this.getVisibleSize().height;
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        while (n6 < jDesktopIconArray.length) {
            int n7 = jDesktopIconArray[n6].getWidth();
            int n8 = jDesktopIconArray[n6].getHeight();
            if (n3 + n7 > n && n5 > 0) {
                n3 = 0;
                n4 -= n5;
                n5 = 0;
            }
            n5 = Math.max(n5, n8);
            jDesktopIconArray[n6].setBounds(n3, n4 - n8, n7, n8);
            n3 += n7;
            ++n6;
        }
        this.repaint();
    }

    protected int getOpenInternalFrameCount() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = 0;
        while (n2 < componentArray.length) {
            JInternalFrame jInternalFrame;
            if (componentArray[n2] instanceof JInternalFrame && !(jInternalFrame = (JInternalFrame)componentArray[n2]).isClosed() && jInternalFrame.isVisible() && jInternalFrame.getLayer() != JLayeredPane.PALETTE_LAYER.intValue()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected int getIconifiedFrameCount() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = 0;
        while (n2 < componentArray.length) {
            JInternalFrame.JDesktopIcon jDesktopIcon;
            JInternalFrame jInternalFrame;
            if (componentArray[n2] instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = (jDesktopIcon = (JInternalFrame.JDesktopIcon)componentArray[n2]).getInternalFrame()) != null && jInternalFrame.isVisible()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected void selectNextFrame() {
        if (this.activatingFrame != null) {
            return;
        }
        Component[] componentArray = this.getComponents();
        JInternalFrame jInternalFrame = null;
        if (componentArray.length != 0) {
            int n = 0;
            while (n < componentArray.length) {
                JInternalFrame jInternalFrame2;
                if (componentArray[n] instanceof JInternalFrame && (jInternalFrame2 = (JInternalFrame)componentArray[n]).isMaximizable() && jInternalFrame2.isVisible()) {
                    jInternalFrame = (JInternalFrame)componentArray[n];
                    break;
                }
                ++n;
            }
        } else {
            this.activateFrame(null);
        }
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            this.setMenuAndToolBarsToRootPane(null, this.menubar, this.toolbar);
        }
    }

    protected void setMenuAndToolBarsToRootPane(JInternalFrame jInternalFrame, JMenuBar jMenuBar, JToolBar jToolBar) {
        if (jMenuBar == null && jToolBar == null) {
            return;
        }
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return;
        }
        if (jMenuBar != null) {
            this.currentMenuBar = jMenuBar;
            this.updateWindowsMenu();
            this.updateIconsInMenuBar(jInternalFrame);
            jRootPane.setJMenuBar(jMenuBar);
        }
        if (jToolBar != null && jToolBar != this.lastToolBarSetToRoot) {
            Container container;
            Container container2;
            if (this.lastToolBarSetToRoot != null && (container2 = SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = JCMDIPane.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, jRootPane)) == (container = SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = JCMDIPane.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this.lastToolBarSetToRoot))) {
                this.lastToolBarSetToRoot.getParent().remove(this.lastToolBarSetToRoot);
            }
            jRootPane.getContentPane().add((Component)jToolBar, "North");
            this.lastToolBarSetToRoot = jToolBar;
        }
        jRootPane.invalidate();
        jRootPane.validate();
        jRootPane.repaint();
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        if (this.activeFrame == jInternalFrame) {
            return;
        }
        this.activatingFrame = jInternalFrame;
        if (jInternalFrame instanceof JCMDIFrame) {
            JCMDIFrame jCMDIFrame = (JCMDIFrame)jInternalFrame;
            this.setMenuAndToolBarsToRootPane(jCMDIFrame, this.getMDIMenuBar(jCMDIFrame), this.getMDIToolBar(jCMDIFrame));
        }
        if (this.maximized) {
            this.updateIconsInMenuBar(jInternalFrame);
        }
        this.updateWindowsMenu();
        this.activeFrame = jInternalFrame;
        this.activatingFrame = null;
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        this.activeFrame = null;
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame == null) {
            return;
        }
        int n = this.getOpenInternalFrameCount();
        if (jInternalFrame != this.maximizedFrame) {
            JInternalFrame jInternalFrame2;
            JInternalFrame jInternalFrame3 = jInternalFrame2 = this.activatingFrame == null ? this.activeFrame : this.activatingFrame;
            if (n == 0 && jInternalFrame2 == null) {
                this.checkIfMenuOrToolBarsNeeded();
            }
            return;
        }
        if (n < 1) {
            this.maximizeFrame(null);
        } else {
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] != jInternalFrame && componentArray[n2] instanceof JInternalFrame) {
                    try {
                        JInternalFrame jInternalFrame4 = (JInternalFrame)componentArray[n2];
                        if (jInternalFrame4.isVisible()) {
                            jInternalFrame4.setSelected(true);
                            this.updateIconsInMenuBar(jInternalFrame4);
                            if (!jInternalFrame4.isMaximizable()) break;
                            this.maximizeFrame(jInternalFrame4);
                            break;
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        this.repaint();
    }

    public void setSelectedIcon(Icon icon) {
        this.selectedIcon = icon;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setNonSelectedIcon(Icon icon) {
        this.nonSelectedIcon = icon;
    }

    public Icon getNonSelectedIcon() {
        return this.nonSelectedIcon;
    }

    protected static Icon makeImage(String[] stringArray) {
        JCIconCreator jCIconCreator = new JCIconCreator(13, 13);
        jCIconCreator.setColor('g', Color.green);
        jCIconCreator.setColor('l', Color.blue);
        jCIconCreator.setColor('X', Color.lightGray);
        jCIconCreator.setColor('w', Color.white);
        jCIconCreator.setColor('b', Color.black);
        jCIconCreator.setColor('r', new Color(220, 50, 0));
        jCIconCreator.setPixels(stringArray);
        ImageIcon imageIcon = jCIconCreator.getIcon();
        jCIconCreator.clear();
        return imageIcon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MDIDesktopManager
    implements DesktopManager,
    Serializable {
        protected DesktopManager manager;
        final int INVALID_X = -999;
        private Rectangle rect = new Rectangle(-999, 0, 0, 0);
        boolean dragging = false;

        public MDIDesktopManager(DesktopManager desktopManager) {
            this.setDesktopManager(desktopManager);
        }

        public DesktopManager getDesktopManager() {
            return this.manager;
        }

        public void setDesktopManager(DesktopManager desktopManager) {
            this.manager = desktopManager;
        }

        public void openFrame(JInternalFrame jInternalFrame) {
            this.manager.openFrame(jInternalFrame);
        }

        public void closeFrame(JInternalFrame jInternalFrame) {
            JCMDIPane.this.closeFrame(jInternalFrame);
            this.manager.closeFrame(jInternalFrame);
        }

        public void maximizeFrame(JInternalFrame jInternalFrame) {
        }

        public void minimizeFrame(JInternalFrame jInternalFrame) {
            this.manager.minimizeFrame(jInternalFrame);
        }

        public void iconifyFrame(JInternalFrame jInternalFrame) {
            this.manager.iconifyFrame(jInternalFrame);
        }

        public void deiconifyFrame(JInternalFrame jInternalFrame) {
            this.manager.deiconifyFrame(jInternalFrame);
        }

        public void activateFrame(JInternalFrame jInternalFrame) {
            if (jInternalFrame != null && !jInternalFrame.isVisible()) {
                return;
            }
            JCMDIPane.this.activateFrame(jInternalFrame);
            this.manager.activateFrame(jInternalFrame);
            if (JCMDIPane.this.maximized && jInternalFrame != null && jInternalFrame.isMaximizable() && jInternalFrame != JCMDIPane.this.maximizingFrame) {
                try {
                    jInternalFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void deactivateFrame(JInternalFrame jInternalFrame) {
            JCMDIPane.this.deactivateFrame(jInternalFrame);
            this.manager.deactivateFrame(jInternalFrame);
        }

        private void drawRect(boolean bl, JComponent jComponent, int n, int n2, int n3, int n4) {
            JDesktopPane jDesktopPane;
            if (!bl) {
                this.rect.setBounds(n, n2, n3, n4);
            } else if (this.rect.x == -999) {
                return;
            }
            if (jComponent instanceof JInternalFrame) {
                jDesktopPane = ((JInternalFrame)jComponent).getDesktopPane();
            } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                jDesktopPane = ((JInternalFrame.JDesktopIcon)jComponent).getDesktopPane();
            } else {
                return;
            }
            Graphics graphics = jDesktopPane.getGraphics();
            graphics.setXORMode(jDesktopPane.getBackground());
            graphics.drawRect(this.rect.x, this.rect.y, this.rect.width - 1, this.rect.height - 1);
            graphics.dispose();
        }

        private void setBounds(JComponent jComponent, int n, int n2, int n3, int n4) {
            this.drawRect(true, jComponent, 0, 0, 0, 0);
            this.drawRect(false, jComponent, n, n2, n3, n4);
        }

        public void beginDraggingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.beginDraggingFrame(jComponent);
            }
        }

        public void dragFrame(JComponent jComponent, int n, int n2) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.dragFrame(jComponent, n, n2);
            } else {
                this.dragging = true;
                this.setBounds(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
            }
        }

        public void endDraggingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.endDraggingFrame(jComponent);
            } else if (this.dragging) {
                this.drawRect(true, jComponent, 0, 0, 0, 0);
                this.dragging = false;
                this.setBoundsForFrame(jComponent, this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
            JCMDIPane.this.resizingScrollPane();
        }

        public void beginResizingFrame(JComponent jComponent, int n) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.beginResizingFrame(jComponent, n);
            }
        }

        public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.resizeFrame(jComponent, n, n2, n3, n4);
            } else {
                this.dragging = true;
                this.setBounds(jComponent, n, n2, n3, n4);
            }
        }

        public void endResizingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.endResizingFrame(jComponent);
            } else if (this.dragging) {
                this.drawRect(true, jComponent, 0, 0, 0, 0);
                this.dragging = false;
                this.setBoundsForFrame(jComponent, this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
        }

        public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            this.manager.setBoundsForFrame(jComponent, n, n2, n3, n4);
            this.rect.x = -999;
            if (JCMDIPane.this.frameManipulationStyle == 1) {
                return;
            }
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane == null ? (class$javax$swing$JScrollPane = JCMDIPane.class$("javax.swing.JScrollPane")) : class$javax$swing$JScrollPane, jComponent);
            if (jScrollPane != null) {
                jComponent.revalidate();
            }
        }
    }

    protected class LayoutListener
    implements ActionListener,
    Serializable {
        protected LayoutListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = JCMDIPane.this.maximizedFrame;
            LayoutButton layoutButton = (LayoutButton)actionEvent.getSource();
            switch (layoutButton.getControlType()) {
                case 3: {
                    int n;
                    if (jInternalFrame == null || !jInternalFrame.isClosable() || (n = jInternalFrame.getDefaultCloseOperation()) == 0) break;
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 1: {
                    JCMDIPane.this.unmaximize();
                    break;
                }
                case 2: {
                    JCMDIPane.this.unmaximize();
                    if (jInternalFrame == null || !jInternalFrame.isIconifiable()) break;
                    try {
                        jInternalFrame.setIcon(true);
                        break;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class ArrangeAction
    extends JCAction
    implements Serializable {
        public ArrangeAction() {
            super(li.getString("ActionArrange"), li.getMnemonic("ActionArrangeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCMDIPane.this.arrangeIcons();
        }
    }

    protected class TileVAction
    extends JCAction
    implements Serializable {
        public TileVAction() {
            super(li.getString("ActionTilev"), li.getMnemonic("ActionTilevMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.tileWindowsVertically();
        }
    }

    protected class TileHAction
    extends JCAction
    implements Serializable {
        public TileHAction() {
            super(li.getString("ActionTileh"), li.getMnemonic("ActionTilehMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.tileWindowsHorizontally();
        }
    }

    protected class CascadeAction
    extends JCAction
    implements Serializable {
        public CascadeAction() {
            super(li.getString("ActionCascade"), li.getMnemonic("ActionCascadeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.cascadeWindows();
        }
    }

    protected class MaxMinAction
    extends JCAction
    implements Serializable {
        public MaxMinAction() {
            super(li.getString("ActionMaximize"), li.getMnemonic("ActionMaximizeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            } else if (JCMDIPane.this.activeFrame != null) {
                JCMDIPane.this.maximize(JCMDIPane.this.activeFrame);
            }
        }
    }

    protected class WindowsMenuListener
    implements ActionListener,
    Serializable {
        protected WindowsMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)((UserMenuItem)actionEvent.getSource()).getUserData();
            if (JCMDIPane.this.maximized && jInternalFrame.isMaximizable()) {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                JCMDIPane.this.maximizeFrame(jInternalFrame);
            } else {
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected class FrameListener
    implements InternalFrameListener,
    VetoableChangeListener,
    Serializable {
        protected FrameListener() {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            JCMDIPane.this.updateWindowsMenu();
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            JCMDIPane.this.updateWindowsMenu();
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            ((JInternalFrame)internalFrameEvent.getSource()).moveToFront();
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            if (jInternalFrame != null && !jInternalFrame.isVisible()) {
                return;
            }
            JCMDIPane.this.activateFrame(jInternalFrame);
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Object object;
            if (propertyChangeEvent.getPropertyName().equals("maximum") && (object = propertyChangeEvent.getSource()) instanceof JInternalFrame) {
                JCMDIPane.this.maximize((JInternalFrame)object);
                throw new PropertyVetoException("MDI Override", propertyChangeEvent);
            }
        }
    }

    class Listener
    implements ContainerListener,
    Serializable {
        Listener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)containerEvent.getChild();
                jInternalFrame.addInternalFrameListener(JCMDIPane.this.frameListener);
                jInternalFrame.addVetoableChangeListener(JCMDIPane.this.frameListener);
                DesktopManager desktopManager = jInternalFrame.getDesktopPane().getDesktopManager();
                if (!(desktopManager instanceof MDIDesktopManager)) {
                    jInternalFrame.getDesktopPane().setDesktopManager(new MDIDesktopManager(desktopManager));
                }
                Rectangle rectangle = jInternalFrame.getBounds();
                if (rectangle.x == 0 && rectangle.y == 0 && rectangle.width == 0 && rectangle.height == 0) {
                    JCMDIPane.this.cascadeFrameByPreferredSize(jInternalFrame);
                }
                if (JCMDIPane.this.isDisplayable() && jInternalFrame.isVisible()) {
                    try {
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
            JCMDIPane.this.updateWindowsMenu();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            if (containerEvent.getChild() instanceof JInternalFrame) {
                JCMDIPane.this.closeFrame((JInternalFrame)containerEvent.getChild());
                JCMDIPane.this.selectNextFrame();
            }
            JCMDIPane.this.updateWindowsMenu();
        }
    }
}

