/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.ttf;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FontFileReader {
    private int fsize;
    private int current;
    private byte[] file;

    private void init(InputStream inputStream, int n, int n2) throws IOException {
        this.fsize = 0;
        this.current = 0;
        int n3 = n;
        this.file = new byte[n];
        int n4 = inputStream.read(this.file, 0, n);
        if (n4 > 0) {
            this.fsize += n4;
        }
        while (n4 > 0) {
            if (n4 == n3) {
                byte[] byArray = new byte[this.file.length + n2];
                System.arraycopy(this.file, 0, byArray, 0, this.file.length);
                n3 = n2;
                n4 = inputStream.read(byArray, this.file.length, n3);
                if (n4 > 0) {
                    this.fsize += n4;
                }
                this.file = byArray;
                continue;
            }
            if (n4 >= n3 || (n4 = inputStream.read(this.file, this.fsize, n3 -= n4)) <= 0) continue;
            this.fsize += n4;
        }
    }

    public FontFileReader(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        this.init(fileInputStream, (int)(file.length() + 1L), (int)(file.length() / 10L));
        fileInputStream.close();
    }

    public FontFileReader(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public FontFileReader(InputStream inputStream, int n) throws IOException {
        if (n < 0) {
            n = 50000;
        }
        this.init(inputStream, n + 1, n / 10);
    }

    public FontFileReader(byte[] byArray) throws IOException {
        this.file = byArray;
        this.fsize = byArray.length;
        this.current = 0;
    }

    public void seek_set(long l) throws IOException {
        if (l > (long)this.fsize || l < 0L) {
            throw new EOFException("Reached EOF, file size=" + this.fsize + " offset=" + l);
        }
        this.current = (int)l;
    }

    public void seek_add(long l) throws IOException {
        this.seek_set((long)this.current + l);
    }

    public void skip(long l) throws IOException {
        this.seek_add(l);
    }

    public int getCurrentPos() {
        return this.current;
    }

    public int getFileSize() {
        return this.fsize;
    }

    public byte read() throws IOException {
        if (this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte by = this.file[this.current++];
        return by;
    }

    public final byte readTTFByte() throws IOException {
        return this.read();
    }

    public final int readTTFUByte() throws IOException {
        byte by = this.read();
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    public final short readTTFShort() throws IOException {
        int n = (this.readTTFUByte() << 8) + this.readTTFUByte();
        short s = (short)n;
        return s;
    }

    public final int readTTFUShort() throws IOException {
        int n = (this.readTTFUByte() << 8) + this.readTTFUByte();
        return n;
    }

    public final void writeTTFUShort(int n, int n2) throws IOException {
        if (n + 2 > this.fsize) {
            throw new EOFException("Reached EOF");
        }
        byte by = (byte)(n2 >> 8 & 0xFF);
        byte by2 = (byte)(n2 & 0xFF);
        this.file[n] = by;
        this.file[n + 1] = by2;
    }

    public final short readTTFShort(long l) throws IOException {
        long l2 = this.getCurrentPos();
        this.seek_set(l);
        short s = this.readTTFShort();
        this.seek_set(l2);
        return s;
    }

    public final int readTTFUShort(long l) throws IOException {
        long l2 = this.getCurrentPos();
        this.seek_set(l);
        int n = this.readTTFUShort();
        this.seek_set(l2);
        return n;
    }

    public final int readTTFLong() throws IOException {
        long l = this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        return (int)l;
    }

    public final long readTTFULong() throws IOException {
        long l = this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        l = (l << 8) + (long)this.readTTFUByte();
        return l;
    }

    public final double readTTFFixedDecimal() throws IOException {
        short s = this.readTTFShort();
        int n = this.readTTFUShort();
        double d = (double)s + (double)n / 65536.0;
        return d;
    }

    public final String readTTFString() throws IOException {
        return this.readTTFString("ISO-8859-1");
    }

    public final String readTTFString(String string) throws IOException {
        int n = this.current;
        while (this.file[n++] != 0) {
            if (n <= this.fsize) continue;
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n - this.current];
        System.arraycopy(this.file, this.current, byArray, 0, n - this.current);
        return new String(byArray, string);
    }

    public final String readTTFString(int n) throws IOException {
        return this.readTTFString(n, "ISO-8859-1");
    }

    public final String readTTFString(int n, String string) throws IOException {
        if (n + this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.file, this.current, byArray, 0, n);
        this.current += n;
        return new String(byArray, string);
    }

    public byte[] readBytes(int n) throws IOException {
        if (this.current + n > this.fsize) {
            throw new IOException("Reached EOF");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.file, this.current, byArray, 0, n);
        this.current += n;
        return byArray;
    }

    public byte[] getBytes(int n, int n2) throws IOException {
        if (n + n2 > this.fsize) {
            throw new IOException("Reached EOF");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.file, n, byArray, 0, n2);
        return byArray;
    }
}

