/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.FontBase;
import com.klg.jclass.page.FontMetricsBase;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.page.render.Splitable;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.List;
import java.util.Vector;

public class StringRender
extends Render
implements Splitable,
Cloneable {
    protected String text;
    protected String fullText;
    protected int textStart;
    protected int textEnd;
    protected JCTextStyle style;
    protected Graphics2D saved_gc;
    protected int macroFlags;
    protected JCUnit.Measure leadingSpace;
    protected JCUnit.Measure trailingSpace;
    protected int splitIndex;
    protected JCUnit.Measure splitDistance;

    public StringRender() {
        this.style = null;
        this.text = null;
        this.fullText = null;
        this.textStart = -1;
        this.textEnd = -1;
        this.origin = new JCUnit.Point(JCUnit.POINTS);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS);
    }

    public StringRender(Graphics2D graphics2D, String string, JCTextStyle jCTextStyle) {
        this.style = jCTextStyle;
        this.text = string;
        this.fullText = string;
        this.textStart = 0;
        this.textEnd = string.length();
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, jCTextStyle);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, string, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.origin = new JCUnit.Point(JCUnit.POINTS);
    }

    public StringRender(Graphics2D graphics2D, String string, int n, int n2, JCTextStyle jCTextStyle) {
        this.style = jCTextStyle;
        this.text = string.substring(n, n2);
        this.fullText = string;
        this.textStart = n;
        this.textEnd = n2;
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, jCTextStyle);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.origin = new JCUnit.Point(JCUnit.POINTS);
    }

    public String getText() {
        return this.text;
    }

    public void setText(Graphics2D graphics2D, String string) {
        this.text = string;
        this.fullText = string;
        this.textStart = 0;
        this.textEnd = string.length();
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, string, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setText(Graphics2D graphics2D, String string, int n, int n2) {
        this.fullText = string;
        this.text = string.substring(n, n2);
        this.textStart = n;
        this.textEnd = n2;
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, string, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String string) {
        this.fullText = string;
        int n = this.fullText.indexOf(this.text);
        if (n != -1) {
            this.textStart = n;
            this.textEnd = n + this.text.length();
        }
    }

    public int getStartIndex() {
        return this.textStart;
    }

    public int getEndIndex() {
        return this.textEnd;
    }

    public JCTextStyle getStyle() {
        return this.style;
    }

    public void setStyle(Graphics2D graphics2D, JCTextStyle jCTextStyle) {
        this.style = jCTextStyle;
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, jCTextStyle);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public int getMacroFlags() {
        return this.macroFlags;
    }

    protected JCUnit.Measure getLeadingSpace() {
        return this.leadingSpace;
    }

    protected JCUnit.Measure getTrailingSpace() {
        return this.trailingSpace;
    }

    public boolean isAtomic() {
        return false;
    }

    public JCUnit.Measure getTrimWidth(Graphics2D graphics2D) {
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        int n = this.text.length();
        while (n > 0 && Character.isWhitespace(this.text.charAt(n - 1))) {
            --n;
        }
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text.substring(0, n), graphics2D);
        return new JCUnit.Measure(JCUnit.POINTS, rectangle2D.getWidth());
    }

    /*
     * Unable to fully structure code
     */
    public Render splitBefore(Graphics2D var1_1, JCUnit.Measure var2_2) {
        block9: {
            var5_3 = 0;
            var6_4 = var2_2.getAs(JCUnit.POINTS);
            var3_5 = (int)(var6_4 / this.bounds.getWidth().getAs(JCUnit.POINTS) * (double)this.text.length());
            var8_6 = BreakIterator.getLineInstance();
            var8_6.setText(this.text);
            this.saved_gc = var1_1;
            var9_7 = this.getFontMetrics(var1_1, this.style);
            var10_8 = FontMetricsBase.getStringBounds(var9_7, this.text.substring(0, var3_5), var1_1);
            if (!(var10_8.getWidth() <= var6_4)) ** GOTO lbl34
            while (var3_5 > 0 && !Character.isWhitespace(this.text.charAt(var3_5 - 1))) {
                --var3_5;
            }
            var4_9 = var3_5;
            while (var10_8.getWidth() < var6_4) {
                var4_9 = var3_5;
                try {
                    var5_3 = var3_5 = var8_6.following(var4_9);
                    if (true) ** GOTO lbl24
                }
                catch (IllegalArgumentException var12_10) {
                    var5_3 = var3_5 = var4_9;
                    break;
                }
                do {
                    --var5_3;
lbl24:
                    // 2 sources

                } while (var5_3 > 0 && Character.isWhitespace(this.text.charAt(var5_3 - 1)));
                var10_8 = FontMetricsBase.getStringBounds(var9_7, this.text.substring(0, var5_3), var1_1);
            }
            var3_5 = var4_9;
            break block9;
lbl-1000:
            // 1 sources

            {
                var3_5 = var8_6.preceding(var3_5);
                while (var3_5 > 0 && Character.isWhitespace(this.text.charAt(var3_5 - 1))) {
                    --var3_5;
                }
                var10_8 = FontMetricsBase.getStringBounds(var9_7, this.text.substring(0, var3_5), var1_1);
lbl34:
                // 2 sources

                ** while (var10_8.getWidth() > var6_4)
            }
        }
        this.splitIndex = var3_5;
        this.splitDistance = var2_2;
        var5_3 = var3_5;
        while (var5_3 > 0 && Character.isWhitespace(this.text.charAt(var5_3 - 1))) {
            --var5_3;
        }
        var11_12 = new StringRender(var1_1, this.text, 0, var5_3, this.style);
        if (var5_3 == 0 && var3_5 != 0) {
            var12_11 = var11_12.getSize();
            var12_11.setWidth(new JCUnit.Measure(JCUnit.POINTS, 0.01));
            var11_12.setSize(var12_11);
        }
        return var11_12;
    }

    public Render splitAfter(Graphics2D graphics2D, JCUnit.Measure measure) {
        if (!measure.equals(this.splitDistance)) {
            this.splitBefore(graphics2D, measure);
        }
        this.fullText = this.text;
        this.textStart = this.splitIndex;
        this.textEnd = this.text.length();
        while (this.splitIndex < this.textEnd && Character.isWhitespace(this.text.charAt(this.splitIndex))) {
            ++this.splitIndex;
        }
        this.text = this.text.substring(this.splitIndex);
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public Render forceSplit(Graphics2D var1_1, JCUnit.Measure var2_2) {
        block3: {
            var4_3 = var2_2.getAs(JCUnit.POINTS);
            var3_4 = (int)(var4_3 / this.bounds.getWidth().getAs(JCUnit.POINTS) * (double)this.text.length());
            this.saved_gc = var1_1;
            var6_5 = this.getFontMetrics(var1_1, this.style);
            var7_6 = FontMetricsBase.getStringBounds(var6_5, this.text.substring(0, var3_4), var1_1);
            if (!(var7_6.getWidth() <= var4_3)) ** GOTO lbl13
            while (var3_4 < this.text.length() && var7_6.getWidth() <= var4_3) {
                var7_6 = FontMetricsBase.getStringBounds(var6_5, this.text.substring(0, ++var3_4), var1_1);
            }
            --var3_4;
            break block3;
lbl-1000:
            // 1 sources

            {
                var7_6 = FontMetricsBase.getStringBounds(var6_5, this.text.substring(0, --var3_4), var1_1);
lbl13:
                // 2 sources

                ** while (var3_4 > 0 && var7_6.getWidth() > var4_3)
            }
        }
        if (var3_4 == 0) {
            ++var3_4;
        }
        this.splitIndex = var3_4;
        this.splitDistance = var2_2;
        var8_7 = new StringRender(var1_1, this.text, 0, var3_4, this.style);
        return var8_7;
    }

    public void unsplit(Graphics2D graphics2D, Render render) {
        StringRender stringRender = (StringRender)render;
        int n = stringRender.getStartIndex();
        if (n < this.textEnd) {
            throw new IllegalArgumentException("Strings do not adjoin");
        }
        int n2 = this.textEnd;
        while (n2 < n) {
            if (!Character.isWhitespace(this.fullText.charAt(n2))) {
                throw new IllegalArgumentException("Strings do not adjoin");
            }
            ++n2;
        }
        this.text = this.fullText.substring(this.textStart, stringRender.getEndIndex());
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void trimTrailingWhitespace() {
        int n = this.text.length() - 1;
        while (n >= 0 && Character.isWhitespace(this.text.charAt(n))) {
            --this.textEnd;
            --n;
        }
        if (n < 0) {
            this.textEnd = 0;
            this.text = this.fullText.substring(this.textStart, this.textEnd);
            this.bounds.setWidth(new JCUnit.Measure(JCUnit.POINTS, 0.05));
            return;
        }
        if (n < this.text.length() - 1) {
            this.text = this.fullText.substring(this.textStart, this.textEnd);
            FontMetrics fontMetrics = this.getFontMetrics(this.saved_gc, this.style);
            Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, this.saved_gc);
            this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    public List splitIntoWords() {
        StringRender stringRender;
        JCUnit.Point point;
        int n;
        boolean bl = false;
        Vector<StringRender> vector = new Vector<StringRender>();
        FontMetrics fontMetrics = this.getFontMetrics(this.saved_gc, this.style);
        int n2 = n = this.text.length();
        int n3 = n - 1;
        while (n3 >= 0) {
            if (Character.isWhitespace(this.text.charAt(n3))) {
                if (bl) {
                    Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text.substring(0, n3 + 1), this.saved_gc);
                    JCUnit.Measure measure = this.origin.getX();
                    measure.add(new JCUnit.Measure(JCUnit.POINTS, rectangle2D.getWidth()));
                    point = (JCUnit.Point)this.origin.clone();
                    point.setX(measure);
                    stringRender = new StringRender(this.saved_gc, this.text, n3 + 1, n2, this.style);
                    stringRender.setLocation(point);
                    vector.add(stringRender);
                    bl = false;
                }
            } else if (!bl) {
                bl = true;
                n2 = n3 + 1;
            }
            --n3;
        }
        if (bl) {
            point = (JCUnit.Point)this.origin.clone();
            stringRender = new StringRender(this.saved_gc, this.text, 0, n2, this.style);
            stringRender.setLocation(point);
            vector.add(stringRender);
        }
        return vector;
    }

    public boolean hasDecimal() {
        return this.text.indexOf(".") != -1;
    }

    public JCUnit.Measure getDecimalPosition() {
        int n = this.text.indexOf(".");
        if (n == -1) {
            return new JCUnit.Measure(JCUnit.POINTS, -1.0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.saved_gc, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text.substring(0, n), this.saved_gc);
        JCUnit.Measure measure = new JCUnit.Measure(JCUnit.POINTS, rectangle2D.getWidth());
        rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text.substring(0, n + 1), this.saved_gc);
        measure.add(new JCUnit.Measure(JCUnit.POINTS, rectangle2D.getWidth()));
        measure.divide(2.0);
        return measure;
    }

    public void draw(Graphics2D graphics2D) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        float f = (float)JCUnit.getAsPoints(this.origin.units, this.origin.x);
        float f2 = (float)JCUnit.getAsPoints(this.origin.units, this.origin.y);
        AttributedString attributedString = new AttributedString(this.text);
        int n = this.text.length();
        Font font = this.style.getFont();
        int n2 = this.style.getBaselineOffset();
        float f3 = (float)this.style.getPointSize();
        if (n2 == 2 || n2 == 3) {
            f3 *= (float)this.style.getSubscriptRatio();
        }
        font = FontBase.deriveFont(font, f3);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, n);
        if (this.style.getUnderlining() == 2) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 0, n);
        }
        graphics2D.setColor(this.style.getColor());
        graphics2D.drawString(attributedString.getIterator(), f, f2);
    }

    public Object clone() {
        StringRender stringRender = (StringRender)super.clone();
        stringRender.text = new String(this.text);
        stringRender.fullText = new String(this.fullText);
        return stringRender;
    }

    private FontMetrics getFontMetrics(Graphics2D graphics2D, JCTextStyle jCTextStyle) {
        FontMetrics fontMetrics;
        Font font = jCTextStyle.getFont();
        if (jCTextStyle.getBaselineOffset() == 2 || jCTextStyle.getBaselineOffset() == 3) {
            double d = (double)FontBase.getSize2D(font) * jCTextStyle.getSubscriptRatio();
            Font font2 = FontBase.deriveFont(font, (float)d);
            fontMetrics = graphics2D.getFontMetrics(font2);
        } else {
            fontMetrics = graphics2D.getFontMetrics(font);
        }
        return fontMetrics;
    }

    public String toString() {
        return "StringRender: " + this.text;
    }
}

