/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.render.Embedable;
import com.klg.jclass.page.render.Floatable;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.util.ServerRenderable;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageRender
extends Render
implements Floatable,
Embedable,
ImageObserver,
Cloneable {
    protected Object image;
    protected int horizontalAlignment;
    protected int verticalAlignment;
    protected boolean fillBackground;
    protected boolean scaleImage;
    private int imageID;
    private static ImComponent imageComponent = new ImComponent();
    private static MediaTracker tracker = new MediaTracker(imageComponent);
    private static int nextImageID = 0;

    public ImageRender() {
        this(null, null, 4);
    }

    public ImageRender(Object object) {
        this(object, null, 4);
    }

    public ImageRender(Object object, JCUnit.Dimension dimension) {
        this(object, dimension, 4);
    }

    public ImageRender(Object object, int n) {
        this(object, null, n);
    }

    public ImageRender(Object object, JCUnit.Dimension dimension, int n) {
        this.image = object;
        this.bounds.assign(dimension);
        this.horizontalAlignment = n;
        this.verticalAlignment = 3;
        this.scaleImage = false;
        this.imageID = nextImageID++;
    }

    public Object getImage() {
        return this.image;
    }

    public void setImage(Object object) {
        this.image = object;
    }

    public int getAlignment() {
        return this.horizontalAlignment;
    }

    public void setAlignment(int n) {
        if (n <= 0 || n > 5) {
            throw new IllegalArgumentException("Unrecognised horizontal alignment");
        }
        this.horizontalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n <= 0 || n > 7) {
            throw new IllegalArgumentException("Unrecognised vertical alignment");
        }
        this.verticalAlignment = n;
    }

    public boolean isFilled() {
        return this.fillBackground;
    }

    public void setFilled(boolean bl) {
        this.fillBackground = bl;
    }

    public boolean isScaleImage() {
        return this.scaleImage;
    }

    public void setScaleImage(boolean bl) {
        this.scaleImage = bl;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        if (graphics2D instanceof Markup) {
            return;
        }
        double d = JCUnit.getAsPoints(this.origin.units, this.origin.x);
        double d2 = JCUnit.getAsPoints(this.origin.units, this.origin.y);
        double d3 = JCUnit.getAsPoints(this.bounds.units, this.bounds.width);
        double d4 = JCUnit.getAsPoints(this.bounds.units, this.bounds.height);
        if (this.image instanceof EPSImage) {
            graphics2D.drawImage((Image)this.image, (int)d, (int)d2, (int)d3, (int)d4, this);
        } else if (this.image instanceof Image || this.image instanceof Icon) {
            Image image = null;
            if (this.image instanceof Image) {
                image = (Image)this.image;
            } else if (this.image instanceof ImageIcon) {
                image = ((ImageIcon)this.image).getImage();
            } else {
                throw new IllegalArgumentException("Unknown Icon type");
            }
            int n = image.getWidth(this);
            int n2 = image.getHeight(this);
            if (this.scaleImage && (n != (int)d3 || n2 != (int)d4)) {
                image = image.getScaledInstance((int)d3, (int)d4, 1);
            }
            tracker.addImage(image, this.imageID);
            try {
                tracker.waitForID(this.imageID);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            graphics2D.drawImage(image, (int)d, (int)d2, (int)d3, (int)d4, this);
            tracker.removeImage(image);
        } else if (this.image instanceof Component) {
            Object object;
            Component component = (Component)this.image;
            int n = component.getWidth();
            int n3 = component.getHeight();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.translate(d, d2);
            if (d3 > 0.0 && d4 > 0.0 && (n != (int)d3 || n3 != (int)d4)) {
                graphics2D2.scale(d3 / (double)n, d4 / (double)n3);
                graphics2D2.setClip(new Rectangle2D.Double(0.0, 0.0, n, n3));
            } else {
                object = graphics2D2.getClipBounds();
                graphics2D2.setClip(new Rectangle2D.Double(0.0, 0.0, Math.min(((Rectangle)object).width, n), Math.min(((Rectangle)object).height, n3)));
            }
            graphics2D2.setStroke(new BasicStroke());
            if (!component.isShowing() && this.image instanceof ServerRenderable) {
                object = (ServerRenderable)this.image;
                object.serverPaint(graphics2D2);
            } else {
                component.paint(graphics2D2);
            }
            graphics2D2.dispose();
        } else {
            throw new IllegalArgumentException("Bad image type");
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 1) == 0 || (n & 2) == 0) {
            return true;
        }
        if (this.bounds.getWidth().isZero()) {
            this.bounds.setWidth(new JCUnit.Measure(JCUnit.POINTS, n4));
        }
        if (this.bounds.getHeight().isZero()) {
            this.bounds.setHeight(new JCUnit.Measure(JCUnit.POINTS, n5));
        }
        return (n & 0x20) == 0;
    }

    public Object clone() {
        ImageRender imageRender = (ImageRender)super.clone();
        return imageRender;
    }

    protected static class ImComponent
    extends Component {
        protected ImComponent() {
        }
    }
}

