/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.render.FlowMarker;
import com.klg.jclass.page.render.ImageRender;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.util.ServerRenderable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageMarker
extends Render
implements Cloneable,
FlowMarker,
ImageObserver {
    protected ImageRender image;
    protected boolean embedded = false;
    private int imageID;
    private static ImComponent imageComponent = new ImComponent();
    private static MediaTracker tracker = new MediaTracker(imageComponent);
    private static int nextImageID = 0;

    public ImageMarker() {
        this.image = null;
    }

    public ImageMarker(ImageRender imageRender) {
        this.image = imageRender;
    }

    public ImageMarker(ImageRender imageRender, boolean bl) {
        this.image = imageRender;
        this.embedded = bl;
    }

    public ImageRender getImage() {
        return this.image;
    }

    public void setImage(ImageRender imageRender) {
        this.image = imageRender;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        String string;
        String string2;
        int n;
        Object object = this.image.getImage();
        Image image = null;
        if (!(graphics2D instanceof Markup)) {
            return;
        }
        Markup markup = (Markup)((Object)graphics2D);
        JCUnit.Dimension dimension = this.image.getSize();
        int n2 = (int)JCUnit.getAsPoints(dimension.units, dimension.width);
        int n3 = (int)JCUnit.getAsPoints(dimension.units, dimension.height);
        if (object instanceof Component) {
            Object object2;
            Component component = (Component)object;
            n = component.getWidth();
            int n4 = component.getHeight();
            if (n == 0 || n4 == 0) {
                if (!component.isShowing() && component instanceof ServerRenderable) {
                    ((ServerRenderable)((Object)component)).setGraphics(graphics2D);
                }
                object2 = component.getPreferredSize();
                if (n == 0) {
                    n = ((Dimension)object2).width;
                }
                if (n4 == 0) {
                    n4 = ((Dimension)object2).height;
                }
            }
            if (n3 == 0 && n2 == 0) {
                n3 = n4;
                n2 = n;
            } else if (n3 == 0) {
                n3 = n4 * n2 / n;
            } else if (n2 == 0) {
                n2 = n * n3 / n4;
            }
            if (n3 != n4 || n2 != n) {
                component.setSize(n2, n3);
            }
            if ((image = component.createImage(n2, n3)) == null) {
                return;
            }
            object2 = image.getGraphics();
            ((Graphics)object2).setClip(new Rectangle(0, 0, n2, n3));
            if (!component.isShowing() && component instanceof ServerRenderable) {
                ((ServerRenderable)((Object)component)).serverPaint((Graphics)object2);
            } else {
                CellRendererPane cellRendererPane = new CellRendererPane();
                Frame frame = new Frame();
                cellRendererPane.paintComponent((Graphics)object2, component, frame, 0, 0, n2, n3, true);
            }
        }
        if (object instanceof Image || object instanceof Icon) {
            if (object instanceof Image) {
                image = (Image)object;
            } else if (object instanceof ImageIcon) {
                image = ((ImageIcon)object).getImage();
            } else {
                throw new IllegalArgumentException("Unknown Icon type");
            }
            int n5 = image.getWidth(this);
            n = image.getHeight(this);
            if (n5 != n2 || n != n3) {
                image = image.getScaledInstance(n2, n3, 1);
            }
            tracker.addImage(image, this.imageID);
            try {
                tracker.waitForID(this.imageID);
            }
            catch (InterruptedException interruptedException) {}
        } else if (!(object instanceof EPSImage)) {
            throw new IllegalArgumentException("Bad image type");
        }
        if (this.embedded) {
            string2 = this.getVAlign(this.image.getVerticalAlignment());
            string = null;
        } else {
            string2 = null;
            string = this.getHAlign(this.image.getAlignment());
        }
        if (image != null) {
            markup.outputImage(image, n2, n3, Color.white, this, string, string2);
            if (object instanceof Image || object instanceof Icon) {
                tracker.removeImage(image);
            }
        }
    }

    private String getHAlign(int n) {
        switch (n) {
            case 2: {
                return "left";
            }
            case 3: {
                return "right";
            }
        }
        return "center";
    }

    private String getVAlign(int n) {
        switch (n) {
            case 1: 
            case 7: {
                return "bottom";
            }
            case 2: 
            case 6: {
                return "top";
            }
        }
        return "middle";
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 1) == 0 || (n & 2) == 0) {
            return true;
        }
        if (this.bounds.getWidth().isZero()) {
            this.bounds.setWidth(new JCUnit.Measure(JCUnit.POINTS, n4));
        }
        if (this.bounds.getHeight().isZero()) {
            this.bounds.setHeight(new JCUnit.Measure(JCUnit.POINTS, n5));
        }
        return (n & 0x20) == 0;
    }

    public Object clone() {
        ImageMarker imageMarker = (ImageMarker)super.clone();
        return imageMarker;
    }

    protected static class ImComponent
    extends Component {
        protected ImComponent() {
        }
    }
}

