/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.pcl;

import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.pcl.CharSetEntryPCL;
import com.klg.jclass.page.pcl.CharacterPCL;
import com.klg.jclass.page.pcl.FontPCL;
import com.klg.jclass.page.pcl.KernPairPCL;
import com.klg.jclass.page.pcl.LineMetricsPCL;
import com.klg.jclass.page.pcl.MetricsPCL;
import com.klg.jclass.page.pcl.TypeFacePCL;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.LineMetrics;
import java.text.CharacterIterator;

public class FontMetricsPCL
extends FontMetrics {
    public FontMetricsPCL(FontPCL fontPCL) {
        super(fontPCL);
        if (!(fontPCL instanceof FontPCL)) {
            throw new IllegalArgumentException("font must be instance of FontPCL");
        }
    }

    public int getAscent() {
        return (int)this.getAscender(JCUnit.POINTS, this.font.getSize());
    }

    public int getDescent() {
        return (int)(-this.getDescender(JCUnit.POINTS, this.font.getSize()));
    }

    public int getMaxAscent() {
        return (int)this.getAscender(JCUnit.POINTS, this.font.getSize());
    }

    public int getMaxDescent() {
        return (int)this.getDescender(JCUnit.POINTS, this.font.getSize());
    }

    public int charWidth(char c) {
        return (int)(this.preciseCharWidth(c) + 0.5);
    }

    protected double preciseCharWidth(char c) {
        CharSetEntryPCL charSetEntryPCL = ((FontPCL)this.font).getCharMetric(c);
        short s = charSetEntryPCL.metrics.getHorizontalEscapement();
        double d = this.convertToDecipoints(s, this.font.getSize());
        return this.convertFromDeciPoints(JCUnit.POINTS, d);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        double d = 0.0;
        int n3 = n;
        while (n3 < n2) {
            d += this.preciseCharWidth(cArray[n3]);
            ++n3;
        }
        return (int)(d + 0.5);
    }

    public LineMetrics getLineMetrics(String string, Graphics graphics) {
        return new LineMetricsPCL(this, string);
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, Graphics graphics) {
        String string2 = string.toString().substring(n, n2);
        return new LineMetricsPCL(this, string2);
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, Graphics graphics) {
        return new LineMetricsPCL(this, new String(cArray, n, n2));
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, Graphics graphics) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = characterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = characterIterator.next();
        }
        String string = stringBuffer.toString().substring(n, n2);
        return new LineMetricsPCL(this, string);
    }

    protected double getHeight(JCUnit jCUnit, int n) {
        return this.getAscent() - this.getDescent();
    }

    protected double getXHeight(JCUnit jCUnit, int n) {
        double d = this.convertToDecipoints(((FontPCL)this.font).getXHeight(), n);
        return this.convertFromDeciPoints(jCUnit, d);
    }

    protected double getAscender(JCUnit jCUnit, int n) {
        TypeFacePCL typeFacePCL = ((FontPCL)this.font).getTypeface();
        short s = typeFacePCL.typefaceMetrics.getLowercaseAscent();
        double d = this.convertToDecipoints(s, n);
        return this.convertFromDeciPoints(jCUnit, d);
    }

    protected double getDescender(JCUnit jCUnit, int n) {
        TypeFacePCL typeFacePCL = ((FontPCL)this.font).getTypeface();
        short s = typeFacePCL.typefaceMetrics.getLowercaseDescent();
        double d = this.convertToDecipoints(s, n);
        return this.convertFromDeciPoints(jCUnit, d);
    }

    protected double convertFromDeciPoints(JCUnit jCUnit, double d) {
        double d2 = 0.0;
        d = this.convertWorldToPoints(d);
        if (jCUnit == JCUnit.POINTS) {
            d2 = d;
        } else if (jCUnit == JCUnit.INCHES) {
            d2 = JCUnit.getAsInches(JCUnit.POINTS, d);
        } else if (jCUnit == JCUnit.CM) {
            d2 = JCUnit.getAsCentimeters(JCUnit.POINTS, d);
        } else {
            throw new IllegalArgumentException("Unknown units " + jCUnit);
        }
        return d2;
    }

    protected double charWidth(JCUnit jCUnit, int n, char c) {
        int n2 = this.charWidth(c);
        double d = this.convertToDecipoints(n2, n);
        return this.convertFromDeciPoints(jCUnit, d);
    }

    protected double stringWidth(JCUnit jCUnit, int n, String string) {
        double d = 0.0;
        CharSetEntryPCL charSetEntryPCL = null;
        TypeFacePCL typeFacePCL = ((FontPCL)this.font).getTypeface();
        int n2 = ((FontPCL)this.font).getCharsPerInch();
        if (n2 < 0) {
            int n3 = 0;
            while (n3 < string.length()) {
                Integer n4;
                KernPairPCL kernPairPCL;
                CharSetEntryPCL charSetEntryPCL2 = ((FontPCL)this.font).getCharMetric(string.charAt(n3));
                d += (double)charSetEntryPCL2.getMetrics().getHorizontalEscapement();
                if (charSetEntryPCL != null && charSetEntryPCL.getKerns().size() > 0 && (kernPairPCL = charSetEntryPCL.getKernPair(n4 = new Integer(charSetEntryPCL2.getIndex()))) != null) {
                    d += (double)kernPairPCL.kernValue;
                }
                charSetEntryPCL = charSetEntryPCL2;
                ++n3;
            }
            double d2 = this.convertToDecipoints(d, n);
            return this.convertFromDeciPoints(jCUnit, d2);
        }
        double d3 = 720.0 * (double)string.length() / (double)n2;
        return this.convertFromDeciPoints(jCUnit, d3);
    }

    protected double getLeadingSpace(JCUnit jCUnit, int n, String string) {
        CharacterPCL characterPCL = ((FontPCL)this.font).getCharMetric(string.charAt(0)).getMetrics();
        double d = 0.0;
        if (characterPCL != null && characterPCL.getLeftExtent() < 0) {
            d = -characterPCL.getLeftExtent();
            d = this.convertToDecipoints(d, n);
        }
        return this.convertFromDeciPoints(jCUnit, d);
    }

    protected double getTrailingSpace(JCUnit jCUnit, int n, String string) {
        int n2 = string.length() - 1;
        CharacterPCL characterPCL = ((FontPCL)this.font).getCharMetric(string.charAt(n2)).getMetrics();
        double d = 0.0;
        if (characterPCL != null && characterPCL.getHorizontalEscapement() < characterPCL.getLeftExtent() + characterPCL.getRightExtent()) {
            d = -characterPCL.getLeftExtent() + characterPCL.getRightExtent() - characterPCL.getHorizontalEscapement();
            d = this.convertToDecipoints(d, n);
        }
        return this.convertFromDeciPoints(jCUnit, d);
    }

    double convertToDecipoints(double d, int n) {
        TypeFacePCL typeFacePCL = ((FontPCL)this.font).getTypeface();
        MetricsPCL metricsPCL = typeFacePCL.getTypefaceMetrics();
        return d * (double)n * 10.0 / metricsPCL.getDesignUnits();
    }

    double convertWorldToPoints(double d) {
        return d / 10.0;
    }
}

