/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.html;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.FontBase;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.awt.FontMetrics11;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.klg.jclass.util.swing.encode.JPEGEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class Graphics2DHTML
extends Graphics2DBase
implements Markup {
    protected Font defaultFont = JCTextStyle.DEFAULT_TEXT.getFont();
    protected int currentPointSize = this.defaultFont.getSize();
    protected Font drawingFont = this.defaultFont;
    protected Color defaultColour;
    protected Color currentColour = this.defaultColour = JCTextStyle.DEFAULT_TEXT.getColor();
    protected String directoryName = null;
    protected boolean isCurrentMonospace = false;
    protected boolean isCurrentUnderline = false;
    protected boolean isCurrentSubscript = false;
    protected boolean isCurrentSuperscript = false;
    protected boolean inDivision = false;
    protected static final int[] pointMapping = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    protected static final int ATTRIBUTE_COLOUR = 1;
    protected static final int ATTRIBUTE_SIZE = 2;
    protected static final int ATTRIBUTE_MONOSPACE = 4;
    protected static final int ATTRIBUTE_BOLD = 8;
    protected static final int ATTRIBUTE_ITALIC = 16;
    protected static final int ATTRIBUTE_UNDERLINE = 32;
    protected static final int ATTRIBUTE_SUBSCRIPT = 64;
    protected static final int ATTRIBUTE_SUPERSCRIPT = 128;
    protected static final int[] attributeSet = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    protected int[] appliedAttributes = new int[attributeSet.length];
    protected int appliedAttributeCount = 0;
    protected static final String[] charNames = new String[]{"&#000;", "&#001;", "&#002;", "&#003;", "&#004;", "&#005;", "&#006;", "&#007;", "&#008;", "&#009;", "&#010;", "&#011;", "&#012;", "&#013;", "&#014;", "&#015;", "&#016;", "&#017;", "&#018;", "&#019;", "&#020;", "&#021;", "&#022;", "&#023;", "&#024;", "&#025;", "&#026;", "&#027;", "&#028;", "&#029;", "&#030;", "&#031;", " ", "!", "\"", "#", "$", "%", "&amp;", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "&lt;", "=", "&gt;", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "&#127;", "&#128;", "&#129;", "&#130;", "&#131;", "&#132;", "&#133;", "&#134;", "&#135;", "&#136;", "&#137;", "&#138;", "&#139;", "&#140;", "&#141;", "&#142;", "&#143;", "&#144;", "&#145;", "&#146;", "&#147;", "&#148;", "&#149;", "&#150;", "&#151;", "&#152;", "&#153;", "&#154;", "&#155;", "&#156;", "&#157;", "&#158;", "&#159;", "&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;"};
    private JPEGEncoder jpegWriter = new JPEGEncoder();

    public Graphics2DHTML(OutputStream outputStream) {
        super(outputStream);
    }

    public Graphics2DHTML(OutputStream outputStream, String string) {
        super(outputStream);
        if (string != null) {
            this.directoryName = new String(string);
        }
    }

    public void drawString(String string, float f, float f2) {
        this.outputTextStyle(this.getFont(), this.getColor(), this.underline, this.subscript, false);
        this.output(this.escapeCharacters(string));
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.translate(d, d2);
        double d3 = rectangle2D.getX() - d;
        double d4 = rectangle2D.getY() - d2;
        double d5 = rectangle2D.getWidth();
        double d6 = rectangle2D.getHeight();
        rectangle2D.setRect(d3, d4, d5, d6);
    }

    public void scale(double d, double d2) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        this.transform.scale(d, d2);
        double d3 = rectangle2D.getX() / d;
        double d4 = rectangle2D.getY() / d2;
        double d5 = rectangle2D.getWidth() / d;
        double d6 = rectangle2D.getHeight() / d2;
        rectangle2D.setRect(d3, d4, d5, d6);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipRect((double)n, (double)n2, (double)n3, (double)n4);
    }

    public void clipRect(double d, double d2, double d3, double d4) {
        Rectangle2D rectangle2D = (Rectangle2D)this.getClip();
        if (this.clipSet) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D.intersect(rectangle2D, new Rectangle2D.Double(d, d2, d3, d4), double_);
            rectangle2D = double_;
        } else {
            rectangle2D.setRect(d, d2, d3, d4);
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (image instanceof EPSImage) {
            return this.drawEPSImage((EPSImage)image, n, n2, n3, n4, color, imageObserver);
        }
        return this.drawJavaImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public void setFont(Font font) {
        this.updateContext();
        if (this.currentFont != null && this.currentFont.equals(font)) {
            return;
        }
        this.currentFont = font;
        String string = font.getName();
        int n = font.getSize();
    }

    public FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        return new FontMetrics11(font, fontMetrics);
    }

    public void startTable(int n) {
        if (this.appliedAttributeCount > 0) {
            this.removeAttributes(0);
        }
        this.output("<table>");
    }

    public void startRow() {
        this.output("\t<tr>");
    }

    public void startCell() {
        this.startCell("left", false, 1, 1);
    }

    public void startCell(String string, boolean bl) {
        this.startCell(string, bl, 1, 1);
    }

    public void startCell(int n, int n2) {
        this.startCell("left", false, n, n2);
    }

    public void startCell(String string, boolean bl, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("\t\t<th");
        } else {
            stringBuffer.append("\t\t<td");
        }
        if (string != null && !string.equals("left")) {
            stringBuffer.append(" align=" + string);
        }
        if (n > 1) {
            stringBuffer.append(" rowspan=\"" + n + "\"");
        }
        if (n2 > 1) {
            stringBuffer.append(" colspan=\"" + n2 + "\"");
        }
        stringBuffer.append(">");
        this.output(stringBuffer.toString());
    }

    public void endCell() {
        this.endCell(false);
    }

    public void endCell(boolean bl) {
        if (this.appliedAttributeCount > 0) {
            this.removeAttributes(0);
        }
        if (bl) {
            this.output("\t\t</th>");
        } else {
            this.output("\t\t</td>");
        }
    }

    public void endRow() {
        this.output("\t</tr>");
    }

    public void endTable() {
        this.output("</table>");
    }

    public void newLine() {
        this.output("<br>");
    }

    public void newParagraph() {
        this.output("<p>");
    }

    public void newParagraph(String string) {
        if (string != null && !string.equals("left")) {
            this.output("<p align=" + string + ">");
        } else {
            this.output("<p>");
        }
    }

    public void newSection(String string) {
        if (this.appliedAttributeCount > 0) {
            this.removeAttributes(0);
        }
        if (this.inDivision) {
            this.output("</div>");
        }
        this.output("<div align=" + string + ">");
        this.inDivision = true;
    }

    public void endSection() {
        if (this.appliedAttributeCount > 0) {
            this.removeAttributes(0);
        }
        if (this.inDivision) {
            this.output("</div>");
            this.inDivision = false;
        }
    }

    public void hRule() {
        this.output("<hr>");
    }

    public void hRule(double d) {
        this.output("<hr width=" + d + "%>");
    }

    public void hRule(double d, String string, int n) {
        this.output("<hr width=" + d + "% align=" + string + " size=" + n + ">");
    }

    public void hRule(int n) {
        this.output("<hr width=" + n + ">");
    }

    public void hRule(int n, String string, int n2) {
        this.output("<hr width=" + n + "align=" + string + " size=" + n2 + ">");
    }

    public boolean outputImage(Image image, int n, int n2, Color color, ImageObserver imageObserver, String string, String string2) {
        Image image2 = null;
        int n3 = image.getHeight(imageObserver);
        int n4 = image.getWidth(imageObserver);
        if (n2 == 0 && n == 0) {
            n2 = n3;
            n = n4;
            image2 = image;
        } else if (n2 == 0) {
            n2 = n3 * n / n4;
        } else if (n == 0) {
            n = n4 * n2 / n3;
        } else if (n2 == n3 && n == n4) {
            image2 = image;
        }
        if (image2 == null) {
            image2 = image.getScaledInstance(n, n2, 1);
            while (image2.getHeight(imageObserver) != n2 || image2.getWidth(imageObserver) != n) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        String string3 = this.createImageFile(image2);
        StringBuffer stringBuffer = new StringBuffer("<img src=\"" + string3 + "\"");
        if (string != null) {
            this.output("<p align=" + string + ">");
        } else if (string2 != null) {
            stringBuffer.append(" align=" + string2);
        }
        stringBuffer.append(" width=" + n + " height=" + n2 + ">");
        this.output(stringBuffer.toString());
        if (string != null) {
            this.output("</p>");
        }
        return true;
    }

    public void startContext() {
    }

    public void endContext() {
    }

    public String getDirectory() {
        return this.directoryName;
    }

    public void setDirectory(String string) {
        this.directoryName = string != null ? new String(string) : null;
    }

    public void drawArcPW(double d, double d2, double d3, double d4, double d5, double d6, int n) {
    }

    public void fillArcPW(double d, double d2, double d3, double d4, double d5, double d6, int n) {
    }

    public void setClipPW(double d, double d2, double d3, double d4) {
    }

    public void fillRectPW(double d, double d2, double d3, double d4) {
    }

    public void drawRectPW(double d, double d2, double d3, double d4) {
    }

    public void drawLinePW(double d, double d2, double d3, double d4) {
    }

    public void drawRoundRectPW(double d, double d2, double d3, double d4, double d5, double d6) {
    }

    public void fillRoundRectPW(double d, double d2, double d3, double d4, double d5, double d6) {
    }

    public void flushLoadedFonts() {
        this.loadedFonts.clear();
    }

    public Shape getClip() {
        Shape shape = super.getClip() instanceof Rectangle2D ? super.getClip() : super.getClip().getBounds2D();
        return shape;
    }

    public boolean drawEPSImage(EPSImage ePSImage, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return true;
    }

    protected String escapeCharacters(String string) {
        int n = -1;
        String string2 = "&<>";
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c < ' ' || c > '~') {
                if (n > -1) {
                    stringBuffer.append(string.substring(n, n2));
                    n = -1;
                }
                if (c <= '\u00ff') {
                    stringBuffer.append(charNames[c]);
                } else {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(Integer.toHexString(c));
                    while (stringBuffer2.length() < 4) {
                        stringBuffer2.insert(0, '0');
                    }
                    stringBuffer2.insert(0, 'x');
                    stringBuffer2.insert(0, '#');
                    stringBuffer2.insert(0, '&');
                    stringBuffer2.append(';');
                    stringBuffer.append(stringBuffer2.toString());
                }
            } else if (string2.indexOf(c) != -1) {
                if (n > -1) {
                    stringBuffer.append(string.substring(n, n2));
                    n = -1;
                }
                stringBuffer.append(charNames[c]);
            } else if (n == -1) {
                n = n2;
            }
            ++n2;
        }
        if (n == 0) {
            return string;
        }
        if (n > -1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    protected String getColorString(Color color) {
        String string = "#" + this.hexCode(color.getRed(), 2) + this.hexCode(color.getGreen(), 2) + this.hexCode(color.getBlue(), 2);
        return string;
    }

    private String hexCode(int n) {
        return this.hexCode(n, -1);
    }

    private String hexCode(int n, int n2) {
        int n3 = 0;
        int[] nArray = new int[8];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        while (n > 0) {
            nArray[n3++] = n % 16;
            n /= 16;
        }
        if (n2 > n3) {
            int n4 = 0;
            while (n4 < n2 - n3) {
                stringBuffer.append('0');
                ++n4;
            }
        }
        --n3;
        while (n3 >= 0) {
            stringBuffer.append(cArray[nArray[n3]]);
            --n3;
        }
        return stringBuffer.toString();
    }

    private void outputTextStyle(Font font, Color color, boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        while (n < this.appliedAttributeCount) {
            if (!this.isAttributeConstant(this.appliedAttributes[n], font, color, bl, bl2, bl3)) {
                this.removeAttributes(n);
            }
            ++n;
        }
        n = 0;
        while (n < attributeSet.length) {
            if (!this.isAttributeConstant(attributeSet[n], font, color, bl, bl2, bl3)) {
                this.applyAttribute(attributeSet[n], font, color, bl, bl2, bl3);
            }
            ++n;
        }
    }

    private void applyAttribute(int n, Font font, Color color, boolean bl, boolean bl2, boolean bl3) {
        switch (n) {
            case 1: {
                if (color == null || color.equals(this.defaultColour)) {
                    return;
                }
                this.output("<font color=" + this.getColorString(color) + ">");
                this.currentColour = color;
                break;
            }
            case 2: {
                int n2;
                String string;
                if (font.getSize() == this.currentPointSize) {
                    return;
                }
                int n3 = pointMapping[this.currentPointSize];
                int n4 = pointMapping[font.getSize()];
                if (n3 == n4) {
                    return;
                }
                if (n3 > n4) {
                    string = "-";
                    n2 = n3 - n4;
                } else {
                    string = "+";
                    n2 = n4 - n3;
                }
                if (n2 > 4) {
                    n2 = 4;
                }
                this.output("<font size=" + string + n2 + ">");
                this.currentPointSize = font.getSize();
                break;
            }
            case 4: {
                this.output("<tt>");
                this.isCurrentMonospace = true;
                break;
            }
            case 16: {
                this.output("<i>");
                this.drawingFont = FontBase.deriveFont(this.drawingFont, this.drawingFont.getStyle() | 2);
                break;
            }
            case 8: {
                this.output("<b>");
                this.drawingFont = FontBase.deriveFont(this.drawingFont, this.drawingFont.getStyle() | 1);
                break;
            }
            case 32: {
                this.output("<u>");
                this.isCurrentUnderline = true;
                break;
            }
            case 64: {
                this.output("<sub>");
                this.isCurrentSubscript = true;
                break;
            }
            case 128: {
                this.output("<sup>");
                this.isCurrentSuperscript = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised attribute type");
            }
        }
        this.appliedAttributes[this.appliedAttributeCount++] = n;
    }

    private void removeAttribute(int n) {
        switch (n) {
            case 1: {
                this.output("</font>");
                this.currentColour = this.defaultColour;
                break;
            }
            case 2: {
                this.output("</font>");
                this.currentPointSize = this.defaultFont.getSize();
                break;
            }
            case 4: {
                this.output("</tt>");
                this.isCurrentMonospace = false;
                break;
            }
            case 16: {
                this.output("</i>");
                this.drawingFont = FontBase.deriveFont(this.drawingFont, this.drawingFont.getStyle() & 0xFFFFFFFD);
                break;
            }
            case 8: {
                this.output("</b>");
                this.drawingFont = FontBase.deriveFont(this.drawingFont, this.drawingFont.getStyle() & 0xFFFFFFFE);
                break;
            }
            case 32: {
                this.output("</u>");
                this.isCurrentUnderline = false;
                break;
            }
            case 64: {
                this.output("</sub>");
                this.isCurrentSubscript = false;
                break;
            }
            case 128: {
                this.output("</sup>");
                this.isCurrentSuperscript = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised attribute type" + n);
            }
        }
        --this.appliedAttributeCount;
    }

    private void removeAttributes(int n) {
        while (this.appliedAttributeCount > n) {
            this.removeAttribute(this.appliedAttributes[this.appliedAttributeCount - 1]);
        }
    }

    private boolean isAttributeConstant(int n, Font font, Color color, boolean bl, boolean bl2, boolean bl3) {
        switch (n) {
            case 1: {
                return color == null || color.equals(this.currentColour);
            }
            case 2: {
                return font.getSize() == this.currentPointSize || pointMapping[font.getSize()] == pointMapping[this.currentPointSize];
            }
            case 4: {
                boolean bl4 = false;
                if (font.getName() != this.defaultFont.getName() && font.getName().indexOf("Courier") != -1) {
                    bl4 = true;
                }
                return bl4 == this.isCurrentMonospace;
            }
            case 16: {
                return font.isItalic() == this.drawingFont.isItalic();
            }
            case 8: {
                return font.isBold() == this.drawingFont.isBold();
            }
            case 32: {
                return bl == this.isCurrentUnderline;
            }
            case 64: {
                return bl2 == this.isCurrentSubscript;
            }
            case 128: {
                return bl3 == this.isCurrentSuperscript;
            }
        }
        throw new IllegalArgumentException("Unrecognised attribute type");
    }

    public void closeOpenTags() {
        if (this.appliedAttributeCount > 0) {
            this.removeAttributes(0);
        }
        if (this.inDivision) {
            this.output("</div>");
        }
    }

    protected void setLineStroke() {
    }

    protected boolean drawJavaImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        Image image2 = null;
        int n5 = image.getHeight(imageObserver);
        int n6 = image.getWidth(imageObserver);
        if (n4 == 0 && n3 == 0) {
            n4 = n5;
            n3 = n6;
            image2 = image;
        } else if (n4 == 0) {
            n4 = n5 * n3 / n6;
        } else if (n3 == 0) {
            n3 = n6 * n4 / n5;
        } else if (n4 == n5 && n3 == n6) {
            image2 = image;
        }
        if (image2 == null) {
            image2 = image.getScaledInstance(n3, n4, 1);
            while (image2.getHeight(imageObserver) != n4 || image2.getWidth(imageObserver) != n3) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        String string = this.createImageFile(image2);
        StringBuffer stringBuffer = new StringBuffer("<img src=\"" + string + "\"");
        stringBuffer.append(" width=" + n3 + " height=" + n4 + ">");
        this.output(stringBuffer.toString());
        return true;
    }

    private String createImageFile(Image image) {
        String string;
        FileOutputStream fileOutputStream;
        if (this.directoryName == null) {
            return null;
        }
        String string2 = "plimg" + System.currentTimeMillis() + ".jpg";
        File file = new File(this.directoryName, string2);
        try {
            if (!file.createNewFile()) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            this.jpegWriter.saveImage(image, fileOutputStream);
        }
        catch (IOException iOException) {
            file.delete();
            return null;
        }
        catch (EncoderException encoderException) {
            file.delete();
            return null;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            string = file.toURL().getFile();
        }
        catch (IOException iOException) {
            try {
                string = this.makeURL(file.getCanonicalPath());
            }
            catch (IOException iOException2) {
                file.delete();
                return null;
            }
        }
        return string;
    }

    private String makeURL(String string) {
        if (string.charAt(0) == '/' && File.separatorChar == '/') {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (Character.isLetter(string.charAt(0)) && string.charAt(1) == ':') {
            stringBuffer.append("/");
            stringBuffer.append(string.charAt(0));
            stringBuffer.append("|/");
            string = string.substring(2);
        } else if (string.charAt(0) != File.separatorChar) {
            stringBuffer.append("/");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(2), File.separator, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(File.separator)) {
                stringBuffer.append("/");
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

