/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.FontBase;
import com.klg.jclass.page.FontFileLookup;
import com.klg.jclass.page.FontLibrary;
import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.TrueTypeFontProperties;
import com.klg.jclass.page.adobe.postscript.AFMParser;
import com.klg.jclass.page.adobe.postscript.BoundBox;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontMetricsPS;
import com.klg.jclass.page.adobe.postscript.GlyphVectorPS;
import com.klg.jclass.page.adobe.postscript.TTFParser;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class FontPS
extends FontBase
implements Cloneable {
    public static final int UNICODE_NOT_FOUND_CHARACTER = 32;
    public static final int UNICODE_NOT_FOUND_GLYPH = 0;
    protected String afmVersion;
    protected String fullName;
    protected String familyName;
    protected String weight;
    protected float italicAngle;
    protected boolean isFixedPitch;
    protected boolean isSerif;
    protected BoundBox fontBBox;
    protected int underlinePosition;
    protected int underlineThickness;
    protected String version;
    protected String notice;
    protected String encodingScheme;
    protected boolean encodingFontSpecific = false;
    protected int capHeight;
    protected int xHeight;
    protected int ascender;
    protected int descender;
    protected int fullHeight = 1000;
    protected int stdHW;
    protected int stdVW;
    public static Hashtable fonts = new Hashtable();
    protected Hashtable trackKerning = new Hashtable();
    protected Hashtable charMetrics = new Hashtable();
    public CharMetricPS[] charMetricList;
    protected Hashtable unicodeCharMetrics = new Hashtable();
    protected FontMetricsPS psFontMetrics = null;
    protected static final String userPropertiesName = "user";
    protected static String defaultJarLocation = "/com/klg/jclass/page/adobe/fonts.jar";
    protected static String defaultFontMap = "com.klg.jclass.page.adobe.JCAdobeFontMap";
    protected static String defaultFileExtension = ".afm";
    protected static boolean loaded = false;
    protected static ResourceBundle userFontBundle;
    protected static ResourceBundle defaultFontBundle;
    public boolean usingTTF = false;
    private static FontFileLookup fakeUserFontLookup;
    private static FontFileLookup fakeStockFontLookup;
    public TTFParser ttfParser = null;
    protected static String[] char_names_iso_latin;

    public FontPS(String string, int n, int n2) {
        super(string, n, n2);
        this.fontBBox = new BoundBox();
    }

    protected FontMetricsPS getLocalFontMetrics() {
        if (this.psFontMetrics == null) {
            this.psFontMetrics = new FontMetricsPS(this);
        }
        return this.psFontMetrics;
    }

    protected Object clone() {
        try {
            FontPS fontPS = (FontPS)super.clone();
            fontPS.psFontMetrics = null;
            return fontPS;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static Font decode(String string) {
        FontPS fontPS;
        String string2;
        Font font = FontPS.decodeToFont(string);
        String string3 = font.getName();
        String string4 = FontBase.getStyleString(font.getStyle());
        String string5 = string4.replace('-', ' ');
        if (string5.length() > 0 && string3.endsWith(string5)) {
            string3 = string3.substring(0, string3.indexOf(string5));
        }
        if (!fonts.containsKey(string2 = FontLibrary.lookupFontNameByUserAlias(string3 = string3 + FontBase.getStyleString(font.getStyle()), 0))) {
            FontPS.loadFont(string2);
        }
        if ((fontPS = (FontPS)fonts.get(string2)) == null) {
            System.err.println("Warning: font " + string2 + " not loaded, " + "substituting Times-Roman");
            string2 = "Times-Roman";
            if (!fonts.containsKey(string2)) {
                FontPS.loadFont(string2);
            }
            fontPS = (FontPS)fonts.get(string2);
        }
        return fontPS.deriveFont(font.getStyle(), font.getSize());
    }

    public static void loadFont(String string) {
        FontFileLookup fontFileLookup = (FontFileLookup)FontLibrary.availableFonts[0].get(string);
        if (fontFileLookup == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            if (fontFileLookup.fileType == 1) {
                TTFParser tTFParser = new TTFParser();
                TrueTypeFontProperties trueTypeFontProperties = FontLibrary.lookupTrueTypeFontProperties(string);
                Vector vector = tTFParser.parse(fontFileLookup, string, true);
                if (vector.size() > 0) {
                    FontPS fontPS = (FontPS)vector.firstElement();
                    fonts.put(fontPS.getName().trim(), fontPS);
                }
            } else if (fontFileLookup.fileType == 0) {
                inputStream = fontFileLookup.openInputStream();
                AFMParser aFMParser = new AFMParser();
                Vector vector = aFMParser.parse(inputStream);
                Font font = (Font)vector.firstElement();
                fonts.put(font.getName().trim(), font);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Font decodeToFont(String string) {
        String string2 = string;
        int n = 12;
        int n2 = 0;
        if (string == null) {
            return new Font("dialog", n2, n);
        }
        int n3 = string.indexOf(45);
        if (n3 >= 0) {
            String string3 = string.toLowerCase();
            int n4 = string3.indexOf("bold-italic");
            if (n4 != -1) {
                n2 = 3;
            }
            if (n4 == -1 && (n4 = string3.indexOf("bolditalic")) != -1) {
                n2 = 3;
            }
            if (n4 == -1 && (n4 = string3.indexOf("bold")) != -1) {
                n2 = 1;
            }
            if (n4 == -1 && (n4 = string3.indexOf("italic")) != -1) {
                n2 = 2;
            }
            int n5 = string.lastIndexOf("-");
            if (n4 != -1) {
                if (n4 > 0) {
                    string2 = string.substring(0, n4 - 1);
                }
            } else {
                string2 = string.substring(0, n5);
            }
            if (n5 != -1) {
                string = string.substring(n5 + 1);
            }
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n3 == -1) {
            n2 = 0;
            n = 12;
            int n6 = (string = string.toLowerCase()).indexOf("bolditalic");
            if (n6 != -1) {
                n2 = 3;
            }
            if (n6 == -1 && (n6 = string.indexOf("bold italic")) != -1) {
                n2 = 3;
            }
            if (n6 == -1 && (n6 = string.indexOf("bold")) != -1) {
                n2 = 1;
            }
            if (n6 == -1 && (n6 = string.indexOf("italic")) != -1) {
                n2 = 2;
            }
            if (n6 != -1) {
                string2 = string2.substring(0, n6);
                string2 = string2.trim();
            }
            if ((n6 = string.lastIndexOf(" ")) != -1) {
                String string4 = string.substring(n6);
                string4 = string4.trim();
                try {
                    n = Integer.valueOf(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new Font(string2, n2, n);
    }

    public String getFamily() {
        return this.getFamilyName();
    }

    public String getFontName() {
        return this.getFullName();
    }

    public boolean isPlain() {
        return !this.isBold() && !this.isItalic();
    }

    public boolean isBold() {
        return this.getFontName().toLowerCase().indexOf("bold") > -1;
    }

    public boolean isItalic() {
        return this.getItalicAngle() != 0.0f;
    }

    public boolean isTrueType() {
        return this.usingTTF;
    }

    public Font deriveFont(int n, float f) {
        FontPS fontPS = (FontPS)this.clone();
        fontPS.style = n;
        fontPS.size = (int)f;
        return fontPS;
    }

    public boolean equals(Object object) {
        if (object instanceof FontPS) {
            FontPS fontPS = (FontPS)object;
            return this.getAfmVersion() == fontPS.getAfmVersion() && (this.getFullName() == null && fontPS.getFullName() == null || this.getFullName().equals(fontPS.getFullName())) && (this.getFamilyName() == null && fontPS.getFamilyName() == null || this.getFamilyName().equals(fontPS.getFamilyName())) && this.getWeight() == fontPS.getWeight() && this.getItalicAngle() == fontPS.getItalicAngle() && this.isFixedPitch() == fontPS.isFixedPitch() && this.isSerif() == fontPS.isSerif() && this.getUnderlinePosition() == fontPS.getUnderlinePosition() && this.getUnderlineThickness() == fontPS.getUnderlineThickness() && this.getVersion() == fontPS.getVersion() && this.getNotice() == fontPS.getNotice() && this.getEncodingScheme() == fontPS.getEncodingScheme() && this.getCapHeight() == fontPS.getCapHeight() && this.getXHeight() == fontPS.getXHeight() && this.getAscender() == fontPS.getAscender() && this.getDescender() == fontPS.getDescender() && this.getStdHW() == fontPS.getStdHW() && this.getStdVW() == fontPS.getStdVW() && (this.getName() == null && fontPS.getName() == null || this.getName().equals(fontPS.getName())) && this.getTrackKerning() == fontPS.getTrackKerning();
        }
        return false;
    }

    public boolean canDisplay(char c) {
        return true;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        FontMetricsPS fontMetricsPS = new FontMetricsPS(this);
        return new GlyphVectorPS(this.getLocalFontMetrics(), fontRenderContext, string);
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (string != null && string.length() > 0) {
            FontMetricsPS fontMetricsPS = this.getLocalFontMetrics();
            int n = fontMetricsPS.getFont().getSize();
            double d = fontMetricsPS.stringWidth(JCUnit.POINTS, n, string);
            double d2 = fontMetricsPS.getLeadingSpace(JCUnit.POINTS, n, string) + fontMetricsPS.getTrailingSpace(JCUnit.POINTS, n, string);
            double d3 = -fontMetricsPS.getAscender(JCUnit.POINTS, n);
            double d4 = fontMetricsPS.getHeight(JCUnit.POINTS, n);
            rectangle.setRect(d2, d3, d, d4);
        }
        return rectangle;
    }

    public void setAfmVersion(String string) {
        this.afmVersion = string;
    }

    public String getAfmVersion() {
        return this.afmVersion;
    }

    public void setFullName(String string) {
        this.fullName = string;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFamilyName(String string) {
        this.familyName = string;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setWeight(String string) {
        this.weight = string;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setItalicAngle(float f) {
        this.italicAngle = f;
    }

    public void setFixedPitch(boolean bl) {
        this.isFixedPitch = bl;
    }

    public boolean isFixedPitch() {
        return this.isFixedPitch;
    }

    public void setSerif(boolean bl) {
        this.isSerif = bl;
    }

    public boolean isSerif() {
        return this.isSerif;
    }

    public void setFontBBox(BoundBox boundBox) {
        this.fontBBox = boundBox;
    }

    public BoundBox getFontBBox() {
        return this.fontBBox;
    }

    public void setUnderlinePosition(int n) {
        this.underlinePosition = n;
    }

    public int getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlineThickness(int n) {
        this.underlineThickness = n;
    }

    public int getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setNotice(String string) {
        this.notice = string;
    }

    public String getNotice() {
        return this.notice;
    }

    public void setEncodingScheme(String string) {
        this.encodingScheme = string;
        if (string.equals("FontSpecific")) {
            this.encodingFontSpecific = true;
        }
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setCapHeight(int n) {
        this.capHeight = n;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public void setXHeight(int n) {
        this.xHeight = n;
    }

    public int getXHeight() {
        return this.xHeight;
    }

    public void setAscender(int n) {
        this.ascender = n;
    }

    public int getAscender() {
        return this.ascender;
    }

    public void setDescender(int n) {
        this.descender = n;
    }

    public int getDescender() {
        return this.descender;
    }

    public void setFullHeight(int n) {
        this.fullHeight = n;
    }

    public int getFullHeight() {
        return this.fullHeight;
    }

    public void setStdHW(int n) {
        this.stdHW = n;
    }

    public int getStdHW() {
        return this.stdHW;
    }

    public void setStdVW(int n) {
        this.stdVW = n;
    }

    public int getStdVW() {
        return this.stdVW;
    }

    public void setFontName(String string) {
        this.name = string;
    }

    public Hashtable getTrackKerning() {
        return this.trackKerning;
    }

    public Hashtable getCharMetrics() {
        return this.charMetrics;
    }

    public Hashtable getUnicodeCharMetrics() {
        return this.unicodeCharMetrics;
    }

    public CharMetricPS getCharMetric(char c) {
        CharMetricPS charMetricPS;
        if (this.usingTTF) {
            charMetricPS = this.getCharByCode(c);
        } else if (this.encodingFontSpecific) {
            charMetricPS = this.getCharByCode(c);
        } else if (c == '\u20ac') {
            c = (char)128;
            charMetricPS = this.getCharByName(char_names_iso_latin[c]);
            if (charMetricPS == null) {
                charMetricPS = this.getCharByName("zero");
            }
        } else if (c > '\u00ff') {
            String string = "Warning: character 0x" + Integer.toHexString(c) + " oustide ISO-Latin1 range -- substituting metrics";
            System.err.println(string);
            charMetricPS = null;
        } else {
            charMetricPS = this.getCharByName(char_names_iso_latin[c]);
        }
        if (charMetricPS == null) {
            charMetricPS = this.usingTTF ? this.getCharByCode(32) : this.getCharByName("space");
        }
        return charMetricPS;
    }

    public CharMetricPS getCharByCode(int n) {
        CharMetricPS charMetricPS;
        block5: {
            block4: {
                charMetricPS = null;
                if (!this.usingTTF) break block4;
                charMetricPS = (CharMetricPS)this.unicodeCharMetrics.get(new Integer(n));
                if (charMetricPS != null) break block5;
                charMetricPS = this.ttfParser.createCharMetric(n);
                if (charMetricPS == null) {
                    charMetricPS = this.ttfParser.createCharMetricFromGlyph(0);
                    if (charMetricPS != null) {
                        charMetricPS.setCode(n);
                    } else {
                        charMetricPS = this.ttfParser.createEmptyCharMetric(n);
                    }
                }
                this.unicodeCharMetrics.put(new Integer(n), charMetricPS);
                break block5;
            }
            Enumeration enumeration = this.getCharMetrics().elements();
            while (enumeration.hasMoreElements()) {
                CharMetricPS charMetricPS2 = (CharMetricPS)enumeration.nextElement();
                if (charMetricPS2.getCode() != n) continue;
                charMetricPS = charMetricPS2;
                break;
            }
        }
        return charMetricPS == null ? this.getCharByName("space") : charMetricPS;
    }

    public CharMetricPS getCharByName(String string) {
        return (CharMetricPS)this.getCharMetrics().get(string);
    }

    public static Font[] getAllFonts(FontParser fontParser, String string, String string2, String string3) {
        boolean bl = loaded;
        FontPS.getAllFonts();
        FontPS.getFontBundles(defaultFontMap, string3);
        loaded = bl;
        Hashtable hashtable = new Hashtable();
        Font[] fontArray = FontBase.getFonts(fontParser, string, string2, hashtable, loaded);
        int n = 0;
        while (n < fontArray.length) {
            FontLibrary.availableFonts[0].put(fontArray[n].getName(), fakeUserFontLookup);
            fonts.put(fontArray[n].getName(), fontArray[n]);
            ++n;
        }
        FontLibrary.addFontNameMap(userFontBundle, 0);
        loaded = true;
        return fontArray;
    }

    public static Font[] getAllFonts() {
        AFMParser aFMParser = new AFMParser();
        FontPS.getFontBundles(defaultFontMap, defaultFontMap);
        Font[] fontArray = FontBase.getFonts(aFMParser, defaultJarLocation, defaultFileExtension, fonts, loaded);
        if (FontLibrary.availableStockFonts[0] == null) {
            FontLibrary.availableStockFonts[0] = new Hashtable();
        }
        int n = 0;
        while (n < fontArray.length) {
            FontLibrary.availableStockFonts[0].put(fontArray[n].getName(), fakeStockFontLookup);
            ++n;
        }
        FontLibrary.stockFontNameMapBundles[0] = defaultFontBundle;
        loaded = true;
        return fontArray;
    }

    public static Font getNativeFont(Font font) {
        String string = font.getName();
        int n = font.getStyle();
        int n2 = font.getSize();
        Font font2 = FontPS.decode(FontBase.getDecodeString(string, n, n2));
        return font2;
    }

    protected static void getFontBundles(String string, String string2) {
        try {
            userFontBundle = ResourceBundle.getBundle(string2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            defaultFontBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.toString());
        }
    }

    static {
        fakeUserFontLookup = new FontFileLookup();
        fakeStockFontLookup = new FontFileLookup();
        char_names_iso_latin = new String[]{"space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "minus", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "space", "Euro", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "space", "dotlessi", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "space", "ring", "cedilla", "space", "hungarumlaut", "ogonek", "caron", "space", "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"};
    }
}

