/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.LineMetricsPS;
import com.klg.jclass.page.adobe.postscript.PairKern;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.LineMetrics;
import java.text.CharacterIterator;

public class FontMetricsPS
extends FontMetrics {
    public static int AFM_DIVISOR = 1000;

    public FontMetricsPS(FontPS fontPS) {
        super(fontPS);
        if (!(fontPS instanceof FontPS)) {
            throw new IllegalArgumentException("font must be instance of FontPS");
        }
    }

    public int getAscent() {
        return (int)this.getAscender(JCUnit.POINTS, this.font.getSize());
    }

    public int getDescent() {
        return (int)(-this.getDescender(JCUnit.POINTS, this.font.getSize()));
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public int charWidth(char c) {
        return (int)(this.preciseCharWidth(c) + 0.5);
    }

    protected double preciseCharWidth(char c) {
        CharMetricPS charMetricPS = ((FontPS)this.font).getCharMetric(c);
        int n = charMetricPS == null ? 0 : charMetricPS.getWx();
        return FontMetricsPS.asPoints(n, this.font.getSize());
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        double d = 0.0;
        int n3 = n;
        while (n3 < n2) {
            d += this.preciseCharWidth(cArray[n3]);
            ++n3;
        }
        return (int)(d + 0.5);
    }

    public LineMetrics getLineMetrics(String string, Graphics graphics) {
        return new LineMetricsPS(this, string);
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, Graphics graphics) {
        return new LineMetricsPS(this, string.substring(n, n2));
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, Graphics graphics) {
        return new LineMetricsPS(this, new String(cArray, n, n2));
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, Graphics graphics) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = characterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = characterIterator.next();
        }
        String string = stringBuffer.toString().substring(n, n2);
        return new LineMetricsPS(this, string);
    }

    public double getHeight(JCUnit jCUnit, int n) {
        int n2 = ((FontPS)this.font).getAscender();
        int n3 = ((FontPS)this.font).getDescender();
        double d = FontMetricsPS.asPoints(n2 - n3, n);
        return FontMetricsPS.convertFromPoints(jCUnit, d);
    }

    public double getXHeight(JCUnit jCUnit, int n) {
        double d = FontMetricsPS.asPoints(((FontPS)this.font).getXHeight(), n);
        return FontMetricsPS.convertFromPoints(jCUnit, d);
    }

    public double getAscender(JCUnit jCUnit, int n) {
        double d = FontMetricsPS.asPoints(((FontPS)this.font).getAscender(), n);
        return FontMetricsPS.convertFromPoints(jCUnit, d);
    }

    public double getDescender(JCUnit jCUnit, int n) {
        double d = FontMetricsPS.asPoints(((FontPS)this.font).getDescender(), n);
        return FontMetricsPS.convertFromPoints(jCUnit, d);
    }

    public static double asPoints(double d, int n) {
        return d * (double)n / (double)AFM_DIVISOR;
    }

    protected static double convertFromPoints(JCUnit jCUnit, double d) {
        double d2 = 0.0;
        if (jCUnit == JCUnit.POINTS) {
            d2 = d;
        } else if (jCUnit == JCUnit.INCHES) {
            d2 = JCUnit.getAsInches(JCUnit.POINTS, d);
        } else if (jCUnit == JCUnit.CM) {
            d2 = JCUnit.getAsCentimeters(JCUnit.POINTS, d);
        } else {
            throw new IllegalArgumentException("Unknown units " + jCUnit);
        }
        return d2;
    }

    public double charWidth(JCUnit jCUnit, int n, char c) {
        CharMetricPS charMetricPS = ((FontPS)this.font).getCharMetric(c);
        double d = 0.0;
        if (charMetricPS != null) {
            d = FontMetricsPS.asPoints(charMetricPS.getWx(), n);
        }
        return FontMetricsPS.convertFromPoints(jCUnit, d);
    }

    public double stringWidth(JCUnit jCUnit, int n, String string) {
        double d = 0.0;
        CharMetricPS charMetricPS = null;
        int n2 = 0;
        while (n2 < string.length()) {
            PairKern pairKern;
            CharMetricPS charMetricPS2 = ((FontPS)this.font).getCharMetric(string.charAt(n2));
            d += (double)charMetricPS2.getWx();
            if (charMetricPS != null && (pairKern = charMetricPS.getKernByName(charMetricPS2.getName())) != null) {
                d += (double)pairKern.xAmount;
            }
            charMetricPS = charMetricPS2;
            ++n2;
        }
        double d2 = FontMetricsPS.asPoints(d, n);
        return FontMetricsPS.convertFromPoints(jCUnit, d2);
    }

    public double getLeadingSpace(JCUnit jCUnit, int n, String string) {
        CharMetricPS charMetricPS = ((FontPS)this.font).getCharMetric(string.charAt(0));
        double d = 0.0;
        if (charMetricPS != null && charMetricPS.getCharBBox().llx < 0) {
            d = -charMetricPS.getCharBBox().llx;
            d = FontMetricsPS.asPoints(d, n);
        }
        return FontMetricsPS.convertFromPoints(jCUnit, d);
    }

    public double getTrailingSpace(JCUnit jCUnit, int n, String string) {
        int n2 = string.length() - 1;
        CharMetricPS charMetricPS = ((FontPS)this.font).getCharMetric(string.charAt(n2));
        double d = 0.0;
        if (charMetricPS != null && charMetricPS.getCharBBox().llx < 0) {
            d = -charMetricPS.getCharBBox().llx;
            d = FontMetricsPS.asPoints(d, n);
        }
        return FontMetricsPS.convertFromPoints(jCUnit, d);
    }
}

