/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.pdf;

import com.klg.jclass.page.FontLibrary;
import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.PrintException;
import com.klg.jclass.page.TrueTypeFontProperties;
import com.klg.jclass.page.adobe.pdf.AcroFontEntry;
import com.klg.jclass.page.adobe.pdf.Ascii85OutputStream;
import com.klg.jclass.page.adobe.pdf.Graphics2DPDF;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.util.SeqRangeCollector;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.zip.DeflaterOutputStream;
import javax.swing.tree.DefaultMutableTreeNode;

public class JCPDFPrinter
extends JCPrinter {
    protected int objectNumber;
    protected int rootPagesReference;
    protected int totalPageCount = 0;
    protected int pagesReference;
    protected int currentPageObjectNumber = -1;
    protected int encodingObj;
    protected int graphicsDictionaryObj;
    protected Vector pageList = new Vector();
    protected Vector pagesList = new Vector();
    protected Vector contentsList = new Vector();
    protected Vector annotationList = new Vector();
    protected Hashtable fontList = new Hashtable();
    protected Rectangle2D bounds = new Rectangle2D.Double();
    protected Rectangle2D oldPageSize = null;
    protected Rectangle2D currentPageSize = null;
    protected boolean docOpen = false;
    protected WeakHashMap imageCache = new WeakHashMap();
    protected Vector docImageList = new Vector();
    protected boolean useAutoStrokeAdjustment = true;
    protected int drawJavaComponentObjectNumber = -1;
    protected int drawJavaComponentLengthObjectNumber = -1;
    protected int drawJavaComponentResourcesObjectNumber = -1;
    protected boolean drawingJavaComponent = false;
    protected Vector annotationRectangles = new Vector();
    protected Vector hyperlinkInfoList = new Vector();
    protected Hashtable hyperlinkObjects = new Hashtable();
    protected TreeMap annoInternalLocations = new TreeMap();
    protected Hashtable annoInternalPages = new Hashtable();
    protected StreamInfo streamInfo = new StreamInfo();
    protected Stack streamStack = new Stack();
    protected Vector pageXObjectReferences = new Vector();
    protected Vector pageXObjectStreams = new Vector();

    public JCPDFPrinter(OutputStream outputStream) {
        this.os = outputStream;
        this.streamInfo.os = outputStream;
        FontLibrary.initFontLibrary();
        FontPS.getAllFonts();
    }

    public JCPDFPrinter(OutputStream outputStream, FontParser fontParser, String string, String string2, String string3) {
        this.os = outputStream;
        FontLibrary.initFontLibrary();
        FontPS.getAllFonts(fontParser, string, string2, string3);
    }

    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(outputStream);
        this.streamInfo.os = outputStream;
    }

    public void setAutoStrokeAdjustment(boolean bl) {
        this.useAutoStrokeAdjustment = bl;
    }

    public boolean getAutoStrokeAdjustment() {
        return this.useAutoStrokeAdjustment;
    }

    public boolean isDocOpen() {
        return this.docOpen;
    }

    public void setup() {
    }

    public boolean isImageScalable() {
        return true;
    }

    public void openDocument(Rectangle2D rectangle2D) {
        super.openDocument(rectangle2D);
        this.totalPageCount = 0;
        this.streamInfo.openDocument();
        this.pageList.clear();
        this.pagesList.clear();
        this.contentsList.clear();
        this.annoInternalLocations.clear();
        this.annoInternalPages.clear();
        this.annotationRectangles.clear();
        this.hyperlinkInfoList.clear();
        this.hyperlinkObjects.clear();
        this.annotationList.clear();
        this.imageCache.clear();
        this.docImageList.clear();
        this.output("%PDF-1.4");
        byte[] byArray = new byte[]{37, -30, -29, -49, -45, 10};
        this.output(byArray);
        this.objectNumber = 0;
        ++this.objectNumber;
        this.rootPagesReference = this.objectNumber++;
        this.pagesReference = this.objectNumber;
        this.writeFontEncoding();
        this.encodingObj = this.objectNumber;
        this.writeDocGraphicsDictionary();
        this.graphicsDictionaryObj = this.objectNumber;
        this.docOpen = true;
    }

    public void closeDocument(Rectangle2D rectangle2D) {
        Comparable<Integer> comparable;
        Object object;
        Object object2;
        this.writePagesTree(rectangle2D);
        Graphics2DPDF graphics2DPDF = (Graphics2DPDF)this.getGraphics();
        boolean bl = !this.annoInternalLocations.isEmpty();
        int n = -1;
        int n2 = -1;
        if (bl) {
            Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
            Iterator iterator = this.annoInternalLocations.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (Point2D.Double)this.annoInternalLocations.get(object2);
                comparable = (Integer)this.annoInternalPages.get(object2);
                this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
                hashtable.put(object2, new Integer(this.objectNumber));
                this.output(this.objectNumber + " 0 obj");
                this.output("[ " + (Integer)comparable + " 0 R /XYZ " + graphics2DPDF.truncateDecimalDigits(((Point2D.Double)object).getX()) + " " + graphics2DPDF.truncateDecimalDigits(((Point2D.Double)object).getY()) + " 0 ]");
                this.output("endobj");
            }
            n = ++this.objectNumber;
            this.storeObjectReference(n, this.getCurrentOffset());
            this.output(n + " 0 obj\n<<");
            this.output("/Names [");
            iterator = this.annoInternalLocations.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (Integer)hashtable.get(object2);
                this.output("(" + (String)object2 + ") " + (Integer)object + " 0 R");
            }
            this.output("]");
            this.output(">> \nendobj");
            n2 = ++this.objectNumber;
            this.storeObjectReference(n2, this.getCurrentOffset());
            this.output(n2 + " 0 obj\n<<");
            this.output("/Dests " + n + " 0 R");
            this.output(">> \nendobj");
        }
        this.annoInternalLocations.clear();
        this.annoInternalPages.clear();
        boolean bl2 = false;
        int n3 = -1;
        if (this.bookmarkTree != null) {
            bl2 = true;
            n3 = ++this.objectNumber;
            this.outputBookmarkTree((DefaultMutableTreeNode)this.bookmarkTree.getRoot(), n3);
        }
        object2 = this.fontList.elements();
        while (object2.hasMoreElements()) {
            object = (AcroFontEntry)object2.nextElement();
            this.writeFontDescription((AcroFontEntry)object);
        }
        this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
        int n4 = this.objectNumber;
        this.output(this.objectNumber + " 0 obj\n<<");
        this.output("/Type /Catalog");
        this.output("/Pages " + this.rootPagesReference + " 0 R");
        if (bl) {
            this.output("/Names " + n2 + " 0 R");
        }
        if (bl2) {
            this.output("/Outlines " + n3 + " 0 R");
            if (this.isBookmarkTreeVisible()) {
                this.output("/PageMode /UseOutlines");
            }
        }
        this.output(">> \nendobj");
        this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
        int n5 = this.objectNumber;
        this.output(this.objectNumber + " 0 obj\n<<");
        this.output("/Creator (Quest Software's PageLayout 6.3.0)");
        object = new GregorianCalendar();
        comparable = new StringBuffer("/CreationDate (D:");
        ((StringBuffer)comparable).append(((Calendar)object).get(1));
        ((StringBuffer)comparable).append(((Calendar)object).get(2));
        ((StringBuffer)comparable).append(((Calendar)object).get(5));
        ((StringBuffer)comparable).append(((Calendar)object).get(10));
        ((StringBuffer)comparable).append(((Calendar)object).get(12));
        ((StringBuffer)comparable).append(((Calendar)object).get(13));
        ((StringBuffer)comparable).append(") ");
        this.output(((StringBuffer)comparable).toString());
        this.output(">> \nendobj");
        long l = this.streamInfo.fileOffset;
        this.output("xref");
        this.output("0 " + (this.objectNumber + 1) + "\n0000000000 65535 f ");
        Collections.sort(this.streamInfo.referenceList);
        int n6 = 0;
        while (n6 < this.objectNumber) {
            AcroReference acroReference = (AcroReference)this.streamInfo.referenceList.elementAt(n6);
            this.output(this.pad10(acroReference.offset) + " 00000 n ");
            ++n6;
        }
        this.output("trailer\n<<\n/Size " + (this.objectNumber + 1));
        this.output("/Root " + n4 + " 0 R");
        this.output("/Info " + n5 + " 0 R");
        this.output(">>");
        this.output("startxref\n" + l + "\n%%EOF");
        super.closeDocument(rectangle2D);
        this.graphics.dispose();
        this.graphics = null;
        this.fontList.clear();
        this.docOpen = false;
    }

    protected void outputBookmarkTree(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
    }

    public void beginPage(Rectangle2D rectangle2D, int n) {
        super.beginPage(rectangle2D, n);
        if (this.pageChanged(rectangle2D)) {
            this.writePagesObject(this.pagesReference, this.pageList, this.rootPagesReference, this.oldPageSize);
            this.pageList.clear();
            this.pagesList.add(new Integer(this.pagesReference));
            this.pagesReference = ++this.objectNumber;
            this.oldPageSize = (Rectangle2D)rectangle2D.clone();
        }
        this.streamInfo.beginPage();
        this.contentsList.clear();
        this.annotationList.clear();
        this.pageXObjectReferences.clear();
        this.pageXObjectStreams.clear();
        this.currentPageObjectNumber = ++this.objectNumber;
        this.currentPageSize = rectangle2D;
        this.beginPageStream();
        this.output("q");
        this.output("/GSDOC gs");
        StringBuffer stringBuffer = new StringBuffer("1 0 0 1 ");
        stringBuffer.append(rectangle2D.getX());
        stringBuffer.append(" ");
        stringBuffer.append(rectangle2D.getHeight() + rectangle2D.getY());
        stringBuffer.append(" cm");
        this.output(stringBuffer.toString());
        StringBuffer stringBuffer2 = new StringBuffer("0 0 ");
        stringBuffer2.append(rectangle2D.getWidth());
        stringBuffer2.append(" ");
        stringBuffer2.append(-rectangle2D.getHeight());
        stringBuffer2.append(" re W n");
        this.output(stringBuffer2.toString());
        this.bounds.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + rectangle2D.getX(), rectangle2D.getHeight() + rectangle2D.getY());
    }

    public void endPage(Rectangle2D rectangle2D) {
        int n;
        int n2;
        int n3 = 0;
        this.output("Q");
        this.endStream();
        Iterator iterator = this.streamInfo.patternList.iterator();
        while (iterator.hasNext()) {
            this.writePatternDescription((PatternInfo)iterator.next());
        }
        this.annotationRectangles.clear();
        this.hyperlinkInfoList.clear();
        this.createNecessaryFontObjects(this.streamInfo.fontList);
        this.storeObjectReference(this.currentPageObjectNumber, this.getCurrentOffset());
        this.pageList.add(new Integer(this.currentPageObjectNumber));
        this.output(this.currentPageObjectNumber + " 0 obj\n<<\n/Type /Page");
        String string = "/CropBox [ " + this.bounds.getX() + " " + this.bounds.getY() + " " + this.bounds.getWidth() + " " + this.bounds.getHeight() + " ] ";
        this.output(string);
        this.output("/Parent " + this.pagesReference + " 0 R");
        this.output("/Resources <<");
        this.writeResourcesDictionary();
        this.output(">>");
        n3 = this.contentsList.size();
        if (n3 > 0) {
            this.output("/Contents [");
            n2 = 0;
            while (n2 < n3) {
                n = (Integer)this.contentsList.elementAt(n2);
                this.output(n + " 0 R");
                ++n2;
            }
            this.output("]");
        }
        if ((n3 = this.annotationList.size()) > 0) {
            this.output("/Annots [");
            n2 = 0;
            while (n2 < n3) {
                n = (Integer)this.annotationList.elementAt(n2);
                this.output(n + " 0 R");
                ++n2;
            }
            this.output("]");
        }
        this.output(">>\nendobj");
        n2 = 0;
        while (n2 < this.pageXObjectStreams.size()) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.pageXObjectStreams.elementAt(n2);
            Vector vector = (Vector)this.pageXObjectReferences.elementAt(n2);
            long l = this.streamInfo.fileOffset;
            int n4 = byteArrayOutputStream.size();
            try {
                byteArrayOutputStream.writeTo(this.os);
                this.streamInfo.fileOffset += (long)n4;
                int n5 = 0;
                while (n5 < vector.size()) {
                    AcroReference acroReference = (AcroReference)vector.elementAt(n5);
                    acroReference.offset += l;
                    this.streamInfo.referenceList.addElement(acroReference);
                    ++n5;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ++n2;
        }
        super.endPage(rectangle2D);
    }

    protected void writeResourcesDictionary() {
        int n;
        int n2;
        int n3 = this.streamInfo.xObjectList.size();
        if (n3 > 0) {
            this.output("/XObject <<");
            n2 = 0;
            while (n2 < n3) {
                n = (Integer)this.streamInfo.xObjectList.elementAt(n2);
                int n4 = (Integer)this.streamInfo.imageList.elementAt(n2);
                String string = "/Im" + n4 + " " + n + " " + "0 R";
                this.output(string);
                ++n2;
            }
            this.output(">>");
        }
        if ((n3 = this.streamInfo.colorSpaceList.size()) > 0) {
            this.output("/ColorSpace <<");
            n2 = 0;
            while (n2 < n3) {
                n = (Integer)this.streamInfo.colorSpaceList.elementAt(n2);
                String string = "/CS" + n2 + " " + n + " " + " 0 R";
                this.output(string);
                ++n2;
            }
            this.output(">>");
        }
        this.writeResourcesFontList(this.streamInfo.fontList);
        this.writeResourcesPatternList();
        this.output("/ExtGState << /GSDOC " + this.graphicsDictionaryObj + " 0 R >>");
        StringBuffer stringBuffer = new StringBuffer("/ProcSet [ /PDF ");
        if (this.streamInfo.textPresent) {
            stringBuffer.append(" /Text ");
        }
        if (this.streamInfo.imagePresent) {
            stringBuffer.append(" /ImageC ");
        }
        if (this.streamInfo.maskPresent) {
            stringBuffer.append(" /ImageB ");
        }
        if (this.streamInfo.indexImage) {
            stringBuffer.append(" /ImageI ");
        }
        stringBuffer.append("]");
        this.output(stringBuffer.toString());
    }

    protected void createNecessaryFontObjects(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            AcroFontEntry acroFontEntry = (AcroFontEntry)this.fontList.get(string);
            if (acroFontEntry.usingAnsi && acroFontEntry.number == -1) {
                acroFontEntry.number = ++this.objectNumber;
            }
            if (!acroFontEntry.usingUnicode || acroFontEntry.unicodeNumber != -1) continue;
            acroFontEntry.unicodeNumber = ++this.objectNumber;
        }
    }

    protected void writeResourcesFontList(Hashtable hashtable) {
        if (hashtable.size() > 0) {
            this.output("/Font <<");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                AcroFontEntry acroFontEntry = (AcroFontEntry)this.fontList.get(string2);
                String string3 = "";
                if (!string.endsWith("-Unicode") && acroFontEntry.usingAnsi) {
                    string3 = "/" + acroFontEntry.abbrev + " " + acroFontEntry.number + " " + "0 R";
                    this.output(string3);
                }
                if (!string.endsWith("-Unicode") || !acroFontEntry.usingUnicode) continue;
                string3 = "/" + acroFontEntry.abbrev + "U " + acroFontEntry.unicodeNumber + " " + "0 R";
                this.output(string3);
            }
            this.output(">>");
        }
    }

    protected void writeResourcesPatternList() {
        if (this.streamInfo.patternList.size() > 0) {
            this.output("/Pattern <<");
            Iterator iterator = this.streamInfo.patternList.iterator();
            while (iterator.hasNext()) {
                PatternInfo patternInfo = (PatternInfo)iterator.next();
                this.output(patternInfo.patternName + " " + patternInfo.patternObjectNumber + " 0 R");
            }
            this.output(">>");
        }
    }

    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.graphics = new Graphics2DPDF(this.os, this);
            ((Graphics2DBase)this.graphics).setFrameRoot();
        }
        return this.graphics;
    }

    public boolean supportsHyperlinks() {
        return false;
    }

    private int getXObjectNumber(int n) {
        int n2 = this.streamInfo.imageList.indexOf(new Integer(n));
        if (n2 < 0 || n2 >= this.streamInfo.xObjectList.size()) {
            return -1;
        }
        return (Integer)this.streamInfo.xObjectList.elementAt(n2);
    }

    protected void writePatternDescription(PatternInfo patternInfo) {
        int n;
        BufferedImage bufferedImage = patternInfo.img;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        double d = 11.0;
        double d2 = d * (double)n2 / (double)n3;
        Integer n4 = (Integer)this.imageCache.get(bufferedImage);
        if (n4 != null && (n = n4.intValue()) >= 0) {
            String string = "/Im" + n;
            int n5 = this.getXObjectNumber(n);
            if (n5 >= 0) {
                String string2 = "/Type /Pattern\n/PatternType 1\n/Name " + patternInfo.patternName + "\n" + "/PaintType 1\n" + "/TilingType 1\n" + "/Matrix [ " + d2 + " 0 0 " + d + " 0 0 ]\n" + "/BBox [ 0 0 " + n2 + " " + n3 + " ]\n" + "/Resources <<\n" + "/ProcSet [ /PDF /Text /ImageC ]\n" + "/XObject << " + string + " " + n5 + " 0 R >>\n" + ">>\n" + "/XStep 1\n" + "/YStep 1";
                String string3 = "q " + string + " Do Q";
                patternInfo.patternObjectNumber = ++this.objectNumber;
                if (this.compressed) {
                    this.writeCompressedStreamObject(patternInfo.patternObjectNumber, string3.getBytes(), string2);
                } else {
                    this.writeUncompressedStreamObject(patternInfo.patternObjectNumber, string3, string2);
                }
            }
        }
    }

    protected void writeFontDescription(AcroFontEntry acroFontEntry) {
        int n;
        int n2;
        int n3;
        Serializable serializable;
        int n4 = 256;
        int n5 = -1;
        int[] nArray = new int[256];
        int n6 = -1;
        int n7 = -1;
        CharMetricPS charMetricPS = null;
        if (acroFontEntry.usingAnsi && acroFontEntry.number == -1) {
            acroFontEntry.number = ++this.objectNumber;
        }
        if (acroFontEntry.usingUnicode && acroFontEntry.unicodeNumber == -1) {
            acroFontEntry.unicodeNumber = ++this.objectNumber;
        }
        String string = "";
        if (acroFontEntry.embeddingRules != 0) {
            serializable = new Random();
            string = "";
            int n8 = 0;
            while (n8 < 6) {
                string = string + (char)(((Random)serializable).nextInt(26) + 65);
                ++n8;
            }
            string = string + '+';
        }
        if (acroFontEntry.usingTTF) {
            serializable = new StringBuffer();
            char[] cArray = acroFontEntry.name.toCharArray();
            n3 = 0;
            while (n3 < cArray.length) {
                if (cArray[n3] != ' ') {
                    ((StringBuffer)serializable).append(cArray[n3]);
                }
                ++n3;
            }
            string = string + ((StringBuffer)serializable).toString();
        } else {
            string = string + acroFontEntry.name.replace(' ', '_');
        }
        serializable = acroFontEntry.font;
        if (acroFontEntry.usingAnsi) {
            this.storeObjectReference(acroFontEntry.number, this.getCurrentOffset());
            this.output(acroFontEntry.number + " 0 obj\n<<");
            if (acroFontEntry.usingTTF) {
                this.output("/Type /Font\n/Subtype /TrueType");
            } else {
                this.output("/Type /Font\n/Subtype /Type1");
            }
            String string2 = "/Name /" + acroFontEntry.abbrev + "\n/BaseFont /" + string;
            this.output(string2);
            if (!acroFontEntry.usingTTF) {
                this.output("/Encoding " + this.encodingObj + " 0 R");
            } else {
                this.output("/Encoding /WinAnsiEncoding");
            }
            if (!acroFontEntry.usingTTF && this.isBaseFont(acroFontEntry.name)) {
                this.output(">>\nendobj");
                return;
            }
            n6 = ++this.objectNumber;
            this.output("/FontDescriptor " + n6 + " 0 R");
            charMetricPS = ((FontPS)serializable).getCharMetric(' ');
            n3 = charMetricPS.getWx();
            n2 = 0;
            while (n2 < 256) {
                nArray[n2] = n3;
                ++n2;
            }
            if (((FontPS)serializable).isFixedPitch()) {
                n5 = n4 = ((Integer)acroFontEntry.ansiCharactersUsed.first()).intValue();
                charMetricPS = ((FontPS)serializable).getCharByCode(n4);
                nArray[n4] = charMetricPS.getWx();
            } else {
                n4 = (Integer)acroFontEntry.ansiCharactersUsed.first();
                n5 = (Integer)acroFontEntry.ansiCharactersUsed.last();
                if (n5 > 255) {
                    n5 = 255;
                }
                Iterator iterator = acroFontEntry.ansiCharactersUsed.iterator();
                while (iterator.hasNext()) {
                    int n9 = (Integer)iterator.next();
                    if (n9 < 0 || n9 > 255) continue;
                    charMetricPS = n9 == 128 && acroFontEntry.usingTTF ? ((FontPS)serializable).getCharByCode(8364) : ((FontPS)serializable).getCharByCode(n9);
                    nArray[n9] = charMetricPS.getWx();
                }
            }
            this.output("/FirstChar " + n4);
            this.output("/LastChar " + n5);
            this.output("/Widths " + (this.objectNumber + 1) + " 0 R");
            this.output(">>\nendobj");
            this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
            this.output(this.objectNumber + " 0 obj");
            this.output("[");
            n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            int n10 = n4;
            while (n10 <= n5) {
                stringBuffer.append(nArray[n10]);
                if (++n % 16 == 0) {
                    this.output(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                } else {
                    stringBuffer.append(" ");
                }
                ++n10;
            }
            this.output(stringBuffer.toString());
            this.output("]");
            this.output("endobj");
        }
        if (acroFontEntry.usingTTF && acroFontEntry.usingUnicode) {
            this.storeObjectReference(acroFontEntry.unicodeNumber, this.getCurrentOffset());
            this.output(acroFontEntry.unicodeNumber + " 0 obj\n<<");
            this.output("/Type /Font\n/Subtype /Type0");
            this.output("/Name /" + acroFontEntry.abbrev + "U");
            this.output("/BaseFont /" + string);
            this.output("/Encoding /Identity-H");
            ++this.objectNumber;
            int n11 = this.objectNumber++;
            this.output("/DescendantFonts [ " + n11 + " 0 R ]");
            n3 = -1;
            if (acroFontEntry.includeUnicodeMap) {
                n3 = this.objectNumber;
                this.output("/ToUnicode " + n3 + " 0 R");
            }
            this.output(">>\nendobj");
            this.storeObjectReference(n11, this.getCurrentOffset());
            this.output(n11 + " 0 obj\n<<");
            this.output("/Type /Font\n/Subtype /CIDFontType2");
            this.output("/BaseFont /" + string);
            ++this.objectNumber;
            n2 = this.objectNumber++;
            n7 = this.objectNumber;
            this.output("/CIDSystemInfo " + n2 + " 0 R");
            this.output("/FontDescriptor " + n7 + " 0 R");
            if (((FontPS)serializable).isFixedPitch()) {
                n = (Integer)acroFontEntry.unicodeCharactersUsed.first();
                this.output("/DW " + ((FontPS)serializable).ttfParser.getGlyphWidthByGlyphCode(n));
            } else {
                Integer n12;
                Integer n13;
                n = -1;
                if (acroFontEntry.unicodeWidths.size() <= acroFontEntry.unicodeCharactersUsed.size() / 2) {
                    int n14 = -1;
                    Enumeration enumeration = acroFontEntry.unicodeWidths.keys();
                    while (enumeration.hasMoreElements()) {
                        n13 = (Integer)enumeration.nextElement();
                        n12 = (Integer)acroFontEntry.unicodeWidths.get(n13);
                        if (n12 <= n14) continue;
                        n = n13;
                        n14 = n12;
                    }
                }
                if (n >= 0) {
                    this.output("/DW " + n);
                }
                this.output("/W [");
                Iterator iterator = acroFontEntry.unicodeCharactersUsed.iterator();
                Integer n15 = null;
                n13 = null;
                n12 = null;
                Integer n16 = null;
                int n17 = -1;
                int n18 = -1;
                boolean bl = false;
                while (iterator.hasNext() || n15 != null) {
                    if (iterator.hasNext()) {
                        n13 = (Integer)iterator.next();
                        n17 = ((FontPS)serializable).ttfParser.getGlyphWidthByGlyphCode(n13);
                        if (n >= 0 && n17 == n) {
                            if (n15 == null) {
                                n17 = -1;
                                continue;
                            }
                            n13 = null;
                            bl = true;
                        } else if (n15 == null) {
                            n15 = n13;
                            n12 = n13;
                            n16 = n13;
                            n18 = n17;
                        } else if (n13 == n12 + 1) {
                            if (n17 == n18) {
                                n12 = n13;
                            } else if (n12 - n16 >= 2) {
                                bl = true;
                            } else {
                                n12 = n13;
                                n16 = n13;
                                n18 = n17;
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        n13 = null;
                        bl = true;
                    }
                    if (!bl) continue;
                    if (n12 - n16 >= 2) {
                        if (n15 < n16) {
                            this.writeCharRangeDiffWidth((FontPS)serializable, n15, n16 - 1);
                        }
                        this.writeCharRangeSameWidth((FontPS)serializable, n16, n12);
                    } else {
                        this.writeCharRangeDiffWidth((FontPS)serializable, n15, n12);
                    }
                    bl = false;
                    n15 = n13;
                    n16 = n13;
                    n18 = n17;
                    n12 = n15;
                }
                this.output("]");
            }
            this.output(">>\nendobj");
            this.storeObjectReference(n2, this.getCurrentOffset());
            this.output(n2 + " 0 obj\n<<");
            this.output("/Type /CIDSystemInfo");
            this.output("/Registry (Adobe)");
            this.output("/Ordering (Identity)");
            this.output("/Supplement 0");
            this.output(">>\nendobj");
            if (acroFontEntry.includeUnicodeMap) {
                this.writeToUnicodeCMap(n3, acroFontEntry, (FontPS)serializable);
            }
        }
        if (n6 >= 0) {
            this.writeFontDescriptor(n6, acroFontEntry, (FontPS)serializable, string);
        }
        if (n7 >= 0) {
            this.writeFontDescriptor(n7, acroFontEntry, (FontPS)serializable, string);
        }
        if (acroFontEntry.embeddingRules != 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (acroFontEntry.embeddingRules == 2) {
                ((FontPS)serializable).ttfParser.writeFont(byteArrayOutputStream);
            } else if (acroFontEntry.embeddingRules == 1) {
                ((FontPS)serializable).ttfParser.writeReducedFont(byteArrayOutputStream, acroFontEntry.usingAnsi ? acroFontEntry.ansiCharactersUsed : null, acroFontEntry.usingUnicode ? acroFontEntry.unicodeCharactersUsed : null);
            }
            n3 = ++this.objectNumber;
            this.writeCompressedStreamObject(n3, byteArrayOutputStream, "/Length1 " + byteArrayOutputStream.size());
        }
    }

    protected void writeFontDescriptor(int n, AcroFontEntry acroFontEntry, FontPS fontPS, String string) {
        CharMetricPS charMetricPS = null;
        int n2 = 0;
        this.storeObjectReference(n, this.getCurrentOffset());
        this.output(n + " 0 obj\n<<");
        this.output("/Type /FontDescriptor");
        this.output("/Ascent " + fontPS.getAscender());
        this.output("/CapHeight " + fontPS.getCapHeight());
        this.output("/Descent " + fontPS.getDescender());
        if (acroFontEntry.usingAnsi && fontPS.isFixedPitch()) {
            int n3 = (Integer)acroFontEntry.ansiCharactersUsed.first();
            charMetricPS = fontPS.getCharByCode(n3);
            this.output("/MissingWidth " + charMetricPS.getWx());
        }
        if (fontPS.isFixedPitch()) {
            n2 |= 1;
        }
        if (fontPS.isSerif()) {
            n2 |= 2;
        }
        n2 = fontPS.getName().equals("Symbol") || fontPS.getName().equals("ZapfDingbats") || !fontPS.getEncodingScheme().equals("AdobeStandardEncoding") && !fontPS.getEncodingScheme().equals("Unicode") ? (n2 |= 4) : (n2 |= 0x20);
        if (Math.abs(fontPS.getItalicAngle()) > 4.0f) {
            n2 |= 0x40;
        }
        this.output("/Flags " + (n2 |= 0x40000));
        String string2 = "/FontBBox [ " + fontPS.getFontBBox().llx + " " + fontPS.getFontBBox().lly + " " + fontPS.getFontBBox().urx + " " + fontPS.getFontBBox().ury + " ]";
        this.output(string2);
        this.output("/FontName /" + string);
        this.output("/ItalicAngle " + (int)fontPS.getItalicAngle());
        double d = fontPS.getStdVW();
        if (d <= 0.0) {
            charMetricPS = fontPS.getCharMetric('!');
            d = charMetricPS.getCharBBox().urx - charMetricPS.getCharBBox().llx;
            if (fontPS.getItalicAngle() != 0.0f) {
                d -= (double)(charMetricPS.getCharBBox().ury - charMetricPS.getCharBBox().lly) * Math.tan(fontPS.getItalicAngle());
            }
            d -= 4.0;
        }
        this.output("/StemV " + (int)d);
        if (acroFontEntry.embeddingRules != 0) {
            this.output("/FontFile2 " + (this.objectNumber + 1) + " 0 R");
        }
        this.output(">>\nendobj");
    }

    protected void writeToUnicodeCMap(int n, AcroFontEntry acroFontEntry, FontPS fontPS) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/CIDInit /ProcSet findresource begin\n");
        stringBuffer.append("12 dict begin\n");
        stringBuffer.append("begincmap\n");
        stringBuffer.append("/CIDSystemInfo\n");
        stringBuffer.append("<< /Registry (Adobe)\n");
        stringBuffer.append("/Ordering (UCS)\n");
        stringBuffer.append("/Supplement 0\n");
        stringBuffer.append(">> def\n");
        stringBuffer.append("/CMapName /Adobe-Identity-UCS def\n");
        stringBuffer.append("/CMapType 2 def\n");
        stringBuffer.append("1 begincodespacerange\n");
        stringBuffer.append("<0001> <FFFF>\n");
        stringBuffer.append("endcodespacerange\n");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        SeqRangeCollector seqRangeCollector = new SeqRangeCollector();
        seqRangeCollector.setRangeBreak(1);
        Iterator iterator = acroFontEntry.unicodeCharactersUsed.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            seqRangeCollector.addItem(n2);
        }
        seqRangeCollector.done();
        List list = seqRangeCollector.getRanges();
        int n3 = 0;
        while (n3 < list.size()) {
            SeqRangeCollector.Range range = (SeqRangeCollector.Range)list.get(n3);
            if (range.end - range.start > 1) {
                int n4;
                List list2;
                object = new SeqRangeCollector();
                int n5 = range.start;
                while (n5 <= range.end) {
                    list2 = fontPS.ttfParser.glyphCodeToUnicodes(n5);
                    if (list2 != null && list2.size() != 0) {
                        n4 = (Integer)list2.get(0);
                        ((SeqRangeCollector)object).addItem(n4);
                    }
                    ++n5;
                }
                ((SeqRangeCollector)object).done();
                list2 = ((SeqRangeCollector)object).getRanges();
                n4 = 0;
                int n6 = 0;
                while (n6 < list2.size()) {
                    SeqRangeCollector.Range range2 = (SeqRangeCollector.Range)list2.get(n6);
                    if (range2.end - range2.start > 1) {
                        vector.add("<" + this.formatHexString(range.start + n4, 4) + "> <" + this.formatHexString(range.start + n4 + range2.size - 1, 4) + "> <" + this.formatHexString(range2.start, 4) + ">\n");
                        n4 += range2.size;
                    } else {
                        StringBuffer stringBuffer2 = new StringBuffer();
                        stringBuffer2.append("<");
                        stringBuffer2.append(this.formatHexString(range.start + n4, 4));
                        stringBuffer2.append("> ");
                        StringBuffer stringBuffer3 = new StringBuffer();
                        int n7 = 0;
                        SeqRangeCollector.Range range3 = range2;
                        while (n6 < list2.size() && range3.end - range3.start <= 1) {
                            int n8 = range3.start;
                            while (n8 <= range3.end) {
                                stringBuffer3.append("<");
                                stringBuffer3.append(this.formatHexString(n8, 4));
                                stringBuffer3.append(">");
                                stringBuffer3.append(" ");
                                ++n7;
                                ++n8;
                            }
                            if (++n6 >= list2.size()) continue;
                            range3 = (SeqRangeCollector.Range)list2.get(n6);
                        }
                        --n6;
                        stringBuffer2.append("<");
                        stringBuffer2.append(this.formatHexString(range.start + n4 + n7 - 1, 4));
                        n4 += n7;
                        stringBuffer2.append("> ");
                        stringBuffer2.append("[ ");
                        while (stringBuffer3.length() > 49) {
                            stringBuffer2.append(stringBuffer3.substring(0, 49));
                            stringBuffer2.append("\n");
                            stringBuffer2.append("                ");
                            stringBuffer3 = new StringBuffer(stringBuffer3.substring(49));
                        }
                        stringBuffer2.append(stringBuffer3.toString());
                        stringBuffer2.append("]\n");
                        vector.add(stringBuffer2.toString());
                    }
                    ++n6;
                }
            } else {
                int n9 = range.start;
                while (n9 <= range.end) {
                    List list3 = fontPS.ttfParser.glyphCodeToUnicodes(n9);
                    if (list3 != null && list3.size() != 0) {
                        vector2.add("<" + this.formatHexString(n9, 4) + "> <" + this.formatHexString((Integer)list3.get(0), 4) + ">\n");
                    }
                    ++n9;
                }
            }
            ++n3;
        }
        int n10 = 0;
        while (n10 * 100 < vector.size()) {
            int n11 = Math.min(vector.size() - n10 * 100, 100);
            stringBuffer.append("" + n11 + " beginbfrange\n");
            int n12 = 0;
            while (n12 < n11) {
                stringBuffer.append((String)vector.get(n10 * 100 + n12));
                ++n12;
            }
            stringBuffer.append("endbfrange\n");
            ++n10;
        }
        n10 = 0;
        while (n10 * 100 < vector2.size()) {
            int n13 = Math.min(vector2.size() - n10 * 100, 100);
            stringBuffer.append("" + n13 + " beginbfchar\n");
            int n14 = 0;
            while (n14 < n13) {
                stringBuffer.append((String)vector2.get(n10 * 100 + n14));
                ++n14;
            }
            stringBuffer.append("endbfchar\n");
            ++n10;
        }
        stringBuffer.append("endcmap\n");
        stringBuffer.append("CMapName currentdict /CMap defineresource pop\n");
        stringBuffer.append("end\n");
        stringBuffer.append("end");
        if (this.compressed) {
            object = null;
            try {
                object = stringBuffer.toString().getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = stringBuffer.toString().getBytes();
            }
            this.writeCompressedStreamObject(n, (byte[])object, null);
        } else {
            this.writeUncompressedStreamObject(n, stringBuffer.toString(), null);
        }
    }

    public String formatHexString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(n));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    protected void writeCompressedStreamObject(int n, ByteArrayOutputStream byteArrayOutputStream, String string) {
        this.writeCompressedStreamObject(n, byteArrayOutputStream.toByteArray(), string);
    }

    protected void writeCompressedStreamObject(int n, byte[] byArray, String string) {
        int n2 = ++this.objectNumber;
        this.writeCompressedStreamHeader(n, n2, string);
        int n3 = this.writeCompressedStreamBody(byArray);
        this.writeCompressedStreamFooter(n2, n3);
    }

    protected void writeCompressedStreamHeader(int n, int n2, String string) {
        this.storeObjectReference(n, this.getCurrentOffset());
        this.output(n + " 0 obj\n<<");
        this.output("/Filter [ /ASCII85Decode /FlateDecode ]");
        this.output("/Length " + n2 + " 0 R");
        if (string != null) {
            this.output(string);
        }
        this.output(">>");
        this.output("stream");
    }

    protected int writeCompressedStreamBody(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(new Ascii85OutputStream(byteArrayOutputStream));
        try {
            deflaterOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            deflaterOutputStream.finish();
            deflaterOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        long l = this.getCurrentOffset();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n = byArray2.length;
        int n2 = 0;
        while (n2 + 72 < n) {
            this.output(byArray2, n2, 72);
            n2 += 72;
            this.output((byte)10);
        }
        this.output(byArray2, n2, n - n2);
        this.output((byte)10);
        return (int)(this.getCurrentOffset() - l - 1L);
    }

    protected void writeCompressedStreamFooter(int n, int n2) {
        this.output("endstream\nendobj");
        this.storeObjectReference(n, this.getCurrentOffset());
        this.output(n + " 0 obj\n" + n2 + " \nendobj");
    }

    protected void writeUncompressedStreamObject(int n, String string, String string2) {
        int n2 = ++this.objectNumber;
        this.writeUncompressedStreamHeader(n, n2, string2);
        long l = this.getCurrentOffset();
        this.output(string);
        int n3 = (int)(this.getCurrentOffset() - l - 1L);
        this.writeUncompressedStreamFooter(n2, n3);
    }

    protected void writeUncompressedStreamHeader(int n, int n2, String string) {
        this.storeObjectReference(n, this.getCurrentOffset());
        this.output(n + " 0 obj\n<<");
        this.output("/Length " + n2 + " 0 R");
        if (string != null) {
            this.output(string);
        }
        this.output(">>");
        this.output("stream");
    }

    protected void writeUncompressedStreamFooter(int n, int n2) {
        this.output("endstream\nendobj");
        this.storeObjectReference(n, this.getCurrentOffset());
        this.output(n + " 0 obj\n" + n2 + " \nendobj");
    }

    protected void writeCharRangeSameWidth(FontPS fontPS, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    " + n);
        stringBuffer.append(" " + n2);
        int n3 = fontPS.ttfParser.getGlyphWidthByGlyphCode(n);
        stringBuffer.append(" " + n3);
        this.output(stringBuffer.toString());
    }

    protected void writeCharRangeDiffWidth(FontPS fontPS, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    " + n + " [");
        int n3 = stringBuffer.toString().indexOf(91);
        int n4 = 0;
        int n5 = n;
        while (n5 <= n2) {
            stringBuffer.append(" " + fontPS.ttfParser.getGlyphWidthByGlyphCode(n5));
            if (++n4 % 12 == 0 && n5 != n2) {
                this.output(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                int n6 = 0;
                while (n6 <= n3) {
                    stringBuffer.append(' ');
                    ++n6;
                }
            }
            ++n5;
        }
        stringBuffer.append(" ]");
        this.output(stringBuffer.toString());
    }

    protected void writeFontEncoding() {
        this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
        this.output(this.objectNumber + " 0 obj\n<<");
        this.output("/Type /Encoding \n/BaseEncoding /WinAnsiEncoding");
        this.output("/Differences [");
        this.output("39 /quoteright 45 /minus 96 /quoteleft");
        this.output("127 /.notdef");
        this.output("129 /.notdef /.notdef /.notdef /.notdef");
        this.output("   /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef");
        this.output("   /.notdef /.notdef /.notdef /.notdef /.notdef");
        this.output("144 /dotlessi /grave /acute /circumflex /tilde /macron /breve");
        this.output("   /dotaccent /dieresis");
        this.output("153 /.notdef");
        this.output("154 /ring /cedilla");
        this.output("156 /.notdef");
        this.output("157 /hungarumlaut /ogonek /caron ]");
        this.output(">>\nendobj");
    }

    protected void writeDocGraphicsDictionary() {
        this.storeObjectReference(++this.objectNumber, this.getCurrentOffset());
        this.output(this.objectNumber + " 0 obj\n<<");
        this.output("/Type /ExtGState");
        if (this.useAutoStrokeAdjustment) {
            this.output("/SA true");
        } else {
            this.output("/SA false");
        }
        this.output(">>\nendobj");
    }

    protected void writePagesTree(Rectangle2D rectangle2D) {
        this.writePagesObject(this.pagesReference, this.pageList, this.rootPagesReference, rectangle2D);
        this.pagesList.add(new Integer(this.pagesReference));
        this.writePagesObject(this.rootPagesReference, this.pagesList, 0, null);
    }

    protected void writePagesObject(int n, Vector vector, int n2, Rectangle2D rectangle2D) {
        this.storeObjectReference(n, this.getCurrentOffset());
        this.output(n + " 0 obj");
        this.output("<<\n/Type /Pages\n/Kids [");
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (Integer)vector.elementAt(n4);
            this.output(n5 + " 0 R");
            ++n4;
        }
        if (n2 != 0) {
            this.output("]\n/Count " + n3);
            this.totalPageCount += n3;
        } else {
            this.output("]\n/Count " + this.totalPageCount);
        }
        if (n2 != 0) {
            this.output("/Parent " + n2 + " 0 R");
        }
        if (rectangle2D != null) {
            String string = "/MediaBox [ " + rectangle2D.getX() + " " + rectangle2D.getY() + " " + (rectangle2D.getWidth() + rectangle2D.getX()) + " " + (rectangle2D.getHeight() + rectangle2D.getY()) + " ]";
            this.output(string);
        }
        this.output(">>\nendobj");
    }

    protected boolean pageChanged(Rectangle2D rectangle2D) {
        if (this.oldPageSize == null) {
            this.oldPageSize = (Rectangle2D)rectangle2D.clone();
            return false;
        }
        return !this.oldPageSize.equals(rectangle2D);
    }

    public boolean isBaseFont(String string) {
        String string2;
        String string3 = null;
        if (string.indexOf(45) != -1) {
            string3 = string.substring(string.indexOf(45) + 1, string.length());
            string2 = string.substring(0, string.indexOf(45));
        } else {
            string2 = string;
        }
        return string2.equals("Courier") || string2.equals("Helvetica") ? string3 == null || string3.equals("Bold") || string3.equals("Oblique") || string3.equals("BoldOblique") : (string2.equals("Times") ? string3.equals("Roman") || string3.equals("Bold") || string3.equals("Italic") || string3.equals("BoldItalic") : string2.equals("Symbol") || string2.equals("ZapfDingbats"));
    }

    protected void switchToNewStream() {
        this.streamStack.push(this.streamInfo);
        this.os = new ByteArrayOutputStream();
        this.streamInfo = new StreamInfo();
        this.streamInfo.os = this.os;
    }

    protected void switchBackToOldStream() {
        this.pageXObjectReferences.addElement(this.streamInfo.referenceList);
        this.pageXObjectStreams.addElement(this.os);
        this.streamInfo = (StreamInfo)this.streamStack.pop();
        this.os = this.streamInfo.os;
    }

    protected void storeObjectReference(int n, long l) {
        AcroReference acroReference = new AcroReference();
        acroReference.number = n;
        acroReference.offset = l;
        this.streamInfo.referenceList.add(acroReference);
    }

    protected long getCurrentOffset() {
        return this.streamInfo.fileOffset;
    }

    protected long getStreamStart() {
        return this.streamInfo.contentsStart;
    }

    protected void setStreamStart() {
        this.streamInfo.contentsStart = this.streamInfo.fileOffset;
    }

    protected String pad10(long l) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l));
        int n2 = n = stringBuffer.length();
        while (n2 < 10) {
            stringBuffer.insert(0, 0);
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void beginPageStream() {
        ++this.objectNumber;
        this.streamInfo.objectNumber = this.objectNumber++;
        this.streamInfo.lengthObjectNumber = this.objectNumber;
        this.contentsList.add(new Integer(this.streamInfo.objectNumber));
        if (!this.streamInfo.collectStream && this.compressed) {
            this.writeCompressedStreamHeader(this.streamInfo.objectNumber, this.streamInfo.lengthObjectNumber, null);
            this.streamInfo.collectStream = true;
            this.streamInfo.collectedStream = new ByteArrayOutputStream();
        } else {
            this.writeUncompressedStreamHeader(this.streamInfo.objectNumber, this.streamInfo.lengthObjectNumber, null);
            this.setStreamStart();
        }
    }

    protected void beginNonPageStream() {
        this.output("stream");
        if (!this.streamInfo.collectStream && this.compressed) {
            this.streamInfo.collectStream = true;
            this.streamInfo.collectedStream = new ByteArrayOutputStream();
        } else {
            this.setStreamStart();
        }
    }

    protected void endStream() {
        if (this.streamInfo.collectStream && this.compressed) {
            this.streamInfo.collectStream = false;
            int n = this.writeCompressedStreamBody(this.streamInfo.collectedStream.toByteArray());
            this.writeCompressedStreamFooter(this.streamInfo.lengthObjectNumber, n);
            this.streamInfo.collectedStream = null;
        } else {
            int n = (int)(this.streamInfo.fileOffset - this.streamInfo.contentsStart - 1L);
            this.writeUncompressedStreamFooter(this.streamInfo.lengthObjectNumber, n);
        }
    }

    protected void output(String string) {
        if (!this.isDocumentOpen()) {
            return;
        }
        if (!this.streamInfo.collectStream) {
            this.streamInfo.fileOffset += (long)(string.length() + 1);
            super.output(string);
        } else {
            try {
                try {
                    this.streamInfo.collectedStream.write(string.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.streamInfo.collectedStream.write(string.getBytes());
                }
                this.streamInfo.collectedStream.write(10);
            }
            catch (IOException iOException) {
                throw new PrintException(iOException.toString());
            }
        }
    }

    protected void output(byte[] byArray) {
        if (!this.isDocumentOpen()) {
            return;
        }
        if (!this.streamInfo.collectStream) {
            this.streamInfo.fileOffset += (long)byArray.length;
            super.output(byArray);
        } else {
            try {
                this.streamInfo.collectedStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new PrintException(iOException.toString());
            }
        }
    }

    protected void output(byte[] byArray, int n, int n2) {
        if (!this.isDocumentOpen()) {
            return;
        }
        if (!this.streamInfo.collectStream) {
            this.streamInfo.fileOffset += (long)n2;
            super.output(byArray, n, n2);
        } else {
            this.streamInfo.collectedStream.write(byArray, n, n2);
        }
    }

    protected void output(byte by) {
        if (!this.isDocumentOpen()) {
            return;
        }
        if (!this.streamInfo.collectStream) {
            ++this.streamInfo.fileOffset;
            super.output(by);
        } else {
            this.streamInfo.collectedStream.write(by);
        }
    }

    protected String getFontAbbreviation(String string) {
        AcroFontEntry acroFontEntry = (AcroFontEntry)this.fontList.get(string);
        return acroFontEntry.abbrev;
    }

    protected AcroFontEntry getFontEntry(String string) {
        AcroFontEntry acroFontEntry = (AcroFontEntry)this.fontList.get(string);
        return acroFontEntry;
    }

    protected void addFontToList(FontPS fontPS) {
        String string = "F" + (this.fontList.size() + 1);
        AcroFontEntry acroFontEntry = new AcroFontEntry();
        acroFontEntry.font = fontPS;
        acroFontEntry.name = fontPS.getName();
        if (fontPS.usingTTF) {
            acroFontEntry.usingTTF = true;
            TrueTypeFontProperties trueTypeFontProperties = FontLibrary.lookupTrueTypeFontProperties(acroFontEntry.name);
            acroFontEntry.expectedCharacterRange = trueTypeFontProperties.getCharacterRange();
            if (acroFontEntry.expectedCharacterRange == 1) {
                acroFontEntry.usingAnsi = true;
                acroFontEntry.usingUnicode = false;
            } else if (acroFontEntry.expectedCharacterRange == 2) {
                acroFontEntry.usingAnsi = false;
                acroFontEntry.usingUnicode = true;
            } else if (acroFontEntry.expectedCharacterRange == 0) {
                acroFontEntry.usingAnsi = false;
                acroFontEntry.usingUnicode = false;
            } else {
                acroFontEntry.usingAnsi = false;
                acroFontEntry.usingUnicode = false;
            }
            acroFontEntry.embeddingRules = trueTypeFontProperties.getEmbeddingRules();
            acroFontEntry.ansiCharactersUsed = new TreeSet();
            acroFontEntry.unicodeCharactersUsed = new TreeSet();
            acroFontEntry.unicodeWidths = new Hashtable();
            acroFontEntry.includeUnicodeMap = trueTypeFontProperties.getIncludeUnicodeMap();
        } else {
            acroFontEntry.usingTTF = false;
            acroFontEntry.expectedCharacterRange = 1;
            acroFontEntry.usingAnsi = true;
            acroFontEntry.usingUnicode = false;
            acroFontEntry.embeddingRules = 0;
            acroFontEntry.ansiCharactersUsed = new TreeSet();
            acroFontEntry.unicodeCharactersUsed = null;
            acroFontEntry.unicodeWidths = null;
            acroFontEntry.includeUnicodeMap = false;
        }
        acroFontEntry.abbrev = string;
        acroFontEntry.number = -1;
        acroFontEntry.unicodeNumber = -1;
        this.fontList.put(acroFontEntry.name, acroFontEntry);
    }

    public boolean isCompressed() {
        return super.isCompressed();
    }

    public void setCompressed(boolean bl) {
        super.setCompressed(bl);
    }

    protected void addPattern(String string, BufferedImage bufferedImage) {
        PatternInfo patternInfo = new PatternInfo(string, bufferedImage);
        this.streamInfo.patternList.add(patternInfo);
    }

    public class StreamInfo {
        protected OutputStream os = null;
        protected Vector imageList = new Vector();
        protected Vector xObjectList = new Vector();
        protected Hashtable fontList = new Hashtable();
        protected Vector patternList;
        protected long fileOffset = 0L;
        protected long contentsStart = 0L;
        protected Vector referenceList = new Vector();
        protected int objectNumber = 0;
        protected int lengthObjectNumber = 0;
        protected boolean textPresent = false;
        protected boolean imagePresent = false;
        protected boolean maskPresent = false;
        protected boolean indexImage = false;
        protected Vector colorSpaceList = new Vector();
        protected boolean collectStream = false;
        protected ByteArrayOutputStream collectedStream = null;

        public StreamInfo() {
            this.patternList = new Vector();
        }

        public void openDocument() {
            this.fileOffset = 0L;
            this.xObjectList.clear();
            this.fontList.clear();
            this.referenceList.clear();
            this.colorSpaceList.clear();
            this.patternList.clear();
        }

        public void beginPage() {
            this.xObjectList.clear();
            this.imageList.clear();
            this.fontList.clear();
            this.colorSpaceList.clear();
            this.patternList.clear();
            this.imagePresent = false;
            this.indexImage = false;
            this.maskPresent = false;
            this.textPresent = false;
        }
    }

    protected class AcroReference
    implements Comparable {
        protected int number;
        protected long offset;

        public AcroReference() {
        }

        public AcroReference(int n, long l) {
            this.number = n;
            this.offset = l;
        }

        public int compareTo(Object object) {
            AcroReference acroReference = (AcroReference)object;
            return this.number - acroReference.number;
        }
    }

    protected class PatternInfo {
        protected String patternName;
        protected int patternObjectNumber;
        protected int imageObjectNumber;
        protected BufferedImage img;

        protected PatternInfo() {
        }

        protected PatternInfo(String string, BufferedImage bufferedImage) {
            this.patternName = string;
            this.img = bufferedImage;
        }
    }
}

