/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.PageArea;
import com.klg.jclass.page.render.BoxRender;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JCPage
extends PageArea {
    protected int pageNumber = 0;
    protected List flowFrameList;
    protected JCPage flowPageTemplate;
    protected JCPage flowSectionTemplate;
    protected int pageType = 2;
    protected String templateName;
    protected boolean firstTemplate = false;
    protected int orientation = 0;
    public static final int PAGE_TYPE_TEMPLATE = 1;
    public static final int PAGE_TYPE_DOCUMENT = 2;
    public static final int PAGE_TYPE_TEAR_OFF = 3;
    public static final int PAGE_TYPE_DELETED = 4;
    public static final int ORIENTATION_AUTOMATIC = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_LANDSCAPE = 2;

    public JCPage() {
        this.flowFrameList = new Vector();
    }

    public JCPage(JCDocument jCDocument) {
        super(jCDocument);
        this.flowFrameList = new Vector();
    }

    public JCPage(String string) {
        super(string);
        this.flowFrameList = new Vector();
    }

    public JCPage(String string, JCDocument jCDocument) {
        super(string, jCDocument);
        this.flowFrameList = new Vector();
    }

    public JCPage(String string, JCUnit.Point point, JCUnit.Dimension dimension) {
        super(string, point, dimension);
        this.flowFrameList = new Vector();
    }

    public JCPage(String string, JCDocument jCDocument, JCUnit.Point point, JCUnit.Dimension dimension) {
        super(string, point, dimension);
        this.flowFrameList = new Vector();
    }

    public JCPage(String string, JCPage jCPage) {
        super(string, jCPage.location, jCPage.size);
        JCFrame jCFrame;
        JCFrame jCFrame2;
        this.templateName = new String(jCPage.name.toString());
        this.orientation = jCPage.orientation;
        this.flowPageTemplate = jCPage.flowPageTemplate;
        this.flowSectionTemplate = jCPage.flowSectionTemplate;
        if (jCPage.color != null) {
            this.setColor(jCPage.color);
        }
        Iterator iterator = jCPage.frameList.iterator();
        while (iterator.hasNext()) {
            jCFrame2 = (JCFrame)iterator.next();
            jCFrame = (JCFrame)jCFrame2.clone();
            jCFrame.setPage(this);
            this.frameList.add(jCFrame);
        }
        iterator = jCPage.flowFrameList.iterator();
        this.flowFrameList = new Vector();
        while (iterator.hasNext()) {
            jCFrame2 = (JCFrame)iterator.next();
            jCFrame = this.stringToFrame(jCFrame2.getName());
            this.flowFrameList.add(jCFrame);
        }
    }

    public JCPage(String string, JCDocument jCDocument, JCPage jCPage) {
        super(string, jCDocument, jCPage.location, jCPage.size);
        JCFrame jCFrame;
        JCFrame jCFrame2;
        this.templateName = new String(jCPage.name.toString());
        this.orientation = jCPage.orientation;
        this.flowPageTemplate = jCPage.flowPageTemplate;
        this.flowSectionTemplate = jCPage.flowSectionTemplate;
        if (jCPage.color != null) {
            this.setColor(jCPage.color);
        }
        Iterator iterator = jCPage.frameList.iterator();
        while (iterator.hasNext()) {
            jCFrame2 = (JCFrame)iterator.next();
            jCFrame = (JCFrame)jCFrame2.clone();
            jCFrame.setDocument(jCDocument);
            jCFrame.setPage(this);
            this.frameList.add(jCFrame);
        }
        iterator = jCPage.flowFrameList.iterator();
        this.flowFrameList = new Vector();
        while (iterator.hasNext()) {
            jCFrame2 = (JCFrame)iterator.next();
            jCFrame = this.stringToFrame(jCFrame2.getName());
            this.flowFrameList.add(jCFrame);
        }
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    public JCPage getFlowPageTemplate() {
        return this.flowPageTemplate;
    }

    public void setFlowPageTemplate(JCPage jCPage) {
        this.flowPageTemplate = jCPage;
    }

    public JCPage getFlowSectionTemplate() {
        return this.flowSectionTemplate;
    }

    public void setFlowSectionTemplate(JCPage jCPage) {
        this.flowSectionTemplate = jCPage;
    }

    public List getFlowFrameList() {
        return this.flowFrameList;
    }

    public void setFlowFrameList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JCFrame jCFrame = (JCFrame)iterator.next();
            if (this.frameList.contains(jCFrame)) continue;
            throw new IllegalArgumentException("Frame specified in flow List not in this page");
        }
        this.flowFrameList = list;
    }

    public boolean isFirstTemplate() {
        return this.firstTemplate;
    }

    public void setFirstTemplate(boolean bl) {
        this.firstTemplate = bl;
    }

    protected String getTemplateName() {
        return this.templateName;
    }

    protected void setTemplateName(String string) {
        this.templateName = string;
    }

    public int getOrientation() {
        return this.orientation;
    }

    protected void setOrientation(int n) {
        this.orientation = n;
    }

    public int getPageType() {
        return this.pageType;
    }

    public void setPageType(int n) {
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException("Unrecognised page type");
        }
        if (n != 2) {
            this.pageNumber = 0;
        }
        this.pageType = n;
    }

    public Rectangle2D getPageSize() {
        double d = JCUnit.getAsPoints(this.location.units, this.location.x);
        double d2 = JCUnit.getAsPoints(this.location.units, this.location.y);
        double d3 = JCUnit.getAsPoints(this.size.units, this.size.width);
        double d4 = JCUnit.getAsPoints(this.size.units, this.size.height);
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public void delete() {
        this.frameList = null;
        this.flowFrameList = null;
        this.pageType = 4;
    }

    public void draw(Graphics2D graphics2D) {
        Graphics2D graphics2D2;
        if (this.color != null) {
            graphics2D2 = (Graphics2D)graphics2D.create();
            if (graphics2D2 instanceof Graphics2DBase) {
                ((Graphics2DBase)graphics2D2).setFrameRoot();
            }
            double d = this.size.getWidth().getAs(JCUnit.POINTS);
            double d2 = this.size.getHeight().getAs(JCUnit.POINTS);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, d2);
            graphics2D2.setClip(double_);
            JCDrawStyle jCDrawStyle = new JCDrawStyle();
            jCDrawStyle.setFillForegroundColor(this.color);
            jCDrawStyle.makeImmutable();
            if (this.background == null) {
                this.background = new BoxRender(new JCUnit.Point(), this.size, jCDrawStyle);
                ((BoxRender)this.background).setFilled(true);
            }
            this.background.draw(graphics2D2);
            graphics2D2.dispose();
        }
        Iterator iterator = graphics2D instanceof Markup ? this.flowFrameList.iterator() : this.frameList.iterator();
        while (iterator.hasNext()) {
            JCFrame jCFrame = (JCFrame)iterator.next();
            JCUnit.Point point = jCFrame.getLocation();
            double d = point.getX().getAs(JCUnit.POINTS);
            double d3 = point.getY().getAs(JCUnit.POINTS);
            JCUnit.Dimension dimension = jCFrame.getSize();
            double d4 = dimension.getWidth().getAs(JCUnit.POINTS);
            double d5 = dimension.getHeight().getAs(JCUnit.POINTS);
            graphics2D2 = (Graphics2D)graphics2D.create();
            if (graphics2D2 instanceof Graphics2DBase) {
                ((Graphics2DBase)graphics2D2).setFrameRoot();
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d3, d4, d5);
            graphics2D2.setClip(double_);
            graphics2D2.translate(d, d3);
            JCUnit.Margins margins = jCFrame.getClipMask();
            if (margins != null) {
                d = margins.getLeft().getAs(JCUnit.POINTS);
                d3 = margins.getTop().getAs(JCUnit.POINTS);
                d4 = margins.getRight().getAs(JCUnit.POINTS);
                d5 = margins.getBottom().getAs(JCUnit.POINTS);
                Rectangle2D.Double double_2 = new Rectangle2D.Double(d, d3, d4, d5);
                graphics2D2.setClip(double_2);
            }
            jCFrame.draw(graphics2D2);
            graphics2D2.dispose();
        }
    }
}

