/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.DuplicateNameException;
import com.klg.jclass.page.JCUnit;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class JCDrawStyle
implements Cloneable {
    protected String name;
    protected Color foreground;
    protected Color fillForeground;
    protected int fillRule;
    protected JCUnit.Measure lineWidth;
    protected int lineType;
    protected JCUnit.Measure lineSpacing;
    protected JCUnit.Measure dashLength;
    protected boolean immutable;
    protected static int styleCount = 0;
    protected static TreeMap instanceCollection = new TreeMap();
    public static final int FILL_RULE_EVEN_ODD = 0;
    public static final int FILL_RULE_NON_ZERO_WINDING = 1;
    public static final int LINE_TYPE_NONE = 1;
    public static final int LINE_TYPE_PLAIN = 2;
    public static final int LINE_TYPE_SINGLE = 2;
    public static final int LINE_TYPE_BROKEN = 3;
    public static final int LINE_TYPE_DOUBLE = 4;
    public static final int POSITION_ON_BASELINE = 1;
    public static final int POSITION_BELOW_BASELINE = 2;
    public static final int CENTER_ON_BASELINE = 3;
    public static final int CENTER_ABOVE_BASELINE = 4;
    public static final int CENTER_IN_LINE = 5;
    public static final int ALIGN_TO_TOP = 6;
    public static final int ALIGN_TO_BOTTOM = 7;
    public static final String DEFAULT_LINE = "default line";
    public static final String DEFAULT_1PT_LINE = "default 1pt line";
    public static final String DEFAULT_2PT_LINE = "default 2pt line";
    protected static final String UNAMED_STYLE_PREFIX = "jcpldrawstyle";
    protected Map immutableDrawStyles = new Hashtable();
    private static final JCUnit.Measure DEFAULT_WIDTH = null;
    private static final JCUnit.Measure DEFAULT_SPACING = null;
    private static final JCUnit.Measure DEFAULT_DASH = null;
    public static final JCDrawStyle BLANK = new JCDrawStyle("default blank", null, 0, 2, DEFAULT_WIDTH, DEFAULT_SPACING, DEFAULT_DASH, true);
    public static final JCDrawStyle LINE = new JCDrawStyle("default line", Color.black, 0, 2, DEFAULT_WIDTH, DEFAULT_SPACING, DEFAULT_DASH, true);
    public static final JCDrawStyle LINE_DOUBLE = new JCDrawStyle("default double line", Color.black, 0, 4, DEFAULT_WIDTH, new JCUnit.Measure(JCUnit.POINTS, 1.0), DEFAULT_DASH, true);
    public static final JCDrawStyle LINE_1POINT = new JCDrawStyle("default 1pt line", Color.black, 0, 2, new JCUnit.Measure(JCUnit.POINTS, 1.0), DEFAULT_SPACING, DEFAULT_DASH, true);
    public static final JCDrawStyle LINE_2POINT = new JCDrawStyle("default 2pt line", Color.black, 0, 2, new JCUnit.Measure(JCUnit.POINTS, 2.0), DEFAULT_SPACING, DEFAULT_DASH, true);
    public static final JCDrawStyle LINE_DASHED = new JCDrawStyle("dashed line", Color.black, 0, 3, DEFAULT_WIDTH, DEFAULT_SPACING, new JCUnit.Measure(JCUnit.POINTS, 9.0), true);

    public JCDrawStyle(String string, Color color, int n, int n2, JCUnit.Measure measure, JCUnit.Measure measure2, JCUnit.Measure measure3, boolean bl) {
        this.name = string;
        this.setForegroundColor(color);
        this.setFillRule(n);
        this.setLineWidth(measure);
        this.setLineSpacing(measure2);
        this.setDashLength(measure3);
        this.setLineType(n2);
        this.immutable = bl;
        if (!string.regionMatches(0, UNAMED_STYLE_PREFIX, 0, UNAMED_STYLE_PREFIX.length())) {
            instanceCollection.put(string, this);
        }
    }

    public JCDrawStyle() {
        this(UNAMED_STYLE_PREFIX + ++styleCount, Color.black, 0, 2, new JCUnit.Measure(JCUnit.INTERNAL, 0.0), DEFAULT_SPACING, DEFAULT_DASH, false);
    }

    public JCDrawStyle(String string) {
        this();
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable objects");
        }
        if (instanceCollection.containsKey(this.name)) {
            instanceCollection.remove(this.name);
        }
        this.name = string;
        if (!string.regionMatches(0, UNAMED_STYLE_PREFIX, 0, UNAMED_STYLE_PREFIX.length())) {
            instanceCollection.put(string, this);
        }
    }

    public Color getForegroundColor() {
        return this.foreground;
    }

    public void setForegroundColor(Color color) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable objects");
        }
        this.foreground = color;
    }

    public Color getFillForegroundColor() {
        return this.fillForeground;
    }

    public void setFillForegroundColor(Color color) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable objects");
        }
        this.fillForeground = color;
    }

    public int getFillRule() {
        return this.fillRule;
    }

    public void setFillRule(int n) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable objects");
        }
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Unrecognized fill rule: " + n);
        }
        this.fillRule = n;
    }

    public JCUnit.Measure getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(JCUnit.Measure measure) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable objects");
        }
        if (measure == null) {
            this.lineWidth = new JCUnit.Measure(JCUnit.POINTS, 0.1);
        } else {
            if (measure.distance < 0.0) {
                throw new IllegalArgumentException("Line width must be >= 0");
            }
            this.lineWidth = (JCUnit.Measure)measure.clone();
        }
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int n) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable objects");
        }
        if (n <= 0 || n > 4) {
            throw new IllegalArgumentException("Unrecognized line type");
        }
        this.lineType = n;
        if (n == 3 && this.dashLength.isZero()) {
            if (this.lineWidth.isZero()) {
                this.dashLength = new JCUnit.Measure(JCUnit.POINTS, 2.0);
            } else {
                this.dashLength.assign(this.lineWidth);
                this.dashLength.multiply(10.0);
            }
        }
    }

    public JCUnit.Measure getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(JCUnit.Measure measure) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable objects");
        }
        if (measure == null) {
            this.lineSpacing = new JCUnit.Measure();
        } else {
            if (measure.distance <= 0.0) {
                throw new IllegalArgumentException("Line spacing must be > 0");
            }
            this.lineSpacing = (JCUnit.Measure)measure.clone();
        }
    }

    public JCUnit.Measure getDrawnWidth() {
        switch (this.lineType) {
            case 4: {
                double d = 2.0 * this.lineWidth.internal() + this.lineSpacing.internal();
                return new JCUnit.Measure(JCUnit.INTERNAL, d);
            }
        }
        return (JCUnit.Measure)this.lineWidth.clone();
    }

    public JCUnit.Measure getDashLength() {
        return this.dashLength;
    }

    public void setDashLength(JCUnit.Measure measure) {
        if (this.immutable) {
            throw new IllegalArgumentException("Set only on mutable objects");
        }
        if (measure == null) {
            this.dashLength = new JCUnit.Measure(JCUnit.POINTS, 0.0);
        } else {
            if (measure.distance <= 0.0) {
                throw new IllegalArgumentException("Dash length must be > 0");
            }
            this.dashLength = (JCUnit.Measure)measure.clone();
        }
    }

    public boolean isMutable() {
        return !this.immutable;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public void makeImmutableAndStore() {
        if (instanceCollection.containsKey(this.name)) {
            throw new DuplicateNameException("Style name already exists: " + this.name);
        }
        instanceCollection.put(this.name, this);
        this.immutable = true;
    }

    public void makeImmutableAndOverride() {
        if (instanceCollection.containsKey(this.name)) {
            instanceCollection.remove(this.name);
        }
        instanceCollection.put(this.name, this);
        this.immutable = true;
    }

    public Object clone() {
        JCDrawStyle jCDrawStyle;
        try {
            jCDrawStyle = (JCDrawStyle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        jCDrawStyle.name = new String(this.name);
        jCDrawStyle.lineWidth = (JCUnit.Measure)this.lineWidth.clone();
        jCDrawStyle.lineSpacing = (JCUnit.Measure)this.lineSpacing.clone();
        jCDrawStyle.dashLength = (JCUnit.Measure)this.dashLength.clone();
        jCDrawStyle.immutable = false;
        return jCDrawStyle;
    }

    public boolean isEqualBorder(JCDrawStyle jCDrawStyle) {
        if (jCDrawStyle == null) {
            return false;
        }
        if (this.lineType != jCDrawStyle.getLineType()) {
            return false;
        }
        if (!this.lineWidth.equals(jCDrawStyle.getLineWidth())) {
            return false;
        }
        Color color = jCDrawStyle.getForegroundColor();
        if ((this.foreground == null || color == null) && this.foreground != color) {
            return false;
        }
        if (this.foreground != null && !this.foreground.equals(color)) {
            return false;
        }
        if (this.lineType == 4 && !this.lineSpacing.equals(jCDrawStyle.getLineSpacing())) {
            return false;
        }
        return this.lineType != 3 || this.dashLength.equals(jCDrawStyle.getDashLength());
    }

    public static Iterator getStyles() {
        return instanceCollection.entrySet().iterator();
    }

    public static Map getStyleList() {
        return instanceCollection;
    }

    public static JCDrawStyle stringToStyle(String string) {
        if (instanceCollection.containsKey(string)) {
            return (JCDrawStyle)instanceCollection.get(string);
        }
        return null;
    }

    public int hashCode() {
        int n = this.foreground != null ? this.foreground.hashCode() : 0;
        n = 29 * n + (this.fillForeground != null ? this.fillForeground.hashCode() : 0);
        n = 29 * n + this.fillRule;
        n = 29 * n + (this.lineWidth != null ? this.lineWidth.hashCode() : 0);
        n = 29 * n + this.lineType;
        n = 29 * n + (this.lineSpacing != null ? this.lineSpacing.hashCode() : 0);
        n = 29 * n + (this.dashLength != null ? this.dashLength.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JCDrawStyle)) {
            return false;
        }
        JCDrawStyle jCDrawStyle = (JCDrawStyle)object;
        if (this.fillRule != jCDrawStyle.fillRule) {
            return false;
        }
        if (this.lineType != jCDrawStyle.lineType) {
            return false;
        }
        if (this.dashLength != null ? !this.dashLength.equals(jCDrawStyle.dashLength) : jCDrawStyle.dashLength != null) {
            return false;
        }
        if (this.fillForeground != null ? !this.fillForeground.equals(jCDrawStyle.fillForeground) : jCDrawStyle.fillForeground != null) {
            return false;
        }
        if (this.foreground != null ? !this.foreground.equals(jCDrawStyle.foreground) : jCDrawStyle.foreground != null) {
            return false;
        }
        if (this.lineSpacing != null ? !this.lineSpacing.equals(jCDrawStyle.lineSpacing) : jCDrawStyle.lineSpacing != null) {
            return false;
        }
        return !(this.lineWidth != null ? !this.lineWidth.equals(jCDrawStyle.lineWidth) : jCDrawStyle.lineWidth != null);
    }

    public JCDrawStyle getImmutable() {
        if (this.immutable) {
            return this;
        }
        JCDrawStyle jCDrawStyle = (JCDrawStyle)this.immutableDrawStyles.get(this);
        if (jCDrawStyle == null) {
            jCDrawStyle = (JCDrawStyle)this.clone();
            jCDrawStyle.makeImmutable();
            this.immutableDrawStyles.put(jCDrawStyle, jCDrawStyle);
        }
        return jCDrawStyle;
    }
}

