/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.FontLibrary;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.awt.JCAWTPrinter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class JCDocument {
    protected String name = null;
    protected JCPrinter printer = null;
    protected List templatePages;
    protected List pageList;
    protected int pageCount = 0;
    protected List tableList;
    protected JCFlow flow;
    protected int flushPolicy;
    protected int outputPolicy;
    protected int startPage = 1;
    protected int lastPage;
    public static final int FLUSH_POLICY_ALWAYS_SAVE = 1;
    public static final int FLUSH_POLICY_ON_OUTPUT = 2;
    public static final int OUTPUT_POLICY_ON_REQUEST = 1;
    public static final int OUTPUT_POLICY_IMMEDIATE = 2;
    public static final List BLANK_8p5X11 = new BlankTemplate(JCUnit.INCHES, 8.5, 11.0, 0.75);
    public static final List BLANK_8p5X14 = new BlankTemplate(JCUnit.INCHES, 8.5, 14.0, 0.75);
    public static final List BLANK_11X17 = new BlankTemplate(JCUnit.INCHES, 11.0, 17.0, 0.75);
    public static final List BLANK_A3 = new BlankTemplate(JCUnit.CM, 29.7, 42.0, 1.5);
    public static final List BLANK_A4 = new BlankTemplate(JCUnit.CM, 21.0, 29.7, 1.5);
    public static final List BLANK_A5 = new BlankTemplate(JCUnit.CM, 14.8, 21.0, 1.5);
    public static final List BLANK_11X8p5 = new BlankTemplate(JCUnit.INCHES, 11.0, 8.5, 0.75);

    public JCDocument(String string) {
        this(string, null, null);
    }

    public JCDocument(JCPrinter jCPrinter) {
        this(null, jCPrinter, null);
    }

    public JCDocument(JCPrinter jCPrinter, List list) {
        this(null, jCPrinter, list);
    }

    public JCDocument(List list) {
        this(null, null, list);
    }

    private JCDocument(String string, JCPrinter jCPrinter, List list) {
        if (string != null) {
            this.name = new String(string);
        }
        this.pageList = new Vector();
        this.pageCount = 0;
        this.flushPolicy = 1;
        this.outputPolicy = 1;
        if (list != null) {
            this.setTemplates(list);
        } else {
            this.templatePages = new ArrayList();
        }
        this.tableList = new Vector();
        this.flow = null;
        this.printer = jCPrinter;
    }

    public String getName() {
        return this.name;
    }

    public JCPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(JCPrinter jCPrinter) {
        this.printer = jCPrinter;
    }

    public Graphics getPrinterGraphics() {
        return this.printer.getGraphics();
    }

    public List getTemplates() {
        return this.templatePages;
    }

    public void setTemplates(List list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("templates list may not be null");
        }
        this.templatePages = list;
        if (list != null) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                JCPage jCPage = (JCPage)list.get(n2);
                jCPage.setDocument(this);
                ++n2;
            }
        }
    }

    public void dispose() {
        if (this.templatePages != null) {
            int n = this.templatePages.size();
            int n2 = 0;
            while (n2 < n) {
                JCPage jCPage = (JCPage)this.templatePages.get(n2);
                jCPage.setDocument(null);
                ++n2;
            }
            this.templatePages = null;
        }
    }

    public JCPage findFirstTemplate() {
        JCPage jCPage = null;
        int n = 0;
        while (n < this.templatePages.size()) {
            jCPage = (JCPage)this.templatePages.get(n);
            if (jCPage.isFirstTemplate()) {
                return jCPage;
            }
            ++n;
        }
        return (JCPage)this.templatePages.get(0);
    }

    public void setStartingPageNumber(int n) {
        this.startPage = n;
    }

    public int getStartingPageNumber() {
        return this.startPage;
    }

    public void addPage(JCPage jCPage) {
        this.addPage(jCPage, true, false);
    }

    public void addPage(JCPage jCPage, boolean bl, boolean bl2) {
        this.pageList.add(jCPage);
        if (this.flow != null && bl) {
            if (!bl2) {
                this.flow.deferCountingNewPage(jCPage);
            } else {
                this.flow.updatePageNumbers(jCPage);
            }
        }
        ++this.pageCount;
        jCPage.setDocument(this);
    }

    public void addFontPackage(String string) {
        FontLibrary.addFontPackage(string);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public List getPages() {
        return this.pageList;
    }

    public JCFlow getFlow() {
        return this.flow;
    }

    public void setFlow(JCFlow jCFlow) {
        this.flow = jCFlow;
    }

    public int getFlushPolicy() {
        return this.flushPolicy;
    }

    public void setFlushPolicy(int n) {
        if (n <= 0 || n > 2) {
            throw new IllegalArgumentException("Unrecognised document flush policy");
        }
        this.flushPolicy = n;
    }

    public int getOutputPolicy() {
        return this.outputPolicy;
    }

    public void setOutputPolicy(int n) {
        if (n <= 0 || n > 2) {
            throw new IllegalArgumentException("Unrecognised document output policy");
        }
        this.outputPolicy = n;
    }

    public JCPage stringToTemplate(String string) {
        Iterator iterator = this.templatePages.iterator();
        while (iterator.hasNext()) {
            JCPage jCPage = (JCPage)iterator.next();
            if (!jCPage.getName().equals(string)) continue;
            return jCPage;
        }
        throw new NoSuchElementException("Page Template not Found: " + string);
    }

    public List getTables() {
        return this.tableList;
    }

    public void addTable(JCPageTable jCPageTable) {
        this.tableList.add(jCPageTable);
    }

    public void print() {
        this.print(this.printer);
    }

    public void print(JCPrinter jCPrinter) {
        int n = jCPrinter.getOutputPageStart();
        if (n < 0) {
            n = 0;
        }
        int n2 = this.pageList.size();
        int n3 = jCPrinter.getOutputPageEnd();
        if (n3 == -1 || n3 >= n2) {
            n3 = n2 - 1;
        }
        if (n > n3) {
            return;
        }
        this.print(jCPrinter, n, n3);
    }

    public void print(int n, int n2) {
        this.print(this.printer, n, n2);
    }

    public void print(JCPrinter jCPrinter, int n, int n2) {
        int n3 = 1;
        if (this.flow.isFlowActive()) {
            this.flow.endFlow();
        }
        if (this.outputPolicy == 2 && jCPrinter.isDocumentOpen()) {
            Rectangle2D rectangle2D = ((JCPage)this.pageList.get(this.lastPage < 0 ? 0 : this.lastPage)).getPageSize();
            while (++this.lastPage < this.pageCount) {
                JCPage jCPage = (JCPage)this.pageList.get(this.lastPage);
                rectangle2D = jCPage.getPageSize();
                int n4 = jCPrinter.getNumCopies();
                while (n4 > 0) {
                    jCPrinter.beginPage(rectangle2D, jCPage.getPageNumber());
                    jCPage.draw((Graphics2D)jCPrinter.getGraphics());
                    jCPrinter.endPage(rectangle2D);
                    --n4;
                }
                this.checkFlushPage(jCPage);
            }
            jCPrinter.closeDocument(rectangle2D);
            return;
        }
        int n5 = this.pageList.size();
        if (n < 0) {
            n = 0;
        }
        if (n2 >= n5) {
            n2 = n5 - 1;
        }
        if (n2 < n && n5 > 0) {
            return;
        }
        boolean bl = jCPrinter.getCollate();
        boolean bl2 = jCPrinter.getReverseOrder();
        int n6 = jCPrinter.getNumCopies();
        if (bl2) {
            int n7 = n;
            n = n2;
            n2 = n7;
            n3 = -1;
        }
        if (jCPrinter instanceof JCAWTPrinter) {
            ((JCAWTPrinter)jCPrinter).registerDocument(this);
            ((JCAWTPrinter)jCPrinter).registerFirstLast(n, n2);
        }
        JCPage jCPage = (JCPage)this.pageList.get(n);
        Rectangle2D rectangle2D = jCPage.getPageSize();
        jCPrinter.setOrientation(jCPage.getOrientation());
        jCPrinter.openDocument(rectangle2D);
        if (jCPrinter instanceof JCAWTPrinter) {
            n6 = -1;
        }
        int n8 = 0;
        while ((bl || n8 == 0) && n8 < n6) {
            int n9 = n;
            while (n3 <= 0 ? n9 >= n2 : n9 <= n2) {
                JCPage jCPage2 = (JCPage)this.pageList.get(n9);
                rectangle2D = jCPage2.getPageSize();
                jCPrinter.setOrientation(jCPage2.getOrientation());
                int n10 = 0;
                while (!(n10 != 0 && bl || n10 >= n6)) {
                    jCPrinter.beginPage(rectangle2D, jCPage2.getPageNumber());
                    jCPage2.draw((Graphics2D)jCPrinter.getGraphics());
                    jCPrinter.endPage(rectangle2D);
                    ++n10;
                }
                if (!bl || n8 + 1 == n6) {
                    this.checkFlushPage(jCPage2);
                }
                n9 += n3;
            }
            ++n8;
        }
        jCPrinter.closeDocument(rectangle2D);
    }

    public void checkOutputPage(JCPage jCPage) {
        int n;
        if (this.outputPolicy != 2) {
            return;
        }
        Rectangle2D rectangle2D = jCPage.getPageSize();
        if (!this.printer.isDocumentOpen()) {
            this.printer.openDocument(rectangle2D);
            this.lastPage = -1;
        }
        if ((n = this.pageList.indexOf(jCPage)) != this.lastPage + 1) {
            return;
        }
        int n2 = this.printer.getNumCopies();
        while (n2 > 0) {
            this.printer.beginPage(rectangle2D, jCPage.getPageNumber());
            jCPage.draw((Graphics2D)this.printer.getGraphics());
            this.printer.endPage(rectangle2D);
            --n2;
        }
        this.checkFlushPage(jCPage);
        this.lastPage = n;
    }

    private void checkFlushPage(JCPage jCPage) {
        if (this.flushPolicy == 2) {
            jCPage.delete();
        }
    }

    private static class BlankTemplate
    extends ArrayList {
        public BlankTemplate(JCUnit jCUnit, double d, double d2, double d3) {
            JCPage jCPage = new JCPage("blank", new JCUnit.Point(jCUnit, 0.0, 0.0), new JCUnit.Dimension(jCUnit, d, d2));
            jCPage.setFlowSectionTemplate(jCPage);
            jCPage.setFlowPageTemplate(jCPage);
            jCPage.setPageType(1);
            JCFrame jCFrame = new JCFrame("blank", new JCUnit.Point(jCUnit, d3, d3), new JCUnit.Dimension(jCUnit, d - 2.0 * d3, d2 - 2.0 * d3));
            Vector<JCFrame> vector = new Vector<JCFrame>(1);
            vector.add(jCFrame);
            jCPage.setFrameList(vector);
            jCPage.setFlowFrameList(vector);
            this.add(jCPage);
        }
    }
}

