/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.FontFileLookup;
import com.klg.jclass.page.TrueTypeFontProperties;
import com.klg.jclass.page.adobe.postscript.TTFParser;
import com.klg.jclass.page.resources.LocaleBundle;
import com.klg.jclass.page.ttf.TTFFontNames;
import com.klg.jclass.util.SettableListResourceBundle;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;

public class FontLibrary {
    public static final int AFM = 0;
    public static final int TTF = 1;
    public static final int ALL_FILE_TYPES = -100;
    public static final int PDF = 0;
    public static final int NUM_OUTPUT_TYPES = 1;
    public static Hashtable[] availableFonts = new Hashtable[]{new Hashtable(), new Hashtable()};
    public static Hashtable[] availableStockFonts = new Hashtable[]{new Hashtable(), new Hashtable()};
    public static ResourceBundle[] stockFontNameMapBundles = new ResourceBundle[1];
    protected static final String defaultUserFontBundleName = "user";
    protected static List[] userFontBundles = new List[]{new Vector(), new Vector()};
    protected static List userFontBundleLookups = new Vector();
    protected static Hashtable automaticFontNameMapTable = new Hashtable();
    public static Hashtable trueTypeFontProperties = new Hashtable();
    protected static boolean autoLoad = false;
    protected static FontLibrary fontLibraryInstance = null;
    protected static boolean suppressErrorMessages = true;

    public static void initFontLibrary() {
        if (fontLibraryInstance == null) {
            fontLibraryInstance = new FontLibrary();
            if (autoLoad) {
                FontLibrary.addFontPackage("C:\\WINNT\\Fonts");
                FontLibrary.addFontPackage("C:\\WINDOWS\\Fonts");
                FontLibrary.addFontPackage("/usr/share/fonts");
                FontLibrary.addFontPackage("/usr/lib/X11/fonts");
            }
        }
    }

    private FontLibrary() {
    }

    public static void setAutoLoad(boolean bl) {
        autoLoad = bl;
    }

    public static boolean isAutoLoad() {
        return autoLoad;
    }

    public static void setSuppressErrorMessages(boolean bl) {
        suppressErrorMessages = bl;
    }

    public static boolean getSuppressErrorMessages() {
        return suppressErrorMessages;
    }

    public static void addFontPackage(String string) {
        FontLibrary.initFontLibrary();
        FontLibrary.addFontPackage(string, true);
    }

    public static void addFontPackage(String string, boolean bl) {
        File[] fileArray;
        File file;
        block21: {
            FontFileLookup fontFileLookup;
            Object object;
            Object object2;
            FontLibrary.initFontLibrary();
            if (string == null) {
                throw new IllegalArgumentException("package path may not be null");
            }
            file = new File(string);
            File[] fileArray2 = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return FontLibrary.isAFMFile(string.trim());
                }
            });
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (fileArray2 != null && n < fileArray2.length) {
                block19: {
                    object2 = new FontFileLookup(0, fileArray2[n].getPath(), 0);
                    try {
                        object = FontLibrary.addAFMToAvailableFonts((FontFileLookup)object2);
                        if (object != null) {
                            vector.add(object);
                        }
                    }
                    catch (IOException iOException) {
                        if (FontLibrary.getSuppressErrorMessages()) break block19;
                        System.err.println(LocaleBundle.string("Warning: Error loading afm file ") + fileArray2[n].getPath());
                        System.err.println("    (" + LocaleBundle.string("Exception:") + " " + iOException.getClass().getName() + " " + iOException.getMessage() + ")");
                    }
                }
                ++n;
            }
            object2 = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return FontLibrary.isTrueTypeFile(string.trim());
                }
            });
            object = new Vector();
            int n2 = 0;
            while (object2 != null && n2 < ((File[])object2).length) {
                block20: {
                    fontFileLookup = new FontFileLookup(0, object2[n2].getPath(), 1);
                    try {
                        fileArray = FontLibrary.addTTFToAvailableFonts(fontFileLookup);
                        if (fileArray != null) {
                            ((Vector)object).addAll(fileArray);
                        }
                    }
                    catch (IOException iOException) {
                        if (FontLibrary.getSuppressErrorMessages()) break block20;
                        System.err.println(LocaleBundle.string("Warning: Error loading ttf file ") + object2[n2].getPath());
                        System.err.println("    (" + LocaleBundle.string("Exception:") + " " + iOException.getClass().getName() + " " + iOException.getMessage() + ")");
                    }
                }
                ++n2;
            }
            fontFileLookup = new FontFileLookup(0, string, defaultUserFontBundleName, 2);
            if (userFontBundleLookups.contains(fontFileLookup)) {
                return;
            }
            try {
                fileArray = fontFileLookup.getResourceBundle();
                if (fileArray == null) {
                    return;
                }
                userFontBundleLookups.add(fontFileLookup);
                SettableListResourceBundle[] settableListResourceBundleArray = new SettableListResourceBundle[1];
                int n3 = 0;
                while (n3 < 1) {
                    settableListResourceBundleArray[n3] = new SettableListResourceBundle();
                    ++n3;
                }
                Enumeration<String> enumeration = fileArray.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    String string3 = fileArray.getString(string2);
                    if (vector.contains(string3)) {
                        settableListResourceBundleArray[0].add(string2, string3);
                    }
                    if (!((Vector)object).contains(string3)) continue;
                    settableListResourceBundleArray[0].add(string2, string3);
                }
                int n4 = 0;
                while (n4 < 1) {
                    userFontBundles[n4].add(settableListResourceBundleArray[n4]);
                    ++n4;
                }
            }
            catch (IOException iOException) {
                if (FontLibrary.getSuppressErrorMessages()) break block21;
                System.err.println(LocaleBundle.string("Warning: Error loading font name map file ") + string + "/" + defaultUserFontBundleName + ".properties");
                System.err.println("    (" + LocaleBundle.string("Exception:") + " " + iOException.getClass().getName() + " " + iOException.getMessage() + ")");
            }
        }
        if (bl) {
            fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            int n = 0;
            while (fileArray != null && n < fileArray.length) {
                FontLibrary.addFontPackage(fileArray[n].getAbsolutePath(), true);
                ++n;
            }
        }
    }

    public static void addFont(String string) throws IOException {
        FontLibrary.initFontLibrary();
        if (string == null) {
            throw new IllegalArgumentException("file location may not be null");
        }
        File file = new File(string);
        if (FontLibrary.isAFMFile(string)) {
            FontFileLookup fontFileLookup = new FontFileLookup(0, file.getPath(), 0);
            FontLibrary.addAFMToAvailableFonts(fontFileLookup);
        } else if (FontLibrary.isTrueTypeFile(string)) {
            FontFileLookup fontFileLookup = new FontFileLookup(0, file.getPath(), 1);
            FontLibrary.addTTFToAvailableFonts(fontFileLookup);
        }
    }

    public static void addFont(URL uRL, int n) throws IOException {
        FontLibrary.initFontLibrary();
        if (uRL == null) {
            throw new IllegalArgumentException("font URL may not be null");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("font type must be either AFM or TTF");
        }
        if (n == 0) {
            FontFileLookup fontFileLookup = new FontFileLookup(2, uRL, 0);
            FontLibrary.addAFMToAvailableFonts(fontFileLookup);
        } else if (n == 1) {
            FontFileLookup fontFileLookup = new FontFileLookup(2, uRL, 1);
            FontLibrary.addTTFToAvailableFonts(fontFileLookup);
        }
    }

    public static void addRelativeFont(String string) throws IOException {
        FontLibrary.initFontLibrary();
        if (string == null) {
            throw new IllegalArgumentException("file location may not be null");
        }
        if (FontLibrary.isAFMFile(string)) {
            FontFileLookup fontFileLookup = new FontFileLookup(3, string, 0);
            FontLibrary.addAFMToAvailableFonts(fontFileLookup);
        } else if (FontLibrary.isTrueTypeFile(string)) {
            FontFileLookup fontFileLookup = new FontFileLookup(3, string, 1);
            FontLibrary.addTTFToAvailableFonts(fontFileLookup);
        }
    }

    protected static String addAFMToAvailableFonts(FontFileLookup fontFileLookup) throws IOException {
        if (availableFonts[0].contains(fontFileLookup)) {
            return null;
        }
        InputStream inputStream = fontFileLookup.openInputStream();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(inputStream));
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        streamTokenizer.nextToken();
        String string = "";
        while (streamTokenizer.ttype != -1) {
            if (streamTokenizer.sval != null && streamTokenizer.sval.equals("FontName")) {
                streamTokenizer.nextToken();
                string = streamTokenizer.sval;
                availableFonts[0].put(string, fontFileLookup);
                break;
            }
            streamTokenizer.nextToken();
        }
        inputStream.close();
        return string;
    }

    protected static List addTTFToAvailableFonts(FontFileLookup fontFileLookup) throws IOException {
        if (availableFonts[0].contains(fontFileLookup)) {
            return null;
        }
        TTFParser tTFParser = new TTFParser();
        List list = tTFParser.parseAllFontNames(fontFileLookup);
        Vector<String> vector = new Vector<String>(list.size());
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                TTFFontNames tTFFontNames = (TTFFontNames)list.get(n);
                fontFileLookup.setTTFFontNames(tTFFontNames);
                vector.add(tTFFontNames.fontName);
                availableFonts[0].put(tTFFontNames.fontName, fontFileLookup);
                if (tTFFontNames.subFamilyName.equals("Bold")) {
                    automaticFontNameMapTable.put(tTFFontNames.familyName + "-Bold", tTFFontNames.fontName);
                } else if (tTFFontNames.subFamilyName.equals("Bold Italic") || tTFFontNames.subFamilyName.equals("Bold Oblique")) {
                    automaticFontNameMapTable.put(tTFFontNames.familyName + "-BoldItalic", tTFFontNames.fontName);
                } else if (tTFFontNames.subFamilyName.equals("Italic") || tTFFontNames.subFamilyName.equals("Oblique")) {
                    automaticFontNameMapTable.put(tTFFontNames.familyName + "-Italic", tTFFontNames.fontName);
                } else {
                    automaticFontNameMapTable.put(tTFFontNames.familyName, tTFFontNames.fontName);
                    automaticFontNameMapTable.put(tTFFontNames.fullName, tTFFontNames.fontName);
                }
                ++n;
            }
        }
        return vector;
    }

    public static void addFontNameMap(String string, String string2) throws IOException {
        FontLibrary.addFontNameMap(string, string2, -100);
    }

    public static void addFontNameMap(String string, String string2, int n) throws IOException {
        FontLibrary.initFontLibrary();
        if (string == null) {
            throw new IllegalArgumentException("location may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        FontFileLookup fontFileLookup = new FontFileLookup(0, string, string2, 2);
        FontLibrary.addFontNameMapBundle(fontFileLookup, n);
    }

    protected static void addFontNameMapBundle(FontFileLookup fontFileLookup, int n) throws IOException {
        if (userFontBundleLookups.contains(fontFileLookup)) {
            return;
        }
        ResourceBundle resourceBundle = fontFileLookup.getResourceBundle();
        if (resourceBundle == null) {
            return;
        }
        userFontBundleLookups.add(fontFileLookup);
        FontLibrary.addFontNameMap(resourceBundle, n);
    }

    public static void addFontNameMap(URL uRL, String string) throws IOException {
        FontLibrary.addFontNameMap(uRL, string, -100);
    }

    public static void addFontNameMap(ResourceBundle resourceBundle, int n) {
        if (resourceBundle != null) {
            if (n == 0) {
                userFontBundles[0].add(resourceBundle);
            } else if (n == 1 || n == -100) {
                userFontBundles[0].add(resourceBundle);
            }
        }
    }

    public static void addFontNameMap(URL uRL, String string, int n) throws IOException {
        FontLibrary.initFontLibrary();
        if (uRL == null) {
            throw new IllegalArgumentException("location may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        FontFileLookup fontFileLookup = new FontFileLookup(1, uRL, string, 2);
        FontLibrary.addFontNameMapBundle(fontFileLookup, n);
    }

    public static void addFontNameMap(URL uRL) throws IOException {
        FontLibrary.addFontNameMap(uRL, -100);
    }

    public static void addFontNameMap(URL uRL, int n) throws IOException {
        FontLibrary.initFontLibrary();
        if (uRL == null) {
            throw new IllegalArgumentException("location URL may not be null");
        }
        FontFileLookup fontFileLookup = new FontFileLookup(2, uRL, "", 2);
        FontLibrary.addFontNameMapBundle(fontFileLookup, n);
    }

    public static void addRelativeFontNameMap(String string, String string2) throws IOException {
        FontLibrary.addRelativeFontNameMap(string, string2, -100);
    }

    public static void addRelativeFontNameMap(String string, String string2, int n) throws IOException {
        FontLibrary.initFontLibrary();
        if (string == null) {
            throw new IllegalArgumentException("location may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        FontFileLookup fontFileLookup = new FontFileLookup(3, string, string2, 2);
        FontLibrary.addFontNameMapBundle(fontFileLookup, n);
    }

    public static String lookupFontNameByUserAlias(String string, int n) {
        String string2 = null;
        string2 = FontLibrary.lookupUserFontName(string, n);
        if (string2 == null && (string2 = FontLibrary.lookupStockFontName(string, n)) == null && (string2 = FontLibrary.lookupAutomaticFontName(string)) == null) {
            if (availableFonts[n].containsKey(string) || availableStockFonts[n].containsKey(string)) {
                string2 = string;
            } else if (availableFonts[n].containsKey(string + "-Regular") || availableStockFonts[n].containsKey(string + "-Regular")) {
                string2 = string + "-Regular";
            } else {
                String string3 = "Times-Roman";
                if (!FontLibrary.getSuppressErrorMessages()) {
                    System.err.println("Warning: font " + string + " not mapped, " + "substituting " + string3);
                }
                if ((string2 = FontLibrary.lookupUserFontName(string3, n)) == null && (string2 = FontLibrary.lookupStockFontName(string3, n)) == null) {
                    string2 = new String(string3);
                }
            }
        }
        return string2.trim();
    }

    public static String lookupStockFontName(String string, int n) {
        FontLibrary.initFontLibrary();
        String string2 = null;
        if (stockFontNameMapBundles[n] != null) {
            try {
                string2 = stockFontNameMapBundles[n].getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (string.indexOf(32) >= 0) {
                    try {
                        string2 = stockFontNameMapBundles[n].getString(string.replace(' ', '_'));
                    }
                    catch (MissingResourceException missingResourceException2) {
                        string2 = null;
                    }
                }
                string2 = null;
            }
        }
        return string2;
    }

    public static String lookupAutomaticFontName(String string) {
        FontLibrary.initFontLibrary();
        String string2 = null;
        if (automaticFontNameMapTable != null) {
            string2 = (String)automaticFontNameMapTable.get(string);
        }
        return string2;
    }

    public static String lookupUserFontName(String string, int n) {
        FontLibrary.initFontLibrary();
        String string2 = null;
        if (userFontBundles[n] != null) {
            int n2 = 0;
            while (n2 < userFontBundles[n].size()) {
                ResourceBundle resourceBundle = (ResourceBundle)userFontBundles[n].get(n2);
                try {
                    string2 = resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    if (string.indexOf(32) >= 0) {
                        try {
                            string2 = resourceBundle.getString(string.replace(' ', '_'));
                        }
                        catch (MissingResourceException missingResourceException2) {
                            string2 = null;
                        }
                    }
                    string2 = null;
                }
                if (string2 != null) break;
                ++n2;
            }
        }
        return string2;
    }

    public static String[] getAvailableFontNames() {
        int n;
        Object object;
        int n2;
        Object object2;
        FontLibrary.initFontLibrary();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        int n3 = 0;
        ResourceBundle resourceBundle = stockFontNameMapBundles[n3];
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            boolean bl = true;
            n2 = n3 + 1;
            while (n2 < 1) {
                object = stockFontNameMapBundles[n2];
                try {
                    Object object3 = ((ResourceBundle)object).getObject((String)object2);
                }
                catch (MissingResourceException missingResourceException) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl) continue;
            object = ((String)object2).replace('_', ' ');
            treeSet.add(object);
        }
        object2 = automaticFontNameMapTable.keys();
        while (object2.hasMoreElements()) {
            String string = (String)object2.nextElement();
            treeSet.add(string);
        }
        List list = userFontBundles[n3];
        n2 = 0;
        while (n2 < list.size()) {
            resourceBundle = (ResourceBundle)list.get(n2);
            enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                Object object4;
                object = enumeration.nextElement();
                boolean bl = true;
                n = n3 + 1;
                while (n < 1 && bl) {
                    object4 = userFontBundles[n];
                    boolean bl2 = false;
                    int n4 = 0;
                    while (n4 < object4.size() && !bl2) {
                        ResourceBundle resourceBundle2 = (ResourceBundle)object4.get(n4);
                        try {
                            Object object5 = resourceBundle2.getObject((String)object);
                            bl2 = true;
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                        ++n4;
                    }
                    if (!bl2) {
                        bl = false;
                    }
                    ++n;
                }
                if (!bl) continue;
                object4 = ((String)object).replace('_', ' ');
                treeSet.add(object4);
            }
            ++n2;
        }
        object = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        n = 0;
        while (iterator.hasNext()) {
            object[n] = (String)iterator.next();
            ++n;
        }
        return object;
    }

    public static String[] getAvailableFontNames(int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        FontLibrary.initFontLibrary();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        ResourceBundle resourceBundle = stockFontNameMapBundles[n];
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            object4 = enumeration.nextElement();
            object3 = ((String)object4).replace('_', ' ');
            treeSet.add(object3);
        }
        object4 = automaticFontNameMapTable.keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            treeSet.add(object3);
        }
        object3 = userFontBundles[n];
        int n2 = 0;
        while (n2 < object3.size()) {
            resourceBundle = (ResourceBundle)object3.get(n2);
            enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                object = ((String)object2).replace('_', ' ');
                treeSet.add(object);
            }
            ++n2;
        }
        object2 = new String[treeSet.size()];
        object = treeSet.iterator();
        int n3 = 0;
        while (object.hasNext()) {
            object2[n3] = (String)object.next();
            ++n3;
        }
        return object2;
    }

    public static FontFileLookup lookupFontFile(String string, int n) {
        FontFileLookup fontFileLookup = null;
        fontFileLookup = (FontFileLookup)availableFonts[n].get(string);
        if (fontFileLookup == null) {
            fontFileLookup = (FontFileLookup)availableStockFonts[n].get(string);
        }
        return fontFileLookup;
    }

    public static TrueTypeFontProperties getTrueTypeFontProperties(String string, int n) {
        FontLibrary.initFontLibrary();
        String string2 = FontLibrary.lookupFontNameByUserAlias(string, n);
        TrueTypeFontProperties trueTypeFontProperties = (TrueTypeFontProperties)FontLibrary.trueTypeFontProperties.get(string2);
        if (trueTypeFontProperties == null) {
            trueTypeFontProperties = new TrueTypeFontProperties();
            FontLibrary.trueTypeFontProperties.put(string2, trueTypeFontProperties);
        }
        return trueTypeFontProperties;
    }

    public static TrueTypeFontProperties lookupTrueTypeFontProperties(String string) {
        FontLibrary.initFontLibrary();
        TrueTypeFontProperties trueTypeFontProperties = (TrueTypeFontProperties)FontLibrary.trueTypeFontProperties.get(string);
        if (trueTypeFontProperties == null) {
            trueTypeFontProperties = new TrueTypeFontProperties();
            FontLibrary.trueTypeFontProperties.put(string, trueTypeFontProperties);
        }
        return trueTypeFontProperties;
    }

    public static boolean isAFMFile(String string) {
        return string.endsWith(".afm") || string.endsWith(".AFM");
    }

    public static boolean isTrueTypeFile(String string) {
        return string.endsWith(".ttf") || string.endsWith(".TTF") || string.endsWith(".ttc") || string.endsWith(".TTC");
    }

    public static List getTTFFontNames(String string) throws IOException {
        if (string == null) {
            return new Vector();
        }
        File file = new File(string);
        FontFileLookup fontFileLookup = new FontFileLookup(0, file.getPath(), 1);
        TTFParser tTFParser = new TTFParser();
        List list = tTFParser.parseFontNames(fontFileLookup);
        return list;
    }

    public static List getTTFFontNames(URL uRL) throws IOException {
        if (uRL == null) {
            return new Vector();
        }
        FontFileLookup fontFileLookup = new FontFileLookup(2, uRL, 1);
        TTFParser tTFParser = new TTFParser();
        List list = tTFParser.parseFontNames(fontFileLookup);
        return list;
    }
}

