/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.SummaryColumn;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.CellColorPage;
import com.klg.jclass.higrid.customizer.CellEditPage;
import com.klg.jclass.higrid.customizer.CellFontPage;
import com.klg.jclass.higrid.customizer.CellFormatPage;
import com.klg.jclass.higrid.customizer.CellGeneralPage;
import com.klg.jclass.higrid.customizer.CellSummaryColumnPage;
import com.klg.jclass.higrid.customizer.GridPropertiesEditor;
import javax.swing.JTabbedPane;

public class CellTabs
extends JTabbedPane {
    private static final boolean TRACE = false;
    public static final int CELL_GENERAL_PAGE = 0;
    public static final int CELL_FONT_PAGE = 1;
    public static final int CELL_COLOR_PAGE = 2;
    public static final int CELL_EDIT_PAGE = 3;
    public static final int CELL_SUMMARY_COLUMN_PAGE = 4;
    public static final int NUM_OF_PAGES = 5;
    static CellFormatPage[] pages;
    static int[] pagesHeader;
    static int[] pagesRecord;
    static int[] pagesSummary;
    JCHiGridNode node;
    int section;

    public CellTabs(int n) {
        this.section = n;
        this.init();
    }

    public void init() {
        if (pages == null) {
            pages = new CellFormatPage[5];
            CellTabs.pages[0] = new CellGeneralPage();
            CellTabs.pages[1] = new CellFontPage();
            CellTabs.pages[2] = new CellColorPage();
            CellTabs.pages[3] = new CellEditPage();
            CellTabs.pages[4] = new CellSummaryColumnPage();
            int n = 0;
            while (n < pages.length) {
                try {
                    CellFormatPage cellFormatPage = pages[n];
                    this.addTab(cellFormatPage.getPageName(), cellFormatPage);
                    this.setEnabledAt(n, false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        if (this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setEditor(GridPropertiesEditor gridPropertiesEditor) {
        int n = 0;
        while (n < pages.length) {
            pages[n].setEditor(gridPropertiesEditor);
            ++n;
        }
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode, CellFormat cellFormat, SummaryColumn summaryColumn) {
        this.node = jCHiGridNode;
        CellFormatPage[] cellFormatPageArray = this.getCurrentPages();
        int n = 0;
        while (n < cellFormatPageArray.length) {
            cellFormatPageArray[n].init(jCHiGridNode, cellFormat, summaryColumn);
            ++n;
        }
    }

    public void setSelectedColumn(CellFormat cellFormat, SummaryColumn summaryColumn) {
        if (cellFormat == null) {
            this.disableAllTabs();
        } else {
            this.enableTabs();
        }
        CellFormatPage[] cellFormatPageArray = this.getCurrentPages();
        int n = 0;
        while (n < cellFormatPageArray.length) {
            boolean bl = cellFormatPageArray[n].isInitializing();
            cellFormatPageArray[n].setInitializing(true);
            cellFormatPageArray[n].setSelectedColumn(cellFormat, summaryColumn);
            cellFormatPageArray[n].setInitializing(bl);
            ++n;
        }
    }

    public void setSection(int n) {
        if (this.section == n) {
            return;
        }
        this.section = n;
        this.updateTabs();
    }

    private int[] getCurrentPageIndices() {
        int[] nArray = null;
        switch (this.section) {
            case 0: {
                nArray = pagesHeader;
                break;
            }
            case 2: {
                nArray = pagesRecord;
                break;
            }
            default: {
                nArray = pagesSummary;
            }
        }
        return nArray;
    }

    private CellFormatPage[] getCurrentPages() {
        int[] nArray = this.getCurrentPageIndices();
        int n = nArray.length;
        CellFormatPage[] cellFormatPageArray = new CellFormatPage[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            cellFormatPageArray[n2] = pages[nArray[n2]];
            ++n2;
        }
        return cellFormatPageArray;
    }

    private void updateTabs() {
        CellFormatPage[] cellFormatPageArray = this.getCurrentPages();
        int n = 0;
        while (n < cellFormatPageArray.length) {
            try {
                CellFormatPage cellFormatPage = cellFormatPageArray[n];
                cellFormatPage.init(this.section);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        this.enableTabs();
        if (this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    private void enableTabs() {
        if (this.getTabCount() > 0) {
            int n = 0;
            while (n < pages.length) {
                this.setEnabledAt(n, this.isTabUsed(n));
                if (this.getComponentAt(n) != null) {
                    this.getComponentAt(n).setEnabled(this.isTabUsed(n));
                }
                ++n;
            }
        }
    }

    public void disableAllTabs() {
        if (this.getTabCount() > 0) {
            int n = 0;
            while (n < pages.length) {
                this.setEnabledAt(n, false);
                if (this.getComponentAt(n) != null) {
                    this.getComponentAt(n).setEnabled(false);
                }
                ++n;
            }
        }
    }

    private boolean isTabUsed(int n) {
        boolean bl = false;
        int[] nArray = this.getCurrentPageIndices();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    static {
        pagesHeader = new int[]{0, 1, 2};
        pagesRecord = new int[]{0, 1, 2, 3};
        pagesSummary = new int[]{0, 1, 2, 4};
    }
}

