/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.SummaryColumn;
import com.klg.jclass.higrid.beans.JCHiGridConverter;
import com.klg.jclass.higrid.beans.JCHiGridEvent;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.CellFormatPage;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.swing.JCGridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CellGeneralPage
extends CellFormatPage
implements ActionListener,
ItemListener {
    JTextField text;
    JTextField width;
    JCheckBox showing;
    JCheckBox allowWidthSizing;
    JComboBox horizontalAlignment;
    JComboBox verticalAlignment;
    JTextField marginInsets;
    JComboBox borderStyle;
    JTextField borderInsets;
    JComboBox clipHints;
    boolean useTextField;
    boolean summaryCellPage;

    public CellGeneralPage() {
        super(LocaleBundle.string("General"));
        this.init();
    }

    public void init() {
        this.setLayout(new JCGridLayout(0, 2, 5, 5));
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (CellGeneralPage.this.isInitializing()) {
                    return;
                }
                CellGeneralPage.this.valueChanged();
            }
        };
        this.useTextField = this.section != 2;
        this.summaryCellPage = this.section == 4 || this.section == 1 || this.section == 3;
        this.text = new JTextField("", 15);
        this.width = new JTextField("", 15);
        this.showing = new JCheckBox(LocaleBundle.string("CellFormatShowing"), true);
        this.allowWidthSizing = new JCheckBox(LocaleBundle.string("Allow Width Sizing"), true);
        this.horizontalAlignment = new JComboBox();
        this.verticalAlignment = new JComboBox();
        this.marginInsets = new JTextField("", 15);
        this.borderStyle = new JComboBox();
        this.borderInsets = new JTextField("", 15);
        this.clipHints = new JComboBox();
        JLabel jLabel = new JLabel("");
        JLabel jLabel2 = new JLabel("");
        JLabel jLabel3 = new JLabel(LocaleBundle.string("HeaderText"));
        JLabel jLabel4 = new JLabel(LocaleBundle.string("Width"));
        JLabel jLabel5 = new JLabel(LocaleBundle.string("HorizontalAlignment"));
        JLabel jLabel6 = new JLabel(LocaleBundle.string("VerticalAlignment"));
        JLabel jLabel7 = new JLabel(LocaleBundle.string("MarginInsets"));
        JLabel jLabel8 = new JLabel(LocaleBundle.string("Border Style"));
        JLabel jLabel9 = new JLabel(LocaleBundle.string("Border Insets"));
        JLabel jLabel10 = new JLabel(LocaleBundle.string("ClipHints"));
        if (this.useTextField) {
            this.text.addActionListener(this);
            this.text.addFocusListener(focusAdapter);
        }
        this.width.addActionListener(this);
        this.width.addFocusListener(focusAdapter);
        this.showing.addItemListener(this);
        this.allowWidthSizing.addItemListener(this);
        String[] stringArray = JCHiGridConverter.getCellHorizontalAlignmentStrings();
        int n = 0;
        while (n < stringArray.length) {
            this.horizontalAlignment.addItem(stringArray[n]);
            ++n;
        }
        this.horizontalAlignment.addItemListener(this);
        String[] stringArray2 = JCHiGridConverter.getCellVerticalAlignmentStrings();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.verticalAlignment.addItem(stringArray2[n2]);
            ++n2;
        }
        this.verticalAlignment.addItemListener(this);
        this.marginInsets.addActionListener(this);
        this.marginInsets.addFocusListener(focusAdapter);
        String[] stringArray3 = JCHiGridConverter.getRowFormatBorderStyleStrings();
        int n3 = 0;
        while (n3 < stringArray3.length - 1) {
            this.borderStyle.addItem(stringArray3[n3]);
            ++n3;
        }
        this.borderStyle.addItemListener(this);
        this.borderInsets.addActionListener(this);
        this.borderInsets.addFocusListener(focusAdapter);
        String[] stringArray4 = JCHiGridConverter.getCellClipHintsStrings();
        int n4 = 0;
        while (n4 < stringArray4.length) {
            this.clipHints.addItem(stringArray4[n4]);
            ++n4;
        }
        this.clipHints.addItemListener(this);
        this.add(jLabel);
        this.add(this.showing);
        if (this.useTextField) {
            this.add(jLabel3);
            this.add(this.text);
        }
        this.add(jLabel4);
        this.add(this.width);
        this.add(jLabel2);
        this.add(this.allowWidthSizing);
        this.add(jLabel5);
        this.add(this.horizontalAlignment);
        this.add(jLabel6);
        this.add(this.verticalAlignment);
        this.add(jLabel7);
        this.add(this.marginInsets);
        this.add(jLabel8);
        this.add(this.borderStyle);
        this.add(jLabel9);
        this.add(this.borderInsets);
        this.add(jLabel10);
        this.add(this.clipHints);
    }

    public void valueChanged() {
        Object object;
        CellFormat cellFormat;
        if (this.cellFormat == null) {
            return;
        }
        boolean bl = false;
        String string = null;
        if (this.useTextField) {
            string = this.text.getText();
            if (string.equals("")) {
                string = null;
            }
            bl = !new String(string == null ? "" : string).equals(new String(this.cellFormat.getText() == null ? "" : this.cellFormat.getText()));
            this.cellFormat.setText(string);
            if (this.summaryCellPage && this.summaryColumn != null && this.summaryColumn.getColumnType() == 1) {
                this.summaryColumn.setName(string);
                this.summaryColumn.setIdentifier();
                this.cellFormat.setName(this.summaryColumn.getIdentifier());
            }
        }
        boolean bl2 = this.showing.isSelected();
        boolean bl3 = this.allowWidthSizing.isSelected();
        if (this.cellFormat.isShowing() != bl2) {
            bl = true;
            this.cellFormat.setShowing(bl2);
            cellFormat = this.getOtherCellFormat();
            if (cellFormat != null) {
                cellFormat.setShowing(bl2);
            }
        }
        if (this.cellFormat.getAllowWidthSizing() != bl3) {
            bl = true;
            this.cellFormat.setAllowWidthSizing(bl3);
            cellFormat = this.getOtherCellFormat();
            if (cellFormat != null) {
                cellFormat.setAllowWidthSizing(bl3);
            }
        }
        boolean bl4 = true;
        string = this.width.getText();
        int n = 0;
        try {
            n = new Integer(string);
        }
        catch (Exception exception) {
            bl4 = false;
        }
        if (bl4) {
            bl = true;
            this.cellFormat.setWidth(n);
            object = this.getOtherCellFormat();
            if (object != null) {
                ((CellFormat)object).setWidth(n);
            }
        }
        bl4 = true;
        string = this.marginInsets.getText();
        object = new StringTokenizer(string, ",");
        int[] nArray = new int[]{2, 2, 2, 2};
        int n2 = 0;
        while (n2 < 4) {
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    nArray[n2] = new Integer(((StringTokenizer)object).nextToken());
                }
                catch (Exception exception) {
                    bl4 = false;
                }
            }
            ++n2;
        }
        if (bl4) {
            this.cellFormat.setMarginInsets(new Insets(nArray[0], nArray[1], nArray[2], nArray[3]));
            bl = true;
        }
        string = (String)this.horizontalAlignment.getSelectedItem();
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        int n3 = JCHiGridConverter.toCellHorizontalAlignment((JCTypeConverter)jCTypeConverter, (String)string, (int)2);
        if (this.cellFormat.getHorizontalAlignment() != n3) {
            bl = true;
        }
        this.cellFormat.setHorizontalAlignment(n3);
        string = (String)this.verticalAlignment.getSelectedItem();
        n3 = JCHiGridConverter.toCellVerticalAlignment((JCTypeConverter)jCTypeConverter, (String)string, (int)0);
        if (this.cellFormat.getVerticalAlignment() != n3) {
            bl = true;
        }
        this.cellFormat.setVerticalAlignment(n3);
        bl4 = true;
        string = this.borderInsets.getText();
        object = new StringTokenizer(string, ",");
        int[] nArray2 = new int[]{2, 2, 2, 2};
        int n4 = 0;
        while (n4 < 4) {
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    nArray2[n4] = new Integer(((StringTokenizer)object).nextToken());
                }
                catch (Exception exception) {
                    bl4 = false;
                }
            }
            ++n4;
        }
        if (bl4) {
            this.cellFormat.setBorderInsets(new Insets(nArray2[0], nArray2[1], nArray2[2], nArray2[3]));
            bl = true;
        }
        string = (String)this.borderStyle.getSelectedItem();
        jCTypeConverter = new JCTypeConverter();
        int n5 = JCHiGridConverter.toRowFormatBorderStyle((JCTypeConverter)jCTypeConverter, (String)string, (int)1);
        if (this.cellFormat.getBorderStyle() != n5) {
            bl = true;
        }
        this.cellFormat.setBorderStyle(n5);
        string = (String)this.clipHints.getSelectedItem();
        int n6 = JCHiGridConverter.toCellClipHints((JCTypeConverter)jCTypeConverter, (String)string, (int)3);
        if (this.cellFormat.getClipHints() != n6) {
            bl = true;
        }
        this.cellFormat.setClipHints(n6);
        if (bl) {
            this.getJCHiGridNode().setChanged();
            this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
        }
    }

    public void showValue() {
        Object object;
        if (this.cellFormat == null) {
            return;
        }
        if (this.useTextField) {
            object = this.cellFormat.getText();
            if (object == null) {
                object = new String("");
            }
            this.text.setText(new String((String)object));
        }
        this.showing.setSelected(this.cellFormat.isShowing());
        this.allowWidthSizing.setSelected(this.cellFormat.getAllowWidthSizing());
        this.width.setText(new Integer(this.cellFormat.getWidth()).toString());
        object = this.cellFormat.getMarginInsets();
        this.marginInsets.setText(new String(((Insets)object).top + "," + ((Insets)object).left + "," + ((Insets)object).bottom + "," + ((Insets)object).right));
        int n = this.cellFormat.getHorizontalAlignment();
        int n2 = -1;
        int n3 = 0;
        while (n3 < JCHiGridConverter.cellHorizontalAlignmentStrings.length) {
            if (n == JCHiGridConverter.cellHorizontalAlignmentValues[n3]) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        n2 = Math.max(0, n2);
        this.horizontalAlignment.setSelectedIndex(n2);
        n = this.cellFormat.getVerticalAlignment();
        n2 = -1;
        int n4 = 0;
        while (n4 < JCHiGridConverter.cellVerticalAlignmentStrings.length) {
            if (n == JCHiGridConverter.cellVerticalAlignmentValues[n4]) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        n2 = Math.max(0, n2);
        this.verticalAlignment.setSelectedIndex(n2);
        Insets insets = this.cellFormat.getBorderInsets();
        this.borderInsets.setText(new String(insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right));
        int n5 = this.cellFormat.getBorderStyle();
        n2 = -1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < JCHiGridConverter.rowFormatBorderStyleValues.length - 1) {
            if (JCHiGridConverter.rowFormatBorderStyleValues[n7] == 1) {
                n6 = JCHiGridConverter.rowFormatBorderStyleValues[n7];
            }
            if (n5 == JCHiGridConverter.rowFormatBorderStyleValues[n7]) {
                n2 = n7;
                break;
            }
            ++n7;
        }
        if (n2 == -1) {
            n2 = n6;
        }
        this.borderStyle.setSelectedIndex(n2);
        int n8 = this.cellFormat.getClipHints();
        n2 = -1;
        int n9 = 0;
        while (n9 < JCHiGridConverter.cellClipHintsStrings.length) {
            if (n8 == JCHiGridConverter.cellClipHintsValues[n9]) {
                n2 = n9;
                break;
            }
            ++n9;
        }
        n2 = Math.max(0, n2);
        this.clipHints.setSelectedIndex(n2);
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode, CellFormat cellFormat, SummaryColumn summaryColumn) {
        this.showValue();
    }

    public void setSelectedColumn(CellFormat cellFormat, SummaryColumn summaryColumn) {
        super.setSelectedColumn(cellFormat, summaryColumn);
        this.showValue();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        this.valueChanged();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        this.valueChanged();
    }

    CellFormat getOtherCellFormat() {
        if (this.summaryCellPage) {
            return null;
        }
        if (this.cellFormat.getOtherCellFormat() != null) {
            return null;
        }
        CellFormat cellFormat = null;
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        int n = jCHiGridNode.getRowFormat(this.section).getDataFormats().indexOf(this.cellFormat);
        RowFormat rowFormat = null;
        if (this.section == 0) {
            rowFormat = jCHiGridNode.getRowFormat(2);
        } else if (this.section == 2) {
            rowFormat = jCHiGridNode.getRowFormat(0);
        } else {
            return null;
        }
        if (n != -1 && rowFormat != null) {
            cellFormat = (CellFormat)rowFormat.getDataFormats().elementAt(n);
        }
        return cellFormat;
    }
}

