/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.LookupTable;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.SummaryColumn;
import com.klg.jclass.higrid.beans.JCHiGridEvent;
import com.klg.jclass.higrid.beans.JCHiGridListener;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.CellTabs;
import com.klg.jclass.higrid.customizer.FormatPage;
import com.klg.jclass.higrid.customizer.GridPropertiesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;

public class BaseCellPage
extends FormatPage
implements ActionListener,
JCHiGridListener {
    int section;
    private static final int UP = 0;
    private static final int DOWN = 1;
    JList columns;
    DefaultListModel columnsModel = new DefaultListModel();
    JButton buttonAdd;
    JButton buttonDelete;
    JButton buttonClear;
    JButton up;
    JButton down;
    CellTabs cellTabManager;

    public BaseCellPage(int n) {
        super(LocaleBundle.string("Cell"));
        this.section = n;
        this.init();
    }

    private boolean isSummaryCellPage() {
        return this.section == 4 || this.section == 1 || this.section == 3;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.columns = new JList(this.columnsModel);
        this.columns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (BaseCellPage.this.isInitializing()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = listSelectionEvent.getFirstIndex();
                while (n <= listSelectionEvent.getLastIndex()) {
                    if (BaseCellPage.this.columns.isSelectedIndex(n)) {
                        BaseCellPage.this.updateUpDownButtons();
                        BaseCellPage.this.cellTabManager.setSelectedColumn(BaseCellPage.this.getSelectedCell(), BaseCellPage.this.getSelectedSummaryColumn());
                        break;
                    }
                    ++n;
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.buttonAdd = new JButton(LocaleBundle.string("CellAdd"));
        this.buttonDelete = new JButton(LocaleBundle.string("CellDelete"));
        this.buttonClear = new JButton(LocaleBundle.string("CellClear"));
        jPanel.setLayout(new BorderLayout());
        this.up = new BasicArrowButton(1);
        this.down = new BasicArrowButton(5);
        this.up.addActionListener(this);
        this.down.addActionListener(this);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel3.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel3.add(this.up);
        jPanel3.add(this.down);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jPanel.add((Component)new JScrollPane(this.columns), "Center");
        jPanel.add((Component)jPanel2, "East");
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 5);
        jPanel4.add((Component)this.buttonAdd, gridBagConstraints2);
        jPanel4.add((Component)this.buttonDelete, gridBagConstraints2);
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        jPanel4.add((Component)this.buttonClear, gridBagConstraints2);
        jPanel.add((Component)jPanel4, "South");
        this.buttonAdd.addActionListener(this);
        this.buttonDelete.addActionListener(this);
        this.buttonClear.addActionListener(this);
        this.setEnabledCellButtons();
        this.cellTabManager = new CellTabs(this.section);
        this.add((Component)jPanel, "West");
        this.add((Component)this.cellTabManager, "East");
    }

    public void setEditor(GridPropertiesEditor gridPropertiesEditor) {
        super.setEditor(gridPropertiesEditor);
        if (this.cellTabManager != null) {
            this.cellTabManager.setEditor(gridPropertiesEditor);
        }
    }

    public void setSection(int n) {
        this.section = n;
        if (this.cellTabManager != null) {
            this.cellTabManager.setSection(n);
        }
    }

    public void valueChanged() {
    }

    public void showValue() {
        Object object;
        if (this.section == 2) {
            this.showRecordValue();
        }
        String string = (String)this.columns.getSelectedValue();
        this.columnsModel.removeAllElements();
        RowFormat rowFormat = this.getJCHiGridNode().getRowFormat(this.section);
        Vector vector = rowFormat.getDataFormats();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (CellFormat)enumeration.nextElement();
                this.columnsModel.addElement(this.isSummaryCellPage() ? ((CellFormat)object).getText() : ((CellFormat)object).getName());
            }
        }
        int n = this.columnsModel.getSize();
        object = new String[n];
        this.columnsModel.copyInto((Object[])object);
        if (n > 0) {
            int n2 = 0;
            if (string != null && string.length() > 0) {
                int n3 = 0;
                while (n3 < ((Object)object).length) {
                    if (((String)object[n3]).equals(string)) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
            }
            this.columns.setSelectedIndex(n2);
        } else {
            this.cellTabManager.disableAllTabs();
        }
        this.setEnabledCellButtons();
        this.updateUpDownButtons();
    }

    void showRecordValue() {
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        if (jCHiGridNode.getRowFormat(2).getDataFormats().size() == 0) {
            this.editor.resetRecordAndHeader(jCHiGridNode, false, true);
            if (jCHiGridNode.getRowFormat(2).getDataFormats().size() > 0) {
                jCHiGridNode.getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)jCHiGridNode.getGridProperties(), jCHiGridNode));
            }
        } else if (jCHiGridNode.getDoRetrieveAllFields()) {
            jCHiGridNode.setDoRetrieveAllFields(false);
            this.editor.retrieveAllFields();
            jCHiGridNode.getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)jCHiGridNode.getGridProperties(), 3, jCHiGridNode, jCHiGridNode.getNodeProperties()));
        }
    }

    void updateUpDownButtons() {
        int n = this.columnsModel.getSize();
        this.up.setEnabled(this.section != 0 && n > 0 && this.columns.getSelectedIndex() != 0);
        this.down.setEnabled(this.section != 0 && n > 0 && this.columns.getSelectedIndex() != n - 1);
    }

    CellFormat getSelectedCell() {
        CellFormat cellFormat = null;
        int n = -1;
        int n2 = this.columnsModel.getSize();
        String string = (String)this.columns.getSelectedValue();
        if (n2 > 0) {
            n = this.columns.getSelectedIndex();
        }
        if (n == -1) {
            return cellFormat;
        }
        RowFormat rowFormat = this.getJCHiGridNode().getRowFormat(this.section);
        Vector vector = rowFormat.getDataFormats();
        if (vector == null) {
            return cellFormat;
        }
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat2 = (CellFormat)enumeration.nextElement();
            if (this.isSummaryCellPage()) {
                if (n3 == n) {
                    cellFormat = cellFormat2;
                    break;
                }
                ++n3;
                continue;
            }
            if (!string.equals(cellFormat2.getName())) continue;
            cellFormat = cellFormat2;
            break;
        }
        return cellFormat;
    }

    SummaryColumn getSelectedSummaryColumn() {
        if (!this.isSummaryCellPage()) {
            return null;
        }
        SummaryColumn summaryColumn = null;
        int n = -1;
        int n2 = this.columnsModel.getSize();
        if (n2 > 0) {
            n = this.columns.getSelectedIndex();
        }
        if (n == -1) {
            return summaryColumn;
        }
        Vector vector = this.getJCHiGridNode().getSummaryColumns(this.section);
        if (vector == null) {
            return summaryColumn;
        }
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SummaryColumn summaryColumn2 = (SummaryColumn)enumeration.nextElement();
            if (n3 == n) {
                summaryColumn = summaryColumn2;
                break;
            }
            ++n3;
        }
        return summaryColumn;
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode) {
        this.showValue();
        this.cellTabManager.setJCHiGridNode(jCHiGridNode, this.getSelectedCell(), this.getSelectedSummaryColumn());
        jCHiGridNode.removeJCHiGridListener((JCHiGridListener)this);
        jCHiGridNode.addJCHiGridListener((JCHiGridListener)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.buttonAdd)) {
                this.addSummaryColumn();
                this.cellTabManager.setSelectedColumn(this.getSelectedCell(), this.getSelectedSummaryColumn());
            } else if (jButton.equals(this.buttonDelete)) {
                if (this.isSummaryCellPage()) {
                    this.deleteSummaryColumn();
                    this.cellTabManager.setSelectedColumn(this.getSelectedCell(), this.getSelectedSummaryColumn());
                }
            } else if (jButton.equals(this.buttonClear)) {
                this.clearSummaryColumns();
                this.cellTabManager.setSelectedColumn(this.getSelectedCell(), this.getSelectedSummaryColumn());
            } else if (jButton.equals(this.up)) {
                this.moveColumn(0);
            } else if (jButton.equals(this.down)) {
                this.moveColumn(1);
            }
        }
    }

    public void JCHiGridValueChanged(JCHiGridEvent jCHiGridEvent) {
        CellFormat cellFormat;
        String string;
        int n = this.columnsModel.getSize();
        String string2 = (String)this.columns.getSelectedValue();
        if (this.isSummaryCellPage() && n > 0 && !(string = (cellFormat = this.getSelectedCell()).getText()).equals(string2)) {
            this.columnsModel.setElementAt(string, this.columns.getSelectedIndex());
        }
    }

    void moveColumn(int n) {
        if (this.section == 2) {
            this.moveColumn(n, (String)this.columns.getSelectedValue(), this.getJCHiGridNode().getRowFormat(0));
        }
        if (this.isSummaryCellPage()) {
            RowFormat rowFormat = this.getJCHiGridNode().getRowFormat(this.section);
            Vector vector = rowFormat.getDataFormats();
            JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
            if (jCHiGridNode == null) {
                return;
            }
            Vector vector2 = jCHiGridNode.getSummaryColumns(this.section);
            if (vector != null && vector2 != null) {
                this.moveColumn(n, this.columns.getSelectedIndex(), rowFormat, vector, vector2);
            }
        } else {
            String string = (String)this.columns.getSelectedValue();
            this.moveColumn(n, string, this.getJCHiGridNode().getRowFormat(this.section));
        }
        this.getJCHiGridNode().setRowFormat(this.section, this.getJCHiGridNode().getRowFormat(this.section));
        this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
    }

    void moveColumn(int n, String string, RowFormat rowFormat) {
        Vector vector = rowFormat.getDataFormats();
        if (vector == null) {
            return;
        }
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (cellFormat.getName().equals(string)) break;
            ++n2;
        }
        this.moveColumn(n, n2, rowFormat, vector, null);
    }

    void moveColumn(int n, int n2, RowFormat rowFormat, Vector vector, Vector vector2) {
        JCHiGridNode jCHiGridNode;
        int n3;
        Vector vector3 = null;
        Vector vector4 = null;
        if (n == 0 && n2 > 0 && n2 < vector.size()) {
            vector3 = new Vector();
            if (vector2 != null) {
                vector4 = new Vector();
            }
            n3 = 0;
            while (n3 < vector.size()) {
                if (n3 == n2 - 1) {
                    vector3.addElement(vector.elementAt(n3 + 1));
                    vector3.addElement(vector.elementAt(n3));
                    if (vector4 != null) {
                        vector4.addElement(vector2.elementAt(n3 + 1));
                        vector4.addElement(vector2.elementAt(n3));
                    }
                    ++n3;
                } else {
                    vector3.addElement(vector.elementAt(n3));
                    if (vector4 != null) {
                        vector4.addElement(vector2.elementAt(n3));
                    }
                }
                ++n3;
            }
        } else if (n == 1 && n2 >= 0 && n2 < vector.size() - 1) {
            vector3 = new Vector();
            if (vector2 != null) {
                vector4 = new Vector();
            }
            n3 = 0;
            while (n3 < vector.size()) {
                if (n3 == n2) {
                    vector3.addElement(vector.elementAt(n3 + 1));
                    vector3.addElement(vector.elementAt(n3));
                    if (vector4 != null) {
                        vector4.addElement(vector2.elementAt(n3 + 1));
                        vector4.addElement(vector2.elementAt(n3));
                    }
                    ++n3;
                } else {
                    vector3.addElement(vector.elementAt(n3));
                    if (vector4 != null) {
                        vector4.addElement(vector2.elementAt(n3));
                    }
                }
                ++n3;
            }
        }
        if (vector3 != null) {
            rowFormat.setDataFormats(vector3);
        }
        if (vector4 != null && (jCHiGridNode = this.getJCHiGridNode()) != null) {
            jCHiGridNode.setSummaryColumns(this.section, vector4);
        }
    }

    void setEnabledCellButtons() {
        this.buttonAdd.setEnabled(this.isSummaryCellPage());
        int n = this.columnsModel.getSize();
        boolean bl = n > 0 && this.isSummaryCellPage();
        this.buttonDelete.setEnabled(bl);
        this.buttonClear.setEnabled(bl);
    }

    void addSummaryColumn() {
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        if (jCHiGridNode == null) {
            return;
        }
        RowFormat rowFormat = jCHiGridNode.getRowFormat(this.section);
        if (rowFormat == null) {
            return;
        }
        Vector vector = jCHiGridNode.getSummaryColumns(this.section);
        if (vector == null) {
            return;
        }
        String string = new String("column");
        SummaryColumn summaryColumn = new SummaryColumn(string);
        vector.addElement(summaryColumn);
        CellFormat cellFormat = new CellFormat();
        cellFormat.setParent(rowFormat);
        try {
            cellFormat.setName(summaryColumn.getIdentifier());
            cellFormat.setText(string);
            cellFormat.setType(summaryColumn.getDataType());
            cellFormat.setCellRenderer(Class.forName(LookupTable.getDefaultCellRendererName(cellFormat.getType())));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        cellFormat.setEditable(false);
        cellFormat.setDefaultSize(this, false);
        Vector<CellFormat> vector2 = rowFormat.getDataFormats();
        if (vector2 == null) {
            vector2 = new Vector<CellFormat>(10);
        }
        vector2.addElement(cellFormat);
        rowFormat.setDataFormats(vector2);
        int n = this.columnsModel.getSize();
        this.columnsModel.addElement(cellFormat.getText());
        this.columns.setSelectedIndex(n);
        this.updateOnColumnListChanged(n);
    }

    void deleteSummaryColumn() {
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        if (jCHiGridNode == null) {
            return;
        }
        RowFormat rowFormat = jCHiGridNode.getRowFormat(this.section);
        if (rowFormat == null) {
            return;
        }
        Vector vector = jCHiGridNode.getSummaryColumns(this.section);
        if (vector == null) {
            return;
        }
        int n = this.columns.getSelectedIndex();
        if (n < 0) {
            return;
        }
        vector.removeElementAt(n);
        Vector vector2 = rowFormat.getDataFormats();
        if (vector2 != null) {
            vector2.removeElementAt(n);
            rowFormat.setDataFormats(vector2);
        }
        this.columns.remove(n);
        int n2 = this.columnsModel.getSize();
        if (n2 > 0) {
            n = Math.min(n2 - 1, n);
            this.columns.setSelectedIndex(n);
        } else {
            n = -1;
        }
        this.updateOnColumnListChanged(n);
    }

    void clearSummaryColumns() {
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        if (jCHiGridNode == null) {
            return;
        }
        RowFormat rowFormat = jCHiGridNode.getRowFormat(this.section);
        if (rowFormat == null) {
            return;
        }
        Vector vector = jCHiGridNode.getSummaryColumns(this.section);
        if (vector == null) {
            return;
        }
        jCHiGridNode.setSummaryColumns(this.section, new Vector(10));
        rowFormat.setDataFormats(new Vector(10));
        this.columns.removeAll();
        this.updateOnColumnListChanged(-1);
    }

    void updateOnColumnListChanged(int n) {
        this.setEnabledCellButtons();
        this.updateUpDownButtons();
        this.cellTabManager.setSelectedColumn(this.getSelectedCell(), this.getSelectedSummaryColumn());
        this.getJCHiGridNode().setRowFormat(this.section, this.getJCHiGridNode().getRowFormat(this.section));
        this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
    }
}

