/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.MetaDataModel;
import java.io.Serializable;

public class SummaryColumn
implements Serializable {
    static final long serialVersionUID = -4348474341309558899L;
    private int table;
    private String name;
    private int columnType;
    private int dataType;
    private int aggregateType;
    private String columnIdentifier;
    public static final int COLUMN_TYPE_UNKNOWN = 0;
    public static final int COLUMN_TYPE_LABEL = 1;
    public static final int COLUMN_TYPE_DATASOURCE = 2;
    public static final int COLUMN_TYPE_AGGREGATE = 3;
    public static final int COLUMN_TYPE_UNBOUND = 4;
    public static final int AGGREGATE_TYPE_NONE = 0;
    public static final int AGGREGATE_TYPE_COUNT = 1;
    public static final int AGGREGATE_TYPE_SUM = 2;
    public static final int AGGREGATE_TYPE_AVERAGE = 3;
    public static final int AGGREGATE_TYPE_MIN = 4;
    public static final int AGGREGATE_TYPE_MAX = 5;
    public static final int AGGREGATE_TYPE_FIRST = 6;
    public static final int AGGREGATE_TYPE_LAST = 7;

    public SummaryColumn(String string) {
        this.init(0, string, 1, 0, 1005);
    }

    public SummaryColumn(MetaDataModel metaDataModel, String string, int n) {
        int n2 = 1005;
        try {
            n2 = metaDataModel.getJavaColumnType(string);
        }
        catch (Exception exception) {
            this.init(0, string, 1, 0, 1005);
            return;
        }
        if (n == 2) {
            this.init(metaDataModel.getMetaID(), string, n, 0, n2);
        } else if (n == 3) {
            int n3 = this.getDefaultAggregateType(n2);
            this.init(metaDataModel.getMetaID(), string, n, n3, n2);
        } else {
            this.init(0, string, 1, 0, 1005);
        }
    }

    public SummaryColumn(MetaDataModel metaDataModel, String string, int n, int n2) {
        if (n != 3) {
            this.init(0, string, 1, 0, 1005);
            return;
        }
        int n3 = 1004;
        if (n2 != 1) {
            try {
                n3 = metaDataModel.getJavaColumnType(string);
            }
            catch (Exception exception) {
                this.init(0, string, 1, 0, 1005);
                return;
            }
        }
        this.init(metaDataModel.getMetaID(), string, n, n2, n3);
    }

    public SummaryColumn(MetaDataModel metaDataModel, String string, int n, int n2, int n3) {
        this.init(metaDataModel.getMetaID(), string, n, n2, n3);
    }

    public SummaryColumn(int n, String string, int n2, int n3, int n4) {
        this.init(n, string, n2, n3, n4);
    }

    public void init(int n, String string, int n2, int n3, int n4) {
        this.name = string;
        this.table = n;
        this.columnType = n2;
        this.aggregateType = n3;
        this.dataType = n4;
        this.setIdentifier();
    }

    public int getDefaultAggregateType(int n) {
        int n2 = 0;
        switch (n) {
            case 1002: 
            case 1003: 
            case 1004: 
            case 1006: 
            case 1007: 
            case 1011: 
            case 1012: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    public String getIdentifier() {
        return this.columnIdentifier;
    }

    public void setIdentifier() {
        this.columnIdentifier = new String(this.name + "." + this.table + "." + this.columnType + "." + this.aggregateType);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = new String(string);
    }

    public int getTable() {
        return this.table;
    }

    public void setTable(int n) {
        this.table = n;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public void setColumnType(int n) {
        this.columnType = n;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public int getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int n) {
        this.aggregateType = n;
    }
}

