/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.Utilities;
import com.klg.jclass.cell.renderers.JCStringCellRenderer;
import com.klg.jclass.higrid.HiGridHeaderRenderer;
import com.klg.jclass.higrid.SortLabel;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class SortLabelCellRenderer
extends JCStringCellRenderer
implements HiGridHeaderRenderer {
    static final long serialVersionUID = -8549022746709463592L;
    public static final int ICON_ARROW = 1;
    public static final int ICON_TRIANGLE = 2;
    public static final int ICON_NONE = 3;
    protected static final String[] arrowDescendingPixels = new String[]{".............", ".............", "...ssss......", "..s...ss.....", ".s....sss....", ".s.... ss....", ".s.....sss...", ".......sss...", "....sssssssss", ".....sssssss.", "......sssss..", ".......sss...", "........s...."};
    protected static final String[] arrowAscendingPixels = new String[]{".............", ".............", "........s....", ".......sss...", "......sssss..", ".....sssssss.", "....sssssssss", ".......sss...", ".s.....sss...", ".s.... ss....", ".s....sss....", "..s...ss.....", "...ssss......"};
    protected static final String[] triangleAscendingPixels = new String[]{".............", ".............", ".............", ".............", ".............", "......d......", ".....d.l.....", "....d...l....", "...d.....l...", "..dllllllll..", ".............", ".............", "............."};
    protected static final String[] triangleDescendingPixels = new String[]{".............", ".............", ".............", ".............", ".............", "..ddddddddd..", "...d.....l...", "....d...l....", ".....d.l.....", "......l......", ".............", ".............", "............."};
    protected static final String[] noneAscendingPixels = new String[]{""};
    protected static final String[] noneDescendingPixels = new String[]{""};
    protected static transient JCIconCreator creator = null;
    protected static transient Image ascendingImage = null;
    protected static transient Image descendingImage = null;
    protected static int CLIP_ARROW_SPACING = 2;
    protected static Color DEFAULT_SORT_COLOR = Color.blue;
    protected static Color sortColor = null;
    protected static Color lightColor = null;
    protected static Color darkColor = null;
    private static final Color WHITE_BRIGHTER = new Color(200, 200, 200);
    private static final Color WHITE_DARKER = new Color(140, 140, 140);
    private static final Color BLACK_BRIGHTER = new Color(125, 125, 125);
    private static final Color BLACK_DARKER = new Color(75, 75, 75);
    private static final double FACTOR = 0.5;

    public static void setImages(int n) {
        switch (n) {
            case 2: {
                sortColor = Color.white;
                lightColor = Color.white;
                darkColor = Color.black;
                SortLabelCellRenderer.makeImage(n);
                break;
            }
            default: {
                SortLabelCellRenderer.setImages(n, DEFAULT_SORT_COLOR);
            }
        }
    }

    public static void setImages(int n, Color color) {
        SortLabelCellRenderer.setSortColor(color);
        SortLabelCellRenderer.makeImage(n);
    }

    public static Image getAscendingImage() {
        return ascendingImage;
    }

    public static void setAscendingImage(Image image) {
        ascendingImage = image;
    }

    public static Image getDescendingImage() {
        return descendingImage;
    }

    public static void setDescendingImage(Image image) {
        descendingImage = image;
    }

    public static void swapImages() {
        Image image = ascendingImage;
        ascendingImage = descendingImage;
        descendingImage = image;
    }

    public SortLabelCellRenderer() {
        SortLabelCellRenderer.setImages(3);
        SortLabelCellRenderer.setImages(2);
        SortLabelCellRenderer.setImages(1);
    }

    protected static void setSortColor(Color color) {
        if (color == null) {
            color = DEFAULT_SORT_COLOR;
        }
        sortColor = color;
        lightColor = SortLabelCellRenderer.brighter(sortColor);
        darkColor = SortLabelCellRenderer.darker(sortColor);
    }

    protected static void makeImages(String[] stringArray, String[] stringArray2) {
        creator.setSize(stringArray.length, stringArray.length);
        creator.setPixels(stringArray);
        ascendingImage = creator.getIcon().getImage();
        creator.clear();
        creator.setSize(stringArray2.length, stringArray2.length);
        creator.setPixels(stringArray2);
        descendingImage = creator.getIcon().getImage();
    }

    protected static void makeImage(int n) {
        if (creator == null) {
            creator = new JCIconCreator();
        }
        creator.setColor('s', sortColor);
        creator.setColor('l', lightColor);
        creator.setColor('d', darkColor);
        switch (n) {
            case 2: {
                SortLabelCellRenderer.makeImages(triangleAscendingPixels, triangleDescendingPixels);
                break;
            }
            case 3: {
                SortLabelCellRenderer.makeImages(noneAscendingPixels, noneDescendingPixels);
                break;
            }
            default: {
                SortLabelCellRenderer.makeImages(arrowAscendingPixels, arrowDescendingPixels);
            }
        }
    }

    public void draw(Graphics graphics, JCCellInfo jCCellInfo, Object object, boolean bl) {
        super.draw(graphics, jCCellInfo, ((SortLabel)object).getLabel(), bl);
        int n = ((SortLabel)object).getDirection();
        if (n != 0) {
            Image image = n == 1 ? ascendingImage : descendingImage;
            Rectangle rectangle = jCCellInfo.getDrawingArea();
            int n2 = jCCellInfo.getHorizontalAlignment();
            int n3 = 0;
            if (n2 == 0 || n2 == 2) {
                n3 = rectangle.width - image.getWidth(null) - CLIP_ARROW_SPACING;
            }
            int n4 = 0;
            graphics.setColor(jCCellInfo.getBackground());
            graphics.fillRect(n3, n4, image.getWidth(null), image.getHeight(null));
            graphics.drawImage(image, n3, n4, jCCellInfo.getBackground(), null);
            Dimension dimension = this.getPreferredSize(graphics, jCCellInfo, object);
            if ((dimension.width > rectangle.width || dimension.height > rectangle.height) && jCCellInfo.getClipHints() != 0) {
                graphics.setColor(Color.black);
                Utilities.drawClipArrows(graphics, jCCellInfo, dimension, 4, this.drawClipArrowOutline);
            }
        }
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        if (object != null && object instanceof SortLabel) {
            Dimension dimension = super.getPreferredSize(graphics, jCCellInfo, ((SortLabel)object).getLabel());
            int n = ascendingImage.getWidth(null);
            if (n > 0) {
                dimension.width += n + CLIP_ARROW_SPACING;
            }
            return dimension;
        }
        return super.getPreferredSize(graphics, jCCellInfo, object);
    }

    protected static Color brighter(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_BRIGHTER;
        }
        if (color.equals(Color.black)) {
            return BLACK_BRIGHTER;
        }
        int n = color.getRed();
        n += (int)((double)(255 - n) * 0.5);
        int n2 = color.getBlue();
        n2 += (int)((double)(255 - n2) * 0.5);
        int n3 = color.getGreen();
        n3 += (int)((double)(255 - n3) * 0.5);
        return new Color(Math.min(n, 255), Math.min(n3, 255), Math.min(n2, 255));
    }

    protected static Color darker(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_DARKER;
        }
        if (color.equals(Color.black)) {
            return BLACK_DARKER;
        }
        return color.darker();
    }
}

