/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.ColumnSortable;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridInternalData;
import com.klg.jclass.higrid.HiGridSortTableEvent;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowTree;
import com.klg.jclass.higrid.SortData;
import com.klg.jclass.higrid.SortGridWalk;
import com.klg.jclass.higrid.SortRowData;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class SortGrid
implements Serializable {
    static final long serialVersionUID = -7147369157833545298L;
    public static final int UNKNOWN = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    protected HiGrid grid = null;
    protected boolean useDefaultSortData = false;

    public SortGrid(HiGrid hiGrid, boolean bl) {
        this.grid = hiGrid;
        this.useDefaultSortData = bl;
    }

    public Comparator getSortable(FormatNode formatNode, String string) {
        Comparator comparator = this.grid.getSortable();
        if (formatNode == null || string == null || string.length() == 0) {
            return comparator;
        }
        RecordFormat recordFormat = formatNode.getRecordFormat();
        Enumeration enumeration = recordFormat.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (string.compareTo(cellFormat.getName()) != 0) continue;
            if (cellFormat.getSortable() == null) break;
            comparator = cellFormat.getSortable();
            break;
        }
        return comparator;
    }

    protected void setInternalData(DataTableModel dataTableModel, SortData sortData) {
        HiGridInternalData hiGridInternalData = (HiGridInternalData)dataTableModel.getInternalData(this.grid);
        if (hiGridInternalData == null) {
            hiGridInternalData = new HiGridInternalData();
            dataTableModel.setInternalData(this.grid, hiGridInternalData);
        }
        hiGridInternalData.setSortData(new SortData(sortData));
    }

    protected void sortColumn(FormatNode formatNode, RowNode rowNode) {
        if (this.grid == null || !this.useDefaultSortData) {
            return;
        }
        SortData sortData = formatNode.getDefaultSortData();
        if (sortData == null) {
            return;
        }
        RowNode rowNode2 = (RowNode)rowNode.getParent();
        RowTree rowTree = this.grid.getRowTree();
        if (!this.sortDataTable(rowTree, rowNode2, formatNode, sortData.columnName, sortData.direction, this.getSortable(formatNode, sortData.columnName))) {
            sortData.setDirection(sortData.getPreviousDirection());
        }
        this.setInternalData(rowNode.getDataTableModel(), sortData);
    }

    public void sortColumn(CellPosition cellPosition, boolean bl) {
        if (this.grid == null) {
            return;
        }
        FormatNode formatNode = cellPosition.row.getFormatNode();
        SortData sortData = null;
        if (this.useDefaultSortData) {
            SortGrid.setDefaultSortData(formatNode, cellPosition.format.getName());
            sortData = formatNode.getDefaultSortData();
        } else {
            sortData = this.getDataTableSortData(formatNode, cellPosition);
        }
        Comparator comparator = this.getSortable(formatNode, sortData.columnName);
        RowTree rowTree = this.grid.getRowTree();
        if (bl) {
            if (!this.sortDataTable(rowTree, (RowNode)cellPosition.row.getParent(), formatNode, sortData.columnName, sortData.direction, comparator)) {
                sortData.setDirection(sortData.getPreviousDirection());
            }
            this.setInternalData(cellPosition.getRowNode().getDataTableModel(), sortData);
        } else {
            SortGridWalk sortGridWalk = new SortGridWalk(formatNode);
            RowNode rowNode = (RowNode)rowTree.getRootNode().getFirstChild();
            RowNode rowNode2 = null;
            while (rowNode != null) {
                sortGridWalk.init();
                rowTree.walk(rowNode, sortGridWalk);
                rowNode = sortGridWalk.getLastRowNode();
                if (rowNode == null) continue;
                rowNode2 = (RowNode)rowNode.getParent();
                if (!this.sortDataTable(rowTree, rowNode2, formatNode, sortData.columnName, sortData.direction, comparator)) {
                    sortData.setDirection(sortData.getPreviousDirection());
                }
                this.setInternalData(rowNode.getDataTableModel(), sortData);
            }
        }
    }

    protected void sortColumn(FormatNode formatNode, RowNode rowNode, SortData sortData) {
        if (this.grid == null) {
            return;
        }
        RowNode rowNode2 = (RowNode)rowNode.getParent();
        if (!this.sortDataTable(this.grid.getRowTree(), rowNode2, formatNode, sortData.columnName, sortData.direction, this.getSortable(formatNode, sortData.columnName))) {
            sortData.setDirection(sortData.getPreviousDirection());
        }
        this.setInternalData(rowNode.getDataTableModel(), sortData);
    }

    public static void setDefaultSortData(FormatNode formatNode, String string) {
        SortData sortData = formatNode.getDefaultSortData();
        if (sortData == null) {
            sortData = new SortData(string);
            formatNode.setDefaultSortData(sortData);
            return;
        }
        if (sortData.columnName.compareTo(string) == 0) {
            sortData.setNextDirection();
        } else {
            sortData.columnName = string;
            sortData.direction = 1;
        }
    }

    public SortData getDataTableSortData(FormatNode formatNode, CellPosition cellPosition) {
        SortData sortData = null;
        DataTableModel dataTableModel = cellPosition.getRowNode().getDataTableModel();
        if (dataTableModel != null) {
            HiGridInternalData hiGridInternalData = (HiGridInternalData)dataTableModel.getInternalData(this.grid);
            if (hiGridInternalData == null) {
                hiGridInternalData = new HiGridInternalData();
                dataTableModel.setInternalData(this.grid, hiGridInternalData);
            }
            if ((sortData = hiGridInternalData.getSortData()) != null && sortData.getColumnName().compareTo(cellPosition.getCellFormat().getName()) == 0) {
                sortData.setNextDirection();
            } else {
                sortData = new SortData(cellPosition.format.getName(), 1);
                hiGridInternalData.setSortData(sortData);
            }
        }
        return sortData;
    }

    public boolean sortDataTable(RowTree rowTree, RowNode rowNode, FormatNode formatNode, String string, int n, Comparator comparator) {
        String[] stringArray = new String[]{string};
        int[] nArray = new int[]{n};
        return this.sortDataTable(rowTree, rowNode, formatNode, stringArray, nArray, comparator);
    }

    public boolean sortDataTable(RowTree rowTree, RowNode rowNode, FormatNode formatNode, String[] stringArray, int[] nArray, Comparator comparator) {
        if (comparator == null && (comparator = this.grid.getSortable()) == null) {
            return false;
        }
        Vector vector = this.setupRowData(rowTree, rowNode, formatNode, stringArray);
        if (vector == null || vector.size() == 0) {
            return false;
        }
        RowNode rowNode2 = ((SortRowData)vector.elementAt((int)0)).rowNode;
        if (this.grid.fireHiGridSortTableEvent(new HiGridSortTableEvent(this.grid, 1, rowNode2, stringArray[0]))) {
            Collections.sort(vector, new ColumnSortable(comparator, nArray));
            this.resetRowData(rowTree, rowNode, formatNode, vector);
            this.addRepeatHeaders(rowTree, rowNode, formatNode);
            SortData sortData = formatNode.getDefaultSortData();
            if (sortData != null) {
                sortData.setDirection(nArray[0]);
            }
            this.grid.fireHiGridSortTableEvent(new HiGridSortTableEvent(this.grid, 2, rowNode2, stringArray[0]));
            return true;
        }
        return false;
    }

    protected Vector setupRowData(RowTree rowTree, RowNode rowNode, FormatNode formatNode, String[] stringArray) {
        Cloneable cloneable;
        int n = 0;
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            cloneable = (RowNode)treeIterator.get();
            if (cloneable != null && ((RowNode)cloneable).getRowFormat() instanceof RecordFormat && ((RowNode)cloneable).getFormatNode() == formatNode) {
                rowTree.removeRepeatHeader((RowNode)cloneable);
                ++n;
            }
            treeIterator.nextElement();
        }
        if (n == 0) {
            return null;
        }
        cloneable = new Vector(n);
        int n2 = 0;
        treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements() && n2 < n) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2 != null && rowNode2.getRowFormat() instanceof RecordFormat && rowNode2.getFormatNode() == formatNode) {
                SortRowData sortRowData = new SortRowData(rowNode2, stringArray.length);
                ((Vector)cloneable).insertElementAt(sortRowData, n2);
                DataTableModel dataTableModel = rowNode2.getDataTableModel();
                if (dataTableModel != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        try {
                            sortRowData.resultData[n3] = dataTableModel.getResultData(rowNode2.getBookmark(), stringArray[n3]);
                        }
                        catch (Exception exception) {
                            sortRowData.resultData[n3] = null;
                        }
                        if (sortRowData.resultData[n3] == null) {
                            sortRowData.resultData[n3] = "";
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            treeIterator.nextElement();
        }
        return cloneable;
    }

    protected void resetRowData(RowTree rowTree, RowNode rowNode, FormatNode formatNode, Vector vector) {
        Serializable serializable;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (SortRowData)enumeration.nextElement();
            rowNode.remove(serializable.rowNode);
        }
        serializable = rowTree.findInsertBeforeNode(rowNode, formatNode);
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            SortRowData sortRowData = (SortRowData)enumeration2.nextElement();
            if (serializable == null) {
                rowNode.add(sortRowData.rowNode);
                continue;
            }
            rowNode.insert((DataSourceTreeNode)serializable, sortRowData.rowNode);
        }
    }

    protected void addRepeatHeaders(RowTree rowTree, RowNode rowNode, FormatNode formatNode) {
        HeaderFormat headerFormat = formatNode.getHeaderFormat();
        if (!headerFormat.isShowing() || !headerFormat.isRepeatHeader()) {
            return;
        }
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2 != null && rowNode2.getRowFormat() instanceof RecordFormat && rowNode2.getFormatNode() == formatNode && rowNode2.getState() == 1 && rowNode2.hasChildren()) {
                rowTree.addRepeatHeader(rowNode2);
            }
            treeIterator.nextElement();
        }
    }
}

