/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HeaderTipWalk;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.Walkable;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class HiGridTip
extends JToolTip
implements Serializable {
    static final long serialVersionUID = -1935142391221415679L;
    protected HiGrid grid;
    protected JLabel label = null;
    protected transient Image panelImage = null;
    protected ImageIcon panelIcon = null;
    protected Dimension preferredSize = null;
    protected RowNode headerRowNode = null;

    public HiGridTip(HiGrid hiGrid) {
        this.grid = hiGrid;
        this.preferredSize = new Dimension(1, 1);
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.setLayout(new BorderLayout());
    }

    protected RowNode getHeaderRowNode(CellPosition cellPosition) {
        if (this.headerRowNode == null) {
            this.headerRowNode = new RowNode();
        }
        this.headerRowNode.setFormatNode(cellPosition.getRowNode().getFormatNode());
        this.headerRowNode.setRowFormat(cellPosition.getRowNode().getFormatNode().getHeaderFormat());
        return this.headerRowNode;
    }

    protected boolean drawTip(Point point, CellPosition cellPosition, Point point2) {
        Serializable serializable;
        if (!(cellPosition.getRowNode().getRowFormat() instanceof RecordFormat) || cellPosition.isIndicator()) {
            return false;
        }
        if (!this.grid.getTopRowNode().equals(cellPosition.getRowNode())) {
            serializable = new HeaderTipWalk(this.grid.getTopRowNode(), cellPosition.getRowNode(), this.grid.getHeaderTipDisplay());
            this.grid.getRowTree().walk(cellPosition.getRowNode(), (Walkable)serializable);
            if (!((HeaderTipWalk)serializable).shouldDisplay()) {
                return false;
            }
        }
        serializable = this.getHeaderRowNode(cellPosition);
        int n = 0;
        int n2 = 0;
        n -= this.grid.getHorizontalScrollbar().getValue();
        n += ((RowNode)serializable).getRowFormat().getIndicatorIndent(this.grid, ((RowNode)serializable).getFormatNode());
        Point point3 = this.grid.getPointFromCellPosition(cellPosition);
        n2 = point3.y - ((RowNode)serializable).getHeight();
        HeaderFormat headerFormat = ((RowNode)serializable).getFormatNode().getHeaderFormat();
        int n3 = this.grid.getGridArea().getSize().width;
        int n4 = headerFormat.getDataWidth();
        n4 = n > 0 ? Math.min(n3 - n, n4) : Math.min(n3, n4 + n);
        int n5 = headerFormat.getHeight();
        if (this.panelImage == null || this.panelImage.getWidth(null) != n4 || this.panelImage.getHeight(null) != n5) {
            if (this.panelImage != null) {
                this.panelImage.flush();
            }
            this.panelImage = this.grid.createImage(n4, n5);
        }
        if (this.panelImage != null) {
            Graphics graphics = this.panelImage.getGraphics();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            Rectangle rectangle2 = new Rectangle(0, 0, headerFormat.getDataWidth(), n5);
            if (n < 0) {
                graphics.translate(n, 0);
            }
            headerFormat.drawCells(graphics, this.grid, (RowNode)serializable, ((RowNode)serializable).getRowFormat().getDataFormats(), rectangle, rectangle2);
            graphics.translate(-rectangle.x, 0);
            if (n < 0) {
                graphics.translate(-n, 0);
            }
            graphics.setClip(0, 0, rectangle.x, n5);
            graphics.setColor(this.getBackground());
            graphics.drawRect(0, 0, this.panelImage.getWidth(null) - 1, this.panelImage.getHeight(null) - 1);
            graphics.dispose();
            this.panelIcon = new ImageIcon(this.panelImage);
            this.label.setIcon(this.panelIcon);
        }
        point2.x = Math.max(n, 0);
        point2.y = n2;
        return true;
    }

    public Point getTip(Point point) {
        CellPosition cellPosition = this.grid.getHorizontalScrollableCellPositionFromPoint(point);
        if (cellPosition == null || cellPosition.getRowNode() == null || cellPosition.getCellFormat() == null) {
            this.grid.getGridArea().setToolTipText(null);
            return null;
        }
        this.preferredSize.setSize(0, 0);
        this.removeAll();
        Point point2 = new Point(0, 0);
        if (this.drawTip(point, cellPosition, point2)) {
            String string = this.grid.getGridArea().getToolTipText();
            this.grid.getGridArea().setToolTipText(string == "1" ? "2" : "1");
            this.label.setSize(this.panelImage.getWidth(null), this.panelImage.getHeight(null));
            this.preferredSize.setSize(this.label.getSize());
            this.add(this.label);
        } else {
            this.grid.getGridArea().setToolTipText(null);
        }
        return point2;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void dispose() {
        if (this.panelImage != null) {
            this.panelImage.flush();
        }
        this.panelImage = null;
        this.panelIcon = null;
        this.headerRowNode = null;
        this.label = null;
        this.removeAll();
        this.setLayout(null);
        this.setComponent(null);
        this.grid = null;
    }
}

