/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.AutoTraverseCallback;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.CellStyleModel;
import com.klg.jclass.higrid.Controller;
import com.klg.jclass.higrid.DefaultAfterDetailsCellStyle;
import com.klg.jclass.higrid.DefaultBeforeDetailsCellStyle;
import com.klg.jclass.higrid.DefaultColumnSelectionHandler;
import com.klg.jclass.higrid.DefaultDataModelListener;
import com.klg.jclass.higrid.DefaultErrorHandler;
import com.klg.jclass.higrid.DefaultFooterCellStyle;
import com.klg.jclass.higrid.DefaultHeaderCellStyle;
import com.klg.jclass.higrid.DefaultRecordCellStyle;
import com.klg.jclass.higrid.DefaultSortable;
import com.klg.jclass.higrid.EditPopupMenu;
import com.klg.jclass.higrid.EditStatusCellFormat;
import com.klg.jclass.higrid.FolderIconStyle;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.FormatTree;
import com.klg.jclass.higrid.GridArea;
import com.klg.jclass.higrid.GridScrollbar;
import com.klg.jclass.higrid.HiGridColumnSelectionEvent;
import com.klg.jclass.higrid.HiGridColumnSelectionListener;
import com.klg.jclass.higrid.HiGridData;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridErrorHandler;
import com.klg.jclass.higrid.HiGridErrorListener;
import com.klg.jclass.higrid.HiGridException;
import com.klg.jclass.higrid.HiGridExpansionEvent;
import com.klg.jclass.higrid.HiGridExpansionListener;
import com.klg.jclass.higrid.HiGridFormatNodeEvent;
import com.klg.jclass.higrid.HiGridFormatNodeListener;
import com.klg.jclass.higrid.HiGridInternalData;
import com.klg.jclass.higrid.HiGridMoveCellEvent;
import com.klg.jclass.higrid.HiGridMoveCellListener;
import com.klg.jclass.higrid.HiGridPrintEvent;
import com.klg.jclass.higrid.HiGridPrintListener;
import com.klg.jclass.higrid.HiGridRepaintEvent;
import com.klg.jclass.higrid.HiGridRepaintListener;
import com.klg.jclass.higrid.HiGridResizeCellEvent;
import com.klg.jclass.higrid.HiGridResizeCellListener;
import com.klg.jclass.higrid.HiGridRowSelectionEvent;
import com.klg.jclass.higrid.HiGridRowSelectionListener;
import com.klg.jclass.higrid.HiGridSortTableEvent;
import com.klg.jclass.higrid.HiGridSortTableListener;
import com.klg.jclass.higrid.HiGridTraverseEvent;
import com.klg.jclass.higrid.HiGridTraverseListener;
import com.klg.jclass.higrid.HiGridUI;
import com.klg.jclass.higrid.HiGridUpdateEvent;
import com.klg.jclass.higrid.HiGridUpdateListener;
import com.klg.jclass.higrid.HiGridValidateEvent;
import com.klg.jclass.higrid.HiGridValidateListener;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.LookupTable;
import com.klg.jclass.higrid.NodeCellFormat;
import com.klg.jclass.higrid.NullGraphics;
import com.klg.jclass.higrid.PixelCountWalk;
import com.klg.jclass.higrid.PrintGrid;
import com.klg.jclass.higrid.PrintGrid12;
import com.klg.jclass.higrid.PrintPreview;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowTree;
import com.klg.jclass.higrid.SortData;
import com.klg.jclass.higrid.SortGrid;
import com.klg.jclass.higrid.beans.JCHiGridExternalDS;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComponentUI;

public class HiGrid
extends JComponent
implements ComponentListener,
JCValidateListener {
    static final long serialVersionUID = 2547033485726164720L;
    public static final int ROW_SELECT_ANY = 0;
    public static final int ROW_SELECT_IN_SAME_LEVEL = 1;
    public static final int ROW_SELECT_IN_SAME_TABLE = 2;
    public static final int SELECT_ROWS_CURRENT = 0;
    public static final int SELECT_ROWS_ALL_IN_SAME_LEVEL = 1;
    public static final int SELECT_ROWS_ALL_IN_SAME_TABLE = 2;
    public static final int SELECT_ROWS_ALL = 3;
    public static final int DELETE_ROWS_CURRENT = 0;
    public static final int DELETE_ROWS_SELECTED = 1;
    public static final int CANCEL_ROWS_CURRENT = 0;
    public static final int CANCEL_ROWS_SELECTED = 1;
    public static final int CANCEL_ROWS_ALL = 2;
    public static final int UPDATE_ROWS_CURRENT = 0;
    public static final int UPDATE_ROWS_SELECTED = 1;
    public static final int UPDATE_ROWS_ALL = 2;
    public static final int REQUERY_ROWS_RECORD = 0;
    public static final int REQUERY_ROWS_RECORD_AND_DETAILS = 1;
    public static final int REQUERY_ROWS_SELECTED = 2;
    public static final int REQUERY_ROWS_SELECTED_AND_DETAILS = 3;
    public static final int REQUERY_ROWS_ALL = 4;
    public static final int MOVE_TO_ROW_HIGRID_FIRST = 0;
    public static final int MOVE_TO_ROW_HIGRID_PREVIOUS = 1;
    public static final int MOVE_TO_ROW_HIGRID_NEXT = 2;
    public static final int MOVE_TO_ROW_HIGRID_LAST = 3;
    public static final int MOVE_TO_ROW_TABLE_FIRST = 4;
    public static final int MOVE_TO_ROW_TABLE_PREVIOUS = 5;
    public static final int MOVE_TO_ROW_TABLE_NEXT = 6;
    public static final int MOVE_TO_ROW_TABLE_LAST = 7;
    public static final int MOVE_TO_ROW_PARENT = 8;
    public static final int PRINT_AS_DISPLAYED = 0;
    public static final int PRINT_AS_EXPANDED = 1;
    public static final int PRINT_EXPAND_ALL = 2;
    public static final int EDIT_SIZE_TO_CELL = 0;
    public static final int EDIT_ENSURE_MINIMUM_SIZE = 1;
    public static final int EDIT_ENSURE_PREFERRED_SIZE = 2;
    public static final int HEADER_TIP_DISPLAY_MINIMAL = 0;
    public static final int HEADER_TIP_DISPLAY_LIKE_REPEAT_HEADER = 1;
    public static final int HEADER_TIP_DISPLAY_ALWAYS = 2;
    public static final int INITIAL_NODE_WIDTH = 20;
    public static final int INITIAL_EDIT_STATUS_WIDTH = 20;
    public static final int INITIAL_LEVEL_INDENT = 25;
    public static final int INITIAL_EXTRA_WIDTH = 10;
    protected static final int NODE_INDICATOR_CELL = -10;
    protected static final int EDITSTATUS_INDICATOR_CELL = -11;
    protected static final int NUMBER_OF_INDICATOR_CELLS = 2;
    protected static final int FIRST_EDITABLE_COLUMN = 0;
    private boolean firstLayout = true;
    protected Controller controller = null;
    protected LookupTable lookupTable = null;
    private JPanel horizontalPanel;
    private JPanel verticalPanel;
    private JPanel cornerPanel;
    private GridScrollbar horizontalScrollbar;
    private GridScrollbar verticalScrollbar;
    private FormatTree formatTree = null;
    private RowTree rowTree = null;
    protected FolderIconStyle folderIconStyle = null;
    private DataModel dataModel = null;
    private GridArea gridArea = null;
    protected DataModelListener dataModelListener = null;
    protected boolean autoEdit = false;
    protected boolean batched = false;
    protected boolean beep = true;
    protected boolean connectionsVisible = true;
    protected Cursor defaultCursor = null;
    protected boolean editable = true;
    protected boolean editorHidden = false;
    protected int extraWidth = 0;
    protected boolean headerTipVisible;
    protected int headerTipDisplay;
    protected boolean rowHeightResizingAll = false;
    protected boolean sortIconsVisible = true;
    protected boolean trackCursor = true;
    protected int verticalScrollbarConstraints = 3;
    protected int horizontalScrollbarConstraints = 5;
    protected Border editorBorder = null;
    protected CellStyleModel headerCellStyle = null;
    protected CellStyleModel recordCellStyle = null;
    protected CellStyleModel footerCellStyle = null;
    protected CellStyleModel beforeDetailsCellStyle = null;
    protected CellStyleModel afterDetailsCellStyle = null;
    protected boolean scrollOnMoveEvent = true;
    private boolean levelIndented = true;
    private int nodeWidth = 20;
    private int editStatusWidth = 20;
    protected HiGridErrorHandler errorHandler = null;
    protected HiGridColumnSelectionListener columnSelectionHandler = null;
    protected JCListenerList hiGridColumnSelectionListeners = null;
    protected JCListenerList hiGridErrorListeners = null;
    protected JCListenerList hiGridExpansionListeners = null;
    protected JCListenerList hiGridFormatNodeListeners = null;
    protected JCListenerList hiGridMoveCellListeners = null;
    protected JCListenerList hiGridPrintListeners = null;
    protected JCListenerList hiGridRepaintListeners = null;
    protected JCListenerList hiGridResizeCellListeners = null;
    protected JCListenerList hiGridRowSelectionListeners = null;
    protected JCListenerList hiGridSortTableListeners = null;
    protected JCListenerList hiGridTraverseListeners = null;
    protected JCListenerList hiGridUpdateListeners = null;
    protected JCListenerList hiGridValidateListeners = null;
    protected AutoTraverseCallback autoTraverseCallback = null;
    protected boolean allowPopupMenu = true;
    protected EditPopupMenu popupMenu = null;
    protected boolean allowRowSelection = true;
    protected int rowSelectionMode = 0;
    protected boolean printing = false;
    protected PrintGrid printGrid = null;
    protected boolean printFoldersAndConnections = false;
    protected int printFormat = 0;
    protected int[] printMetaID = null;
    protected boolean allowSorting = true;
    protected Comparator defaultSortable = null;
    protected Comparator sortable = null;
    protected transient boolean adviseClearAllFormats;
    private boolean fNewFocusModel = JCEnvironment.getJavaVersion() >= 140;

    public HiGrid() {
        this.setErrorHandler(new DefaultErrorHandler(this));
        this.setColumnSelectionHandler(new DefaultColumnSelectionHandler(this));
        this.setController(new Controller(this));
        this.setDataModelListener(new DefaultDataModelListener(this));
        this.setLookupTable(new LookupTable(this));
        this.setPrintGrid(new PrintGrid12(this));
        this.sortable = this.defaultSortable = new DefaultSortable();
        this.setEditPopupMenu(new EditPopupMenu(this));
        this.verticalScrollbar = new GridScrollbar(this, 1);
        this.horizontalPanel = new JPanel();
        this.horizontalPanel.setLayout(new BorderLayout());
        this.verticalPanel = new JPanel();
        this.verticalPanel.setLayout(new BorderLayout());
        this.horizontalScrollbar = new GridScrollbar(this, 0);
        this.cornerPanel = new JPanel();
        int n = this.verticalScrollbar.getComponent().getPreferredSize().width;
        this.cornerPanel.setPreferredSize(new Dimension(n, n));
        this.setGridArea(new GridArea(this));
        this.addComponentListener(this);
        this.setHeaderCellStyle(new DefaultHeaderCellStyle());
        this.setRecordCellStyle(new DefaultRecordCellStyle());
        this.setFooterCellStyle(new DefaultFooterCellStyle());
        this.setBeforeDetailsCellStyle(new DefaultBeforeDetailsCellStyle());
        this.setAfterDetailsCellStyle(new DefaultAfterDetailsCellStyle());
        this.setEditorBorder(this.getDefaultEditorBorder());
        this.setHeaderTipVisible(true);
        this.setHeaderTipDisplay(0);
        this.setExtraWidth(10);
        this.setFormatTree(new FormatTree(this));
        this.setRowTree(new RowTree(this));
        this.folderIconStyle = new FolderIconStyle(this);
        this.folderIconStyle.setStyle(1);
        this.verticalScrollbar.initValues();
        this.horizontalScrollbar.initValues();
        this.setDefaultCursor(0);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        UIManager.getDefaults().put("HiGridUI", "com.klg.jclass.higrid.HiGridUI");
        this.setUI(HiGridUI.createUI(this));
    }

    public void addNotify() {
        super.addNotify();
    }

    public HiGridUI getUI() {
        return (HiGridUI)this.ui;
    }

    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
    }

    public void updateUI() {
        this.setUI((HiGridUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "HiGridUI";
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.gridArea != null) {
            this.gridArea.addMouseListener(mouseListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (this.gridArea != null) {
            this.gridArea.removeMouseListener(mouseListener);
        }
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.gridArea != null) {
            this.gridArea.addMouseMotionListener(mouseMotionListener);
        }
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.gridArea != null) {
            this.gridArea.removeMouseMotionListener(mouseMotionListener);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.gridArea != null) {
            if (this.fNewFocusModel) {
                this.gridArea.setFocusTraversalKeysEnabled(false);
            }
            this.gridArea.addKeyListener(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.gridArea != null) {
            this.gridArea.removeKeyListener(keyListener);
        }
    }

    public JComponent getGridArea() {
        return this.gridArea;
    }

    public void setGridArea(GridArea gridArea) {
        this.removeMouseListener(this.controller);
        this.removeMouseMotionListener(this.controller);
        this.removeKeyListener(this.controller);
        if (this.gridArea != null) {
            this.remove(this.gridArea);
            this.gridArea.removeAll();
            this.gridArea.setToolTipText(null);
            this.gridArea.toolTip.dispose();
            this.gridArea.toolTip = null;
            this.gridArea.dispose();
        }
        this.gridArea = gridArea;
        this.addMouseListener(this.controller);
        this.addMouseMotionListener(this.controller);
        this.addKeyListener(this.controller);
        if (gridArea != null) {
            this.setLayout(null);
            this.layoutGrid();
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.removeMouseListener(this.controller);
        this.removeMouseMotionListener(this.controller);
        this.removeKeyListener(this.controller);
        if (this.controller != null) {
            this.controller.setCurrentCell(null);
            this.controller.removeAllActions();
        }
        this.controller = controller;
        this.addMouseListener(this.controller);
        this.addMouseMotionListener(this.controller);
        this.addKeyListener(this.controller);
    }

    public DataModelListener getDataModelListener() {
        return this.dataModelListener;
    }

    protected void setDataModelListener(DataModelListener dataModelListener) {
        this.dataModelListener = dataModelListener;
    }

    public GridScrollbar getVerticalScrollbar() {
        return this.verticalScrollbar;
    }

    public GridScrollbar getHorizontalScrollbar() {
        return this.horizontalScrollbar;
    }

    protected void resetScrollbarConstraints() {
        this.remove(this.verticalPanel);
        this.remove(this.horizontalPanel);
        this.verticalPanel.removeAll();
        this.horizontalPanel.removeAll();
        this.add((Component)this.verticalPanel, this.convertConstraints(this.verticalScrollbarConstraints));
        this.verticalPanel.add(this.verticalScrollbar.getComponent());
        this.add((Component)this.horizontalPanel, this.convertConstraints(this.horizontalScrollbarConstraints));
        this.horizontalPanel.add(this.horizontalScrollbar.getComponent());
        this.horizontalPanel.add((Component)this.cornerPanel, this.convertConstraints(this.verticalScrollbarConstraints));
    }

    public LookupTable getLookupTable() {
        return this.lookupTable;
    }

    public void setLookupTable(LookupTable lookupTable) {
        if (this.lookupTable != null) {
            // empty if block
        }
        this.lookupTable = lookupTable;
    }

    public FormatTree getFormatTree() {
        return this.formatTree;
    }

    public void setFormatTree(FormatTree formatTree) {
        if (this.formatTree != null) {
            // empty if block
        }
        this.formatTree = formatTree;
    }

    public RowTree getRowTree() {
        return this.rowTree;
    }

    public void setRowTree(RowTree rowTree) {
        if (this.rowTree != null) {
            // empty if block
        }
        this.rowTree = rowTree;
    }

    public HiGridErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(HiGridErrorHandler hiGridErrorHandler) {
        this.removeHiGridErrorListener(this.errorHandler);
        this.errorHandler = hiGridErrorHandler;
        this.addHiGridErrorListener(this.errorHandler);
    }

    public HiGridColumnSelectionListener getColumnSelectionHandler() {
        return this.columnSelectionHandler;
    }

    public void setColumnSelectionHandler(HiGridColumnSelectionListener hiGridColumnSelectionListener) {
        this.removeHiGridColumnSelectionListener(this.columnSelectionHandler);
        this.columnSelectionHandler = hiGridColumnSelectionListener;
        this.addHiGridColumnSelectionListener(this.columnSelectionHandler);
    }

    public AutoTraverseCallback getAutoTraverseCallback() {
        return this.autoTraverseCallback;
    }

    public void setAutoTraverseCallback(AutoTraverseCallback autoTraverseCallback) {
        this.autoTraverseCallback = autoTraverseCallback;
    }

    public Comparator getDefaultSortable() {
        return this.defaultSortable;
    }

    public CellStyleModel getCellStyle(int n) {
        CellStyleModel cellStyleModel = null;
        switch (n) {
            case 2: {
                cellStyleModel = this.getHeaderCellStyle();
                break;
            }
            case 1: {
                cellStyleModel = this.getRecordCellStyle();
                break;
            }
            case 3: {
                cellStyleModel = this.getFooterCellStyle();
                break;
            }
            case 4: {
                cellStyleModel = this.getBeforeDetailsCellStyle();
                break;
            }
            case 5: {
                cellStyleModel = this.getAfterDetailsCellStyle();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return cellStyleModel;
    }

    public CellStyleModel getHeaderCellStyle() {
        return this.headerCellStyle;
    }

    protected void setHeaderCellStyle(CellStyleModel cellStyleModel) {
        this.headerCellStyle = cellStyleModel;
    }

    public CellStyleModel getRecordCellStyle() {
        return this.recordCellStyle;
    }

    protected void setRecordCellStyle(CellStyleModel cellStyleModel) {
        this.recordCellStyle = cellStyleModel;
    }

    public CellStyleModel getFooterCellStyle() {
        return this.footerCellStyle;
    }

    protected void setFooterCellStyle(CellStyleModel cellStyleModel) {
        this.footerCellStyle = cellStyleModel;
    }

    public CellStyleModel getBeforeDetailsCellStyle() {
        return this.beforeDetailsCellStyle;
    }

    protected void setBeforeDetailsCellStyle(CellStyleModel cellStyleModel) {
        this.beforeDetailsCellStyle = cellStyleModel;
    }

    public CellStyleModel getAfterDetailsCellStyle() {
        return this.afterDetailsCellStyle;
    }

    protected void setAfterDetailsCellStyle(CellStyleModel cellStyleModel) {
        this.afterDetailsCellStyle = cellStyleModel;
    }

    public Comparator getSortable() {
        return this.sortable;
    }

    public void setSortable(Comparator comparator) {
        this.sortable = comparator;
    }

    public int getVerticalScrollbarDisplay() {
        return this.verticalScrollbar.getDisplay();
    }

    public void setVerticalScrollbarDisplay(int n) {
        this.verticalScrollbar.setDisplay(n);
        this.refresh();
    }

    public int getHorizontalScrollbarDisplay() {
        return this.horizontalScrollbar.getDisplay();
    }

    public void setHorizontalScrollbarDisplay(int n) {
        this.horizontalScrollbar.setDisplay(n);
        this.refresh();
    }

    public int getHorizontalScrollbarConstraints() {
        return this.horizontalScrollbarConstraints;
    }

    public void setHorizontalScrollbarConstraints(int n) {
        switch (n) {
            case 1: 
            case 5: {
                this.horizontalScrollbarConstraints = n;
                this.resetScrollbarConstraints();
            }
        }
    }

    public int getVerticalScrollbarConstraints() {
        return this.verticalScrollbarConstraints;
    }

    public void setVerticalScrollbarConstraints(int n) {
        switch (n) {
            case 3: 
            case 7: {
                this.verticalScrollbarConstraints = n;
                this.resetScrollbarConstraints();
            }
        }
    }

    protected String convertConstraints(int n) {
        String string = null;
        switch (n) {
            case 3: {
                string = "East";
                break;
            }
            case 7: {
                string = "West";
                break;
            }
            case 1: {
                string = "North";
                break;
            }
            case 5: {
                string = "South";
            }
        }
        return string;
    }

    public Border getEditorBorder() {
        return this.editorBorder;
    }

    public void setEditorBorder(Border border) {
        this.editorBorder = border;
    }

    public Border getDefaultEditorBorder() {
        return this.createDefaultEditorBorder(Color.green, 2, new Insets(2, 2, 2, 2));
    }

    public Border createDefaultEditorBorder(Color color, int n, Insets insets) {
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(color, n), new EmptyBorder(insets));
        return compoundBorder;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setAutoEdit(boolean bl) {
        this.autoEdit = bl;
    }

    public RowNode getCurrentRowNode() {
        CellPosition cellPosition = this.controller.getCurrentCell();
        if (cellPosition != null) {
            return cellPosition.row;
        }
        return null;
    }

    public RowNode getRowNode(long l) {
        return this.rowTree.findRecordRowNode(null, l);
    }

    public RowNode getRowNode(int n) {
        return this.rowTree.getRowNode(n);
    }

    public int getRowIndex(RowNode rowNode) {
        return this.rowTree.getRowIndex(rowNode);
    }

    public RowNode[] getTableRowNodes(RowNode rowNode) {
        if (rowNode == null) {
            return null;
        }
        FormatNode formatNode = rowNode.getFormatNode();
        DataTableModel dataTableModel = rowNode.getDataTableModel();
        if (dataTableModel == null) {
            return null;
        }
        int n = dataTableModel.getRowCount();
        if (n == 0) {
            return null;
        }
        RowNode[] rowNodeArray = new RowNode[n];
        CellPosition cellPosition = this.controller.goLevelHome(rowNode);
        if (cellPosition == null) {
            return null;
        }
        rowNode = cellPosition.row;
        if (rowNode == null) {
            return null;
        }
        int n2 = 0;
        rowNodeArray[n2++] = rowNode;
        while (rowNode != null) {
            if ((rowNode = (RowNode)rowNode.getNextSibling()) == null) break;
            if (!(rowNode.getRowFormat() instanceof RecordFormat)) continue;
            if (rowNode.getFormatNode() != formatNode) break;
            rowNodeArray[n2++] = rowNode;
        }
        return rowNodeArray;
    }

    public boolean moveCellEditor(RowNode rowNode, int n) {
        CellPosition cellPosition;
        return rowNode.getRowFormat() instanceof RecordFormat && this.controller.validateAndTraverse(cellPosition = new CellPosition(rowNode, n), n, null);
    }

    public RowNode getTopRowNode() {
        return this.rowTree.getTopRowNode();
    }

    public void setTopRowNode(RowNode rowNode) {
        this.rowTree.setTopRow(rowNode);
        this.refresh();
    }

    public void setTopRowBookmark(long l) {
        this.setTopRowNode(this.rowTree.findRecordRowNode(null, l));
    }

    public int getTopRowIndex() {
        return this.getVerticalScrollbar().getValue();
    }

    public void setTopRowIndex(int n) {
        this.rowTree.setTopRow(n);
        this.refresh();
    }

    public boolean isRowHeightResizingAll() {
        return this.rowHeightResizingAll;
    }

    public void setRowHeightResizingAll(boolean bl) {
        this.rowHeightResizingAll = bl;
    }

    public int getExtraWidth() {
        return this.extraWidth;
    }

    public void setExtraWidth(int n) {
        this.extraWidth = n;
    }

    public boolean isBeepOnInvalid() {
        return this.beep;
    }

    public void setBeepOnInvalid(boolean bl) {
        this.beep = bl;
    }

    public boolean isHeaderTipVisible() {
        return this.headerTipVisible;
    }

    public void setHeaderTipVisible(boolean bl) {
        this.headerTipVisible = bl;
        this.getGridArea().setToolTipText(bl ? "1" : null);
    }

    public int getHeaderTipDisplay() {
        return this.headerTipDisplay;
    }

    public void setHeaderTipDisplay(int n) {
        this.headerTipDisplay = n;
    }

    public boolean isRowtipVisible() {
        return this.verticalScrollbar.isRowtipVisible();
    }

    public void setRowtipVisible(boolean bl) {
        this.verticalScrollbar.setRowtipVisible(bl);
    }

    public boolean isEditorHidden() {
        return this.editorHidden;
    }

    public void setEditorHidden(boolean bl) {
        this.editorHidden = bl;
    }

    public boolean isConnectionsVisible() {
        return this.connectionsVisible;
    }

    public void setConnectionsVisible(boolean bl) {
        this.connectionsVisible = bl;
        this.refresh();
    }

    public boolean isSortIconsVisible() {
        return this.sortIconsVisible;
    }

    public void setSortIconsVisible(boolean bl) {
        this.sortIconsVisible = bl;
        this.refresh();
    }

    public boolean isScrollOnMoveEvent() {
        return this.scrollOnMoveEvent;
    }

    public void setScrollOnMoveEvent(boolean bl) {
        this.scrollOnMoveEvent = bl;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        boolean bl;
        this.removeOldReferences();
        if (dataModel == null || dataModel.getMetaDataTree() == null || dataModel.getMetaDataTree().getRoot() == null) {
            dataModel = null;
        }
        boolean bl2 = bl = this.dataModel == null;
        if (dataModel == null || dataModel instanceof HiGridData) {
            if (this.dataModel != null) {
                this.dataModel.removeDataModelListener(this.getDataModelListener());
                this.dataModel.clearDataTableTreeInternalData(this);
                bl = true;
            }
            this.dataModel = dataModel;
        } else if (dataModel instanceof DataModel) {
            if (this.dataModel != null) {
                if (this.dataModel instanceof HiGridData) {
                    if (!((HiGridData)this.dataModel).dataModel.equals(dataModel)) {
                        this.dataModel.removeDataModelListener(this.getDataModelListener());
                        this.dataModel.clearDataTableTreeInternalData(this);
                        bl = true;
                    }
                } else if (!this.dataModel.equals(dataModel)) {
                    this.dataModel.removeDataModelListener(this.getDataModelListener());
                    this.dataModel.clearDataTableTreeInternalData(this);
                    bl = true;
                }
            }
            this.dataModel = new HiGridData(dataModel);
        }
        if (this.dataModel != null && bl) {
            this.dataModel.addDataModelListener(this.getDataModelListener());
        }
        if (this.dataModel != null) {
            this.formatTree.createFormatTreeFromDataModel(this.dataModel);
        }
        this.resetRunTimeGrid();
        this.createDefaultTrees();
        this.refresh();
    }

    protected void removeOldReferences() {
        if (this.horizontalScrollbar != null) {
            this.horizontalScrollbar.removeOldReferences();
        }
        if (this.verticalScrollbar != null) {
            this.verticalScrollbar.removeOldReferences();
        }
    }

    public int getFolderIconStyle() {
        return this.folderIconStyle.getStyle();
    }

    public void setFolderIconStyle(int n) {
        this.folderIconStyle.setStyle(n);
        this.refresh();
    }

    public Image getFolderIcon(int n) {
        return this.folderIconStyle.getFolderIcon(n);
    }

    public void setFolderIcon(Image image, int n) {
        this.folderIconStyle.setFolderIcon(image, n);
        this.refresh();
    }

    public boolean isBatched() {
        return this.batched;
    }

    public void setBatched(boolean bl) {
        this.batched = bl;
        if (!bl) {
            this.controller.initializeEditor();
            this.refresh();
        }
    }

    public boolean isLevelIndented() {
        return this.levelIndented;
    }

    public void setLevelIndented(boolean bl) {
        this.levelIndented = bl;
        this.recalculateRowFormats(-10);
        this.refresh();
    }

    public int getNodeWidth() {
        return this.nodeWidth;
    }

    public void setNodeWidth(int n) {
        this.nodeWidth = n;
        this.recalculateRowFormats(-10);
        this.refresh();
    }

    public int getEditStatusWidth() {
        return this.editStatusWidth;
    }

    public void setEditStatusWidth(int n) {
        this.editStatusWidth = n;
        this.recalculateRowFormats(-11);
        this.refresh();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void resetSortIndications(RowNode rowNode, boolean bl) {
        if (rowNode == null) {
            TreeIterator treeIterator = ((RowNode)this.rowTree.getRoot()).getIterator();
            while (treeIterator.hasMoreElements()) {
                rowNode = (RowNode)treeIterator.get();
                this.resetSortIndicationsInternal(rowNode, bl);
                treeIterator.nextElement();
            }
        } else {
            this.resetSortIndicationsInternal(rowNode, bl);
        }
    }

    protected void resetSortIndications(long l, boolean bl) {
        RowNode rowNode = this.getRowTree().findRecordRowNode(null, l);
        this.resetSortIndications(rowNode, bl);
    }

    protected void resetSortIndicationsInternal(RowNode rowNode, boolean bl) {
        if (rowNode == null || !(rowNode.getRowFormat() instanceof RecordFormat)) {
            return;
        }
        HiGridInternalData hiGridInternalData = (HiGridInternalData)rowNode.getDataTableModel().getInternalData(this);
        if (hiGridInternalData != null) {
            hiGridInternalData.setSortData(null);
        }
        if (bl) {
            TreeIterator treeIterator = rowNode.getIterator();
            while (treeIterator.hasMoreElements()) {
                RowNode rowNode2 = (RowNode)treeIterator.get();
                this.resetSortIndicationsInternal(rowNode2, bl);
                treeIterator.nextElement();
            }
        }
    }

    public void sortDataTable(RowNode rowNode, String string, int n, boolean bl) {
        FormatNode formatNode = rowNode.getFormatNode();
        if (bl) {
            formatNode.setDefaultSortData(new SortData(string, n));
        }
        Cursor cursor = this.gridArea.getCursor();
        this.gridArea.setCursor(new Cursor(3));
        SortGrid sortGrid = new SortGrid(this, false);
        sortGrid.sortColumn(formatNode, rowNode, new SortData(string, n));
        this.gridArea.setCursor(cursor);
        this.refreshChildrenRows(rowNode);
    }

    public void sortDataTable(CellPosition cellPosition, boolean bl) {
        Cursor cursor = this.gridArea.getCursor();
        this.gridArea.setCursor(new Cursor(3));
        SortGrid sortGrid = new SortGrid(this, bl);
        sortGrid.sortColumn(cellPosition, !bl);
        this.gridArea.setCursor(cursor);
        this.refreshChildrenRows(bl ? null : cellPosition.row);
    }

    public Object getCellData(CellPosition cellPosition) {
        Object object;
        block4: {
            object = null;
            try {
                RowNode rowNode = cellPosition.getRowNode();
                String string = cellPosition.getCellFormat().getName();
                DataTableModel dataTableModel = rowNode.getDataTableModel();
                if (dataTableModel == null) break block4;
                try {
                    object = dataTableModel.getResultData(rowNode.getBookmark(), string);
                }
                catch (DataModelException dataModelException) {
                    return null;
                }
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        return object;
    }

    public CellPosition getCurrentCellPosition() {
        return (CellPosition)this.controller.getCurrentCell().clone();
    }

    public CellPosition getCellPositionFromPoint(Point point) {
        NullGraphics nullGraphics = this.controller.getCellFromXY(point);
        if (nullGraphics == null || nullGraphics.cell == null || nullGraphics.cell.format == null) {
            return null;
        }
        return nullGraphics.cell;
    }

    public Point getPointFromCellPosition(CellPosition cellPosition) {
        if (cellPosition == null) {
            return null;
        }
        NullGraphics nullGraphics = this.controller.getXYFromCell(cellPosition);
        if (nullGraphics == null || nullGraphics.cell == null) {
            return null;
        }
        return nullGraphics.cell.point;
    }

    public CellPosition getHorizontalScrollableCellPositionFromPoint(Point point) {
        Point point2 = new Point(point);
        if (this.horizontalScrollbar != null && this.horizontalScrollbar.isVisible()) {
            point2.translate(this.horizontalScrollbar.getValue(), 0);
        }
        return this.getCellPositionFromPoint(point2);
    }

    public Point getPointFromHorizontalScrollableCellPosition(CellPosition cellPosition) {
        Point point = this.getPointFromCellPosition(cellPosition);
        if (point != null && this.horizontalScrollbar != null && this.horizontalScrollbar.isVisible()) {
            point.translate(-this.horizontalScrollbar.getValue(), 0);
        }
        return point;
    }

    protected CellPosition getCurrentCell() {
        return this.controller.getCurrentCell();
    }

    public boolean isAllowPopupMenu() {
        return this.allowPopupMenu;
    }

    public void setAllowPopupMenu(boolean bl) {
        this.allowPopupMenu = bl;
    }

    public EditPopupMenu getEditPopupMenu() {
        return this.popupMenu;
    }

    public void setEditPopupMenu(EditPopupMenu editPopupMenu) {
        if (this.popupMenu != editPopupMenu && this.popupMenu != null) {
            this.popupMenu.dispose();
        }
        this.popupMenu = editPopupMenu;
    }

    public boolean isAllowSorting() {
        return this.allowSorting;
    }

    public void setAllowSorting(boolean bl) {
        this.allowSorting = bl;
    }

    public boolean isTrackCursor() {
        return this.trackCursor;
    }

    public void setTrackCursor(boolean bl) {
        this.trackCursor = bl;
        this.setCursor(this.getDefaultCursor());
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public void setDefaultCursor(int n) {
        this.setDefaultCursor(Cursor.getPredefinedCursor(n));
    }

    protected void draw(Graphics graphics) {
        Font font;
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.rowTree.displayRuntimeTree(graphics);
        if (this.getDataModel() == null && JCEnvironment.isDesignTime() && (font = this.getFont()) != null) {
            graphics.setFont(font);
            graphics.setColor(this.getForeground());
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            String string = LocaleBundle.string(this instanceof JCHiGridExternalDS ? "JCHiGridExternalDS" : "JCHiGrid");
            graphics.drawString(string, 0, fontMetrics.getHeight());
        }
    }

    public void createDefaultTrees() {
        if (this.dataModel == null) {
            return;
        }
        if (this.formatTree.getRoot() == null) {
            this.formatTree.createFormatTreeFromDataModel(this.dataModel);
            this.rowTree.computeTotalWidth();
        }
        if (this.rowTree.getRoot() == null) {
            this.rowTree.createRuntimeTree(this.formatTree);
        }
        if (this.rowTree.getTopRowNode() == null) {
            this.rowTree.setTopRowNode((RowNode)this.rowTree.getRootNode().getFirstChild());
        }
        this.controller.positionCurrentCell();
    }

    public void resetDesignTimeGrid() {
        this.formatTree.createFormatTreeFromDataModel(this.dataModel);
    }

    public void resetRunTimeGrid() {
        this.controller.showEditor(false);
        this.controller.setCurrentCell(null);
        this.rowTree.setTopRowNode(null);
        this.formatTree.resetRuntimeInfo();
        if (this.getDataModel() != null) {
            this.getDataModel().clearDataTableTreeInternalData(this);
        }
        this.rowTree.createRuntimeTree(this.formatTree);
        if (this.getDataModel() != null && this.rowTree.getRoot() != null && this.rowTree.getRootNode().getChildCount() > 0) {
            DataTableModel dataTableModel;
            RowNode rowNode = null;
            if (!JCEnvironment.isDesignTime() && (rowNode = this.rowTree.findRecordRowNode(null, this.dataModel.getCurrentGlobalBookmark())) == null && (dataTableModel = this.dataModel.getCurrentGlobalTable()) != null) {
                Vector vector = new Vector();
                dataTableModel.getAncestors(vector);
                int n = vector.size() - 1;
                while (n >= 0) {
                    rowNode = this.rowTree.findRecordRowNode(null, (Long)vector.elementAt(n));
                    if (rowNode != null) break;
                    --n;
                }
            }
            if (rowNode == null) {
                this.rowTree.setTopRow(0);
                this.controller.positionCurrentCell();
                this.controller.createEditor();
                this.controller.positionEditor();
            } else {
                if (rowNode == this.rowTree.getFirstRecordRowNode()) {
                    this.rowTree.setTopRow(0);
                } else {
                    this.rowTree.setTopRow(rowNode);
                }
                this.controller.repositionCurrentCell(rowNode, false, true);
            }
        }
        this.horizontalScrollbar.setValue(0);
    }

    public void setBackground(Color color) {
        this.cornerPanel.setBackground(color);
        super.setBackground(color);
    }

    protected void widthChanged(Vector vector, int n) {
        if (n < vector.size()) {
            ((CellFormat)vector.elementAt(n)).widthChanged();
        }
    }

    protected void calculateWidth(FormatNode formatNode, int n) {
        if ((n = this.getIndicatorIndex(formatNode, n)) >= 0) {
            this.widthChanged(formatNode.getRecordFormat().getIndicatorFormats(), n);
            this.widthChanged(formatNode.getHeaderFormat().getIndicatorFormats(), n);
            this.widthChanged(formatNode.getFooterFormat().getIndicatorFormats(), n);
            this.widthChanged(formatNode.getBeforeDetailsFormat().getIndicatorFormats(), n);
            this.widthChanged(formatNode.getAfterDetailsFormat().getIndicatorFormats(), n);
        }
    }

    protected void walkFormatTree(FormatNode formatNode, int n) {
        if (formatNode == null) {
            return;
        }
        this.calculateWidth(formatNode, n);
        TreeIterator treeIterator = formatNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            formatNode = (FormatNode)treeIterator.get();
            this.walkFormatTree(formatNode, n);
            treeIterator.nextElement();
        }
    }

    protected void recalculateRowFormats(int n) {
        if (this.formatTree == null || this.formatTree.getRoot() == null) {
            return;
        }
        this.walkFormatTree((FormatNode)this.formatTree.getRoot(), n);
    }

    protected int getIndicatorIndex(FormatNode formatNode, int n) {
        if (formatNode.getRecordFormat() == null) {
            return -1;
        }
        return this.getIndicatorIndex(formatNode.getRecordFormat().getIndicatorFormats(), n);
    }

    protected int getIndicatorIndex(Vector vector, int n) {
        block4: {
            block5: {
                if (vector == null) break block4;
                if (n != -10) break block5;
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (vector.elementAt(n2) instanceof NodeCellFormat) {
                        return n2;
                    }
                    ++n2;
                }
                break block4;
            }
            if (n != -11) break block4;
            int n3 = 0;
            while (n3 < vector.size()) {
                if (vector.elementAt(n3) instanceof EditStatusCellFormat) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    protected CellPosition makeCellPosition(RowNode rowNode, int n) {
        int n2 = this.getIndicatorIndex(rowNode.getFormatNode(), n);
        if (n2 < 0) {
            return null;
        }
        return new CellPosition(rowNode, n2, true);
    }

    protected void refreshEditStatus(RowNode rowNode) {
        CellPosition cellPosition = this.makeCellPosition(rowNode, -11);
        if (cellPosition != null) {
            this.refreshCell(cellPosition);
        }
    }

    protected void refreshEditStatus(CellPosition cellPosition, boolean bl) {
        if (bl && cellPosition != null) {
            this.refreshEditStatus(cellPosition.row);
        }
    }

    protected void refreshCell(CellPosition cellPosition) {
        NullGraphics nullGraphics = this.controller.getXYFromCell(cellPosition);
        if (!nullGraphics.finishedOperation) {
            return;
        }
        cellPosition = nullGraphics.cell;
        Rectangle rectangle = cellPosition.format.getTotalArea();
        this.refreshGridArea(cellPosition.point.x, cellPosition.point.y, rectangle.width, rectangle.height);
    }

    protected void refreshRowsWithoutEditor(int n, int n2) {
        Dimension dimension = this.gridArea.getSize();
        this.refreshGridArea(0, n, Math.max(this.rowTree.getGridAreaWidth(), dimension.width), n2);
    }

    protected void refreshRows(int n, int n2) {
        this.controller.showEditor(false);
        this.refreshRowsWithoutEditor(n, n2);
        this.controller.positionEditor();
        this.controller.showEditor(true);
    }

    public boolean expandFolder(RowNode rowNode) {
        return this.controller.expandFolder(rowNode);
    }

    public boolean collapseFolder(RowNode rowNode) {
        return this.controller.collapseFolder(rowNode);
    }

    protected void refreshRowAndBelow(RowNode rowNode, int n) {
        int n2 = this.verticalScrollbar.getValue();
        if (n == 1) {
            this.rowTree.closeFolder(rowNode);
        } else if (n == 0) {
            this.rowTree.openFolder(rowNode);
        } else {
            throw new HiGridException("Bad current state: " + n + " for rowNode " + rowNode);
        }
        if (n2 != this.verticalScrollbar.getValue()) {
            this.refresh();
        } else {
            NullGraphics nullGraphics = this.controller.getXYFromCell(this.makeCellPosition(rowNode, -10));
            if (nullGraphics.finishedOperation) {
                this.refreshRows(nullGraphics.cell.point.y, this.gridArea.getSize().height - nullGraphics.cell.point.y);
            }
        }
    }

    protected void refreshRow(RowNode rowNode) {
        NullGraphics nullGraphics = this.controller.getXYFromCell(this.makeCellPosition(rowNode, -10));
        if (nullGraphics.finishedOperation) {
            this.refreshRows(nullGraphics.cell.point.y, rowNode.getHeight());
        }
    }

    protected void refreshRowWithoutEditor(RowNode rowNode) {
        NullGraphics nullGraphics = this.controller.getXYFromCell(this.makeCellPosition(rowNode, -10));
        if (nullGraphics.finishedOperation) {
            this.refreshRowsWithoutEditor(nullGraphics.cell.point.y, rowNode.getHeight());
        }
    }

    protected void refreshChildrenRows(RowNode rowNode) {
        if (rowNode == null) {
            this.refresh();
            return;
        }
        RowNode rowNode2 = (RowNode)rowNode.getParent();
        if (rowNode2 == null || rowNode2.getParent() == null) {
            this.refresh();
            return;
        }
        NullGraphics nullGraphics = this.controller.getXYFromCell(this.makeCellPosition(rowNode2, -10));
        if (nullGraphics.finishedOperation) {
            int n = nullGraphics.cell.point.y + rowNode2.getHeight();
            this.refreshRows(n, this.gridArea.getSize().height - n);
        } else {
            this.refresh();
        }
    }

    protected void refresh(RowNode rowNode, RowNode rowNode2, boolean bl) {
        if (rowNode != rowNode2) {
            PixelCountWalk pixelCountWalk = new PixelCountWalk(rowNode2, this.gridArea.getSize().height, bl);
            this.rowTree.walk(rowNode, pixelCountWalk);
            this.refresh(bl ? pixelCountWalk.getPixelCount() : -pixelCountWalk.getPixelCount());
        }
    }

    protected void refresh(int n) {
        if (!this.isBatched()) {
            this.controller.showEditor(false);
            this.rowTree.updateGridState();
            this.layoutGrid();
            this.refreshGridArea(n);
            this.controller.showEditor(true);
        }
    }

    public void refresh() {
        this.refresh(true, true);
    }

    protected void refresh(boolean bl) {
        this.refresh(bl, true);
    }

    protected void refresh(boolean bl, boolean bl2) {
        if (!this.isBatched()) {
            this.controller.showEditor(false);
            if (bl) {
                this.rowTree.updateGridState();
                this.layoutGrid();
                this.refreshGridArea();
            } else {
                this.gridArea.repaint();
            }
            if (bl2) {
                this.controller.positionEditor();
            }
            this.controller.showEditor(true);
        }
    }

    protected void refreshGridArea() {
        this.gridArea.refresh();
        this.gridArea.repaint();
    }

    protected void refreshGridArea(int n) {
        this.gridArea.refresh(n);
        this.gridArea.repaint();
    }

    protected void refreshGridArea(int n, int n2, int n3, int n4) {
        this.gridArea.refresh(n, n2, n3, n4);
        this.gridArea.repaint(n -= this.getHorizontalScrollbar().getValue(), n2, n3, n4);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.layoutGrid();
        this.rowTree.setGridAreaRows();
        this.layoutGrid();
        this.refreshGridArea();
        this.controller.positionEditor();
        this.controller.showEditor(true);
    }

    protected void layoutGrid() {
        super.doLayout();
        int n = this.verticalScrollbar.getComponent().getPreferredSize().width;
        if (this.dataModel == null) {
            if (this.verticalScrollbar.isVisible()) {
                this.verticalScrollbar.setVisible(false);
                super.doLayout();
            }
            if (this.horizontalPanel.isVisible()) {
                this.horizontalPanel.setVisible(false);
                super.doLayout();
            }
            return;
        }
        if (this.rowTree.getGridAreaRows() == 0) {
            this.rowTree.updateGridState();
        }
        boolean bl = this.horizontalScrollbar.getDisplay() != 2;
        boolean bl2 = this.verticalScrollbar.getDisplay() != 2;
        boolean bl3 = this.horizontalScrollbar.getDisplay() == 1;
        boolean bl4 = this.verticalScrollbar.getDisplay() == 1;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        boolean bl8 = true;
        int n2 = this.gridArea.getSize().width;
        int n3 = this.gridArea.getSize().height;
        int n4 = n2;
        int n5 = n3;
        if (bl) {
            boolean bl9 = bl7 = this.rowTree.getGridAreaWidth() > n2;
            if (bl7 || bl3) {
                bl5 = true;
                if (!this.horizontalPanel.isVisible()) {
                    n3 = Math.max(0, n3 - n);
                }
            } else if (this.horizontalPanel.isVisible()) {
                bl5 = false;
                n3 += n;
            }
        }
        if (bl2) {
            boolean bl10 = bl8 = this.rowTree.getScrollableRowsHeight() > n3;
            if (bl8 || bl4) {
                bl6 = true;
                if (!this.verticalScrollbar.isVisible()) {
                    n2 = Math.max(0, n2 - n);
                }
            } else if (this.verticalScrollbar.isVisible()) {
                bl6 = false;
                n2 += n;
            }
        }
        if (bl && n4 != n2) {
            if (this.rowTree.getGridAreaWidth() > n2 || bl3) {
                if (!bl5) {
                    bl5 = true;
                    if (!this.horizontalPanel.isVisible()) {
                        n3 = Math.max(0, n3 - n);
                    }
                }
            } else if (this.horizontalPanel.isVisible() && bl5) {
                bl5 = false;
                n3 += n;
            }
        }
        if (bl2 && n5 != n3) {
            if (this.rowTree.getScrollableRowsHeight() > n3 || bl4) {
                if (!bl6) {
                    bl6 = true;
                    if (!this.verticalScrollbar.isVisible()) {
                        n2 = Math.max(0, n2 - n);
                    }
                }
            } else if (this.verticalScrollbar.isVisible() && bl6) {
                bl6 = false;
                n2 += n;
            }
        }
        if (!bl3 && !bl4 && bl5 && bl6 && this.horizontalPanel.isVisible() && this.verticalScrollbar.isVisible() && this.rowTree.getGridAreaWidth() <= n2 + n && this.rowTree.getScrollableRowsHeight() <= n3 + n) {
            bl5 = false;
            bl6 = false;
        }
        boolean bl11 = this.firstLayout;
        if (this.firstLayout) {
            this.firstLayout = false;
        }
        if (bl5 != this.horizontalPanel.isVisible()) {
            this.horizontalPanel.setVisible(bl5);
            if (!bl5) {
                this.horizontalScrollbar.setValue(0);
            }
            bl11 = true;
        }
        if (bl6 != this.verticalScrollbar.isVisible()) {
            this.verticalScrollbar.setVisible(bl6);
            if (!bl6) {
                this.rowTree.setTopRow(0);
            }
            bl11 = true;
        }
        if (bl5) {
            this.horizontalPanel.setSize(new Dimension(this.getSize().width, n));
            this.horizontalScrollbar.adjustValues(this.rowTree.getGridAreaWidth(), this.gridArea.getSize().width);
            this.horizontalScrollbar.setSize(new Dimension(this.gridArea.getSize().width, n));
        }
        if (bl11) {
            super.doLayout();
        }
        if (bl6) {
            this.verticalScrollbar.adjustValues(this.rowTree.getTotalNumberOfScrollableRows(), this.rowTree.getGridAreaRows());
            this.verticalScrollbar.setSize(new Dimension(n, this.gridArea.getSize().height));
        }
        if (bl11) {
            super.doLayout();
        }
        if (!bl8) {
            this.verticalScrollbar.setValues(0, 0, 0, 0);
        }
        this.verticalScrollbar.getComponent().setEnabled(bl8);
        if (!bl7) {
            this.horizontalScrollbar.setValues(0, 0, 0, 0);
        }
        this.horizontalScrollbar.getComponent().setEnabled(bl7);
        this.cornerPanel.setVisible(this.verticalScrollbar.isVisible() && this.horizontalScrollbar.isVisible());
    }

    public final void setLayout(LayoutManager layoutManager) {
        super.setLayout(new BorderLayout());
        this.add((Component)this.gridArea, "Center");
        this.resetScrollbarConstraints();
    }

    public boolean isAllowRowSelection() {
        return this.allowRowSelection;
    }

    public void setAllowRowSelection(boolean bl) {
        if (this.allowRowSelection && !bl) {
            this.resetRowSelection();
        }
        this.allowRowSelection = bl;
    }

    public int getRowSelectionMode() {
        return this.rowSelectionMode;
    }

    public void setRowSelectionMode(int n) {
        this.rowSelectionMode = n;
    }

    public void selectRows(int n) {
        if (this.popupMenu == null) {
            return;
        }
        String string = null;
        switch (n) {
            case 3: {
                string = this.popupMenu.getCommand(24);
                break;
            }
            case 2: {
                string = this.popupMenu.getCommand(23);
                break;
            }
            case 1: {
                string = this.popupMenu.getCommand(22);
                break;
            }
            default: {
                string = this.popupMenu.getCommand(21);
            }
        }
        this.popupMenu.performCommand(string);
    }

    public void toggleRowSelection(RowNode rowNode, boolean bl, boolean bl2) {
        if (!bl) {
            this.resetRowSelection(bl2);
        }
        this.controller.doRowSelection(rowNode, this.rowSelectionMode, false, bl2);
    }

    public void toggleRowSelection(RowNode rowNode, boolean bl) {
        this.toggleRowSelection(rowNode, bl, true);
    }

    public void resetRowSelection() {
        this.resetRowSelection(true);
    }

    public void resetRowSelection(boolean bl) {
        this.controller.resetRowSelection(bl);
    }

    public void insertRow(RowNode rowNode) {
        DataTableModel dataTableModel;
        if (!this.isEditable()) {
            return;
        }
        if (rowNode != null && (dataTableModel = rowNode.getDataTableModel()) != null) {
            try {
                dataTableModel.addRow(this.getDataModelListener());
            }
            catch (Exception exception) {
                this.fireHiGridErrorEvent(new HiGridErrorEvent(this, exception));
            }
            this.resetRowSelection();
        }
    }

    public void deleteRows(int n) {
        if (!this.isEditable()) {
            return;
        }
        if (this.popupMenu == null) {
            return;
        }
        String string = null;
        switch (n) {
            case 1: {
                if (this.controller.selectedRowNodes.isEmpty()) {
                    return;
                }
                string = this.popupMenu.getCommand(4);
                break;
            }
            default: {
                string = this.popupMenu.getCommand(3);
            }
        }
        this.popupMenu.performCommand(string);
    }

    public void deleteRow(RowNode rowNode) {
        DataTableModel dataTableModel;
        if (!this.isEditable()) {
            return;
        }
        if (rowNode != null && (dataTableModel = rowNode.getDataTableModel()) != null) {
            try {
                dataTableModel.deleteRow(this.getDataModelListener(), rowNode.getBookmark());
            }
            catch (Exception exception) {
                this.fireHiGridErrorEvent(new HiGridErrorEvent(this, exception));
            }
            this.resetRowSelection();
        }
    }

    public void cancelRows(int n) {
        if (!this.isEditable()) {
            return;
        }
        if (this.popupMenu == null) {
            return;
        }
        String string = null;
        switch (n) {
            case 2: {
                string = this.popupMenu.getCommand(8);
                break;
            }
            case 1: {
                if (this.controller.selectedRowNodes.isEmpty()) {
                    return;
                }
                string = this.popupMenu.getCommand(7);
                break;
            }
            default: {
                string = this.popupMenu.getCommand(6);
            }
        }
        this.popupMenu.performCommand(string);
    }

    public void cancelRow(RowNode rowNode) {
        DataTableModel dataTableModel;
        if (!this.isEditable()) {
            return;
        }
        if (rowNode != null && (dataTableModel = rowNode.getDataTableModel()) != null) {
            try {
                dataTableModel.cancelRowChanges(this.getDataModelListener(), rowNode.getBookmark());
            }
            catch (Exception exception) {
                this.fireHiGridErrorEvent(new HiGridErrorEvent(this, exception));
            }
            this.resetRowSelection();
        }
    }

    public void updateRows(int n) {
        if (!this.isEditable()) {
            return;
        }
        if (this.popupMenu == null) {
            return;
        }
        String string = null;
        switch (n) {
            case 2: {
                string = this.popupMenu.getCommand(19);
                break;
            }
            case 1: {
                if (this.controller.selectedRowNodes.isEmpty()) {
                    return;
                }
                string = this.popupMenu.getCommand(18);
                break;
            }
            default: {
                string = this.popupMenu.getCommand(17);
            }
        }
        this.popupMenu.performCommand(string);
    }

    public void updateRow(RowNode rowNode) {
        DataTableModel dataTableModel;
        if (!this.isEditable()) {
            return;
        }
        if (rowNode != null && (dataTableModel = rowNode.getDataTableModel()) != null) {
            try {
                dataTableModel.commitRow(this.getDataModelListener(), rowNode.getBookmark());
            }
            catch (Exception exception) {
                this.fireHiGridErrorEvent(new HiGridErrorEvent(this, exception));
            }
            this.resetRowSelection();
        }
    }

    public void requeryRows(int n) {
        if (this.popupMenu == null) {
            return;
        }
        String string = null;
        switch (n) {
            case 4: {
                string = this.popupMenu.getCommand(15);
                break;
            }
            case 2: {
                if (this.controller.selectedRowNodes.isEmpty()) {
                    return;
                }
                string = this.popupMenu.getCommand(12);
                break;
            }
            case 3: {
                if (this.controller.selectedRowNodes.isEmpty()) {
                    return;
                }
                string = this.popupMenu.getCommand(13);
                break;
            }
            case 1: {
                string = this.popupMenu.getCommand(11);
                break;
            }
            default: {
                string = this.popupMenu.getCommand(10);
            }
        }
        this.popupMenu.performCommand(string);
    }

    public void requeryRow(RowNode rowNode) {
        DataTableModel dataTableModel;
        if (rowNode != null && (dataTableModel = rowNode.getDataTableModel()) != null) {
            try {
                dataTableModel.requeryRow(this.getDataModelListener(), rowNode.getBookmark());
            }
            catch (Exception exception) {
                this.fireHiGridErrorEvent(new HiGridErrorEvent(this, exception));
            }
            this.resetRowSelection();
        }
    }

    public void moveToRow(int n) {
        if (this.popupMenu == null) {
            return;
        }
        String string = null;
        switch (n) {
            case 0: {
                string = this.popupMenu.getCommand(26);
                break;
            }
            case 1: {
                string = this.popupMenu.getCommand(27);
                break;
            }
            default: {
                string = this.popupMenu.getCommand(28);
                break;
            }
            case 3: {
                string = this.popupMenu.getCommand(29);
                break;
            }
            case 4: {
                string = this.popupMenu.getCommand(31);
                break;
            }
            case 5: {
                string = this.popupMenu.getCommand(32);
                break;
            }
            case 6: {
                string = this.popupMenu.getCommand(33);
                break;
            }
            case 7: {
                string = this.popupMenu.getCommand(34);
                break;
            }
            case 8: {
                string = this.popupMenu.getCommand(35);
            }
        }
        this.popupMenu.performCommand(string);
    }

    public void moveToRow(long l) {
        this.moveToRow(this.getRowTree().findRecordRowNode(null, l));
    }

    public void moveToRow(RowNode rowNode) {
        if (rowNode == null) {
            return;
        }
        int n = rowNode.getRowFormat().getFirstVisibleCell();
        CellPosition cellPosition = new CellPosition(rowNode, n);
        this.controller.validateAndTraverse(cellPosition, n, null);
    }

    public Enumeration getSelectedRows() {
        return this.controller.getSelectedRows().elements();
    }

    protected static Frame getFrame(Component component) {
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            return (Frame)component;
        }
        return null;
    }

    public void print(int n) {
        if (this.popupMenu == null) {
            return;
        }
        String string = null;
        switch (n) {
            case 1: {
                string = this.popupMenu.getCommand(39);
                break;
            }
            case 2: {
                string = this.popupMenu.getCommand(40);
                break;
            }
            default: {
                string = this.popupMenu.getCommand(38);
            }
        }
        this.popupMenu.performCommand(string);
    }

    public void print() {
        this.print(null, false, null);
    }

    public void print(PageFormat pageFormat) {
        this.print(null, false, pageFormat);
    }

    public void print(boolean bl) {
        this.print(null, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrinterJob printerJob, boolean bl, PageFormat pageFormat) {
        if (printerJob == null) {
            printerJob = PrinterJob.getPrinterJob();
        }
        if (bl && !printerJob.printDialog()) {
            return;
        }
        if (pageFormat == null) {
            pageFormat = printerJob.defaultPage();
        }
        this.getPrintGrid().initialize(pageFormat);
        this.setPrinting(true);
        printerJob.setPrintable(this.getPrintGrid(), pageFormat);
        try {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                Object var6_5 = null;
                this.setPrinting(false);
            }
            Object var6_4 = null;
            this.setPrinting(false);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setPrinting(false);
            throw throwable;
        }
    }

    public void printPreview() {
        PrintPreview printPreview;
        Frame frame = HiGrid.getFrame(this);
        boolean bl = false;
        if (frame == null) {
            bl = true;
            frame = new Frame();
        }
        if ((printPreview = new PrintPreview(frame, LocaleBundle.string("PrintPreview"), this)) != null) {
            printPreview.show();
        }
        if (bl) {
            frame.dispose();
        }
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public void setPrinting(boolean bl) {
        this.printing = bl;
    }

    protected boolean isPrintingSubsequentColumnPages() {
        return this.isPrinting() && this.getPrintColumnPageIndex() != 0;
    }

    protected boolean isDrawingFoldersAndConnections() {
        return !this.isPrinting() || this.isPrintFoldersAndConnections();
    }

    protected void setPrintGrid(PrintGrid printGrid) {
        this.printGrid = printGrid;
    }

    public PrintGrid12 getPrintGrid() {
        return (PrintGrid12)this.printGrid;
    }

    public int getPrintRowPageIndex() {
        return this.getPrintGrid() == null ? 0 : this.getPrintGrid().getRowPageIndex();
    }

    public int getPrintColumnPageIndex() {
        return this.getPrintGrid() == null ? 0 : this.getPrintGrid().getColumnPageIndex();
    }

    public boolean isPrintFoldersAndConnections() {
        return this.printFoldersAndConnections;
    }

    public void setPrintFoldersAndConnections(boolean bl) {
        this.printFoldersAndConnections = bl;
    }

    public int getPrintFormat() {
        return this.printFormat;
    }

    public void setPrintFormat(int n) {
        this.printFormat = n;
    }

    public synchronized void addHiGridColumnSelectionListener(HiGridColumnSelectionListener hiGridColumnSelectionListener) {
        this.hiGridColumnSelectionListeners = JCListenerList.add(this.hiGridColumnSelectionListeners, hiGridColumnSelectionListener);
    }

    public synchronized void removeHiGridColumnSelectionListener(HiGridColumnSelectionListener hiGridColumnSelectionListener) {
        this.hiGridColumnSelectionListeners = JCListenerList.remove(this.hiGridColumnSelectionListeners, hiGridColumnSelectionListener);
    }

    protected boolean fireHiGridColumnSelectionEvent(HiGridColumnSelectionEvent hiGridColumnSelectionEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridColumnSelectionListeners);
        while (enumeration.hasMoreElements()) {
            HiGridColumnSelectionListener hiGridColumnSelectionListener = (HiGridColumnSelectionListener)enumeration.nextElement();
            switch (hiGridColumnSelectionEvent.getEventType()) {
                case 1: {
                    hiGridColumnSelectionListener.selectColumn(hiGridColumnSelectionEvent);
                    break;
                }
            }
            if (!hiGridColumnSelectionEvent.getCancelled() || !hiGridColumnSelectionEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridErrorListener(HiGridErrorListener hiGridErrorListener) {
        this.hiGridErrorListeners = JCListenerList.add(this.hiGridErrorListeners, hiGridErrorListener);
    }

    public synchronized void removeHiGridErrorListener(HiGridErrorListener hiGridErrorListener) {
        this.hiGridErrorListeners = JCListenerList.remove(this.hiGridErrorListeners, hiGridErrorListener);
    }

    protected boolean fireHiGridErrorEvent(HiGridErrorEvent hiGridErrorEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridErrorListeners);
        while (enumeration.hasMoreElements()) {
            HiGridErrorListener hiGridErrorListener = (HiGridErrorListener)enumeration.nextElement();
            hiGridErrorListener.processError(hiGridErrorEvent);
        }
        return true;
    }

    public synchronized void addHiGridExpansionListener(HiGridExpansionListener hiGridExpansionListener) {
        this.hiGridExpansionListeners = JCListenerList.add(this.hiGridExpansionListeners, hiGridExpansionListener);
    }

    public synchronized void removeHiGridExpansionListener(HiGridExpansionListener hiGridExpansionListener) {
        this.hiGridExpansionListeners = JCListenerList.remove(this.hiGridExpansionListeners, hiGridExpansionListener);
    }

    protected boolean fireHiGridExpansionEvent(HiGridExpansionEvent hiGridExpansionEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridExpansionListeners);
        while (enumeration.hasMoreElements()) {
            HiGridExpansionListener hiGridExpansionListener = (HiGridExpansionListener)enumeration.nextElement();
            switch (hiGridExpansionEvent.getEventType()) {
                case 1: {
                    hiGridExpansionListener.beforeExpandRow(hiGridExpansionEvent);
                    break;
                }
                case 2: {
                    hiGridExpansionListener.beforeCollapseRow(hiGridExpansionEvent);
                    break;
                }
                case 4: {
                    hiGridExpansionListener.afterCollapseRow(hiGridExpansionEvent);
                    break;
                }
                case 3: {
                    hiGridExpansionListener.afterExpandRow(hiGridExpansionEvent);
                    break;
                }
            }
            if (!hiGridExpansionEvent.getCancelled() || !hiGridExpansionEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridFormatNodeListener(HiGridFormatNodeListener hiGridFormatNodeListener) {
        this.hiGridFormatNodeListeners = JCListenerList.add(this.hiGridFormatNodeListeners, hiGridFormatNodeListener);
    }

    public synchronized void removeHiGridFormatNodeListener(HiGridFormatNodeListener hiGridFormatNodeListener) {
        this.hiGridFormatNodeListeners = JCListenerList.remove(this.hiGridFormatNodeListeners, hiGridFormatNodeListener);
    }

    protected boolean fireHiGridFormatNodeEvent(HiGridFormatNodeEvent hiGridFormatNodeEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridFormatNodeListeners);
        while (enumeration.hasMoreElements()) {
            HiGridFormatNodeListener hiGridFormatNodeListener = (HiGridFormatNodeListener)enumeration.nextElement();
            switch (hiGridFormatNodeEvent.getEventType()) {
                case 1: {
                    hiGridFormatNodeListener.beforeCreateFormatNodeContents(hiGridFormatNodeEvent);
                    break;
                }
                case 2: {
                    hiGridFormatNodeListener.afterCreateFormatNodeContents(hiGridFormatNodeEvent);
                    break;
                }
            }
            if (!hiGridFormatNodeEvent.getCancelled() || !hiGridFormatNodeEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridMoveCellListener(HiGridMoveCellListener hiGridMoveCellListener) {
        this.hiGridMoveCellListeners = JCListenerList.add(this.hiGridMoveCellListeners, hiGridMoveCellListener);
    }

    public synchronized void removeHiGridMoveCellListener(HiGridMoveCellListener hiGridMoveCellListener) {
        this.hiGridMoveCellListeners = JCListenerList.remove(this.hiGridMoveCellListeners, hiGridMoveCellListener);
    }

    protected boolean fireHiGridMoveCellEvent(HiGridMoveCellEvent hiGridMoveCellEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridMoveCellListeners);
        while (enumeration.hasMoreElements()) {
            HiGridMoveCellListener hiGridMoveCellListener = (HiGridMoveCellListener)enumeration.nextElement();
            switch (hiGridMoveCellEvent.getEventType()) {
                case 1: {
                    hiGridMoveCellListener.beforeMoveColumn(hiGridMoveCellEvent);
                    break;
                }
                case 2: {
                    hiGridMoveCellListener.afterMoveColumn(hiGridMoveCellEvent);
                    break;
                }
            }
            if (!hiGridMoveCellEvent.getCancelled() || !hiGridMoveCellEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridPrintListener(HiGridPrintListener hiGridPrintListener) {
        this.hiGridPrintListeners = JCListenerList.add(this.hiGridPrintListeners, hiGridPrintListener);
    }

    public synchronized void removeHiGridPrintListener(HiGridPrintListener hiGridPrintListener) {
        this.hiGridPrintListeners = JCListenerList.remove(this.hiGridPrintListeners, hiGridPrintListener);
    }

    protected void fireHiGridPrintEvent(HiGridPrintEvent hiGridPrintEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridPrintListeners);
        if (!enumeration.hasMoreElements() && hiGridPrintEvent.getEventType() == 2002 && this.getPrintGrid() != null) {
            this.getPrintGrid().printPageFooter(hiGridPrintEvent);
        }
        while (enumeration.hasMoreElements()) {
            HiGridPrintListener hiGridPrintListener = (HiGridPrintListener)enumeration.nextElement();
            switch (hiGridPrintEvent.getEventType()) {
                case 2001: {
                    hiGridPrintListener.printPageHeader(hiGridPrintEvent);
                    break;
                }
                case 2002: {
                    hiGridPrintListener.printPageFooter(hiGridPrintEvent);
                    break;
                }
                case 2003: {
                    hiGridPrintListener.printEnd(hiGridPrintEvent);
                    break;
                }
            }
        }
    }

    public synchronized void addHiGridRepaintListener(HiGridRepaintListener hiGridRepaintListener) {
        this.hiGridRepaintListeners = JCListenerList.add(this.hiGridRepaintListeners, hiGridRepaintListener);
    }

    public synchronized void removeHiGridRepaintListener(HiGridRepaintListener hiGridRepaintListener) {
        this.hiGridRepaintListeners = JCListenerList.remove(this.hiGridRepaintListeners, hiGridRepaintListener);
    }

    protected boolean fireHiGridRepaintEvent(HiGridRepaintEvent hiGridRepaintEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridRepaintListeners);
        while (enumeration.hasMoreElements()) {
            HiGridRepaintListener hiGridRepaintListener = (HiGridRepaintListener)enumeration.nextElement();
            switch (hiGridRepaintEvent.getEventType()) {
                case 1: {
                    hiGridRepaintListener.beforeRepaintRow(hiGridRepaintEvent);
                    break;
                }
            }
        }
        return true;
    }

    public synchronized void addHiGridResizeCellListener(HiGridResizeCellListener hiGridResizeCellListener) {
        this.hiGridResizeCellListeners = JCListenerList.add(this.hiGridResizeCellListeners, hiGridResizeCellListener);
    }

    public synchronized void removeHiGridResizeCellListener(HiGridResizeCellListener hiGridResizeCellListener) {
        this.hiGridResizeCellListeners = JCListenerList.remove(this.hiGridResizeCellListeners, hiGridResizeCellListener);
    }

    protected boolean fireHiGridResizeCellEvent(HiGridResizeCellEvent hiGridResizeCellEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridResizeCellListeners);
        while (enumeration.hasMoreElements()) {
            HiGridResizeCellListener hiGridResizeCellListener = (HiGridResizeCellListener)enumeration.nextElement();
            switch (hiGridResizeCellEvent.getEventType()) {
                case 1: {
                    hiGridResizeCellListener.beforeResizeRow(hiGridResizeCellEvent);
                    break;
                }
                case 2: {
                    hiGridResizeCellListener.beforeResizeColumn(hiGridResizeCellEvent);
                    break;
                }
                case 3: {
                    hiGridResizeCellListener.afterResizeRow(hiGridResizeCellEvent);
                    break;
                }
                case 4: {
                    hiGridResizeCellListener.afterResizeColumn(hiGridResizeCellEvent);
                    break;
                }
            }
            if (!hiGridResizeCellEvent.getCancelled() || !hiGridResizeCellEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridRowSelectionListener(HiGridRowSelectionListener hiGridRowSelectionListener) {
        this.hiGridRowSelectionListeners = JCListenerList.add(this.hiGridRowSelectionListeners, hiGridRowSelectionListener);
    }

    public synchronized void removeHiGridRowSelectionListener(HiGridRowSelectionListener hiGridRowSelectionListener) {
        this.hiGridRowSelectionListeners = JCListenerList.remove(this.hiGridRowSelectionListeners, hiGridRowSelectionListener);
    }

    protected boolean fireHiGridRowSelectionEvent(HiGridRowSelectionEvent hiGridRowSelectionEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridRowSelectionListeners);
        while (enumeration.hasMoreElements()) {
            HiGridRowSelectionListener hiGridRowSelectionListener = (HiGridRowSelectionListener)enumeration.nextElement();
            switch (hiGridRowSelectionEvent.getEventType()) {
                case 1: {
                    hiGridRowSelectionListener.beforeSelectRow(hiGridRowSelectionEvent);
                    break;
                }
                case 2: {
                    hiGridRowSelectionListener.afterSelectRow(hiGridRowSelectionEvent);
                    break;
                }
            }
            if (!hiGridRowSelectionEvent.getCancelled() || !hiGridRowSelectionEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridSortTableListener(HiGridSortTableListener hiGridSortTableListener) {
        this.hiGridSortTableListeners = JCListenerList.add(this.hiGridSortTableListeners, hiGridSortTableListener);
    }

    public synchronized void removeHiGridSortTableListener(HiGridSortTableListener hiGridSortTableListener) {
        this.hiGridSortTableListeners = JCListenerList.remove(this.hiGridSortTableListeners, hiGridSortTableListener);
    }

    protected boolean fireHiGridSortTableEvent(HiGridSortTableEvent hiGridSortTableEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridSortTableListeners);
        while (enumeration.hasMoreElements()) {
            HiGridSortTableListener hiGridSortTableListener = (HiGridSortTableListener)enumeration.nextElement();
            switch (hiGridSortTableEvent.getEventType()) {
                case 1: {
                    hiGridSortTableListener.beforeSortTable(hiGridSortTableEvent);
                    break;
                }
                case 2: {
                    hiGridSortTableListener.afterSortTable(hiGridSortTableEvent);
                    break;
                }
            }
            if (!hiGridSortTableEvent.getCancelled() || !hiGridSortTableEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridTraverseListener(HiGridTraverseListener hiGridTraverseListener) {
        this.hiGridTraverseListeners = JCListenerList.add(this.hiGridTraverseListeners, hiGridTraverseListener);
    }

    public synchronized void removeHiGridTraverseListener(HiGridTraverseListener hiGridTraverseListener) {
        this.hiGridTraverseListeners = JCListenerList.remove(this.hiGridTraverseListeners, hiGridTraverseListener);
    }

    protected boolean fireHiGridTraverseEvent(HiGridTraverseEvent hiGridTraverseEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridTraverseListeners);
        while (enumeration.hasMoreElements()) {
            HiGridTraverseListener hiGridTraverseListener = (HiGridTraverseListener)enumeration.nextElement();
            switch (hiGridTraverseEvent.getEventType()) {
                case 1: {
                    hiGridTraverseListener.afterTraverse(hiGridTraverseEvent);
                    break;
                }
            }
            if (!hiGridTraverseEvent.getCancelled() || !hiGridTraverseEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridUpdateListener(HiGridUpdateListener hiGridUpdateListener) {
        this.hiGridUpdateListeners = JCListenerList.add(this.hiGridUpdateListeners, hiGridUpdateListener);
    }

    public synchronized void removeHiGridUpdateListener(HiGridUpdateListener hiGridUpdateListener) {
        this.hiGridUpdateListeners = JCListenerList.remove(this.hiGridUpdateListeners, hiGridUpdateListener);
    }

    protected boolean fireHiGridUpdateEvent(HiGridUpdateEvent hiGridUpdateEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridUpdateListeners);
        while (enumeration.hasMoreElements()) {
            HiGridUpdateListener hiGridUpdateListener = (HiGridUpdateListener)enumeration.nextElement();
            switch (hiGridUpdateEvent.getEventType()) {
                case 1: {
                    hiGridUpdateListener.afterResetFormatData(hiGridUpdateEvent);
                    break;
                }
                case 2: {
                    hiGridUpdateListener.afterResetHiGridData(hiGridUpdateEvent);
                    break;
                }
                case 3: {
                    hiGridUpdateListener.afterCreateRow(hiGridUpdateEvent);
                    break;
                }
            }
            if (!hiGridUpdateEvent.getCancelled() || !hiGridUpdateEvent.isCancelable()) continue;
            return false;
        }
        return true;
    }

    public synchronized void addHiGridValidateListener(HiGridValidateListener hiGridValidateListener) {
        this.hiGridValidateListeners = JCListenerList.add(this.hiGridValidateListeners, hiGridValidateListener);
    }

    public synchronized void removeHiGridValidateListener(HiGridValidateListener hiGridValidateListener) {
        this.hiGridValidateListeners = JCListenerList.remove(this.hiGridValidateListeners, hiGridValidateListener);
    }

    protected HiGridValidateEvent makeValidateEvent(int n, JCValidateEvent jCValidateEvent) {
        RowNode rowNode = null;
        String string = "";
        CellPosition cellPosition = this.getCurrentCell();
        if (cellPosition != null) {
            rowNode = cellPosition.row;
            string = cellPosition.format.getName();
        }
        try {
            return new HiGridValidateEvent(this, 3001, jCValidateEvent, rowNode, string);
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
            return null;
        }
    }

    public void valueChangedBegin(JCValidateEvent jCValidateEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridValidateListeners);
        while (enumeration.hasMoreElements()) {
            HiGridValidateListener hiGridValidateListener = (HiGridValidateListener)enumeration.nextElement();
            HiGridValidateEvent hiGridValidateEvent = this.makeValidateEvent(3001, jCValidateEvent);
            hiGridValidateListener.valueChangedBegin(hiGridValidateEvent);
            if (hiGridValidateEvent.getValidateEvent().isValid()) continue;
            return;
        }
    }

    public void valueChangedEnd(JCValidateEvent jCValidateEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridValidateListeners);
        while (enumeration.hasMoreElements()) {
            HiGridValidateListener hiGridValidateListener = (HiGridValidateListener)enumeration.nextElement();
            HiGridValidateEvent hiGridValidateEvent = this.makeValidateEvent(3002, jCValidateEvent);
            hiGridValidateListener.valueChangedEnd(hiGridValidateEvent);
        }
    }

    public void stateIsInvalid(JCValidateEvent jCValidateEvent) {
        Enumeration enumeration = JCListenerList.elements(this.hiGridValidateListeners);
        while (enumeration.hasMoreElements()) {
            HiGridValidateListener hiGridValidateListener = (HiGridValidateListener)enumeration.nextElement();
            HiGridValidateEvent hiGridValidateEvent = this.makeValidateEvent(3003, jCValidateEvent);
            hiGridValidateListener.stateIsInvalid(hiGridValidateEvent);
        }
        if (this.isBeepOnInvalid() && jCValidateEvent.getBeep() && !jCValidateEvent.isValid()) {
            this.getToolkit().beep();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected void finalize() throws Throwable {
    }

    public void dispose() {
        if (this.getDataModel() != null) {
            this.setDataModel(null);
            this.setDataModelListener(null);
        }
        this.setController(null);
        this.setGridArea(null);
        this.setEditPopupMenu(null);
        this.ui = null;
    }

    public void generateError() {
        try {
            if (this.getDataModel() != null) {
                this.getCurrentRowNode().getDataTableModel().getResultData(this.getCurrentRowNode().getBookmark(), "Unknown Field");
            }
        }
        catch (Exception exception) {
            this.fireHiGridErrorEvent(new HiGridErrorEvent(this, exception));
        }
    }

    protected void printStackTrace() {
    }

    protected static void addUnique(Vector vector, Object object) {
        if (!vector.contains(object)) {
            vector.addElement(object);
        }
    }
}

