/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.FolderIcons;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;

public class FolderIconStyle
implements Serializable {
    static final long serialVersionUID = 6876423810461928052L;
    public static final int FOLDER_ICON_STYLE_USER_DEFINED = 0;
    public static final int FOLDER_ICON_STYLE_SHORTCUT = 1;
    public static final int FOLDER_ICON_STYLE_FOLDER = 2;
    public static final int FOLDER_ICON_STYLE_TRIANGLE = 3;
    public static final int FOLDER_ICON_STYLE_SMALL_LINE_3D = 4;
    public static final int FOLDER_ICON_STYLE_MEDIUM_LINE_3D = 5;
    public static final int FOLDER_ICON_STYLE_LARGE_LINE_3D = 6;
    public static final int FOLDER_ICON_STYLE_TURNER = 7;
    protected static final int FIRST_FOLDER_ICON_STYLE = 1;
    protected static final int LAST_FOLDER_ICON_STYLE = 7;
    protected static final int DEFAULT_FOLDER_ICON_STYLE = 1;
    private static final String[] shortcutOpenIcon = new String[]{".........", ".       .", ".       .", ".       .", ". ..... .", ".       .", ".       .", ".       .", "........."};
    private static final String[] shortcutClosedIcon = new String[]{".........", ".       .", ".   .   .", ".   .   .", ". ..... .", ".   .   .", ".   .   .", ".       .", "........."};
    private HiGrid grid = null;
    private int style;
    private transient Image[] folderIcons = null;

    public FolderIconStyle(HiGrid hiGrid) {
        this.grid = hiGrid;
        this.recreateIcons();
    }

    protected void recreateIcons() {
        if (this.folderIcons == null) {
            this.folderIcons = new Image[3];
            this.setStyle(1);
        }
    }

    protected int getMaximumHeight() {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            Image image = this.getFolderIcon(n2);
            if (image != null) {
                n = Math.max(n, image.getHeight(null));
            }
            ++n2;
        }
        return n;
    }

    protected int getMaximumWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            Image image = this.getFolderIcon(n2);
            if (image != null) {
                n = Math.max(n, image.getWidth(null));
            }
            ++n2;
        }
        return n;
    }

    protected int getStyle() {
        return this.style;
    }

    protected void validateGridNodeWidth() {
        int n = this.getMaximumWidth();
        if (n > this.grid.getNodeWidth()) {
            this.grid.setNodeWidth(n);
        }
    }

    protected void setStyle(int n) {
        if (n < 1 || n > 7) {
            n = 1;
        }
        JCIconCreator jCIconCreator = null;
        if (n == 1) {
            jCIconCreator = new JCIconCreator(9, 9);
            jCIconCreator.setColor('X', new Color(235, 235, 128));
            jCIconCreator.setColor('.', Color.black);
            jCIconCreator.setPixels(shortcutOpenIcon);
            this.setIcon(jCIconCreator.getIcon().getImage(), 1);
            jCIconCreator.clear();
            jCIconCreator.setPixels(shortcutClosedIcon);
            this.setIcon(jCIconCreator.getIcon().getImage(), 0);
            this.setIcon(null, 2);
        } else {
            FolderIcons folderIcons = new FolderIcons(this.grid, this);
            folderIcons.setStyle(n);
        }
        this.style = n;
        this.validateGridNodeWidth();
    }

    public Image getFolderIcon(int n) {
        this.recreateIcons();
        return this.folderIcons[n];
    }

    public void setFolderIcon(Image image, int n) {
        this.recreateIcons();
        this.folderIcons[n] = image;
        this.style = 0;
        this.validateGridNodeWidth();
    }

    protected void setIcon(Image image, int n) {
        this.recreateIcons();
        this.folderIcons[n] = image;
    }
}

