/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellTextEditor;
import com.klg.jclass.cell.JCKeyModifier;
import com.klg.jclass.cell.JCValidateInterface;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.ActionInitiator;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.EditPopupMenu;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.GridArea;
import com.klg.jclass.higrid.GridScrollbar;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridAction;
import com.klg.jclass.higrid.HiGridColumnSelectionEvent;
import com.klg.jclass.higrid.HiGridEditStatusRenderer;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridException;
import com.klg.jclass.higrid.HiGridExpansionEvent;
import com.klg.jclass.higrid.HiGridFocusAdapter;
import com.klg.jclass.higrid.HiGridMoveCellEvent;
import com.klg.jclass.higrid.HiGridResizeCellEvent;
import com.klg.jclass.higrid.HiGridRowSelectionEvent;
import com.klg.jclass.higrid.HiGridTraverseEvent;
import com.klg.jclass.higrid.KeyActionInitiator;
import com.klg.jclass.higrid.LastRowWalk;
import com.klg.jclass.higrid.LevelSelectWalk;
import com.klg.jclass.higrid.MouseActionInitiator;
import com.klg.jclass.higrid.NullCellEditor;
import com.klg.jclass.higrid.NullGraphics;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RecordWalk;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowSelectWalk;
import com.klg.jclass.higrid.RowTree;
import com.klg.jclass.higrid.StringRowFlavor;
import com.klg.jclass.util.JCEnvironment;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class Controller
implements Serializable,
JCCellEditorListener,
KeyListener,
MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 4304445072571427191L;
    public static final int MINIMUM_COLUMN_WIDTH = 8;
    public static final int MINIMUM_ROW_HEIGHT = 8;
    public static final int SELECT_TOLERANCE = 2;
    protected boolean resizingColumn = false;
    protected int columnXResize = 0;
    protected int xResizeOffset = -1;
    protected int columnIndexResize = -1;
    protected boolean resizingRow = false;
    protected int rowYResize = 0;
    protected int yResizeOffset = -1;
    protected RowNode resizeLevel = null;
    protected JPanel resizer = null;
    protected CellPosition resizeCell = null;
    protected boolean movingColumn = false;
    protected JColumnHeaderLabel columnLabel = null;
    protected boolean mouseExited = false;
    protected Point columnOrigin = null;
    protected boolean selectingColumn = false;
    protected CellPosition selectedCell = null;
    protected Point originalMousePress = null;
    protected CellPosition currentCell = null;
    protected JCCellEditor currentCellEditor = null;
    protected boolean inEditMode = false;
    protected int desiredColumn = 0;
    protected RowNode lastSelectedRowNode = null;
    protected Vector selectedRowNodes = null;
    protected Vector actions;
    protected int currentAction = 0;
    protected boolean duringTraversal = false;
    protected Class nullEditor = null;
    protected HiGridFocusAdapter focusListener = null;
    private boolean fNewFocusModel = false;
    private HiGrid grid;
    protected int lastKeyProcessed = 0;

    public Controller(HiGrid hiGrid) {
        this.grid = hiGrid;
        this.removeAllActions();
        this.createDefaultActions();
        this.selectedRowNodes = new Vector(10);
        try {
            this.nullEditor = Class.forName("com.klg.jclass.higrid.NullCellEditor");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fNewFocusModel = JCEnvironment.getJavaVersion() >= 140;
        String string = this.fNewFocusModel ? "com.klg.jclass.higrid.HiGridFocusNew" : "com.klg.jclass.higrid.HiGridFocusOld";
        try {
            Class<?> clazz = Class.forName(string);
            this.focusListener = (HiGridFocusAdapter)clazz.newInstance();
            this.focusListener.setGrid(hiGrid);
        }
        catch (Exception exception) {
            System.out.println("FocusListener initialization error:" + exception.getMessage());
        }
    }

    private GridArea getGridArea() {
        return (GridArea)this.grid.getGridArea();
    }

    protected boolean isTraversing() {
        return this.duringTraversal;
    }

    protected CellPosition getCurrentCell() {
        return this.currentCell;
    }

    protected void setCurrentCell(CellPosition cellPosition) {
        this.currentCell = cellPosition;
        if (this.currentCell == null) {
            this.removeEditor();
        }
    }

    protected int getDesiredColumn() {
        return this.desiredColumn;
    }

    protected void setDesiredColumn(int n) {
        this.desiredColumn = n = Math.max(0, n);
    }

    protected boolean containerReserved(JCKeyModifier jCKeyModifier) {
        if (jCKeyModifier.match(27, 0)) {
            return true;
        }
        if (jCKeyModifier.match(37, 0)) {
            return true;
        }
        if (jCKeyModifier.match(39, 0)) {
            return true;
        }
        if (jCKeyModifier.match(36, 0)) {
            return true;
        }
        if (jCKeyModifier.match(35, 0)) {
            return true;
        }
        if (jCKeyModifier.match(9, 0)) {
            return true;
        }
        return jCKeyModifier.match(9, 1);
    }

    protected boolean shouldProcessThisKey(int n, int n2) {
        if (this.currentCellEditor == null) {
            return false;
        }
        JCKeyModifier[] jCKeyModifierArray = this.currentCellEditor.getReservedKeys();
        if (jCKeyModifierArray != null && jCKeyModifierArray.length > 0) {
            int n3 = 0;
            while (n3 < jCKeyModifierArray.length) {
                if (jCKeyModifierArray[n3] != null && jCKeyModifierArray[n3].match(n, n2) && (this.inEditMode || !this.containerReserved(jCKeyModifierArray[n3]))) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    protected void processKey(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getKeyCode();
        if (!this.shouldProcessThisKey(n2, n = keyEvent.getModifiers())) {
            return;
        }
        RowTree rowTree = this.grid.getRowTree();
        boolean bl = false;
        boolean bl2 = true;
        CellPosition cellPosition = null;
        int n3 = this.getDesiredColumn();
        int n4 = this.getAction(keyEvent);
        this.setCurrentAction(n4);
        switch (n4) {
            case 3: {
                cellPosition = this.goUp();
                break;
            }
            case 4: {
                cellPosition = this.goDown();
                break;
            }
            case 1: {
                cellPosition = this.goLeft();
                if (cellPosition == null) break;
                n3 = this.getVisibleIndex(cellPosition);
                break;
            }
            case 2: {
                cellPosition = this.goRight();
                if (cellPosition == null) break;
                n3 = this.getVisibleIndex(cellPosition);
                break;
            }
            case 5: {
                if (this.validateCell(null)) {
                    this.grid.getVerticalScrollbar().scrollPageUp();
                    cellPosition = this.doTheRecordWalk(rowTree.getTopRowNode(), 0, true);
                }
                if (cellPosition == null) break;
                cellPosition.columnIndex = this.getActualIndex(cellPosition.row.getRowFormat(), n3);
                break;
            }
            case 6: {
                if (this.validateCell(null)) {
                    this.grid.getVerticalScrollbar().scrollPageDown();
                    cellPosition = this.doTheRecordWalk(rowTree.getTopRowNode(), 0, true);
                }
                if (cellPosition == null) break;
                cellPosition.columnIndex = this.getActualIndex(cellPosition.row.getRowFormat(), n3);
                break;
            }
            case 7: {
                if (!this.validateCell(null)) break;
                this.grid.getHorizontalScrollbar().scrollPageUp();
                break;
            }
            case 8: {
                if (!this.validateCell(null)) break;
                this.grid.getHorizontalScrollbar().scrollPageDown();
                break;
            }
            case 9: {
                cellPosition = new CellPosition(this.currentCell.row, this.currentCell.row.getRowFormat().getFirstVisibleCell());
                if (cellPosition.columnIndex < 0) {
                    bl2 = false;
                    break;
                }
                n3 = this.getVisibleIndex(cellPosition);
                this.grid.getHorizontalScrollbar().setValue(0);
                break;
            }
            case 10: {
                cellPosition = new CellPosition(this.currentCell.row, 0);
                cellPosition = this.getLastCell(cellPosition.row);
                n3 = this.getVisibleIndex(cellPosition);
                break;
            }
            case 11: {
                cellPosition = this.goHome();
                if (cellPosition.columnIndex < 0) {
                    bl2 = false;
                    break;
                }
                n3 = this.getVisibleIndex(cellPosition);
                this.grid.getHorizontalScrollbar().setValue(0);
                break;
            }
            case 12: {
                cellPosition = this.goEnd();
                n3 = this.getVisibleIndex(cellPosition);
                break;
            }
            case 13: {
                cellPosition = this.goRight();
                if (cellPosition == null && (cellPosition = this.goDown()) != null) {
                    cellPosition = this.getFirstCell(cellPosition.row);
                }
                if (cellPosition == null) break;
                n3 = this.getVisibleIndex(cellPosition);
                break;
            }
            case 14: {
                cellPosition = this.goLeft();
                if (cellPosition == null && (cellPosition = this.goUp()) != null) {
                    cellPosition = this.getLastCell(cellPosition.row);
                }
                if (cellPosition == null) break;
                n3 = this.getVisibleIndex(cellPosition);
                break;
            }
            case 15: {
                if (this.currentCell.row.getState() != 0) break;
                this.expandFolder(this.currentCell.row);
                break;
            }
            case 16: {
                if (this.currentCell.row.getState() != 1) break;
                this.collapseFolder(this.currentCell.row);
                break;
            }
            case 20: {
                this.grid.fireHiGridColumnSelectionEvent(new HiGridColumnSelectionEvent(this.grid, 1, this.currentCell.row, this.currentCell, keyEvent));
                bl2 = false;
                break;
            }
            case 18: {
                this.cancelCellEditing();
                break;
            }
            case 17: {
                this.stopCellEditing();
                break;
            }
            case 23: {
                bl2 = false;
                break;
            }
            case 19: {
                this.showPopupMenu(keyEvent);
                bl2 = false;
                break;
            }
            case 21: 
            case 22: {
                if (this.grid.isAllowRowSelection()) {
                    this.doRowSelection(this.currentCell.row, this.grid.getRowSelectionMode(), n4 == 22);
                }
                bl2 = false;
                break;
            }
            case 24: {
                this.performCopyAction();
                bl2 = false;
                break;
            }
            case 25: {
                this.performPasteAction();
                bl2 = false;
                break;
            }
            default: {
                if (!this.grid.isEditable() || !this.currentCell.format.isEditable()) {
                    this.inEditMode = false;
                }
                this.makeCellEditorVisible(n4);
                if (this.currentCellEditor instanceof NullCellEditor) {
                    char c;
                    this.popupEditor(keyEvent);
                    this.acquireFocusForCellEditor();
                    if (JCEnvironment.getJavaVersion() >= 140 && this.currentCellEditor instanceof JCCellTextEditor && (c = keyEvent.getKeyChar()) != '\uffff') {
                        String string = null;
                        string = c == '\b' ? new String() : String.valueOf(c);
                        ((JCCellTextEditor)this.currentCellEditor).setCellEditorText(string);
                    }
                } else {
                    this.acquireFocusForCellEditor();
                }
                bl2 = false;
            }
        }
        if (bl2) {
            keyEvent.consume();
            if (cellPosition != null) {
                cellPosition = new CellPosition(cellPosition.row, cellPosition.columnIndex);
            }
            this.validateAndTraverse(cellPosition, n3, keyEvent);
        }
        this.setCurrentAction(0);
    }

    protected void setCurrentAction(int n) {
        this.currentAction = n;
    }

    public int getCurrentAction() {
        return this.currentAction;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.lastKeyProcessed = keyEvent.getKeyCode();
        this.processKey(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        this.lastKeyProcessed = 0;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public int getVisibleIndex(CellPosition cellPosition) {
        return cellPosition.row.getRowFormat().getVisibleColumnIndex(cellPosition.columnIndex);
    }

    public int getActualIndex(RowFormat rowFormat, int n) {
        int n2 = Math.min(n, rowFormat.getVisibleColumnCount() - 1);
        return rowFormat.getActualColumnIndex(n2);
    }

    protected CellPosition goHome() {
        return this.getFirstCell(null);
    }

    protected CellPosition goEnd() {
        CellPosition cellPosition = this.getLastCell(null);
        RowNode rowNode = cellPosition.row;
        LastRowWalk lastRowWalk = new LastRowWalk(true);
        this.grid.getRowTree().walk(rowNode, lastRowWalk);
        cellPosition = this.getLastCell(lastRowWalk.getFoundNode());
        return cellPosition;
    }

    protected CellPosition goUp() {
        RowNode rowNode = this.currentCell.row;
        RowNode rowNode2 = (RowNode)rowNode.getPreviousSibling();
        if (rowNode2 != null && rowNode2.getState() == 0 && rowNode2.getRowFormat() instanceof RecordFormat) {
            CellPosition cellPosition = new CellPosition(rowNode2, this.currentCell.columnIndex);
            return cellPosition;
        }
        CellPosition cellPosition = this.doTheRecordWalk(this.currentCell.row, 1, false);
        if (cellPosition != null) {
            if (cellPosition.row == this.currentCell.row) {
                return null;
            }
            cellPosition.columnIndex = this.getActualIndex(cellPosition.row.getRowFormat(), this.getDesiredColumn());
        }
        return cellPosition;
    }

    protected CellPosition goDown() {
        Serializable serializable;
        RowNode rowNode = this.currentCell.row;
        if (rowNode.getState() == 0 && (serializable = (RowNode)rowNode.getNextSibling()) != null && serializable.getRowFormat() instanceof RecordFormat) {
            CellPosition cellPosition = new CellPosition((RowNode)serializable, this.currentCell.columnIndex);
            return cellPosition;
        }
        serializable = this.doTheRecordWalk(this.currentCell.row, 1, true);
        if (serializable != null) {
            if (((CellPosition)serializable).row == this.currentCell.row) {
                return null;
            }
            ((CellPosition)serializable).columnIndex = this.getActualIndex(((CellPosition)serializable).row.getRowFormat(), this.getDesiredColumn());
        }
        return serializable;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected CellPosition goLeft() {
        CellPosition cellPosition = null;
        int n = this.currentCell.columnIndex;
        while (n > 0) {
            if (!((CellFormat)this.currentCell.row.getRowFormat().getDataFormats().elementAt(--n)).isShowing()) continue;
            return new CellPosition(this.currentCell.row, n);
        }
        return cellPosition;
    }

    protected CellPosition goRight() {
        CellPosition cellPosition = null;
        int n = this.currentCell.columnIndex;
        int n2 = this.currentCell.row.getRowFormat().getDataFormats().size() - 1;
        while (n < n2) {
            if (!((CellFormat)this.currentCell.row.getRowFormat().getDataFormats().elementAt(++n)).isShowing()) continue;
            cellPosition = new CellPosition(this.currentCell.row, n);
            break;
        }
        return cellPosition;
    }

    protected CellPosition goLevelHome(RowNode rowNode) {
        return this.goLevelUp(rowNode, false);
    }

    protected CellPosition goLevelHome() {
        return this.goLevelHome(this.currentCell.row);
    }

    protected CellPosition goLevelUp() {
        return this.goLevelUp(this.currentCell.row, true);
    }

    protected CellPosition goLevelUp(RowNode rowNode, boolean bl) {
        RowNode rowNode2 = rowNode;
        FormatNode formatNode = rowNode.getFormatNode();
        while ((rowNode = (RowNode)rowNode.getPreviousSibling()) != null) {
            if (!(rowNode.getRowFormat() instanceof RecordFormat)) continue;
            if (rowNode.getFormatNode() != formatNode) break;
            rowNode2 = rowNode;
            if (!bl) continue;
        }
        return new CellPosition(rowNode2, this.getActualIndex(rowNode2.getRowFormat(), this.getDesiredColumn()));
    }

    protected CellPosition goLevelEnd(RowNode rowNode) {
        return this.goLevelDown(rowNode, false);
    }

    protected CellPosition goLevelEnd() {
        return this.goLevelDown(this.currentCell.row, false);
    }

    protected CellPosition goLevelDown() {
        return this.goLevelDown(this.currentCell.row, true);
    }

    protected CellPosition goLevelDown(RowNode rowNode, boolean bl) {
        RowNode rowNode2 = rowNode;
        FormatNode formatNode = rowNode.getFormatNode();
        while ((rowNode = (RowNode)rowNode.getNextSibling()) != null) {
            if (!(rowNode.getRowFormat() instanceof RecordFormat)) continue;
            if (rowNode.getFormatNode() != formatNode) break;
            rowNode2 = rowNode;
            if (!bl) continue;
        }
        return new CellPosition(rowNode2, this.getActualIndex(rowNode2.getRowFormat(), this.getDesiredColumn()));
    }

    protected CellPosition goLevelParent() {
        RowNode rowNode = this.currentCell.row;
        RowNode rowNode2 = (RowNode)rowNode.getParent();
        if (rowNode2 != null && (RowNode)this.grid.getRowTree().getRootNode() != rowNode2) {
            rowNode = rowNode2;
        }
        return new CellPosition(rowNode, this.getActualIndex(rowNode.getRowFormat(), this.getDesiredColumn()));
    }

    protected boolean isSourceEditorComponent(Object object) {
        return this.currentCellEditor != null && (Component)object == this.getFirstTraversable(this.currentCellEditor.getComponent());
    }

    public void editingStopped(JCCellEditorEvent jCCellEditorEvent) {
        if (this.currentCellEditor.isModified()) {
            if (this.commitAndConvert()) {
                this.inEditMode = false;
                this.handleAutoEdit();
            }
        } else {
            this.currentCellEditor.cancelCellEditing();
            this.inEditMode = false;
            this.handleAutoEdit();
        }
    }

    public void editingCanceled(JCCellEditorEvent jCCellEditorEvent) {
        this.currentCellEditor.cancelCellEditing();
        this.inEditMode = false;
        this.handleAutoEdit();
    }

    public void cancelCellEditing() {
        if (this.currentCellEditor != null && this.grid.isAutoEdit()) {
            this.currentCellEditor.cancelCellEditing();
        }
        this.inEditMode = false;
        this.handleAutoEdit();
    }

    public void stopCellEditing() {
        if (this.currentCellEditor != null && this.commitAndConvert()) {
            this.inEditMode = false;
            this.handleAutoEdit();
        }
    }

    protected void handleAutoEdit() {
        if (!this.grid.isAutoEdit()) {
            this.popupEditor(null);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isSourceEditorComponent(mouseEvent.getSource())) {
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.isSourceEditorComponent(mouseEvent.getSource())) {
            return;
        }
        if (this.grid.isTrackCursor()) {
            this.setOurCursor(mouseEvent);
        } else {
            this.getGridArea().setCursor(this.grid.getDefaultCursor());
        }
        this.mouseExited = false;
        if (this.columnLabel != null) {
            this.columnLabel.setVisible(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isSourceEditorComponent(mouseEvent.getSource())) {
            return;
        }
        this.getGridArea().setCursor(Cursor.getDefaultCursor());
        this.mouseExited = true;
        if (this.columnLabel != null) {
            this.columnLabel.setVisible(false);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof NullCellEditor) {
            this.popupEditor(mouseEvent);
            this.acquireFocusForCellEditor();
            return;
        }
        if (this.isSourceEditorComponent(object)) {
            this.inEditMode = true;
            return;
        }
        if (object != this.getGridArea()) {
            return;
        }
        RowTree rowTree = this.grid.getRowTree();
        GridArea gridArea = this.getGridArea();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.originalMousePress = new Point(n += this.grid.getHorizontalScrollbar().getValue(), n2);
        NullGraphics nullGraphics = this.getCellFromXY(new Point(n, n2));
        RowNode rowNode = null;
        if (nullGraphics.cell != null) {
            rowNode = nullGraphics.cell.row;
        }
        if (!this.duringRowResizing(nullGraphics) && !this.duringColumnResizing(nullGraphics)) {
            boolean bl = true;
            int n3 = this.getAction(mouseEvent);
            this.setCurrentAction(n3);
            switch (n3) {
                case 20: {
                    if (nullGraphics.cell != null && !nullGraphics.cell.isIndicator && nullGraphics.cell.format != null && rowNode != null && rowNode.getRowFormat() instanceof HeaderFormat) {
                        this.selectingColumn = true;
                        this.selectedCell = (CellPosition)nullGraphics.cell.clone();
                        this.columnOrigin = this.grid.getPointFromCellPosition(this.selectedCell);
                        this.columnOrigin.x -= n;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 19: {
                    this.showPopupMenu(mouseEvent);
                    break;
                }
                case 21: 
                case 22: {
                    if (!this.grid.isAllowRowSelection() || rowNode == null || !(rowNode.getRowFormat() instanceof RecordFormat)) break;
                    this.doRowSelection(rowNode, this.grid.getRowSelectionMode(), n3 == 22);
                    break;
                }
                case 24: {
                    this.performCopyAction();
                    break;
                }
                case 25: {
                    this.performPasteAction();
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                this.setCurrentAction(0);
                return;
            }
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.duringRowResizing(nullGraphics)) {
            if (this.grid.fireHiGridResizeCellEvent(new HiGridResizeCellEvent(this.grid, 1, rowNode))) {
                this.resizingRow = true;
                this.resizeLevel = rowNode;
                this.yResizeOffset = nullGraphics.rowYOffset;
                this.rowYResize = n2 + this.yResizeOffset;
                this.resizer = new JPanel();
                this.resizer.setVisible(false);
                this.resizer.setBackground(Color.black);
                this.getGridArea().add((Component)this.resizer, 0);
                this.resizer.setBounds(0, this.rowYResize, this.grid.getSize().width, 1);
                this.resizer.setVisible(true);
            }
        } else if (this.duringColumnResizing(nullGraphics)) {
            if (this.grid.fireHiGridResizeCellEvent(new HiGridResizeCellEvent(this.grid, 2, rowNode, nullGraphics.resizeFormat.getName()))) {
                this.resizingColumn = true;
                this.columnXResize = nullGraphics.columnX;
                this.columnIndexResize = nullGraphics.columnIndex;
                this.resizeCell = new CellPosition(rowNode, this.columnIndexResize, nullGraphics.cell.isIndicator);
                this.resizeCell.format = nullGraphics.resizeFormat;
                this.xResizeOffset = n - this.columnXResize;
                this.resizer = new JPanel();
                this.resizer.setVisible(false);
                this.resizer.setBackground(Color.black);
                this.getGridArea().add((Component)this.resizer, 0);
                this.resizer.setBounds(this.columnXResize - this.grid.getHorizontalScrollbar().getValue(), 0, 1, this.grid.getSize().height);
                this.resizer.setVisible(true);
            }
        } else if (nullGraphics.overFolderIcon) {
            switch (rowNode.getState()) {
                case 0: {
                    this.expandFolder(rowNode);
                    break;
                }
                case 1: {
                    this.collapseFolder(rowNode);
                    break;
                }
            }
        } else if (nullGraphics.cell.format != null) {
            if (this.grid.lookupTable.getCellRendererInstance(nullGraphics.cell.format.getCellRenderer()) instanceof HiGridEditStatusRenderer) {
                if (rowNode != null && rowNode.getDataTableModel() != null && rowNode.getDataTableModel().getRowStatus(rowNode.getBookmark()) != 4) {
                    try {
                        rowNode.getDataTableModel().commitRow(this.grid.getDataModelListener(), rowNode.getBookmark());
                    }
                    catch (Exception exception) {
                        this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
                    }
                    this.resetRowSelection();
                }
            } else if (rowNode != null && rowNode.getRowFormat() instanceof RecordFormat) {
                this.validateAndTraverse(nullGraphics.cell, rowNode.getRowFormat().getVisibleColumnIndex(nullGraphics.cell.columnIndex), mouseEvent);
            }
        } else {
            this.commitAndConvert();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isSourceEditorComponent(mouseEvent.getSource())) {
            return;
        }
        int n = mouseEvent.getX();
        n += this.grid.getHorizontalScrollbar().getValue();
        if (this.resizingColumn) {
            this.resizer.setVisible(false);
            this.getGridArea().remove(this.resizer);
            int n2 = this.resizeCell.format.getWidth();
            int n3 = n2 + n - this.columnXResize - this.xResizeOffset;
            if (n2 != n3) {
                int n4 = 8;
                if (this.resizeCell.isIndicator && this.resizeCell.columnIndex == 0) {
                    n4 = this.grid.folderIconStyle.getMaximumWidth();
                }
                n3 = Math.max(n3, n4);
                if (mouseEvent.isShiftDown() && !this.resizeCell.isIndicator) {
                    this.resizeCell.row.getRowFormat().setCellWidths(n3);
                } else {
                    this.resizeCell.format.setWidth(n3);
                }
                this.grid.getRowTree().updateGridArea();
            }
            if (n2 != n3) {
                this.grid.fireHiGridResizeCellEvent(new HiGridResizeCellEvent(this.grid, 4, this.resizeCell.row, this.resizeCell.format.getName()));
                this.grid.refresh();
            }
            this.resizeCell = null;
            this.resizingColumn = false;
        } else if (this.resizingRow) {
            int n5 = mouseEvent.getY();
            this.resizer.setVisible(false);
            this.getGridArea().remove(this.resizer);
            int n6 = this.resizeLevel.getRowFormat().getHeight();
            int n7 = n6 + n5 - this.rowYResize + this.yResizeOffset;
            if (n6 != n7) {
                n7 = Math.max(n7, 8);
                this.resizeLevel.getRowFormat().setHeight(n7);
                int n8 = (n7 - n6) * this.resizeLevel.getFormatNode().getNumberOfScrollableRows();
                RowTree rowTree = this.grid.getRowTree();
                rowTree.setScrollableRowsHeight(n8 + rowTree.getScrollableRowsHeight());
                rowTree.updateGridArea();
            }
            this.resizingRow = false;
            if (n6 != n7) {
                this.grid.fireHiGridResizeCellEvent(new HiGridResizeCellEvent(this.grid, 3, this.resizeLevel));
                this.grid.refresh();
            }
        } else if (this.movingColumn) {
            if (this.mouseExited) {
                this.mouseExited = false;
            } else {
                NullGraphics nullGraphics = this.getCellFromXY(new Point(n, this.columnOrigin.y));
                this.exchangeColumns(this.selectedCell, nullGraphics.cell);
                this.grid.fireHiGridMoveCellEvent(new HiGridMoveCellEvent(this.grid, 2, this.selectedCell.row, this.selectedCell.getCellFormat().getName()));
            }
            this.grid.getGridArea().remove(this.columnLabel);
            this.columnLabel = null;
            this.movingColumn = false;
            this.grid.refresh();
        } else if (this.selectingColumn) {
            this.grid.fireHiGridColumnSelectionEvent(new HiGridColumnSelectionEvent(this.grid, 1, this.selectedCell.row, this.selectedCell, mouseEvent));
            this.selectingColumn = false;
        } else {
            return;
        }
        this.resizingColumn = false;
        this.resizingRow = false;
        this.movingColumn = false;
        this.selectingColumn = false;
        this.acquireFocusForCellEditor();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.resizingColumn) {
            this.resizer.setLocation(mouseEvent.getX() - this.xResizeOffset, 0);
        } else if (this.resizingRow) {
            this.resizer.setLocation(0, mouseEvent.getY() + this.yResizeOffset);
        } else if (this.movingColumn) {
            this.positionColumnLabel(mouseEvent);
        } else if (this.selectingColumn) {
            if (Math.abs(this.originalMousePress.x - mouseEvent.getX()) > 2 || Math.abs(this.originalMousePress.y - mouseEvent.getY()) > 2) {
                this.selectingColumn = false;
                if (this.grid.fireHiGridMoveCellEvent(new HiGridMoveCellEvent(this.grid, 1, this.selectedCell.row, this.selectedCell.getCellFormat().getName()))) {
                    this.movingColumn = true;
                    this.createColumnLabel();
                    this.grid.getGridArea().add((Component)this.columnLabel, 0);
                    this.positionColumnLabel(mouseEvent);
                }
            }
        } else {
            this.setOurCursor(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.resizingColumn || this.resizingRow || this.movingColumn) {
            return;
        }
        this.setOurCursor(mouseEvent);
    }

    protected void setOurCursor(MouseEvent mouseEvent) {
        if (this.isSourceEditorComponent(mouseEvent.getSource())) {
            return;
        }
        if (!this.grid.isTrackCursor()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        NullGraphics nullGraphics = this.getCellFromXY(new Point(n += this.grid.getHorizontalScrollbar().getValue(), n2));
        GridArea gridArea = this.getGridArea();
        if (this.resizingRow || this.duringRowResizing(nullGraphics)) {
            gridArea.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.resizingColumn || this.duringColumnResizing(nullGraphics)) {
            gridArea.setCursor(Cursor.getPredefinedCursor(10));
        } else {
            gridArea.setCursor(this.grid.getDefaultCursor());
        }
    }

    protected void createColumnLabel() {
        this.columnLabel = new JColumnHeaderLabel();
        CellFormat cellFormat = this.selectedCell.getCellFormat();
        this.columnLabel.setText(cellFormat.getText());
        this.columnLabel.setBackground(cellFormat.getBackground());
        this.columnLabel.setForeground(Color.black);
        this.columnLabel.setBounds(cellFormat.getTotalArea());
        this.columnLabel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.columnLabel.setFont(cellFormat.getFont());
    }

    protected void positionColumnLabel(MouseEvent mouseEvent) {
        this.columnLabel.setLocation(this.columnOrigin.x + mouseEvent.getX(), this.columnOrigin.y);
    }

    protected boolean duringRowResizing(NullGraphics nullGraphics) {
        return nullGraphics.overRowDivider && nullGraphics.cell.row.getRowFormat().getAllowHeightSizing();
    }

    protected boolean duringColumnResizing(NullGraphics nullGraphics) {
        if (!nullGraphics.overColumnDivider) {
            return false;
        }
        Vector vector = nullGraphics.cell.isIndicator ? nullGraphics.cell.row.getRowFormat().getIndicatorFormats() : nullGraphics.cell.row.getRowFormat().getDataFormats();
        return ((CellFormat)vector.elementAt(nullGraphics.columnIndex)).getAllowWidthSizing();
    }

    protected void exchangeColumns(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.removeElementAt(n);
        vector.insertElementAt(e, n2);
    }

    protected void exchangeColumns(CellPosition cellPosition, CellPosition cellPosition2) {
        if (cellPosition == null || cellPosition2 == null || cellPosition.isIndicator() || cellPosition2.isIndicator() || cellPosition.getRowNode() != cellPosition2.getRowNode() || cellPosition2.getCellFormat() == null || cellPosition.getColumnIndex() == cellPosition2.getColumnIndex()) {
            return;
        }
        FormatNode formatNode = cellPosition.getRowNode().getFormatNode();
        int n = cellPosition.getColumnIndex();
        int n2 = cellPosition2.getColumnIndex();
        this.exchangeColumns(formatNode.getHeaderFormat().getDataFormats(), n, n2);
        this.exchangeColumns(formatNode.getRecordFormat().getDataFormats(), n, n2);
        if (this.currentCell.getRowNode().getRowFormat() == formatNode.getRecordFormat() && this.currentCell.columnIndex == n) {
            this.currentCell.columnIndex = n2;
            this.setDesiredColumn(n2);
            this.positionEditor(true);
        }
    }

    protected boolean expandFolder(RowNode rowNode) {
        if (rowNode == null || rowNode.getState() != 0) {
            return false;
        }
        boolean bl = false;
        bl = this.grid.fireHiGridExpansionEvent(new HiGridExpansionEvent(this.grid, 1, rowNode));
        if (bl) {
            GridArea gridArea = this.getGridArea();
            Cursor cursor = gridArea.getCursor();
            gridArea.setCursor(Cursor.getPredefinedCursor(3));
            this.resetRowSelection();
            this.grid.refreshRowAndBelow(rowNode, 0);
            this.grid.fireHiGridExpansionEvent(new HiGridExpansionEvent(this.grid, 3, rowNode));
            gridArea.setCursor(cursor);
        }
        return bl;
    }

    protected boolean collapseFolder(RowNode rowNode) {
        CellPosition cellPosition;
        if (rowNode == null || rowNode.getState() != 1) {
            return false;
        }
        boolean bl = false;
        bl = this.grid.fireHiGridExpansionEvent(new HiGridExpansionEvent(this.grid, 2, rowNode));
        if (bl && this.currentCell.row.isChildOf(rowNode) && !this.validateAndTraverse(cellPosition = new CellPosition(rowNode, this.getActualIndex(rowNode.getRowFormat(), this.getDesiredColumn())), this.getDesiredColumn(), null)) {
            bl = false;
        }
        if (bl) {
            this.resetRowSelection();
            this.grid.refreshRowAndBelow(rowNode, 1);
            this.grid.fireHiGridExpansionEvent(new HiGridExpansionEvent(this.grid, 4, rowNode));
        }
        return bl;
    }

    protected void showEditor(boolean bl) {
        if (this.grid.getRowTree().getRootNode() == null || this.grid.getRowTree().getRootNode().getChildCount() <= 0 || this.currentCellEditor == null || this.currentCellEditor.getComponent() == null) {
            return;
        }
        if (this.grid.isEditorHidden()) {
            bl = false;
        }
        this.currentCellEditor.getComponent().setVisible(bl);
    }

    protected void initializeEditor() {
        this.initializeEditor(null);
    }

    protected void initializeEditor(AWTEvent aWTEvent) {
        if (this.grid.getDataModel() == null || this.currentCell == null) {
            return;
        }
        Object object = null;
        try {
            object = this.currentCell.row.getDataTableModel().getResultData(this.currentCell.row.getBookmark(), this.currentCell.format.getName());
        }
        catch (Exception exception) {
            this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
        }
        if (aWTEvent instanceof MouseEvent) {
            Point point = this.grid.getPointFromCellPosition(this.currentCell);
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            aWTEvent = new MouseEvent(this.currentCellEditor.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - point.x, mouseEvent.getY() - point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        }
        this.currentCellEditor.initialize(aWTEvent, this.currentCell.format, object);
        this.inEditMode = false;
    }

    protected void removeEditor() {
        if (this.currentCellEditor != null) {
            Component component;
            Component component2;
            this.currentCellEditor.cancelCellEditing();
            this.getGridArea().remove(this.currentCellEditor.getComponent());
            this.currentCellEditor.removeCellEditorListener(this);
            if (this.currentCellEditor instanceof JCValidateInterface) {
                ((JCValidateInterface)((Object)this.currentCellEditor)).removeValidateListener(this.grid);
            }
            if ((component2 = this.currentCellEditor.getComponent()) != null && (component = this.getFirstTraversable(component2)) != null) {
                component.removeKeyListener(this);
                component.removeMouseListener(this);
                component.removeFocusListener(this.focusListener);
            }
            this.currentCellEditor = null;
        }
    }

    protected void addEditor() {
        Component component = this.currentCellEditor.getComponent();
        if (component != null) {
            Component component2;
            this.currentCellEditor.addCellEditorListener(this);
            if (this.currentCellEditor instanceof JCValidateInterface) {
                ((JCValidateInterface)((Object)this.currentCellEditor)).addValidateListener(this.grid);
            }
            if ((component2 = this.getFirstTraversable(component)) != null) {
                component2.addKeyListener(this);
                component2.addFocusListener(this.focusListener);
                if (this.fNewFocusModel) {
                    component2.setFocusTraversalKeysEnabled(false);
                }
                component2.addMouseListener(this);
            }
        }
    }

    protected void createEditor() {
        this.createEditor(null);
    }

    protected void createEditor(AWTEvent aWTEvent) {
        if (this.grid.getDataModel() == null || this.currentCell == null) {
            return;
        }
        this.showEditor(false);
        this.removeEditor();
        this.currentCellEditor = this.grid.lookupTable.getCellEditorInstance(this.grid.isAutoEdit() || aWTEvent != null ? this.currentCell.format.getCellEditor() : this.nullEditor);
        this.addEditor();
        this.initializeEditor(aWTEvent);
        this.showEditor(false);
    }

    protected void positionEditor() {
        this.positionEditor(false);
    }

    protected void positionEditor(boolean bl) {
        if (this.grid.getRowTree().getRootNode() == null || this.grid.getRowTree().getRootNode().getChildCount() <= 0) {
            return;
        }
        if (this.currentCellEditor == null) {
            this.createEditor();
        }
        if (this.currentCellEditor != null && this.currentCell != null && this.currentCell.format != null && this.currentCell.row != null) {
            Component component = this.currentCellEditor.getComponent();
            if (component == null) {
                return;
            }
            this.getGridArea().remove(this.currentCellEditor.getComponent());
            NullGraphics nullGraphics = this.getXYFromCell(this.currentCell);
            if (!nullGraphics.finishedOperation) {
                return;
            }
            this.currentCell = nullGraphics.cell;
            this.getGridArea().add(component, 0);
            Dimension dimension = new Dimension(this.currentCell.format.getTotalArea().width, this.currentCell.row.getHeight());
            this.getEditorSize(component, this.currentCell.format, dimension);
            component.setBounds(this.currentCell.point.x - this.grid.getHorizontalScrollbar().getValue(), this.currentCell.point.y, dimension.width, dimension.height);
            if (bl) {
                this.acquireFocusForCellEditor();
            }
        }
    }

    protected void acquireFocusForCellEditor() {
        Component component;
        if (this.currentCellEditor == null) {
            return;
        }
        if (!this.fNewFocusModel) {
            if (this.currentCellEditor instanceof JComboBox || this.currentCellEditor instanceof JCCellEditor) {
                FocusManager.disableSwingFocusManager();
            } else {
                FocusManager.setCurrentManager(FocusManager.getCurrentManager());
            }
        }
        if ((component = this.getFirstTraversable(this.currentCellEditor.getComponent())) != null && (!component.hasFocus() || component instanceof JTextComponent || component instanceof NullCellEditor)) {
            this.getGridArea().getFocusManager().requestFocus();
            this.getGridArea().getFocusManager().requestFocus(component);
        }
    }

    protected void getEditorSize(Component component, CellFormat cellFormat, Dimension dimension) {
        switch (cellFormat.getEditWidthPolicy()) {
            case 0: {
                break;
            }
            case 1: {
                dimension.width = Math.max(component.getMinimumSize().width, dimension.width);
                break;
            }
            case 2: {
                dimension.width = Math.max(component.getPreferredSize().width, dimension.width);
            }
        }
        switch (cellFormat.getEditHeightPolicy()) {
            case 0: {
                break;
            }
            case 1: {
                dimension.height = Math.max(component.getMinimumSize().height, dimension.height);
                break;
            }
            case 2: {
                dimension.height = Math.max(component.getPreferredSize().height, dimension.height);
            }
        }
    }

    protected Component getFirstTraversable(Component component) {
        if (component != null) {
            if (component instanceof Container) {
                if (component.isFocusTraversable()) {
                    return component;
                }
                Component[] componentArray = ((Container)component).getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    if (componentArray[n].isFocusTraversable()) {
                        return componentArray[n];
                    }
                    ++n;
                }
                if (componentArray.length > 0) {
                    return componentArray[0];
                }
            } else {
                return component;
            }
        }
        return null;
    }

    protected void positionCurrentCell() {
        if (this.currentCell == null || this.currentCell.row == null) {
            CellPosition cellPosition = this.getFirstCell(null);
            if (cellPosition == null) {
                return;
            }
            this.setDesiredColumn(cellPosition.columnIndex);
            this.moveCurrentCellInternal(cellPosition, cellPosition.columnIndex, false, true);
        }
    }

    protected void repositionCurrentCell(RowNode rowNode, boolean bl, boolean bl2) {
        if (rowNode != null) {
            CellPosition cellPosition = new CellPosition(rowNode, rowNode.getRowFormat().getFirstVisibleCell());
            this.moveCurrentCellInternal(cellPosition, cellPosition.columnIndex, bl, bl2);
            this.createEditor();
            this.positionEditor();
            if (bl) {
                this.showEditor(true);
            }
        }
    }

    protected CellPosition getLastCell(RowNode rowNode) {
        int n = -1;
        if (rowNode == null) {
            rowNode = (RowNode)this.grid.getRowTree().getRootNode().getLastChild();
            CellPosition cellPosition = this.doTheRecordWalk(rowNode, 0, false);
            rowNode = cellPosition.row;
        }
        n = rowNode.getRowFormat().getLastVisibleCell();
        if (n < 0) {
            return null;
        }
        return new CellPosition(rowNode, n);
    }

    protected CellPosition getFirstCell(RowNode rowNode) {
        int n = -1;
        if (rowNode == null) {
            TreeIterator treeIterator = this.grid.getRowTree().getRootNode().getIterator();
            while (treeIterator.hasMoreElements()) {
                rowNode = (RowNode)treeIterator.get();
                n = rowNode.getRowFormat().getFirstVisibleCell();
                if (n < 0) {
                    treeIterator.nextElement();
                    continue;
                }
                break;
            }
        } else {
            n = rowNode.getRowFormat().getFirstVisibleCell();
        }
        if (n < 0) {
            return null;
        }
        return new CellPosition(rowNode, n);
    }

    protected boolean commitAndConvert() {
        if (this.currentCellEditor == null || this.currentCell == null || this.currentCell.row.getDataTableModel().getRowStatus(this.currentCell.row.getBookmark()) == 5 || this.currentCell.row.getDataTableModel().getRowStatus(this.currentCell.row.getBookmark()) == 3) {
            return true;
        }
        if (!this.grid.isEditable() || !this.currentCell.format.isEditable()) {
            this.currentCellEditor.cancelCellEditing();
            return true;
        }
        if (!this.currentCellEditor.stopCellEditing()) {
            return false;
        }
        Object object = this.currentCellEditor.getCellEditorValue();
        String string = this.currentCell.format.getName();
        boolean bl = true;
        try {
            this.currentCell.row.getDataTableModel().updateCell(this.grid.getDataModelListener(), this.currentCell.row.getBookmark(), string, object);
        }
        catch (Exception exception) {
            this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            bl = false;
        }
        return bl;
    }

    protected int horizontalCellAdjustment(CellPosition cellPosition) {
        if (cellPosition != null) {
            GridArea gridArea = this.getGridArea();
            GridScrollbar gridScrollbar = this.grid.getHorizontalScrollbar();
            int n = cellPosition.format.getTotalArea().width;
            int n2 = gridArea.getSize().width;
            if (cellPosition.point.x < gridScrollbar.getValue()) {
                if (cellPosition.point.x + n < n2) {
                    return 0 - gridScrollbar.getValue();
                }
                return cellPosition.point.x - gridScrollbar.getValue();
            }
            if (n >= n2) {
                return 0;
            }
            if (cellPosition.point.x + n > n2 + gridScrollbar.getValue()) {
                return cellPosition.point.x + n - (n2 + gridScrollbar.getValue());
            }
        }
        return 0;
    }

    protected boolean scrollEditorIntoView(int n) {
        if (this.currentCell == null || this.getGridArea().getSize().height <= 0) {
            return false;
        }
        boolean bl = false;
        RowTree rowTree = this.grid.getRowTree();
        NullGraphics nullGraphics = this.getXYFromCell(this.currentCell);
        CellPosition cellPosition = nullGraphics.cell;
        if (!nullGraphics.finishedOperation && n != 4) {
            rowTree.setTopRow(this.currentCell.row);
            nullGraphics = this.getXYFromCell(this.currentCell);
            cellPosition = nullGraphics.cell;
            bl = true;
        } else if (!nullGraphics.fullyVisible) {
            RowNode rowNode = rowTree.getTopRowNodeFromLastFullyVisibleRow(this.currentCell.row);
            rowTree.setTopRow(rowNode == null ? this.currentCell.row : rowNode);
            bl = true;
        }
        int n2 = this.horizontalCellAdjustment(cellPosition);
        if (n2 != 0) {
            GridScrollbar gridScrollbar = this.grid.getHorizontalScrollbar();
            gridScrollbar.setValue(n2 + gridScrollbar.getValue());
        }
        return bl;
    }

    public void makeCellEditorVisible() {
        this.makeCellEditorVisible(0);
    }

    protected void makeCellEditorVisible(int n) {
        if (!this.isTraversing() && this.scrollEditorIntoView(n)) {
            this.grid.refresh();
            this.acquireFocusForCellEditor();
            this.inEditMode = true;
        }
    }

    public boolean moveCurrentCell(CellPosition cellPosition, int n) {
        if (cellPosition == null) {
            return false;
        }
        if (!(cellPosition.getRowNode().getRowFormat() instanceof RecordFormat)) {
            return false;
        }
        cellPosition.setColumnIndex(this.getActualIndex(cellPosition.getRowNode().getRowFormat(), n));
        if (cellPosition.getCellFormat() == null) {
            return false;
        }
        return this.validateAndTraverse(cellPosition, cellPosition.columnIndex, null);
    }

    public boolean moveCurrentCell(CellPosition cellPosition, int n, boolean bl, boolean bl2) {
        return this.moveCurrentCell(cellPosition, n);
    }

    protected boolean moveCurrentCellInternal(CellPosition cellPosition, int n) {
        return this.moveCurrentCellInternal(cellPosition, n, true, true);
    }

    protected boolean moveCurrentCellInternal(CellPosition cellPosition, int n, boolean bl, boolean bl2) {
        boolean bl3 = this.currentCell == null ? true : this.currentCell.row != cellPosition.row;
        CellPosition cellPosition2 = null;
        if (this.currentCell != null) {
            cellPosition2 = (CellPosition)this.currentCell.clone();
        }
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        DataTableModel dataTableModel = cellPosition.row.getDataTableModel();
        long l = cellPosition.row.getBookmark();
        int n2 = dataTableModel.getRowIndex(l);
        DataTableModel dataTableModel2 = (DataTableModel)((Object)((DataSourceTreeNode)((Object)dataTableModel)).getParent());
        long l2 = dataTableModel.getParentBookmark();
        if (bl3) {
            if (bl2) {
                try {
                    bl4 = this.grid.getDataModel().moveToRow(this.grid.getDataModelListener(), dataTableModel, l);
                }
                catch (Exception exception) {
                    this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
                    bl4 = false;
                }
            }
            if (bl4) {
                DataModel dataModel = dataTableModel.getMetaData().getDataModel();
                DataSourceTreeNode dataSourceTreeNode = (DataSourceTreeNode)((Object)dataTableModel);
                DataSourceTreeNode dataSourceTreeNode2 = (DataSourceTreeNode)dataModel.getDataTableTree().getRoot();
                boolean bl7 = bl5 = dataSourceTreeNode.getParent() == null && dataSourceTreeNode != dataSourceTreeNode2 || ((DataTableModel)((Object)dataSourceTreeNode2)).getRowIndex(((DataTableModel)((Object)dataSourceTreeNode)).getRootAncestorBookmark(l)) == -1 || l != dataModel.getCurrentGlobalBookmark();
                if (bl5) {
                    try {
                        RowNode rowNode;
                        if (dataSourceTreeNode == dataSourceTreeNode2 && cellPosition2.row.getDataTableModel() == dataSourceTreeNode2) {
                            rowNode = dataModel.getCurrentGlobalTable() != null ? this.grid.getRowTree().findRecordRowNode(null, dataModel.getCurrentGlobalTable().getRowIdentifier(n2)) : null;
                        } else if (cellPosition2.row.getDataTableModel() == dataSourceTreeNode2) {
                            rowNode = this.grid.getRowTree().findFirstRowNode(null, (DataTableModel)((Object)dataSourceTreeNode2));
                            n = rowNode != null ? Math.max(0, rowNode.getRowFormat().getFirstVisibleCell()) : 0;
                        } else {
                            rowNode = dataSourceTreeNode != dataSourceTreeNode2 ? this.grid.getRowTree().findRecordRowNode(null, dataTableModel2.createTable(this.grid.getDataModelListener(), l2, (DataSourceTreeNode)((Object)dataTableModel.getMetaData())).getRowIdentifier(n2)) : null;
                        }
                        cellPosition = new CellPosition(rowNode, n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (cellPosition.row.getBookmark() != l) {
                    try {
                        this.grid.getDataModel().moveToRow(this.grid.getDataModelListener(), cellPosition.row.getDataTableModel(), cellPosition.row.getBookmark());
                    }
                    catch (Exception exception) {
                        this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
                    }
                    bl6 = true;
                }
                this.currentCell = cellPosition;
                this.grid.refreshEditStatus(cellPosition2, bl);
            }
        }
        if (bl4) {
            this.currentCell = cellPosition;
            this.setDesiredColumn(n);
            this.grid.refreshEditStatus(this.currentCell, bl);
            if (this.getSelectedRows().size() != 0) {
                this.resetRowSelection();
            }
        } else {
            this.currentCell = cellPosition2;
        }
        if (bl6) {
            this.grid.refresh();
        }
        if (bl4) {
            this.grid.fireHiGridTraverseEvent(new HiGridTraverseEvent(this.grid, 1, cellPosition2, cellPosition));
        }
        return bl4;
    }

    protected boolean validateCell(CellPosition cellPosition) {
        return this.validateCell(cellPosition, true);
    }

    protected boolean validateCell(CellPosition cellPosition, boolean bl) {
        if (this.currentCellEditor != null && this.currentCellEditor.isModified()) {
            if (!this.commitAndConvert()) {
                return false;
            }
            if (bl) {
                if (cellPosition == null) {
                    this.grid.refreshEditStatus(this.currentCell, true);
                } else {
                    this.grid.refreshCell(this.currentCell);
                }
            }
        }
        return true;
    }

    protected boolean traverseToCell(CellPosition cellPosition, int n, AWTEvent aWTEvent) {
        this.duringTraversal = true;
        if (cellPosition != null) {
            if (!this.moveCurrentCellInternal(cellPosition, n)) {
                return false;
            }
            this.showEditor(false);
            RowTree rowTree = this.grid.getRowTree();
            RowNode rowNode = rowTree.getTopRowNode();
            int n2 = this.grid.getVerticalScrollbar().getValue();
            int n3 = this.getAction(aWTEvent);
            boolean bl = this.scrollEditorIntoView(n3);
            if (aWTEvent instanceof KeyEvent) {
                this.popupEditor(n3 != 0 ? null : aWTEvent);
            } else {
                this.popupEditor(aWTEvent);
            }
            this.acquireFocusForCellEditor();
        }
        this.duringTraversal = false;
        return true;
    }

    protected void popupEditor(AWTEvent aWTEvent) {
        this.createEditor(aWTEvent);
        this.positionEditor(true);
        this.showEditor(true);
    }

    protected boolean validateAndTraverse(CellPosition cellPosition, int n, AWTEvent aWTEvent) {
        if (!this.validateCell(cellPosition)) {
            return false;
        }
        return this.traverseToCell(cellPosition, n, aWTEvent);
    }

    protected NullGraphics getCellFromXY(Point point) {
        NullGraphics nullGraphics = new NullGraphics(3, this.grid, null, point);
        this.grid.getRowTree().displayRuntimeTree(nullGraphics);
        return nullGraphics;
    }

    protected NullGraphics getXYFromCell(CellPosition cellPosition) {
        cellPosition = new CellPosition(cellPosition.row, cellPosition.columnIndex, cellPosition.isIndicator);
        int n = cellPosition.isIndicator ? 2 : 1;
        NullGraphics nullGraphics = new NullGraphics(n, this.grid, cellPosition, new Point(-1, -1));
        this.grid.getRowTree().displayRuntimeTree(nullGraphics);
        return nullGraphics;
    }

    protected CellPosition doTheRecordWalk(RowNode rowNode, int n, boolean bl) {
        RecordWalk recordWalk = new RecordWalk(n, bl);
        this.grid.getRowTree().walk(rowNode, recordWalk);
        RowNode rowNode2 = recordWalk.getFoundNode();
        if (rowNode2 == null && rowNode.getRowFormat() instanceof RecordFormat) {
            rowNode2 = rowNode;
        }
        if (rowNode2 != null) {
            return new CellPosition(rowNode2, Math.max(rowNode2.getRowFormat().getFirstVisibleCell(), Math.min(this.getDesiredColumn(), rowNode2.getRowFormat().getLastVisibleCell())));
        }
        return null;
    }

    protected void showPopupMenu(InputEvent inputEvent) {
        Serializable serializable;
        int n;
        int n2;
        if (!this.grid.isAllowPopupMenu()) {
            return;
        }
        if (inputEvent instanceof MouseEvent) {
            n2 = ((MouseEvent)inputEvent).getX();
            n = ((MouseEvent)inputEvent).getY();
        } else if (inputEvent instanceof KeyEvent) {
            serializable = this.grid.getPointFromCellPosition(this.currentCell);
            n2 = ((Point)serializable).x;
            n = ((Point)serializable).y + this.currentCell.getCellFormat().getTotalArea().height;
        } else {
            return;
        }
        serializable = this.grid.getEditPopupMenu();
        if (serializable != null) {
            ((EditPopupMenu)serializable).show(n2, n);
            this.getGridArea().getFocusManager().requestFocus((Component)serializable);
        }
    }

    public void performCopyAction() {
        this.performCopyAction(this.getSelectedRows());
    }

    public void performCopyAction(Vector vector) {
        StringRowFlavor stringRowFlavor = new StringRowFlavor(this.grid, vector);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringRowFlavor, stringRowFlavor);
    }

    public void performPasteAction() {
        this.performPasteAction(this.grid.getCurrentCellPosition());
    }

    public void performPasteAction(CellPosition cellPosition) {
        if (cellPosition == null) {
            return;
        }
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        if (transferable != null) {
            try {
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                int n = 0;
                while (n < dataFlavorArray.length) {
                    if (dataFlavorArray[n].getHumanPresentableName().equals("Unicode String")) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)transferable.getTransferData(dataFlavorArray[n]), "\n", false);
                        Vector vector = new Vector();
                        while (stringTokenizer.hasMoreElements()) {
                            String string = (String)stringTokenizer.nextElement();
                            if (string == null) continue;
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\t", false);
                            Vector<String> vector2 = new Vector<String>();
                            while (stringTokenizer2.hasMoreElements()) {
                                vector2.addElement(stringTokenizer2.nextToken());
                            }
                            vector.addElement(vector2);
                        }
                        this.pasteData(vector, cellPosition.getRowNode());
                        return;
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                System.out.println("Error pasting data: " + iOException.getMessage());
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println("Error pasting data: " + unsupportedFlavorException.getMessage());
            }
        }
    }

    public void pasteData(Vector vector, RowNode rowNode) {
        DataTableModel dataTableModel = rowNode.getDataTableModel();
        if (dataTableModel == null) {
            return;
        }
        MetaDataModel metaDataModel = dataTableModel.getMetaData();
        if (metaDataModel == null) {
            return;
        }
        int n = metaDataModel.getCommitPolicy();
        try {
            metaDataModel.setCommitPolicy(3);
        }
        catch (DataModelException dataModelException) {
            this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, dataModelException));
        }
        long l = rowNode.getBookmark();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration.nextElement();
            try {
                Object[] objectArray = (Object[])dataTableModel.createNewRow();
                if (objectArray.length != vector2.size()) {
                    throw new HiGridException("Number of columns does not match " + objectArray.length + " " + vector2.size() + " - paste aborted ");
                }
                int n2 = 0;
                while (n2 < objectArray.length) {
                    objectArray[n2] = vector2.elementAt(n2);
                    ++n2;
                }
                dataTableModel.addRow(this.grid.getDataModelListener(), objectArray, 2, dataTableModel.getRowIndex(l));
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
        }
        try {
            metaDataModel.setCommitPolicy(n);
        }
        catch (DataModelException dataModelException) {
            this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, dataModelException));
        }
        this.resetRowSelection();
    }

    public Vector getSelectedRows() {
        return this.selectedRowNodes;
    }

    protected void setSelectedRows(Vector vector) {
        this.selectedRowNodes = vector;
    }

    protected boolean canSelectRowNode(int n, RowNode rowNode, RowNode rowNode2) {
        switch (n) {
            case 2: {
                if (rowNode == null || rowNode.getDataTableModel() == rowNode2.getDataTableModel()) break;
                return false;
            }
            case 1: {
                if (rowNode == null || rowNode.getFormatNode() == rowNode2.getFormatNode()) break;
                return false;
            }
        }
        return true;
    }

    protected boolean doRowSelection(RowNode rowNode, int n, boolean bl, boolean bl2) {
        if (rowNode == null || !(rowNode.getRowFormat() instanceof RecordFormat)) {
            return false;
        }
        if (!this.canSelectRowNode(n, this.lastSelectedRowNode, rowNode)) {
            return false;
        }
        if (bl) {
            if (this.lastSelectedRowNode == null) {
                return false;
            }
            RowNode rowNode2 = this.lastSelectedRowNode;
            if (!this.resetRowSelection()) {
                return false;
            }
            this.lastSelectedRowNode = rowNode2;
            RowSelectWalk rowSelectWalk = new RowSelectWalk(this.grid, n, this.lastSelectedRowNode, rowNode);
            this.grid.getRowTree().walk((RowNode)this.grid.getRowTree().getRootNode().getFirstChild(), rowSelectWalk);
            if (!this.selectRows(rowSelectWalk.getSelectedRows(), true)) {
                return false;
            }
            this.setSelectedRows(rowSelectWalk.getSelectedRows());
        } else {
            if (!this.selectRows(rowNode, !rowNode.isSelected())) {
                return false;
            }
            if (rowNode.isSelected()) {
                this.selectedRowNodes.addElement(rowNode);
                this.lastSelectedRowNode = rowNode;
            } else {
                this.selectedRowNodes.removeElement(rowNode);
            }
        }
        if (bl2) {
            if (bl) {
                this.grid.refresh();
            } else {
                this.grid.refreshRowWithoutEditor(rowNode);
            }
        }
        return true;
    }

    protected boolean doRowSelection(RowNode rowNode, int n, boolean bl) {
        return this.doRowSelection(rowNode, n, bl, true);
    }

    protected boolean doRowSelection(RowNode rowNode, int n) {
        if (rowNode == null || !(rowNode.getRowFormat() instanceof RecordFormat)) {
            return false;
        }
        if (!this.canSelectRowNode(n, this.lastSelectedRowNode, rowNode)) {
            return false;
        }
        if (!this.resetRowSelection()) {
            return false;
        }
        if (n == 0) {
            RowNode rowNode2;
            CellPosition cellPosition = this.goHome();
            RowNode rowNode3 = rowNode2 = cellPosition == null ? null : cellPosition.row;
            if (!this.doRowSelection(rowNode2, 0, false)) {
                return false;
            }
            cellPosition = this.goEnd();
            RowNode rowNode4 = rowNode2 = cellPosition == null ? null : cellPosition.row;
            if (!this.doRowSelection(rowNode2, 0, true)) {
                return false;
            }
        } else if (n == 2) {
            RowNode rowNode5;
            CellPosition cellPosition = this.goLevelHome();
            RowNode rowNode6 = rowNode5 = cellPosition == null ? null : cellPosition.row;
            if (!this.doRowSelection(rowNode5, 2, false)) {
                return false;
            }
            cellPosition = this.goLevelEnd();
            RowNode rowNode7 = rowNode5 = cellPosition == null ? null : cellPosition.row;
            if (!this.doRowSelection(rowNode5, 2, true)) {
                return false;
            }
        } else if (n == 1) {
            LevelSelectWalk levelSelectWalk = new LevelSelectWalk(this.grid, rowNode);
            this.grid.getRowTree().walk((RowNode)this.grid.getRowTree().getRootNode().getFirstChild(), levelSelectWalk);
            if (this.selectRows(levelSelectWalk.getSelectedRows(), true)) {
                this.setSelectedRows(levelSelectWalk.getSelectedRows());
                this.lastSelectedRowNode = levelSelectWalk.first();
            }
        }
        this.grid.refresh();
        return true;
    }

    protected boolean resetRowSelection() {
        return this.resetRowSelection(true);
    }

    protected boolean resetRowSelection(boolean bl) {
        if (this.selectedRowNodes.size() == 0) {
            return true;
        }
        Vector vector = (Vector)this.selectedRowNodes.clone();
        if (!this.selectRows(vector, false)) {
            return false;
        }
        RowNode rowNode = (RowNode)this.selectedRowNodes.elementAt(0);
        boolean bl2 = this.selectedRowNodes.size() == 1;
        this.selectedRowNodes.removeAllElements();
        this.lastSelectedRowNode = null;
        if (bl) {
            if (bl2) {
                this.grid.refreshRowWithoutEditor(rowNode);
            } else {
                this.grid.refresh();
            }
        }
        return true;
    }

    protected boolean selectRows(RowNode rowNode, boolean bl) {
        Vector<RowNode> vector = new Vector<RowNode>(1);
        vector.addElement(rowNode);
        return this.selectRows(vector, bl);
    }

    protected boolean selectRows(Vector vector, boolean bl) {
        if (vector.size() == 0) {
            return true;
        }
        if (!this.grid.fireHiGridRowSelectionEvent(new HiGridRowSelectionEvent(this.grid, 1, bl, vector))) {
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RowNode rowNode = (RowNode)enumeration.nextElement();
            rowNode.setSelected(bl);
        }
        this.grid.fireHiGridRowSelectionEvent(new HiGridRowSelectionEvent(this.grid, 2, bl, vector));
        return true;
    }

    public void addAction(ActionInitiator actionInitiator, int n) {
        this.addAction(new HiGridAction(actionInitiator, n));
    }

    public void addAction(HiGridAction hiGridAction) {
        if (this.actions == null) {
            this.actions = new Vector();
        }
        this.actions.addElement(hiGridAction);
    }

    public int getAction(AWTEvent aWTEvent) {
        if (this.actions != null) {
            int n = 0;
            while (n < this.actions.size()) {
                HiGridAction hiGridAction = (HiGridAction)this.actions.elementAt(n);
                if (hiGridAction.isMatch(this.grid, aWTEvent)) {
                    return hiGridAction.getAction();
                }
                ++n;
            }
        }
        return 0;
    }

    public MouseActionInitiator getMouseActionInitiator(int n, int n2) {
        if (this.actions != null) {
            int n3 = 0;
            while (n3 < this.actions.size()) {
                HiGridAction hiGridAction = (HiGridAction)this.actions.elementAt(n3);
                if (hiGridAction.getInitiator() instanceof MouseActionInitiator) {
                    MouseActionInitiator mouseActionInitiator = (MouseActionInitiator)hiGridAction.getInitiator();
                    if (mouseActionInitiator.button_mask == n && mouseActionInitiator.modifier == n2) {
                        return mouseActionInitiator;
                    }
                }
                ++n3;
            }
        }
        return null;
    }

    public void removeAction(HiGridAction hiGridAction) {
        this.removeAction(hiGridAction.getInitiator(), hiGridAction.getAction());
    }

    public void removeAction(ActionInitiator actionInitiator, int n) {
        if (this.actions != null) {
            int n2 = 0;
            while (n2 < this.actions.size()) {
                HiGridAction hiGridAction = (HiGridAction)this.actions.elementAt(n2);
                if (hiGridAction.getInitiator() == actionInitiator && hiGridAction.action == n) {
                    this.actions.removeElement(hiGridAction);
                }
                ++n2;
            }
            if (this.actions.size() == 0) {
                this.actions = null;
            }
        }
    }

    public void removeAction(int n) {
        if (this.actions != null) {
            int n2 = 0;
            while (n2 < this.actions.size()) {
                HiGridAction hiGridAction = (HiGridAction)this.actions.elementAt(n2);
                if (hiGridAction.action == n) {
                    this.actions.removeElement(hiGridAction);
                }
                ++n2;
            }
            if (this.actions.size() == 0) {
                this.actions = null;
            }
        }
    }

    public void removeAllKeyActions() {
        if (this.actions != null) {
            int n = 0;
            while (n < this.actions.size()) {
                HiGridAction hiGridAction = (HiGridAction)this.actions.elementAt(n);
                if (hiGridAction.getInitiator() instanceof KeyActionInitiator) {
                    this.actions.removeElement(hiGridAction);
                }
                ++n;
            }
            if (this.actions.size() == 0) {
                this.actions = null;
            }
        }
    }

    public void removeAllMouseActions() {
        if (this.actions != null) {
            int n = 0;
            while (n < this.actions.size()) {
                HiGridAction hiGridAction = (HiGridAction)this.actions.elementAt(n);
                if (hiGridAction.getInitiator() instanceof MouseActionInitiator) {
                    this.actions.removeElement(hiGridAction);
                }
                ++n;
            }
            if (this.actions.size() == 0) {
                this.actions = null;
            }
        }
    }

    public void removeAllActions() {
        if (this.actions != null) {
            this.actions.removeAllElements();
            this.actions = null;
        }
    }

    public Enumeration getAllActions() {
        return this.actions.elements();
    }

    public void createDefaultActions() {
        this.addAction(new KeyActionInitiator(37, 0), 1);
        this.addAction(new KeyActionInitiator(39, 0), 2);
        this.addAction(new KeyActionInitiator(38, 0), 3);
        this.addAction(new KeyActionInitiator(40, 0), 4);
        this.addAction(new KeyActionInitiator(33, 0), 5);
        this.addAction(new KeyActionInitiator(34, 0), 6);
        this.addAction(new KeyActionInitiator(33, 8), 7);
        this.addAction(new KeyActionInitiator(34, 8), 8);
        this.addAction(new KeyActionInitiator(36, 0), 9);
        this.addAction(new KeyActionInitiator(35, 0), 10);
        this.addAction(new KeyActionInitiator(36, 2), 11);
        this.addAction(new KeyActionInitiator(35, 2), 12);
        this.addAction(new KeyActionInitiator(9, 0), 13);
        this.addAction(new KeyActionInitiator(9, 1), 14);
        this.addAction(new KeyActionInitiator(107, 2), 15);
        this.addAction(new KeyActionInitiator(109, 2), 16);
        this.addAction(new MouseActionInitiator(16, -1), 20);
        this.addAction(new MouseActionInitiator(4, -1), 19);
        this.addAction(new MouseActionInitiator(16, 2), 21);
        this.addAction(new MouseActionInitiator(16, 1), 22);
        this.addAction(new KeyActionInitiator(10, -1), 23);
        this.addAction(new KeyActionInitiator(27, -1), 23);
        this.addAction(new KeyActionInitiator(17, -1), 23);
        this.addAction(new KeyActionInitiator(16, -1), 23);
        this.addAction(new KeyActionInitiator(18, -1), 23);
        this.addAction(new KeyActionInitiator(20, -1), 23);
        this.addAction(new KeyActionInitiator(144, -1), 23);
        this.addAction(new KeyActionInitiator(145, -1), 23);
    }

    protected class JColumnHeaderLabel
    extends JLabel {
        protected JColumnHeaderLabel() {
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setXORMode(Color.gray);
            graphics.setColor(this.getBackground());
            ((Graphics2D)graphics).fill(graphics.getClipBounds());
            graphics.setPaintMode();
            super.paintComponent(graphics);
        }
    }
}

