/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.validate;

import com.klg.jclass.field.validate.AbstractValidator;
import com.klg.jclass.field.validate.TextCursorEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public abstract class JCNumberValidator
extends AbstractValidator {
    protected DecimalFormat displayFormat;
    protected DecimalFormat editFormat;
    protected DecimalFormatSymbols symbols;
    protected DecimalFormatSymbols currencySymbols;
    protected String display_pattern = null;
    protected String edit_pattern = null;
    protected int spin_policy = 0;
    protected String exponentialChar = null;
    protected boolean isCurrency = false;
    protected Locale currency_locale = null;
    protected boolean use_intl_currency_symbol = false;

    public JCNumberValidator() {
        this.setPatterns();
        this.displayFormat = this.createDisplayFormat(this.getLocale());
        if (this.display_pattern != null) {
            this.displayFormat.applyPattern(this.display_pattern);
        }
        this.editFormat = this.createEditFormat(this.getLocale());
        if (this.edit_pattern != null) {
            this.editFormat.applyPattern(this.edit_pattern);
        }
        String[] stringArray = this.li.getStringArray("NumberElements");
        this.exponentialChar = stringArray[7];
    }

    public Object copyValue(Object object) {
        return object;
    }

    protected abstract void setPatterns();

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        super.setLocale(locale);
        this.symbols = new DecimalFormatSymbols(locale);
        if (!this.abstractInitializing) {
            this.setPatterns();
            this.displayFormat = this.createDisplayFormat(this.getLocale());
            if (this.display_pattern != null) {
                this.displayFormat.applyPattern(this.display_pattern);
            }
            this.editFormat = this.createEditFormat(this.getLocale());
            if (this.edit_pattern != null) {
                this.editFormat.applyPattern(this.edit_pattern);
            }
        }
        String[] stringArray = this.li.getStringArray("NumberElements");
        this.exponentialChar = stringArray[7];
    }

    protected abstract DecimalFormat createDisplayFormat(Locale var1);

    protected abstract DecimalFormat createEditFormat(Locale var1);

    public void setCursor(TextCursorEvent textCursorEvent) {
        textCursorEvent.getNewPosition();
    }

    public String getDisplayPattern() {
        return this.display_pattern;
    }

    public void setDisplayPattern(String string) {
        this.display_pattern = string;
        this.displayFormat.applyPattern(string);
    }

    public String getEditPattern() {
        return this.edit_pattern;
    }

    public void setEditPattern(String string) {
        this.edit_pattern = string;
        this.editFormat.applyPattern(string);
    }

    public DecimalFormat getDisplayFormat() {
        return this.displayFormat;
    }

    public DecimalFormat getEditFormat() {
        return this.editFormat;
    }

    public void setDisplayFormat(DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            throw new IllegalArgumentException("null DecimalFormat object invalid");
        }
        this.displayFormat = decimalFormat;
    }

    public void setEditFormat(DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            throw new IllegalArgumentException("null DecimalFormat object invalid");
        }
        this.editFormat = decimalFormat;
    }

    public int getFirstValidCursorPosition() {
        return 0;
    }

    public String format(Object object) {
        if (object == null || !this.isClassSupported(object.getClass())) {
            return "";
        }
        String string = this.displayFormat.format(object);
        if (this.isCurrency && this.use_intl_currency_symbol || !this.getLocale().equals(this.getCurrencyLocale())) {
            String string2 = this.symbols.getCurrencySymbol();
            String string3 = this.getCurrencySymbol(this.getCurrencyLocale());
            StringBuffer stringBuffer = new StringBuffer(string.length() - string2.length() + string3.length());
            int n = string.indexOf(string2);
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append(string3);
            stringBuffer.append(string.substring(n + string2.length()));
            return stringBuffer.toString();
        }
        return string;
    }

    public boolean isCurrency() {
        return this.isCurrency;
    }

    public void setCurrency(boolean bl) {
        this.isCurrency = bl;
        this.setPatterns();
        if (this.display_pattern != null) {
            this.displayFormat.applyPattern(this.display_pattern);
        }
    }

    public Locale getCurrencyLocale() {
        if (this.currency_locale == null) {
            return this.getLocale();
        }
        return this.currency_locale;
    }

    public void setCurrencyLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        if (locale != this.currency_locale) {
            this.currency_locale = locale;
        }
        this.setPatterns();
        this.currencySymbols = new DecimalFormatSymbols(this.currency_locale);
    }

    protected String getLocalCurrencySymbol(Locale locale) {
        return this.currencySymbols.getCurrencySymbol();
    }

    protected String getIntlCurrencySymbol(Locale locale) {
        return this.currencySymbols.getInternationalCurrencySymbol();
    }

    public String getCurrencySymbol(Locale locale) {
        if (locale == this.locale && !this.use_intl_currency_symbol) {
            return this.getLocalCurrencySymbol(locale);
        }
        return this.getIntlCurrencySymbol(locale);
    }

    public String getCurrencySymbol() {
        return this.getCurrencySymbol(this.getCurrencyLocale());
    }

    public boolean getUseIntlCurrencySymbol() {
        return this.use_intl_currency_symbol;
    }

    public void setUseIntlCurrencySymbol(boolean bl) {
        if (bl != this.use_intl_currency_symbol) {
            this.use_intl_currency_symbol = bl;
        }
    }
}

