/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.util;

import java.io.Serializable;
import java.util.StringTokenizer;

public class SqlStatementTable
implements Serializable {
    static final long serialVersionUID = 445042217633496325L;
    private String alias;
    private String table;
    private String qualifier;
    private String subQuery = null;
    private String catalog;
    private String schema;
    private boolean isSubQuery = false;

    public SqlStatementTable(String string, String string2, String string3) {
        this.table = string;
        this.qualifier = string2;
        this.alias = string3 == null ? this.getQualifiedName() : string3;
        this.parseQualifier();
    }

    public String getTableName() {
        return this.table;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String string) {
        String string2 = this.getQualifiedName();
        this.qualifier = string;
        if (this.alias == null || this.alias == string2) {
            this.alias = this.getQualifiedName();
        }
    }

    public String getQualifiedName() {
        return this.qualifier == null ? this.table : this.qualifier + "." + this.table;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public boolean isSubQuery() {
        return this.isSubQuery;
    }

    public void setSubQuery(String string) {
        this.subQuery = string;
    }

    public String getSubQuery() {
        return this.subQuery;
    }

    public String getCatalogName() {
        return this.catalog;
    }

    public String getSchemaName() {
        return this.schema;
    }

    void parseQualifier() {
        String string = this.getQualifier();
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.insert(0, stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(stringBuffer.toString(), ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            this.schema = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.catalog = stringTokenizer.nextToken();
        }
    }

    public String toString() {
        return new String("[table name: " + this.table + " qualifier: " + this.qualifier + " alias: " + this.alias + " isSubQuery: " + this.isSubQuery + " subQuery: " + this.subQuery + "]\n");
    }
}

