/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.jdbc;

import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.jdbc.Column;
import com.klg.jclass.datasource.jdbc.DataTable;
import com.klg.jclass.datasource.jdbc.MetaData;
import com.klg.jclass.datasource.jdbc.PersistorModel;
import com.klg.jclass.datasource.util.SqlStatementTable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class Persistor
implements PersistorModel,
Serializable {
    static final long serialVersionUID = 922782684857133093L;
    protected static final int ONE_ROW_CHANGED = 1;
    protected transient PreparedStatement update_statement;

    public void saveRow(long l, MetaData metaData, DataTableModel dataTableModel) throws DataModelException {
        MetaData metaData2 = metaData;
        DataTable dataTable = (DataTable)dataTableModel;
        int n = dataTable.getRowStatus(l);
        if (n == 4) {
            return;
        }
        Object[] objectArray = null;
        Vector vector = metaData2.getTables();
        int n2 = 1;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            int n3;
            String string = (String)enumeration.nextElement();
            Vector vector2 = metaData2.getColumnIndexesForTable(string);
            if (n == 1) {
                if (objectArray == null) {
                    objectArray = (Object[])dataTable.getOriginalRow(l);
                }
                if (objectArray == null) {
                    Exception exception = new Exception(LocaleBundle.string("Internal error: bookmark not found in cache: ") + l);
                    throw new DataModelException(107, exception);
                }
                if (!this.tablesColumnsModified(l, vector2, metaData2, dataTable)) continue;
                this.buildUpdateStatement(string, vector2, l, metaData2, dataTable);
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    n3 = (Integer)enumeration2.nextElement();
                    if (!dataTable.columnModified(l, metaData2.getColumnIdentifier(n3))) continue;
                    object = dataTable.getResultData(l, metaData2.getColumnIdentifier(n3));
                    this.setUpdateParameter(n2++, object, metaData2.getColumnIdentifier(n3), metaData2);
                }
            } else if (n == 3) {
                if (!metaData2.getDeleteAllowed(string)) continue;
                objectArray = (Object[])dataTable.getDeletedRow(l);
                this.buildDeleteStatement(string, vector2, objectArray, metaData2, dataTable);
            } else {
                if (!metaData2.getInsertAllowed(string)) continue;
                objectArray = (Object[])dataTable.getRowFromCache(l);
                this.buildInsertStatement(string, vector2, objectArray, metaData2, dataTable);
            }
            int n4 = 0;
            while (n4 < vector2.size()) {
                if (!dataTable.originalCellWasNull(n4, vector2, objectArray)) {
                    n3 = (Integer)vector2.elementAt(n4);
                    object = objectArray[n3];
                    this.setUpdateParameter(n2++, object, metaData2.getColumnIdentifier(n3), metaData2);
                }
                ++n4;
            }
            this.commit(metaData2);
            n2 = 1;
        }
    }

    protected void commit(MetaData metaData) throws DataModelException {
        int n = this.executeUpdate(metaData);
        if (n != 1) {
            Exception exception = new Exception(LocaleBundle.string("The data has been changed in the data source by another user. Please requery then make your changes"));
            throw new DataModelException(107, exception);
        }
    }

    protected boolean tablesColumnsModified(long l, Vector vector, MetaData metaData, DataTable dataTable) throws DataModelException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            if (!dataTable.columnModified(l, metaData.getColumnIdentifier(n))) continue;
            return true;
        }
        return false;
    }

    protected void buildDeleteStatement(String string, Vector vector, Object[] objectArray, MetaData metaData, DataTable dataTable) throws DataModelException {
        String string2 = " DELETE FROM ";
        string2 = string2 + this.getQualifiedTableName(string, false, metaData);
        string2 = string2 + this.buildWhereClause(vector, objectArray, false, metaData, dataTable);
        this.setUpdateStatement(string2, metaData);
    }

    protected void buildUpdateStatement(String string, Vector vector, long l, MetaData metaData, DataTable dataTable) throws DataModelException {
        Object[] objectArray = (Object[])dataTable.getOriginalRow(l);
        String string2 = " UPDATE ";
        string2 = string2 + this.getQualifiedTableName(string, false, metaData);
        string2 = string2 + " SET ";
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            int n2 = (Integer)vector.elementAt(n);
            if (dataTable.columnModified(l, metaData.getColumnIdentifier(n2))) {
                string2 = string2 + (bl ? "," : " ");
                ColumnModel columnModel = metaData.getColumnObject(metaData.getColumnIdentifier(n2));
                String string3 = columnModel.getColumnName();
                string2 = string2 + string3.substring(string3.lastIndexOf(".") + 1, string3.length());
                string2 = string2 + " = ? ";
                bl = true;
            }
            ++n;
        }
        string2 = string2 + this.buildWhereClause(vector, objectArray, false, metaData, dataTable);
        this.setUpdateStatement(string2, metaData);
    }

    private void buildInsertStatement(String string, Vector vector, Object[] objectArray, MetaData metaData, DataTable dataTable) throws DataModelException {
        Object object;
        Object object2;
        int n;
        boolean bl = false;
        String string2 = " INSERT INTO ";
        string2 = string2 + this.getQualifiedTableName(string, false, metaData);
        string2 = string2 + " (";
        int n2 = 0;
        while (n2 < vector.size()) {
            if (!dataTable.originalCellWasNull(n2, vector, objectArray)) {
                string2 = string2 + (bl ? ", " : " ");
                n = (Integer)vector.elementAt(n2);
                object2 = metaData.getColumnObject(metaData.getColumnIdentifier(n));
                object = object2.getColumnName();
                string2 = string2 + ((String)object).substring(((String)object).lastIndexOf(".") + 1, ((String)object).length());
                bl = true;
            }
            ++n2;
        }
        string2 = string2 + " ) VALUES ( ";
        bl = false;
        n = 0;
        while (n < vector.size()) {
            if (!dataTable.originalCellWasNull(n, vector, objectArray)) {
                string2 = string2 + (bl ? ", " : " ");
                string2 = string2 + " ? ";
                bl = true;
            }
            ++n;
        }
        string2 = string2 + " ) ";
        if (!bl) {
            object2 = "\n" + LocaleBundle.string("Attempt to insert failed. The sql statement is malformed: ");
            object2 = (String)object2 + " level \"" + metaData.getDescription() + "\"";
            object2 = (String)object2 + " statement \"" + string2 + "\"";
            object = new Exception((String)object2);
            throw new DataModelException(101, (Exception)object);
        }
        this.setUpdateStatement(string2, metaData);
    }

    private String buildWhereClause(Vector vector, Object[] objectArray, boolean bl, MetaData metaData, DataTable dataTable) {
        String string = " WHERE ";
        boolean bl2 = false;
        int n = 0;
        while (n < vector.size()) {
            string = string + (bl2 ? " AND " : " ");
            int n2 = (Integer)vector.elementAt(n);
            try {
                ColumnModel columnModel = metaData.getColumnObject(metaData.getColumnIdentifier(n2));
                String string2 = columnModel.getColumnName();
                string = string + (bl ? string2 : string2.substring(string2.lastIndexOf(".") + 1, string2.length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = dataTable.originalCellWasNull(n, vector, objectArray) ? string + " IS NULL " : string + " = ? ";
            bl2 = true;
            ++n;
        }
        return string;
    }

    protected String getQualifiedTableName(String string, boolean bl, MetaData metaData) {
        String string2;
        SqlStatementTable sqlStatementTable = metaData.getParser().getSqlStatementTable(string);
        String string3 = string2 = sqlStatementTable.getQualifier() != null && !sqlStatementTable.getQualifier().equals("") ? sqlStatementTable.getQualifier() + "." + string : string;
        if (bl) {
            string2 = string2 + (sqlStatementTable.getAlias() != null && !sqlStatementTable.getAlias().equals(string2) ? " " + sqlStatementTable.getAlias() : " ");
        }
        return string2;
    }

    protected void setUpdateStatement(String string, MetaData metaData) throws DataModelException {
        try {
            this.update_statement = metaData.getDataTableConnection().getConnection().prepareCall(string);
        }
        catch (Exception exception) {
            try {
                this.update_statement = metaData.getDataTableConnection().getConnection().prepareStatement(string);
            }
            catch (Exception exception2) {
                throw new DataModelException(107, exception2);
            }
        }
    }

    protected void setUpdateParameter(int n, Object object, String string, MetaData metaData) throws DataModelException {
        block13: {
            int n2 = this.getJDBCColumnType(string, metaData);
            try {
                if (object == null) {
                    try {
                        this.update_statement.setNull(n, n2);
                        break block13;
                    }
                    catch (SQLException sQLException) {
                        switch (n2) {
                            case 91: {
                                this.update_statement.setNull(n, 9);
                                break block13;
                            }
                            case 92: {
                                this.update_statement.setNull(n, 10);
                                break block13;
                            }
                            case 93: {
                                this.update_statement.setNull(n, 11);
                                break block13;
                            }
                            default: {
                                throw new DataModelException(107, sQLException);
                            }
                        }
                    }
                }
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        this.update_statement.setBinaryStream(n, (InputStream)byteArrayInputStream, ((byte[])object).length);
                        break;
                    }
                    default: {
                        this.update_statement.setObject(n, object);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new DataModelException(107, sQLException);
            }
        }
    }

    protected int executeUpdate(MetaData metaData) throws DataModelException {
        if (!metaData.isOpen()) {
            throw new DataModelException(107, this.createNotOpenException("executeUpdate()", metaData));
        }
        int n = 0;
        try {
            n = this.update_statement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
        return n;
    }

    private Exception createNotOpenException(String string, MetaData metaData) {
        String string2 = LocaleBundle.string("MetaData is not open.  Call MetaData.open() before calling: ");
        string2 = string2 + metaData.getDescription();
        string2 = string2 + " " + string;
        return new Exception(string2);
    }

    private int getJDBCColumnType(String string, MetaData metaData) throws DataModelException {
        return ((Column)metaData.getColumnObject(string)).getColumnType();
    }
}

